/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.gtk.gl;

import com.sas.analytics.qc.statgraph.sgchart.util.BBox;
import com.sas.analytics.qc.statgraph.sgchart.util.QCMargins;
import com.sas.graphics.util.gl.Channel;
import com.sas.graphics.util.gtk.ABuildAction;
import com.sas.graphics.util.gtk.AComputeBoundingBoxAction;
import com.sas.graphics.util.gtk.ATransform;
import com.sas.graphics.util.gtk.ColorProperty;
import com.sas.graphics.util.gtk.Connector;
import com.sas.graphics.util.gtk.ContinuousRangeToNumericMapper;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.NumericProperty;
import com.sas.graphics.util.gtk.PropertyContainer;
import com.sas.graphics.util.gtk.Variable;
import com.sas.graphics.util.gtk.gl.BuildAction;
import com.sas.graphics.util.gtk.gl.Marker;
import com.sas.graphics.util.gtk.gl.Transform;
import java.awt.Color;
import java.awt.Font;

public class QCPhaseBoxConnector
extends Connector {
    public boolean outline = true;
    public boolean fill = true;
    public boolean text = true;
    public boolean header = true;
    public boolean mean = true;
    public boolean connectBox = true;
    public boolean connectMean = true;
    public Color outlineColor = ColorProperty.getDefaultColor();
    public Color fillColor = ColorProperty.getDefaultColor();
    public Color headerColor = ColorProperty.getDefaultColor();
    public Color connectColor = ColorProperty.getDefaultColor();
    public int connectWidth = 1;
    public int connectFactor = 1;
    public int connectPattern = 1;
    public Variable connectVar = null;
    public Variable labelVar = null;
    public Color labelColor = ColorProperty.getDefaultColor();
    public Font labelFont = null;
    public Marker meanMarker = null;
    public final NumericProperty pointXMin = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty pointXMax = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty pointYMin = new NumericProperty((PropertyContainer)this, true);
    public final NumericProperty pointYMax = new NumericProperty((PropertyContainer)this, true);
    public double innerMarginX = 0.0;
    public double innerMarginY = 0.0;
    public double xOffset = 0.0;
    public double yOffset = 0.0;
    public double headerHeight = 0.0;
    private BBox frame = null;
    private ContinuousRangeToNumericMapper xMapper = null;
    private double prevX;
    private double prevY;
    protected boolean SVGRender = false;

    public QCPhaseBoxConnector() {
        super((ATransform)new Transform());
        this.init();
    }

    public void init() {
        this.prevX = Double.NaN;
        this.prevY = Double.NaN;
    }

    public void setSVGRender(boolean SVG) {
        this.SVGRender = SVG;
    }

    public boolean isSVGRender() {
        return this.SVGRender;
    }

    public void setFrame(BBox bbox) {
        this.frame = bbox;
    }

    protected void render(ABuildAction buildAction) throws MissingValueException {
        BuildAction ba = BuildAction.castBuildAction((ABuildAction)buildAction);
        Channel channel = ba.getChannel();
        int index = ba.getValueIndex();
        double xmin = 0.0;
        double xmax = 0.0;
        double ymin = 0.0;
        double ymax = 0.0;
        double xmean = 0.0;
        double ymean = 0.0;
        NumericProperty pointMean = null;
        String s = null;
        int meanMarkerPosition = 0;
        try {
            xmin = this.pointXMin.getValue(index);
            xmax = this.pointXMax.getValue(index);
            ymin = this.pointYMin.getValue(index);
            ymax = this.pointYMax.getValue(index);
        }
        catch (MissingValueException mve) {
            return;
        }
        xmin -= this.innerMarginX;
        xmax += this.innerMarginX;
        ymin -= this.innerMarginY;
        ymax += this.innerMarginY;
        try {
            Object value;
            if (this.mean || this.connectBox || this.connectMean) {
                pointMean = this.meanMarker.coordY;
                ymean = pointMean.getValue(index);
                if (this.connectVar != null) {
                    value = Variable.getValue((Variable)this.connectVar, (int)index, (boolean)false);
                    meanMarkerPosition = ((Double)value).intValue();
                }
            }
            if (this.labelVar != null) {
                value = Variable.getValue((Variable)this.labelVar, (int)index, (boolean)false);
                s = value.toString();
            } else {
                s = null;
            }
            if (s != null) {
                ymax += this.headerHeight;
            }
        }
        catch (MissingValueException value) {
            // empty catch block
        }
        xmean = (xmin + xmax) / 2.0;
        channel.glNormal(0.0, 0.0, 1.0);
        if (this.fill) {
            channel.glBegin(2);
            channel.glPolygonMode(3);
            channel.glColor(this.fillColor);
            channel.glVertex(xmin, ymin);
            channel.glVertex(xmin, ymax);
            channel.glVertex(xmax, ymax);
            channel.glVertex(xmax, ymin);
            channel.glEnd();
            if (this.header) {
                channel.glBegin(2);
                channel.glPolygonMode(3);
                channel.glColor(this.headerColor);
                channel.glVertex(xmin, ymax);
                channel.glVertex(xmin, ymax - this.headerHeight);
                channel.glVertex(xmax, ymax - this.headerHeight);
                channel.glVertex(xmax, ymax);
                channel.glEnd();
            }
        }
        if (this.text && s != null) {
            double maxWidth = xmax - xmin;
            String str = this.truncateString(channel, s, maxWidth -= this.xOffset + (double)QCMargins.getBlockRightOffset());
            double x = xmin + this.xOffset;
            double y = ymax + this.yOffset;
            channel.glAlignment(0, 2);
            channel.glSelect2DFont(this.labelFont);
            channel.glColor(this.labelColor);
            channel.gl2DText(str, x, y, 0.0);
        }
        if (this.outline) {
            if (this.header) {
                channel.glBegin(1);
                channel.glColor(this.outlineColor);
                channel.glLineWidth(1.0f);
                channel.glVertex(xmin, ymax - this.headerHeight);
                channel.glVertex(xmax, ymax - this.headerHeight);
                channel.glEnd();
            }
            channel.glBegin(2);
            channel.glPolygonMode(2);
            channel.glColor(this.outlineColor);
            channel.glVertex(xmin, ymin);
            channel.glVertex(xmin, ymax);
            channel.glVertex(xmax, ymax);
            channel.glVertex(xmax, ymin);
            channel.glEnd();
        }
        if (this.mean) {
            Color c = this.meanMarker.color.getValue(index);
            channel.glColor(c);
            int i = this.meanMarker.size.getValue(index);
            channel.setMarkerSize(i);
            i = this.meanMarker.type.getValue(index);
            channel.setMarkerType(i);
            if (this.meanMarker.weightedEdgeEnabled.getValue(index)) {
                channel.glEnable(28);
            } else {
                channel.glDisable(28);
            }
            i = this.meanMarker.edgeWeight.getValue(index);
            channel.setMarkerWeight(i);
            i = this.meanMarker.edgeWidth.getValue(index);
            channel.glLineWidth((float)i);
            c = this.meanMarker.edgeColor.getValue(index);
            channel.glEdgeColor(c);
            switch (meanMarkerPosition) {
                case 1: {
                    channel.glBegin(4);
                    channel.glVertex(xmin, ymean);
                    channel.glEnd();
                    break;
                }
                case 2: {
                    channel.glBegin(4);
                    channel.glVertex(xmax, ymean);
                    channel.glEnd();
                    break;
                }
                case 3: {
                    channel.glBegin(4);
                    channel.glVertex(xmin, ymean);
                    channel.glVertex(xmax, ymean);
                    channel.glEnd();
                    break;
                }
                case 4: {
                    channel.glBegin(4);
                    channel.glVertex(xmean, ymean);
                    channel.glEnd();
                    break;
                }
            }
            channel.glLineWidth(1.0f);
        }
        if (this.connectBox) {
            if (!Double.isNaN(this.prevX) && !Double.isNaN(this.prevY)) {
                channel.glBegin(1);
                channel.glColor(this.connectColor);
                channel.glLineWidth((float)this.connectWidth);
                channel.glLineStipple(this.connectFactor, this.connectPattern);
                channel.glVertex(this.prevX, this.prevY);
                channel.glVertex(xmin, ymean);
                channel.glEnd();
            }
            this.prevX = xmax;
            this.prevY = ymean;
        }
        if (this.connectMean) {
            if (!Double.isNaN(this.prevX) && !Double.isNaN(this.prevY)) {
                channel.glBegin(1);
                channel.glColor(this.connectColor);
                channel.glLineWidth((float)this.connectWidth);
                channel.glLineStipple(this.connectFactor, this.connectPattern);
                channel.glVertex(this.prevX, this.prevY);
                channel.glVertex(xmean, ymean);
                channel.glEnd();
            }
            this.prevX = xmean;
            this.prevY = ymean;
        }
    }

    protected void getBoundingBox(AComputeBoundingBoxAction bBoxAction) throws MissingValueException {
    }

    private String truncateString(Channel channel, String label, double maxWidth) {
        if (label == null) {
            return null;
        }
        channel.glSelect2DFont(this.labelFont);
        boolean rc = true;
        String temp = label;
        double width = channel.glGetTextWidth(label);
        if (width > maxWidth) {
            rc = false;
            int n = label.length();
            for (int i = n - 1; i > 0; --i) {
                String substring = label.substring(0, i);
                substring = substring.trim();
                i = substring.length();
                temp = substring + "...";
                width = channel.glGetTextWidth(temp);
                if (!(width <= maxWidth)) continue;
                rc = true;
                break;
            }
        }
        if (!rc) {
            width = channel.glGetTextWidth("...");
            rc = width <= maxWidth;
        }
        return rc ? temp : null;
    }
}

