/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph.sgchart.composite;

import com.sas.analytics.qc.statgraph.sgchart.composite.QCSimple2DOverlayComposite;
import com.sas.graphics.applets.statgraph.StatGraphPanel;
import com.sas.graphics.applets.statgraph.sgchart.composite.AbstractSGComponent;
import com.sas.graphics.applets.statgraph.sgchart.grid.MarginInterface;
import com.sas.graphics.util.gl.Channel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;

public class QCCompositeComponent
extends AbstractSGComponent {
    protected Insets si = new Insets(0, 0, 0, 0);
    protected QCSimple2DOverlayComposite composite;
    protected Channel channel;
    protected boolean view2D = true;
    protected boolean softwareBuffered = true;
    protected boolean interactive = false;
    protected float azim = 0.0f;
    protected float inc = 0.0f;
    protected float zoom = 1.0f;
    public boolean fastRender = false;
    boolean holdDisplay = false;
    boolean forceResize = false;
    private Dimension oldSize = null;

    public QCCompositeComponent(boolean twod, boolean softwareBuffered, boolean interactive) {
        this.setInteractive(interactive);
        this.setSoftwareBuffered(softwareBuffered);
        this.setView2D(twod);
        this.setDoubleBuffered(false);
    }

    public QCCompositeComponent(boolean twod) {
        this(twod, false, false);
    }

    public Channel getChannel() {
        return this.channel;
    }

    public Dimension getMinimumSize() {
        return new Dimension(1, 1);
    }

    public void setView2D(boolean v2D) {
        this.view2D = v2D;
        if (this.view2D) {
            this.channel = this.softwareBuffered ? new Channel((Component)((Object)this), 1) : new Channel((Component)((Object)this), 2);
            this.channel.glEnable(29);
            this.channel.glDisable(3);
            this.channel.glDisable(4);
            this.channel.glEnable(1);
        } else {
            this.channel = new Channel((Component)((Object)this), 1);
            this.channel.glEnable(29);
            this.channel.glEnable(3);
            this.channel.glEnable(19);
            this.channel.glLight(19, 3, new double[]{0.0, 0.0, 1.0});
            this.channel.glLight(19, 1, new double[]{1.0, 1.0, 1.0});
            this.channel.glLight(19, 0, new double[]{0.0, 0.0, 0.0});
            this.channel.glLight(19, 2, new double[]{0.0, 0.0, 0.0});
            this.channel.glEnable(4);
            this.channel.setDepthTestAlgorithm(4);
            this.channel.glEnable(1);
            this.channel.glEnable(8);
        }
        this.resize();
    }

    public boolean isView2D() {
        return this.view2D;
    }

    public boolean isInteractive() {
        return this.interactive;
    }

    public void setInteractive(boolean b) {
        this.interactive = b;
    }

    public boolean isSoftwareBuffered() {
        return this.softwareBuffered;
    }

    public void setSoftwareBuffered(boolean b) {
        this.softwareBuffered = b;
    }

    public void setFastRender(boolean b) {
    }

    public boolean isFastRender() {
        return this.fastRender;
    }

    public void setAzimuth(float a) {
        this.azim = a;
        this.resize();
    }

    public float getAzimuth() {
        return this.azim;
    }

    public void setInclination(float i) {
        this.inc = i;
        this.resize();
    }

    public float getInclination() {
        return this.inc;
    }

    public void setZoom(float z) {
        this.zoom = z;
        this.resize();
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setViewAngles(float a, float i) {
        this.azim = a;
        this.inc = i;
        this.resize();
    }

    public synchronized void paintComponent(Graphics g) {
        if (this.holdDisplay || !this.isVisible() || g == null) {
            return;
        }
        if (StatGraphPanel.dumpTiming) {
            StatGraphPanel.dumpTimeStamp((String)"Begin client: paint component");
        }
        if (this.composite != null && this.channel != null) {
            if (this.view2D) {
                Graphics2D g2d = (Graphics2D)g;
                g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
                g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_SPEED);
                if (this.composite.dataDisplayAntialiased) {
                    g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                    this.channel.glEnable(13);
                    this.channel.glEnable(14);
                }
                if (this.softwareBuffered) {
                    this.channel.setBackgroundColor(this.getBackground());
                    this.channel.glRenderMode(0);
                    this.channel.glClear(1);
                    this.channel.glEnable(12);
                    this.channel.setBackbuffer(-1);
                    this.channel.clearBGC();
                } else {
                    this.channel.setSingleBufferGraphics(g);
                    g.setColor(this.getBackground());
                    g.fillRect(0, 0, this.getWidth(), this.getHeight());
                }
                this.composite.draw(g);
                if (this.softwareBuffered) {
                    this.channel.glRefresh(g);
                }
            } else {
                if (this.fastRender) {
                    this.channel.glDisable(4);
                    this.channel.glDisable(12);
                    this.channel.glRenderMode(0);
                    this.channel.setBackbuffer(0);
                    this.channel.glPolygonMode(2);
                } else {
                    this.channel.setBackbuffer(0);
                    this.channel.glEnable(4);
                    this.channel.glEnable(12);
                    this.channel.setBackgroundColor(this.getBackground());
                    this.channel.glRenderMode(0);
                    this.channel.setBackbuffer(-1);
                    this.channel.glClear(3);
                    this.channel.glPolygonMode(4);
                }
                this.channel.clearBGC();
                this.composite.draw(g);
                this.channel.glRefresh(g);
            }
        }
        if (StatGraphPanel.dumpTiming) {
            StatGraphPanel.dumpTimeStamp((String)"End client:paint component");
        }
    }

    public void addNotify() {
        super.addNotify();
        if (this.composite != null && this.getWidth() > 0 && this.getHeight() > 0) {
            int w = this.getWidth();
            int h = this.getHeight();
            if (this.view2D) {
                this.composite.setBounds(0, 0, w, h, h);
            } else {
                int lim = Math.min(w, h);
                double diag = lim;
                double side = diag / Math.sqrt(3.0);
                int wg = w - (int)side;
                int hg = h - (int)side;
                this.composite.setBounds(wg / 2, hg / 2, w - wg, h - hg, h);
            }
        }
    }

    public void setBackground(Color color) {
        super.setBackground(color);
        if (this.channel == null) {
            return;
        }
        this.channel.setBackgroundColor(color);
    }

    public void forceResize() {
        this.forceResize = true;
    }

    public void setBounds(int x, int y, int w, int h) {
        boolean sizeChanged = this.forceResize || w != this.getWidth() || h != this.getHeight();
        w = Math.max(w, 1);
        h = Math.max(h, 1);
        super.setBounds(x, y, w, h);
        if (sizeChanged && this.composite != null) {
            this.holdDisplay = true;
            if (this.view2D) {
                this.composite.setBounds(0, 0, w, h, h);
            } else {
                int lim = Math.min(w, h);
                double diag = lim;
                double side = diag / Math.sqrt(3.0);
                int wg = w - (int)side;
                int hg = h - (int)side;
                this.composite.setBounds(wg / 2, hg / 2, w - wg, h - hg, h);
            }
            this.resize();
            this.holdDisplay = false;
            this.repaint();
        }
    }

    protected void setSurroundingInsets(Insets si) {
        this.si = si;
    }

    public void resize() {
        Dimension d = this.getSize();
        if (d.width == 0 && d.height == 0) {
            return;
        }
        int depth = Math.max(d.width, d.height);
        if (this.composite instanceof MarginInterface) {
            Insets pom = this.composite.getPreferredOuterMargin();
            int cw = this.composite.getWidth();
            int ch = this.composite.getHeight();
            if (cw == 0 || ch == 0) {
                cw = this.getWidth();
                ch = this.getHeight();
            }
            int ORw = cw - pom.left - pom.right;
            int ORh = ch - pom.top - pom.bottom;
            depth = Math.max(ORw, ORh);
        }
        double do2 = depth / 2;
        double wo2 = (double)d.width / 2.0;
        double ho2 = (double)d.height / 2.0;
        if (this.forceResize || !d.equals(this.oldSize)) {
            if (this.view2D) {
                this.channel.glViewport(-this.si.left, -this.si.top, d.width + this.si.left + this.si.right, d.height + this.si.top + this.si.bottom);
            } else {
                this.channel.glViewport(0, 0, d.width, d.height);
            }
            this.forceResize = false;
        }
        this.oldSize = d;
        if (this.view2D) {
            this.channel.gluLookAt(wo2, ho2, 0.0, 0.5, 0.0, 0.0, 0.0);
        }
        if (this.view2D) {
            this.channel.glOrtho(-wo2 / (double)this.zoom - (double)this.si.left, wo2 / (double)this.zoom + 1.0 + (double)this.si.right, -ho2 / (double)this.zoom - 1.0 - (double)this.si.bottom, ho2 / (double)this.zoom + (double)this.si.top, -1000.0 * (double)depth / (double)this.zoom, 1000.0 * (double)depth / (double)this.zoom);
        }
    }

    public QCSimple2DOverlayComposite getComposite() {
        return this.composite;
    }

    public void setComposite(QCSimple2DOverlayComposite aComposite) {
        this.composite = aComposite;
        this.composite.setChannel(this.channel);
        this.composite.setBounds(0, 0, this.getWidth(), this.getHeight());
    }
}

