/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph;

import com.sas.analytics.qc.statgraph.QCShewhartChart;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCLayoutInternalOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCNeedleOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCPhaseBoxOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCScatterOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCSeriesOverlay;
import com.sas.analytics.qc.statgraph.sgchart.util.QCMargins;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.util.Vector;

public class QCShewhart {
    private static Vector<QCShewhartChart> charts = new Vector();
    private static Vector<Overlay> drivers = new Vector();
    private static Vector<Overlay> passengers = new Vector();
    private static QCShewhartChart chart = null;
    static CRD primaryModel = null;
    static Graphics2D g = null;
    static StatGraph statGraph = null;
    static boolean todo = true;
    static boolean mvplot = true;
    static boolean subsetData = false;
    static boolean glyph = false;
    static int glyphOffset = 0;
    static boolean superSet = true;
    static boolean clipChartArea = true;
    static boolean connectAcrossPages = true;
    static boolean phaseLegend = false;
    static boolean phaseBox = false;
    static int igrpLower = -1;
    static int igrpUpper = -1;
    static int ngrp = -1;
    static int nMin = -1;
    static int nMax = -1;
    static int nInc = -1;
    static int iPage = -1;
    static int nPage = -1;
    static int ichartOff = 0;
    static int hOffset = -1;
    static int[] vOffset = new int[]{-1, -1};
    static boolean highlight = true;
    static boolean subsetted = false;
    static boolean frontRef = false;
    static String select = null;
    static double intervalWidth = 0.0;
    static boolean qcSymbols = true;
    static int userBlockOffset = -1;
    static boolean useQCBoxPlotParm = true;
    static boolean useQCNeedlePlot = true;
    static boolean useQCScatterPlot = true;
    static boolean useQCSeriesPlot = true;

    public static void addDriver(Overlay o) {
        if (todo && !mvplot) {
            System.err.println("QCEnvironment: Change Vector<Overlay> to Vector<QCOverlay> when all QC Components are stubbed out.");
            todo = false;
        }
        if (o instanceof QCOverlay) {
            drivers.add(o);
        } else if (o instanceof QCNeedleOverlay || o instanceof QCSeriesOverlay || o instanceof QCScatterOverlay) {
            drivers.add(o);
        }
        if (primaryModel == null && o.isPrimary()) {
            primaryModel = o.getModel();
        }
        if (o instanceof QCPhaseBoxOverlay) {
            phaseBox = true;
        }
    }

    public static void addPassenger(Overlay o) {
        if (todo && !mvplot) {
            System.err.println("QCEnvironment: Change Vector<Overlay> to Vector<QCOverlay> when all QC Components are stubbed out.");
            todo = false;
        }
        if (o instanceof QCOverlay) {
            passengers.add(o);
        }
        if (primaryModel == null && o.isPrimary()) {
            primaryModel = o.getModel();
        }
        if (o instanceof QCPhaseBoxOverlay) {
            phaseBox = true;
        }
    }

    public static Vector<Overlay> getDrivers() {
        return drivers;
    }

    public static Vector<Overlay> getPassengers() {
        return passengers;
    }

    public static void clearDrivers() {
        drivers.clear();
    }

    public static void clearPassengers() {
        passengers.clear();
    }

    public static void clearCharts() {
        charts.clear();
    }

    private static void init() {
        primaryModel = null;
        g = null;
        todo = true;
        mvplot = true;
        glyph = false;
        glyphOffset = 0;
        superSet = true;
        clipChartArea = true;
        connectAcrossPages = true;
        phaseBox = false;
        phaseLegend = false;
        igrpLower = -1;
        igrpUpper = -1;
        ngrp = -1;
        nInc = -1;
        iPage = -1;
        nPage = -1;
        ichartOff = 0;
        highlight = true;
        subsetted = false;
        frontRef = false;
        qcSymbols = true;
        hOffset = -1;
        QCShewhart.vOffset[0] = -1;
        QCShewhart.vOffset[1] = -1;
        intervalWidth = 0.0;
        userBlockOffset = -1;
    }

    public static void reset() {
        QCShewhart.clearDrivers();
        QCShewhart.clearPassengers();
        QCShewhart.clearCharts();
        QCShewhart.init();
    }

    public static void set(QCLayoutInternalOverlay _internal) {
        iPage = _internal.iPage;
        nPage = _internal.nPage;
        igrpLower = _internal.igrpLower;
        igrpUpper = _internal.igrpUpper;
        ngrp = _internal.ngrp;
        nMin = _internal.nMin;
        nMax = _internal.nMax;
        nInc = _internal.nInc;
        select = _internal.select;
        highlight = _internal.highlight;
        subsetted = _internal.subsetted;
        frontRef = _internal.frontRef;
        qcSymbols = _internal.qcSymbols;
        ichartOff = _internal.ichartOff;
        hOffset = _internal.hOffset;
        vOffset = _internal.vOffset;
        useQCBoxPlotParm = _internal.useQCBoxPlotParm;
        useQCNeedlePlot = _internal.useQCNeedlePlot;
        useQCScatterPlot = _internal.useQCScatterPlot;
        useQCSeriesPlot = _internal.useQCSeriesPlot;
    }

    public static void addChart(QCShewhartChart chart) {
        int level = charts.size();
        chart.reset();
        chart.setChartLevel(level -= ichartOff);
        charts.add(chart);
    }

    public static void addChart(QCShewhartChart ch, boolean curr) {
        QCShewhart.addChart(ch);
        if (curr) {
            chart = ch;
        }
    }

    public static void setCurrentChart(QCShewhartChart curr) {
        chart = curr;
    }

    public static QCShewhartChart getCurrentChart() {
        return chart;
    }

    public static void setPrimaryModel(CRD model) {
        primaryModel = model;
    }

    public static CRD getPrimaryModel() {
        return primaryModel;
    }

    public static int getHOffset() {
        return hOffset;
    }

    public static int getVOffset(int ichart) {
        int j = ichart == 0 ? 0 : 1;
        return vOffset[j];
    }

    public static Insets replaceUserOffsets(Insets in, int ichart) {
        int j;
        if (hOffset > 0) {
            in.left = 2 * hOffset;
            in.right = 2 * hOffset;
        }
        int n = j = ichart == 0 ? 0 : 1;
        if (vOffset[j] > 0) {
            in.top = 2 * vOffset[j];
            in.bottom = 2 * vOffset[j];
        }
        return in;
    }

    public static double replaceUserOffset(byte dimension, double in, int ichart) {
        if (dimension == 1) {
            return hOffset > 0 ? (double)(2 * hOffset) : in;
        }
        if (dimension == 2) {
            int j = ichart == 0 ? 0 : 1;
            return vOffset[j] > 0 ? (double)(2 * vOffset[j]) : in;
        }
        return in;
    }

    public static Insets addUserOffsets(Insets in, int ichart) {
        int j;
        if (hOffset > 0) {
            in.left += 2 * hOffset;
            in.right += 2 * hOffset;
        }
        int n = j = ichart == 0 ? 0 : 1;
        if (vOffset[j] > 0) {
            in.top += 2 * vOffset[j];
            in.bottom += 2 * vOffset[j];
        }
        return in;
    }

    public static double addUserOffset(byte dimension, double in, int ichart) {
        if (dimension == 1) {
            return hOffset > 0 ? in + (double)(2 * hOffset) : in;
        }
        if (dimension == 2) {
            int j = ichart == 0 ? 0 : 1;
            return vOffset[j] > 0 ? in + (double)(2 * vOffset[j]) : in;
        }
        return in;
    }

    public static double getUserOffset(byte dimension, int ichart) {
        if (dimension == 1) {
            return hOffset;
        }
        if (dimension == 2) {
            int j = ichart == 0 ? 0 : 1;
            return vOffset[j];
        }
        return -1.0;
    }

    public static void setBlockOffset(int i) {
        userBlockOffset = i;
    }

    public static int getBlockOffset(byte dim) {
        int rc = 0;
        if (dim == 2) {
            rc = 0;
        } else if (dim == 1) {
            double phaseBoxOffset = QCShewhart.getPhaseBoxOffset(dim);
            double blockOffset = userBlockOffset == -1 ? (double)QCMargins.getBlockX() : (double)userBlockOffset;
            phaseBoxOffset = 0.0;
            rc = (int)(blockOffset + phaseBoxOffset);
        } else {
            rc = 0;
        }
        return rc;
    }

    public static int getTextOffset(byte dim) {
        int rc = 0;
        rc = dim == 2 ? 0 : (dim == 1 ? QCMargins.getBlockX() : 0);
        return rc;
    }

    public static int getPhaseOffset(byte dim) {
        int rc = 0;
        rc = dim == 2 ? 0 : (dim == 1 ? QCMargins.getBlockX() : 0);
        return rc;
    }

    public static boolean hasPhaseBox() {
        return phaseBox;
    }

    public static int getPhaseBoxOffset(byte dim) {
        int rc = 0;
        if (dim != 2 && dim == 1 && phaseBox) {
            rc = QCMargins.getBlockX();
            rc = QCMargins.getPhaseBoxInnerX() + QCMargins.getPhaseBoxOuterX();
        }
        return rc;
    }

    public static int getGlyphOffset(byte dim) {
        int rc = 0;
        rc = dim == 2 ? 0 : (dim == 1 ? (glyph ? glyphOffset : 0) : 0);
        return rc;
    }

    public static void resetGlyphOffset(double d) {
        int i = (int)(d + 0.5);
        QCShewhart.setGlyphOffset(i, true);
    }

    public static void setGlyphOffset(double d) {
        int i = (int)(d + 0.5);
        QCShewhart.setGlyphOffset(i, false);
    }

    public static void setGlyphOffset(int i, boolean reset) {
        int n = glyphOffset = reset ? i : Math.max(glyphOffset, i);
        if (glyphOffset > 0) {
            glyph = true;
        }
    }

    public static int getCurrentPageNumber() {
        return iPage;
    }

    public static int getTotalNumberOfPages() {
        return nPage;
    }

    public static boolean isFirstPage() {
        return iPage == 1;
    }

    public static boolean isLastPage() {
        return iPage == nPage;
    }

    public static boolean singlePage() {
        return nPage == 1;
    }

    public static int getNPanel() {
        int b;
        int a;
        int n = a = igrpLower == -1 ? 0 : igrpLower;
        if (nInc > 0) {
            return nInc;
        }
        if (igrpUpper == -1) {
            boolean skipLegendObs = true;
            int ngrp = 0;
            int n2 = charts.size();
            for (int i = 0; i < n2; ++i) {
                chart = charts.get(i);
                Vector<QCOverlay> responses = chart.getResponseOverlays();
                if (responses.isEmpty()) continue;
                QCOverlay response = responses.firstElement();
                CRD model = response.getModel();
                int nRows = model.getRowCount();
                if (skipLegendObs) {
                    double[] x = null;
                    double[] y = null;
                    if (model.isAvailable(10)) {
                        x = model.getDoubleColumn(10);
                    }
                    if (model.isAvailable(11)) {
                        y = model.getDoubleColumn(11);
                    }
                    for (int j = nRows - 1; j >= 0; --j) {
                        boolean yMissing;
                        boolean xMissing = x != null ? Double.isNaN(x[j]) : false;
                        boolean bl = yMissing = y != null ? Double.isNaN(y[j]) : false;
                        if (xMissing && yMissing) continue;
                        nRows = j + 1;
                        break;
                    }
                }
                ngrp = Math.max(nRows, ngrp);
            }
            b = ngrp == 0 ? 0 : ngrp - 1;
        } else {
            b = igrpUpper;
        }
        return b - a + 1;
    }

    public static int getLowerSubgrpIndex() {
        return primaryModel == null ? -1 : QCShewhart.getLowerSubgrpIndex(primaryModel);
    }

    public static int getLowerSubgrpIndex(CRD model) {
        int min = 0;
        int max = model.getRowCount() - 1;
        if (igrpLower == -1) {
            return min;
        }
        min = Math.min(max, igrpLower);
        min = Math.max(0, igrpLower);
        return min;
    }

    public static int getUpperSubgrpIndex() {
        return primaryModel == null ? -1 : QCShewhart.getUpperSubgrpIndex(primaryModel);
    }

    public static int getUpperSubgrpIndex(CRD model) {
        boolean min = false;
        int max = model.getRowCount() - 1;
        if (igrpUpper == -1) {
            return ngrp == -1 ? max : Math.min(max, ngrp - 1);
        }
        max = Math.min(max, igrpUpper);
        max = Math.max(0, igrpUpper);
        return max;
    }

    public static int getNMin() {
        return nMin;
    }

    public static int getNMax() {
        return nMax;
    }

    public static void setClipChartAreaOn(boolean b) {
        clipChartArea = b;
    }

    public static boolean isClipChartAreaOn() {
        return clipChartArea;
    }

    public static void setConnectAcrossPages(boolean b) {
        connectAcrossPages = b;
    }

    public static boolean isConnectedAcrossPages() {
        return connectAcrossPages;
    }

    public static int getDefaultAxisOffset(MarginOffsetType type) {
        int offset = 0;
        switch (type) {
            case OFFSET_XMIN: {
                offset = 0;
                break;
            }
            case OFFSET_YMIN: {
                offset = 0;
                break;
            }
            case OFFSET_XMAX: {
                offset = 0;
                break;
            }
            case OFFSET_YMAX: {
                offset = 0;
            }
        }
        return offset;
    }

    public static void setGraphics2D(Graphics2D g2) {
        g = g2;
    }

    public static Graphics2D getGraphics2D() {
        return g;
    }

    public static boolean isSubsetted() {
        return subsetted;
    }

    public static boolean getFrontRef() {
        return frontRef;
    }

    public static boolean isMultiVariatePlot() {
        return mvplot;
    }

    public static void setExtendedRange(boolean b) {
        superSet = b;
    }

    public static boolean useExtendedRange() {
        return superSet;
    }

    public static int applySubsetList() {
        int n = primaryModel == null ? 0 : primaryModel.getRowCount();
        return n;
    }

    public static int applySupersetList() {
        int n = primaryModel == null ? 0 : primaryModel.getRowCount();
        return n;
    }

    public static int applyNullList() {
        int n = primaryModel == null ? 0 : primaryModel.getRowCount();
        return n;
    }

    public static int resetNPts() {
        return QCShewhart.applyNullList();
    }

    public static int getNPts() {
        int nPts = QCShewhart.isConnectedAcrossPages() ? QCShewhart.applySupersetList() : QCShewhart.applySubsetList();
        return nPts;
    }

    public static boolean glyphChart() {
        int nCharts = charts.size();
        boolean rc = false;
        block0: for (int i = 0; i < nCharts; ++i) {
            QCShewhartChart ch = charts.get(i);
            if (ch == null) continue;
            Vector<QCOverlay> responses = ch.getResponseOverlays();
            int n = responses.size();
            for (int j = 0; j < n; ++j) {
                QCOverlay response = responses.get(j);
                if (response == null || !response.isGlyph()) continue;
                rc = true;
                continue block0;
            }
        }
        return rc;
    }

    public static void setHighlight(boolean b) {
        highlight = b;
    }

    public static boolean getHighlight() {
        return highlight;
    }

    public static void setStatGraph(StatGraph graph) {
        statGraph = graph;
    }

    public static StatGraph getStatGraph() {
        return statGraph;
    }

    public static void setIntervalWidth(double w) {
        intervalWidth = w;
    }

    public static double getIntervalWidth() {
        return intervalWidth;
    }

    public static void setPhaseLegend(boolean b) {
        phaseLegend = b;
    }

    public static boolean getPhaseLegend() {
        return phaseLegend;
    }

    public static int getAdjustedBlockOffset() {
        int bo = QCShewhart.getBlockOffset((byte)1);
        int go = QCShewhart.getGlyphOffset((byte)1);
        int pbo = QCShewhart.getPhaseBoxOffset((byte)1);
        int blockOffset = bo + go + pbo;
        double interval = QCShewhart.getIntervalWidth();
        if (QCShewhart.hasPhaseBox() && (double)(2 * blockOffset) > interval) {
            int fuzz = 1;
            blockOffset = go + pbo + fuzz;
        }
        return blockOffset;
    }

    public static void subsetX(DataModel m, int col) {
        QCShewhart.subsetX(m, col, 0);
    }

    public static void subsetX(DataModel m, int col, int igrp_col) {
        double[] xi;
        if (col == 0) {
            return;
        }
        if (subsetData) {
            return;
        }
        if (igrpLower == -1 && igrpUpper == -1) {
            return;
        }
        boolean numeric = m.getColumnClass(col) == Double.class;
        double[] dArray = xi = igrp_col == 0 ? null : m.getDoubleColumn(igrp_col);
        if (numeric) {
            double[] xd = m.getDoubleColumn(col);
            int n = xd.length;
            for (int i = 0; i < n; ++i) {
                int igrp;
                int n2 = igrp = xi == null ? i : (int)xi[i];
                if (igrpLower != -1 && igrp < igrpLower) {
                    xd[i] = Double.NaN;
                }
                if (igrpUpper == -1 || igrp <= igrpUpper) continue;
                xd[i] = Double.NaN;
            }
        } else {
            String[] xs = m.getStringColumn(col);
            int n = xs.length;
            for (int i = 0; i < n; ++i) {
                int igrp;
                int n3 = igrp = xi == null ? i : (int)xi[i];
                if (igrpLower != -1 && igrp < igrpLower) {
                    xs[i] = "";
                }
                if (igrpUpper == -1 || igrp <= igrpUpper) continue;
                xs[i] = "";
            }
        }
    }

    public static void subsetBoxX(DataModel m, int col) {
        QCShewhart.subsetBoxX(m, col, 0);
    }

    public static void subsetBoxX(DataModel m, int col, int igrp_col) {
        boolean numeric;
        if (subsetData) {
            return;
        }
        if (igrpLower == -1 && igrpUpper == -1) {
            return;
        }
        boolean bl = numeric = m.getColumnClass(col) == Double.class;
        if (numeric) {
            double[] xd = m.getDoubleColumn(col);
            int n = xd.length;
            for (int i = 0; i < n; ++i) {
                int igrp = (int)xd[i];
                if (igrpLower != -1 && igrp < igrpLower) {
                    xd[i] = Double.NaN;
                }
                if (igrpUpper == -1 || igrp <= igrpUpper) continue;
                xd[i] = Double.NaN;
            }
        } else {
            String[] xs = m.getStringColumn(col);
            int n = xs.length;
        }
    }

    public static void subsetY(DataModel m, int col) {
        QCShewhart.subsetY(m, col, 0);
    }

    public static void subsetY(DataModel m, int col, int igrp_col) {
        if (col == 0) {
            return;
        }
        if (subsetData) {
            return;
        }
        if (igrpLower == -1 && igrpUpper == -1) {
            return;
        }
        double[] xi = igrp_col == 0 ? null : m.getDoubleColumn(igrp_col);
        double[] y = m.getDoubleColumn(col);
        int n = Math.min(y.length, ngrp);
        for (int i = 0; i < n; ++i) {
            int igrp;
            int n2 = igrp = xi == null ? i : (int)xi[i];
            if (igrpLower != -1 && igrp < igrpLower) {
                y[i] = Double.NaN;
            }
            if (igrpUpper == -1 || igrp <= igrpUpper) continue;
            y[i] = Double.NaN;
        }
    }

    public static void subsetLegend(DataModel m, int col) {
        QCShewhart.subsetLegend(m, col, 0);
    }

    public static void subsetLegend(DataModel m, int col, int igrp_col) {
        if (col == 0) {
            return;
        }
        if (subsetData) {
            return;
        }
        if (igrpLower == -1 && igrpUpper == -1) {
            return;
        }
        double[] xi = igrp_col == 0 ? null : m.getDoubleColumn(igrp_col);
        double[] l = m.getDoubleColumn(col);
        int n = Math.min(l.length, ngrp);
        for (int i = 0; i < n; ++i) {
            int igrp;
            int n2 = igrp = xi == null ? i : (int)xi[i];
            if (igrpLower != -1 && igrp < igrpLower) {
                l[i] = Double.NaN;
            }
            if (igrpUpper == -1 || igrp <= igrpUpper) continue;
            l[i] = Double.NaN;
        }
    }

    public static boolean useQCSymbols() {
        return qcSymbols;
    }

    public static enum MarginOffsetType {
        OFFSET_XMIN,
        OFFSET_YMIN,
        OFFSET_XMAX,
        OFFSET_YMAX;

    }
}

