/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph;

import com.sas.analytics.qc.statgraph.QCLayoutOverlayParser;
import com.sas.analytics.qc.statgraph.QCParserUtils;
import com.sas.analytics.qc.statgraph.QCScatterParser;
import com.sas.analytics.qc.statgraph.QCShewhart;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCScatterOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCSeriesOverlay;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.MarkerAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.common.attrmap.AttrMapper;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.text.Message;
import com.sas.text.SASFormat;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class QCSeriesParser {
    public static final String RB_KEY = "QCSeriesParser.";

    public static QCSeriesOverlay load(StatGraph graph, Element elem, int autoCurveLabelPosition) {
        QCSeriesOverlay series = (QCSeriesOverlay)((Object)graph.getObjectFromElement(elem));
        if (series == null) {
            series = new QCSeriesOverlay();
        }
        return QCSeriesParser.load(graph, series, elem, autoCurveLabelPosition) ? series : null;
    }

    public static boolean load(StatGraph graph, QCScatterOverlay plot, Element elem, int autoCurveLabelPosition) {
        Element roleElement;
        String indexVarID;
        int ii;
        RoleColumnMap map = new RoleColumnMap();
        DataModel m = QCScatterParser.parseXYVariables(plot, graph, elem, map);
        if (m == null) {
            return false;
        }
        boolean ok = true;
        plot.setScaleMarkers(false);
        QCLayoutOverlayParser.parseGraphOpts(graph, elem, plot);
        Element _internal = ParserUtils.getChildWithTagName((String)"_internal", (Element)elem);
        if (!QCSeriesParser.loadInternal(graph, plot, _internal)) {
            // empty if block
        }
        String str = elem.getAttribute("primary");
        plot.setPrimary(str.equalsIgnoreCase("true"));
        if (plot.getStmt().equalsIgnoreCase("RegressionPlot")) {
            plot.setImagemapThreshold(graph.imagemapThreshold);
        }
        if (plot.getPlotType() == 5) {
            if (plot.isVerticalFill()) {
                plot.setDiscreteX(true);
                plot.setDiscreteY(false);
            } else {
                plot.setDiscreteX(false);
                plot.setDiscreteY(true);
            }
        } else {
            if (plot.getXAxis().equalsIgnoreCase("x2")) {
                plot.setDiscreteX(QCLayoutOverlayParser.x2AxisType == 2);
            } else {
                plot.setDiscreteX(QCLayoutOverlayParser.xAxisType == 2);
            }
            if (plot.getYAxis().equalsIgnoreCase("y2")) {
                plot.setDiscreteY(QCLayoutOverlayParser.y2AxisType == 2);
            } else {
                plot.setDiscreteY(QCLayoutOverlayParser.yAxisType == 2);
            }
        }
        if ((plot.isDiscreteX() || plot.isDiscreteY()) && QCSeriesParser.isComputedPlot(elem)) {
            Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"computed.fmt.txt"));
            StatGraph.printWarning((String)msg.toString((Object)elem.getAttribute("_stmt").toUpperCase()));
            graph.removeNamedGraph((Overlay)plot);
            return false;
        }
        str = elem.getAttribute("group");
        String groupVarID = StatGraph.getVarID((String)str);
        if (QCLayoutOverlayParser.hasTooManyGroups(graph, m, groupVarID)) {
            groupVarID = "";
        }
        if ((str = elem.getAttribute("smoothConnect")).equalsIgnoreCase("true")) {
            plot.setJoinType((byte)1);
        }
        Element labelElem = null;
        Element curveLabelElem = null;
        Element lineElem = null;
        Element markerElem = null;
        Element fillElem = null;
        Element oocLineElem = null;
        Element oocFillElem = null;
        Element oocMarkerElem = null;
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("DataLabelAttrs")) {
                labelElem = (Element)node;
                continue;
            }
            if (elemTag.equals("CurveLabelAttrs")) {
                curveLabelElem = (Element)node;
                continue;
            }
            if (elemTag.equals("LineAttrs")) {
                lineElem = (Element)node;
                continue;
            }
            if (elemTag.equals("MarkerAttrs")) {
                markerElem = (Element)node;
                continue;
            }
            if (elemTag.equals("FillAttrs")) {
                fillElem = (Element)node;
                continue;
            }
            if (elemTag.equals("OOCLineAttrs")) {
                oocLineElem = (Element)node;
                continue;
            }
            if (elemTag.equals("OOCFillAttrs")) {
                oocFillElem = (Element)node;
                continue;
            }
            if (!elemTag.equals("OOCMarkerAttrs")) continue;
            oocMarkerElem = (Element)node;
        }
        String mrkAttr = elem.getAttribute("markerAttrs");
        String lineAttr = elem.getAttribute("lineAttrs");
        String fillAttr = elem.getAttribute("fillAttrs");
        String oocLineAttr = elem.getAttribute("OOCLineAttrs");
        String oocFillAttr = elem.getAttribute("OOCFillAttrs");
        String oocMarkerAttr = elem.getAttribute("OOCMarkerAttrs");
        boolean hasMarkers = false;
        str = elem.getAttribute("display");
        if (str.length() > 0 && !str.equalsIgnoreCase("standard")) {
            if (str.equalsIgnoreCase("all")) {
                plot.setFillOn(false);
                hasMarkers = true;
            } else {
                hasMarkers = false;
                plot.setFillOn(false);
                String[] opts = StatGraph.parseList2String((String)str);
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("markers")) {
                        hasMarkers = true;
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("fill")) {
                        plot.setFillOn(true);
                        continue;
                    }
                    hasMarkers = false;
                    plot.setFillOn(false);
                    StatGraph.printOptionError((String)"DISPLAY", (String)opts[i]);
                    break;
                }
            }
        }
        if (groupVarID.length() > 0) {
            String linePatternGroupVarID;
            int gcol = m.getColumn(groupVarID);
            boolean groupMapped = false;
            str = elem.getAttribute("lineColorGroup");
            String lineColorGroupVarID = StatGraph.getVarID((String)str);
            if (lineColorGroupVarID.length() > 0) {
                String indexVarID2;
                int ii2;
                int col = m.getColumn(lineColorGroupVarID);
                map.map(46, col);
                plot.addRole("LINECOLOR", m.getColumnLabel(col));
                groupMapped = true;
                str = elem.getAttribute("lineColorGroupAttrVar");
                if (str.length() > 0) {
                    plot.addAttrVar("LINECOLORGROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
                }
                if ((str = elem.getAttribute("lineColorGroupIndex")).length() > 0 && StatGraph.checkVariable((String)"LINECOLORGROUPINDEX", (Object)m.getColumnLabel(ii2 = m.getColumn(indexVarID2 = StatGraph.getVarID((String)str))), Double.class, (int)2, (boolean)true, (boolean)false) && QCScatterParser.checkIndexColumn(m, ii2, "LINECOLORGROUPINDEX", indexVarID2)) {
                    map.map(110, ii2);
                    plot.addRole("LINECOLORINDEX", m.getColumnLabel(ii2));
                }
            }
            if ((linePatternGroupVarID = StatGraph.getVarID((String)(str = elem.getAttribute("linePatternGroup")))).length() > 0) {
                String indexVarID3;
                int ii3;
                int col = m.getColumn(linePatternGroupVarID);
                map.map(36, col);
                plot.addRole("LINE", m.getColumnLabel(col));
                groupMapped = true;
                str = elem.getAttribute("linePatternGroupAttrVar");
                if (str.length() > 0) {
                    plot.addAttrVar("LINEPATTERNGROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
                }
                if ((str = elem.getAttribute("linePatternGroupIndex")).length() > 0 && StatGraph.checkVariable((String)"LINEPATTERNGROUPINDEX", (Object)m.getColumnLabel(ii3 = m.getColumn(indexVarID3 = StatGraph.getVarID((String)str))), Double.class, (int)2, (boolean)true, (boolean)false) && QCScatterParser.checkIndexColumn(m, ii3, "LINEPATTERNGROUPINDEX", indexVarID3)) {
                    map.map(43, ii3);
                    plot.addRole("LINEINDEX", m.getColumnLabel(ii3));
                }
            }
            if (!(map.isRoleMapped(46) || lineElem != null && lineElem.hasAttribute("color") || lineAttr.length() != 0)) {
                map.map(46, gcol);
                groupMapped = true;
            }
            if (!(map.isRoleMapped(36) || lineElem != null && lineElem.hasAttribute("pattern") || lineAttr.length() != 0)) {
                map.map(36, gcol);
                groupMapped = true;
            }
            if (hasMarkers) {
                groupMapped = StatGraph.mapMarkerRoles((StatGraph)graph, (Element)elem, (RoleColumnMap)map, (Element)markerElem, (String)mrkAttr, (int)gcol, (boolean)groupMapped, (DataModel)m, (Overlay)plot);
            }
            map.map(3, gcol);
            plot.addRole("GROUP", m.getColumnLabel(gcol));
            if (groupMapped && (str = elem.getAttribute("groupAttrVar")).length() > 0) {
                plot.addAttrVar("GROUP", (AttrMapper)graph.getDiscreteAttrVar(str));
            }
            if ((str = elem.getAttribute("includeMissingGroup")).length() > 0 && str.equalsIgnoreCase("false")) {
                plot.setMissingGroupOn(false);
            }
        }
        if (groupVarID.length() > 0) {
            str = elem.getAttribute("groupOrder");
            if (str.length() > 0) {
                if (str.equalsIgnoreCase("Ascending")) {
                    plot.setGroupOrder(1);
                } else if (str.equalsIgnoreCase("Descending")) {
                    plot.setGroupOrder(2);
                } else if (str.equalsIgnoreCase("Data")) {
                    plot.setGroupOrder(0);
                } else {
                    plot.setGroupOrder(0);
                    StatGraph.printOptionError((String)"GROUPORDER", (String)str);
                }
            }
            if (StatGraph.isNumber((String)(str = elem.getAttribute("clusterWidth")))) {
                plot.setClusterWidth(Double.parseDouble(str));
            }
            if ((str = elem.getAttribute("groupDisplay")).equalsIgnoreCase("Cluster")) {
                plot.setGroupDisplay(0);
            } else {
                plot.setGroupDisplay(1);
            }
        }
        StatGraph.parseURLOpt((Element)elem, (DataModel)m, (RoleColumnMap)map, (Overlay)plot);
        str = elem.getAttribute("dataLabel");
        String labelVarID = StatGraph.getVarID((String)str);
        boolean labelVisible = false;
        if (!labelVarID.equals("")) {
            int lcol = m.getColumn(labelVarID);
            map.map(5, lcol);
            ColumnMetadata cmd = (ColumnMetadata)m.getColumnLabel(lcol);
            int nms = cmd.getNobs() - cmd.getMissings();
            if (nms == 0) {
                map.unmapRole(5);
            } else {
                boolean labelingEnabled;
                labelVisible = true;
                boolean bl = labelingEnabled = nms <= graph.labelingThreshold;
                if (!labelingEnabled) {
                    Message msg = new Message(RB.getStringResource((String)"StatGraph.", (String)"labeling.fmt.txt"));
                    StatGraph.printNote((String)msg.toString((Object)String.valueOf(StatGraph.roundToNextHundreds((int)nms))), (boolean)false);
                } else if (cmd.getNobs() > 5 * graph.labelingThreshold) {
                    labelingEnabled = false;
                    Message msg = new Message(RB.getStringResource((String)"StatGraph.", (String)"labeling.fmt.txt"));
                    StatGraph.printNote((String)msg.toString((Object)String.valueOf(StatGraph.roundToNextHundreds((int)cmd.getNobs()))), (boolean)false);
                }
                int position = QCScatterParser.parseDataLabelPosition(elem);
                if (position != -1) {
                    labelingEnabled = false;
                    plot.setFixedDataLabelPosition(position);
                }
                if (plot.getDataLabelRotate()) {
                    plot.setFixedDataLabelPosition(10);
                }
                plot.setLabelCollisionAvoidance(labelingEnabled);
                plot.setLabelVisible(true);
            }
            plot.addRole("DATALABEL", m.getColumnLabel(lcol));
        }
        if ((str = elem.getAttribute("curveLabel")).length() > 0) {
            Message msg;
            Message msg2;
            String curveLabelVarID;
            int type = StatGraph.getAttributeType((Element)elem, (String)"curveLabel");
            if (type < 0) {
                if (StatGraph.getDataName((String)str).length() > 0) {
                    curveLabelVarID = StatGraph.getVarID((String)str);
                    if (m.hasColumn(curveLabelVarID)) {
                        if (groupVarID.length() > 0) {
                            int clcol = m.getColumn(curveLabelVarID);
                            map.map(48, clcol);
                            plot.addRole("CURVELABEL", m.getColumnLabel(clcol));
                        } else {
                            msg2 = new Message(RB.getStringResource((String)RB_KEY, (String)"label1.fmt.txt"));
                            StatGraph.printNote((String)msg2.toString((Object)curveLabelVarID));
                        }
                    }
                } else if (groupVarID.length() > 0) {
                    msg = new Message(RB.getStringResource((String)RB_KEY, (String)"label2.fmt.txt"));
                    StatGraph.printNote((String)msg.toString((Object)str));
                } else {
                    plot.setCurveLabelString(str);
                }
            } else if (type == 0) {
                curveLabelVarID = StatGraph.getVarID((String)str);
                if (m.hasColumn(curveLabelVarID)) {
                    if (groupVarID.length() > 0) {
                        int clcol = m.getColumn(curveLabelVarID);
                        map.map(48, clcol);
                        plot.addRole("CURVELABEL", m.getColumnLabel(clcol));
                    } else {
                        msg2 = new Message(RB.getStringResource((String)RB_KEY, (String)"label1.fmt.txt"));
                        StatGraph.printNote((String)msg2.toString((Object)curveLabelVarID));
                    }
                }
            } else if (groupVarID.length() > 0) {
                msg = new Message(RB.getStringResource((String)RB_KEY, (String)"label2.fmt.txt"));
                String val = type == 2 ? str : "'" + str + "'";
                StatGraph.printNote((String)msg.toString((Object)val));
            } else {
                plot.setCurveLabelString(str);
            }
        }
        if ((str = elem.getAttribute("index")).length() > 0 && StatGraph.checkVariable((String)"INDEX", (Object)m.getColumnLabel(ii = m.getColumn(indexVarID = StatGraph.getVarID((String)str))), Double.class, (int)2, (boolean)true, (boolean)false) && QCScatterParser.checkIndexColumn(m, ii, "INDEX", indexVarID)) {
            if (map.isRoleMapped(46) || map.isRoleMapped(45)) {
                map.map(41, ii);
            }
            if (map.isRoleMapped(36) && !map.isRoleMapped(43)) {
                map.map(43, ii);
            }
            if (map.isRoleMapped(8) && !map.isRoleMapped(42)) {
                map.map(42, ii);
            }
            plot.addRole("INDEX", m.getColumnLabel(ii));
        }
        if ((roleElement = StatGraph.getOptionAttrsElement((Element)elem, (String)"Roles")) != null) {
            Object cmd;
            int col;
            String var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_Y");
            if (m.hasColumn(var)) {
                col = m.getColumn(var);
                cmd = m.getColumnLabel(col);
                map.map(792, col);
                plot.addRole("OUTFILL", cmd);
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_SUBGRPLABEL"))) {
                col = m.getColumn(var);
                cmd = m.getColumnLabel(col);
                map.map(798, col);
                plot.addRole("SUBGRPLABEL", cmd);
            }
            int xcol = map.getColumn(10);
            int ycol = map.getColumn(11);
            var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_IGRP");
            if (m.hasColumn(var)) {
                col = m.getColumn(var);
                cmd = m.getColumnLabel(col);
                map.map(802, col);
                plot.addRole("IGRP", cmd);
                QCShewhart.subsetX(m, xcol, col);
                QCShewhart.subsetY(m, ycol, col);
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_OOC"))) {
                col = m.getColumn(var);
                cmd = m.getColumnLabel(col);
                map.map(796, col);
                plot.addRole("OOC", cmd);
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_GROUPPHASE"))) {
                col = m.getColumn(var);
                cmd = m.getColumnLabel(col);
                map.map(793, col);
                plot.addRole("GROUPPHASE", cmd);
            }
        }
        QCLayoutOverlayParser.parseRoleTipStuff(elem, m, map, plot);
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        QCLayoutOverlayParser.parseWhere(graph, crd, plot);
        str = elem.getAttribute("sortRole");
        if (str.length() > 0 && str.equalsIgnoreCase("x")) {
            crd.setSortRole(10);
        }
        if ((str = elem.getAttribute("dataSelectable")).length() > 0 && str.equalsIgnoreCase("true")) {
            plot.setDataSelectable(true);
        }
        if (StatGraph.isNumber((String)(str = elem.getAttribute("barWidth")))) {
            double barWidth = Double.parseDouble(str);
            if (barWidth >= 0.0 && barWidth <= 1.0) {
                plot.setBarWidth(barWidth);
            } else {
                StatGraph.printOptionError((String)"BARWIDTH", (String)str);
            }
        } else if (str.length() > 0) {
            StatGraph.printOptionError((String)"BARWIDTH", (String)str);
        }
        str = elem.getAttribute("anchor");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("TOPCENTER")) {
                plot.setBarLineAnchor(0);
            } else if (str.equalsIgnoreCase("TOPEND")) {
                plot.setBarLineAnchor(1);
            } else if (str.equalsIgnoreCase("BOTTOMCENTER")) {
                plot.setBarLineAnchor(3);
            } else if (str.equalsIgnoreCase("BOTTOMSTART")) {
                plot.setBarLineAnchor(2);
            } else {
                StatGraph.printOptionError((String)"ANCHOR", (String)str);
            }
        }
        if ((str = elem.getAttribute("discreteOffset")).length() > 0 && !QCSeriesParser.isDiscreteOffsetSupported(plot)) {
            Message msg = new Message(RB.getStringResource((String)"StatGraph.", (String)"doffset.fmt.txt"));
            StatGraph.printNote((String)msg.toString((Object)str));
        } else if (StatGraph.isNumber((String)str)) {
            double offset = Double.parseDouble(str);
            if (offset >= -0.5 && offset <= 0.5) {
                plot.setDiscreteOffset(offset);
            } else {
                StatGraph.printOptionError((String)"DISCRETEOFFSET", (String)str);
            }
        } else if (str.length() > 0) {
            StatGraph.printOptionError((String)"DISCRETEOFFSET", (String)str);
        }
        str = elem.getAttribute("dataSkin");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("pressed")) {
                plot.setSkinType(3);
                plot.setSkinnedLine(true);
            } else if (str.equalsIgnoreCase("sheen")) {
                plot.setSkinType(4);
                plot.setSkinnedLine(true);
            } else if (str.equalsIgnoreCase("crisp")) {
                plot.setSkinType(5);
                plot.setSkinnedLine(true);
            } else if (str.equalsIgnoreCase("gloss")) {
                plot.setSkinType(6);
                plot.setSkinnedLine(true);
            } else if (str.equalsIgnoreCase("matte")) {
                plot.setSkinType(7);
                plot.setSkinnedLine(true);
            } else if (str.equalsIgnoreCase("none")) {
                plot.setSkinType(0);
                plot.setSkinnedLine(false);
            } else {
                StatGraph.printOptionError((String)"DATASKIN", (String)str);
            }
        }
        plot.setModel(crd);
        str = elem.getAttribute("connectOrder");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("xAxis")) {
                plot.setConnectOrder(1);
            } else if (str.equalsIgnoreCase("xValues")) {
                plot.setConnectOrder(0);
            } else {
                StatGraph.printOptionError((String)"CONNECTORDER", (String)str);
            }
        }
        String contextName = graph.style.isCycleAttrs() ? graph.style.getContextName() : (QCSeriesParser.isComputedPlot(elem) ? "Fit" : "GraphDataStyleDefault");
        plot.setContextName(contextName);
        if (hasMarkers) {
            MarkerAttrs ms = new MarkerAttrs();
            GraphStyle.setDefaultMarkerStyle((StatGraph)graph, (String)mrkAttr, (MarkerAttrs)ms, (String)contextName);
            if (markerElem != null) {
                StatGraph.parseMarkerAttrs((StatGraph)graph, (Element)markerElem, (MarkerAttrs)ms);
            }
            plot.setDefaultMarkerColor(ms.getColor());
            plot.setDefaultMarkerShape((short)ms.getShape());
            plot.setDefaultMarkerWeight(ms.getWeight());
            plot.setMinMarkerSize(ms.getSize());
            plot.setMaxMarkerSize(ms.getSize());
            plot.setDefaultMarkerScale(0.0);
        } else {
            plot.setDefaultMarkerShape((short)-1);
        }
        plot.setJoinVisible(true);
        LineAttrs ls = plot.getLineStyle();
        GraphStyle.setDefaultDataLineStyle((StatGraph)graph, (String)lineAttr, (LineAttrs)ls, (String)contextName);
        if (lineElem != null) {
            StatGraph.parseLineAttrs((StatGraph)graph, (Element)lineElem, (LineAttrs)plot.getLineStyle());
        }
        if (groupVarID.length() > 0 && StatGraph.isBundleAttributeFixed((Element)elem, (String)"lineAttrs", (String)"color") && !StatGraph.isBundleAttributeFixed((Element)elem, (String)"markerAttrs", (String)"color")) {
            plot.setDefaultMarkerColor(plot.getLineStyle().getColor());
        }
        ls = plot.getOOCLineStyle();
        GraphStyle.setDefaultLineStyle((StatGraph)graph, (String)oocLineAttr, (LineAttrs)ls, (String)"KPIRange1");
        if (oocLineElem != null) {
            StatGraph.parseLineAttrs((StatGraph)graph, (Element)oocLineElem, (LineAttrs)ls);
        }
        if (plot.isFillOn()) {
            GraphStyle.setDefaultDataFillStyle((StatGraph)graph, (String)fillAttr, (FillAttrs)plot.getFillStyle(), (String)graph.style.getContextName());
            if (fillElem != null) {
                StatGraph.parseFillAttrs((StatGraph)graph, (Element)fillElem, (FillAttrs)plot.getFillStyle());
            }
        }
        FillAttrs fillStyle = plot.getOOCFillAttrs();
        GraphStyle.setDefaultFillStyle((StatGraph)graph, (String)oocFillAttr, (FillAttrs)fillStyle, (String)"RunTest");
        if (oocFillElem != null) {
            StatGraph.parseFillAttrs((StatGraph)graph, (Element)oocFillElem, (FillAttrs)fillStyle);
        }
        MarkerAttrs markerStyle = plot.getOOCMarkerAttrs();
        GraphStyle.setDefaultMarkerStyle((StatGraph)graph, (String)oocMarkerAttr, (MarkerAttrs)markerStyle, (String)"RunTest");
        if (oocMarkerElem != null) {
            StatGraph.parseMarkerAttrs((StatGraph)graph, (Element)oocMarkerElem, (MarkerAttrs)markerStyle);
        }
        if ((str = elem.getAttribute("break")).equalsIgnoreCase("true")) {
            plot.setSkipMiss(true);
        }
        boolean b = QCParserUtils.getBoolean("phaseBreak", elem, false);
        plot.setPhaseBreak(b);
        if (labelVisible) {
            GraphStyle.setDefaultTextStyle((StatGraph)graph, (String)elem.getAttribute("dataLabelAttrs"), (TextStyle)plot.getLabelStyle(), (String)"DataText");
            if (groupVarID.length() <= 0 || StatGraph.isBundleAttributeFixed((Element)elem, (String)"dataLabelAttrs", (String)"color")) {
                if (graph.style.isCycleAttrs()) {
                    plot.getLabelStyle().setColor(plot.getLineStyle().getColor());
                }
                plot.setUseLabelColor(true);
            }
            if (labelElem != null) {
                StatGraph.parseTextAttrs((StatGraph)graph, (Element)labelElem, (TextStyle)plot.getLabelStyle());
            }
            if ((str = elem.getAttribute("dataLabelFormat")).length() > 0) {
                plot.setLabelFormat(SASFormat.getInstance((String)str));
            }
        }
        if ((str = elem.getAttribute("dataLabelProtected")).equalsIgnoreCase("true")) {
            plot.setProtectedSeries(true);
        } else if (str.equalsIgnoreCase("false")) {
            plot.setProtectedSeries(false);
        } else {
            plot.setProtectedSeries(labelVisible);
        }
        str = elem.getAttribute("curveLabelLocation");
        if (str.equalsIgnoreCase("INSIDE")) {
            plot.setCurveLabelLocation(0);
        } else if (str.equalsIgnoreCase("OUTSIDE")) {
            plot.setCurveLabelLocation(1);
        } else {
            plot.setCurveLabelLocation(0);
            if (str.length() > 0) {
                StatGraph.printOptionError((String)"CURVELABELLOCATION", (String)str);
            }
        }
        str = elem.getAttribute("curveLabelPosition");
        if (str.equalsIgnoreCase("MIN")) {
            plot.setCurveLabelPosition(0);
        } else if (str.equalsIgnoreCase("MAX")) {
            plot.setCurveLabelPosition(1);
        } else if (str.equalsIgnoreCase("START") && plot.getCurveLabelLocation() == 0) {
            plot.setCurveLabelPosition(2);
        } else if (str.equalsIgnoreCase("END") && plot.getCurveLabelLocation() == 0) {
            plot.setCurveLabelPosition(3);
        } else if (str.equalsIgnoreCase("AUTO") && plot.getCurveLabelLocation() == 1) {
            plot.setCurveLabelPosition(autoCurveLabelPosition);
        } else {
            if (plot.getCurveLabelLocation() == 1) {
                plot.setCurveLabelPosition(autoCurveLabelPosition);
            } else {
                plot.setCurveLabelPosition(3);
            }
            if (str.length() > 0) {
                StatGraph.printOptionError((String)"CURVELABELPOSITION", (String)str);
            }
        }
        if (plot.isCurveLabeled()) {
            GraphStyle.setDefaultTextStyle((StatGraph)graph, (String)elem.getAttribute("curveLabelAttrs"), (TextStyle)plot.getCurveLabelStyle(), (String)"ValueText");
            if (graph.style.isCycleAttrs()) {
                plot.getCurveLabelStyle().setColor(plot.getLineStyle().getColor());
            }
            if (curveLabelElem != null) {
                StatGraph.parseTextAttrs((StatGraph)graph, (Element)curveLabelElem, (TextStyle)plot.getCurveLabelStyle());
            }
            if (groupVarID.length() <= 0 || StatGraph.isBundleAttributeFixed((Element)elem, (String)"curveLabelAttrs", (String)"color")) {
                plot.setUseCurveLabelColor(true);
            }
        }
        QCScatterParser.parseSelectionColor(plot, graph);
        QCScatterParser.parseLabelVisibles(plot, elem);
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        int startContrastColorIndex = -1;
        if (crd.isAvailable(46)) {
            graph.style.setContextCount(contextCount);
            startContrastColorIndex = graph.style.getContextCount();
            QCLayoutOverlayParser.setDiscreteEncoder(graph, plot, (byte)17);
        }
        if (crd.isAvailable(36)) {
            graph.style.setContextCount(contextCount);
            QCLayoutOverlayParser.setDiscreteEncoder(graph, plot, (byte)15);
        }
        if (crd.isAvailable(45)) {
            graph.style.setContextCount(contextCount);
            if (startContrastColorIndex >= 0) {
                graph.style.setContrastColorCount(startContrastColorIndex);
            }
            QCLayoutOverlayParser.setDiscreteEncoder(graph, plot, (byte)16);
        }
        if (crd.isAvailable(8)) {
            graph.style.setContextCount(contextCount);
            QCLayoutOverlayParser.setDiscreteEncoder(graph, plot, (byte)6);
        }
        if (crd.isAvailable(26)) {
            QCLayoutOverlayParser.setContinuousEncoder(graph, plot, (byte)7);
        }
        if (crd.isAvailable(27)) {
            QCLayoutOverlayParser.setContinuousEncoder(graph, plot, (byte)8);
        }
        if (crd.isAvailable(28)) {
            QCLayoutOverlayParser.setContinuousEncoder(graph, plot, (byte)9);
        }
        if (crd.isAvailable(29)) {
            QCLayoutOverlayParser.setContinuousEncoder(graph, plot, (byte)10);
        }
        if (QCLayoutOverlayParser.isIndexVarAssigned(crd)) {
            graph.style.setContextCount(contextCount);
        }
        graph.style.resetToCurrentCounters();
        return true;
    }

    static boolean isDiscreteOffsetSupported(QCScatterOverlay plot) {
        return plot.isDiscreteX() || plot.isDiscreteY();
    }

    static boolean isComputedPlot(Element elem) {
        String str = elem.getAttribute("_stmt");
        return str.equalsIgnoreCase("DensityPlot") || str.equalsIgnoreCase("LoessPlot") || str.equalsIgnoreCase("RegressionPlot") || str.equalsIgnoreCase("PBSplinePlot");
    }

    static boolean loadInternal(StatGraph graph, QCScatterOverlay plot, Element _internal) {
        if (_internal == null) {
            // empty if block
        }
        boolean b = QCParserUtils.getBoolean("phaseBoxResponse", _internal, false);
        plot.setPhaseBoxResponse(b);
        int i = QCOverlay.QCOutfillType.toInteger(QCOverlay.QCOutfillType.TRUE);
        i = QCParserUtils.getInteger("outFill", _internal, i);
        plot.setOOCFillType(QCOverlay.QCOutfillType.fromInteger(i));
        i = QCOverlay.QCOutlineType.toInteger(QCOverlay.QCOutlineType.TRUE);
        i = QCParserUtils.getInteger("outLine", _internal, i);
        plot.setOOCLineType(QCOverlay.QCOutlineType.fromInteger(i));
        b = QCParserUtils.getBoolean("maximizeInnerMargin", _internal, false);
        plot.setMaximizeInnerMargin(b);
        b = QCParserUtils.getBoolean("scaleMarkers", _internal, false);
        plot.setQCScaling(b);
        i = QCParserUtils.getInteger("context", _internal, -1);
        QCOverlay.QCResponseContext type = QCOverlay.QCResponseContext.fromInteger(i, QCOverlay.QCResponseContext.Y);
        plot.setContext(type);
        double d = QCParserUtils.getDouble("interval", _internal, -1.0);
        if (d > 0.0) {
            plot.setInterval(d);
        }
        d = plot.getDataTransparency();
        d = QCParserUtils.getDouble("labelTransparency", _internal, d);
        plot.setLabelTransparency(d);
        b = QCParserUtils.getBoolean("dataLabelBox", _internal, false);
        plot.setDataLabelBox(b);
        b = QCParserUtils.getBoolean("dataLabelRotate", _internal, false);
        plot.setDataLabelRotate(b);
        d = QCParserUtils.getDouble("dataLabelThreshold", _internal, Double.NaN);
        plot.setDataLabelThreshold(d);
        b = QCParserUtils.getBoolean("hideLegendItems", _internal, false);
        plot.setHideLegendItems(b);
        return true;
    }
}

