/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph;

import com.sas.analytics.qc.statgraph.QCStylizedTextElement;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.graphics.applets.statgraph.RB;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.util.gtk.MissingValueException;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.text.Message;
import java.awt.Color;
import java.awt.font.TextAttribute;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class QCParserUtils {
    private static boolean debug = false;

    public static void setDebug(boolean b) {
        debug = b;
    }

    public static void resetDebug() {
        debug = false;
    }

    public static Element getChildWithTagName(String name, Element parent) {
        return QCParserUtils.getChildWithTagName(name, parent, 1);
    }

    public static Element getChildWithTagName(String name, Element parent, int which) {
        NodeList children = parent.getChildNodes();
        int num = children.getLength();
        int numSeen = 0;
        for (int i = 0; i < num; ++i) {
            Element e;
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !(e = (Element)child).getTagName().equalsIgnoreCase(name) || ++numSeen != which) continue;
            return e;
        }
        if (debug) {
            StatGraph.printDebug((String)("Name=" + name + " not found.  Using default value null."));
        }
        return null;
    }

    public static String getAttribute(String attr, Element e) {
        return QCParserUtils.getString(attr, e);
    }

    public static String getString(String attr, Element e) {
        String str = e.getAttribute(attr);
        if (str == null || str.length() == 0 || str.equals("")) {
            if (debug) {
                StatGraph.printDebug((String)("Attribute=" + attr + " not found.  Using default value \"\"."));
            }
            return "";
        }
        return str;
    }

    public static String getString(String attr, Element e, String dflt) {
        if (e == null) {
            return dflt;
        }
        String str = e.getAttribute(attr);
        if (str == null || str.length() == 0 || str.equals("")) {
            if (debug) {
                StatGraph.printDebug((String)("Attribute=" + attr + " not found.  Using default value " + dflt + "."));
            }
            return dflt;
        }
        return str;
    }

    public static String getElementText(Element e) {
        return QCParserUtils.getElementText(e, null);
    }

    public static String getElementText(Element e, String prepend) {
        NodeList list = e.getChildNodes();
        StringBuffer buf = prepend == null ? new StringBuffer() : new StringBuffer(prepend);
        for (int i = 0; i < list.getLength(); ++i) {
            buf.append(list.item(i).getNodeValue());
        }
        String out = buf.toString();
        return out;
    }

    public static String[] getCSLString(String attr, Element e) {
        String str = e.getAttribute(attr);
        if (str == null || str.length() == 0 || str.equals("")) {
            return new String[0];
        }
        String[] list = ParserUtils.parseStringArray((String)str, (String)",");
        return list;
    }

    public static double[] getDoubleArray(String attr, Element e) {
        String str = e.getAttribute(attr);
        if (str == null || str.length() == 0 || str.equals("")) {
            if (debug) {
                StatGraph.printDebug((String)("Attribute=" + attr + " not found.  Using default value null."));
            }
            return null;
        }
        String[] list = ParserUtils.parseStringArray((String)str, (String)",");
        double[] array = new double[list.length];
        for (int i = 0; i < list.length; ++i) {
            array[i] = Double.parseDouble(list[i]);
        }
        return array;
    }

    public static int[] getCSLInt(String attr, Element e) {
        String str = e.getAttribute(attr);
        if (str == null || str.length() == 0 || str.equals("")) {
            return null;
        }
        String[] list = ParserUtils.parseStringArray((String)str, (String)",");
        int[] array = new int[list.length];
        for (int i = 0; i < list.length; ++i) {
            array[i] = Integer.parseInt(list[i]);
        }
        return array;
    }

    public static char getChar(String attr, Element e) {
        String str = e.getAttribute(attr);
        if (str == null || str.length() == 0 || str.equals("")) {
            if (debug) {
                StatGraph.printDebug((String)("Attribute=" + attr + " not found.  Using default value ' '."));
            }
            return ' ';
        }
        char c = str.charAt(0);
        return c;
    }

    public static char getChar(String attr, Element e, char dflt) {
        if (e == null) {
            return dflt;
        }
        String str = e.getAttribute(attr);
        if (str == null || str.length() == 0 || str.equals("")) {
            if (debug) {
                StatGraph.printDebug((String)("Attribute=" + attr + " not found.  Using default value " + dflt + "."));
            }
            return dflt;
        }
        char c = str.charAt(0);
        return c;
    }

    public static double getDouble(String attr, Element e) {
        String str = e.getAttribute(attr);
        double d = ParserUtils.getDoubleValue((String)str);
        if (Double.isNaN(d) && debug) {
            StatGraph.printDebug((String)("Attribute=" + attr + " not found.  Using default value " + Double.NaN + "."));
        }
        return d;
    }

    public static double getDouble(String attr, Element e, double dflt) {
        if (e == null) {
            return dflt;
        }
        String str = e.getAttribute(attr);
        if (str == null || str.length() == 0 || str.equals("")) {
            if (debug) {
                StatGraph.printDebug((String)("Attribute=" + attr + " not found.  Using default value " + dflt + "."));
            }
            return dflt;
        }
        double d = ParserUtils.getDoubleValue((String)str);
        return d;
    }

    public static float getOpacity(String attr, Element e) {
        String str = e.getAttribute(attr);
        double d = ParserUtils.getDoubleValue((String)str);
        if (d < 0.0 || d > 1.0) {
            d = 1.0;
        }
        return (float)d;
    }

    public static float getOpacity(String attr, Element e, float dflt) {
        if (e == null) {
            return dflt;
        }
        String str = e.getAttribute(attr);
        if (str == null || str.length() == 0 || str.equals("")) {
            if (debug) {
                StatGraph.printDebug((String)("Attribute = \"" + attr + "\" not found.  Using default value " + dflt + "."));
            }
            return dflt;
        }
        double d = ParserUtils.getDoubleValue((String)str);
        if (d < 0.0 || d > 1.0) {
            d = dflt;
        }
        return (float)d;
    }

    public static int getInteger(String attr, Element e) {
        String str = e.getAttribute(attr);
        int i = ParserUtils.getIntValue((String)str);
        return i;
    }

    public static int getInteger(String attr, Element e, int dflt) {
        if (e == null) {
            return dflt;
        }
        String str = e.getAttribute(attr);
        if (str == null || str.length() == 0 || str.equals("")) {
            if (debug) {
                StatGraph.printDebug((String)("Attribute=" + attr + " not found.  Using default value " + dflt + "."));
            }
            return dflt;
        }
        int i = ParserUtils.getIntValue((String)str);
        return i;
    }

    public static boolean getBoolean(String attr, Element e) {
        return QCParserUtils.getBoolean(attr, e, false);
    }

    public static boolean getBoolean(String attr, Element e, boolean dflt) {
        if (e == null) {
            return dflt;
        }
        String str = e.getAttribute(attr);
        if (str == null || str.length() == 0 || str.equals("")) {
            if (debug) {
                StatGraph.printDebug((String)("Attribute=" + attr + " not found.  Using default value " + dflt + "."));
            }
            return dflt;
        }
        if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("yes") || str.equalsIgnoreCase("on")) {
            return true;
        }
        if (str.equalsIgnoreCase("false") || str.equalsIgnoreCase("no") || str.equalsIgnoreCase("off")) {
            return false;
        }
        int i = ParserUtils.getIntValue((String)str);
        return i == -1 ? false : i != 0;
    }

    private static String buildWhereExpression(StringVectorVariable whereVar, String rb_key, int mpc, int page, StatGraph graph) {
        int n = whereVar.getUniqueValueCount();
        if (mpc >= n) {
            return null;
        }
        int maxPages = (int)Math.ceil((double)n / (double)mpc);
        if (page >= maxPages) {
            Message msg = new Message(RB.getStringResource((String)rb_key, (String)"page2.fmt.txt"));
            StatGraph.printWarning((String)msg.toString((Object)Integer.toString(page + 1), (Object)Integer.toString(maxPages)));
            page = maxPages - 1;
        }
        graph.pageNo = page;
        StringBuffer where = new StringBuffer();
        int s = mpc * page;
        int e = Math.min(s + mpc, n);
        String v = "";
        for (int i = s; i < e; ++i) {
            try {
                v = whereVar.uniqueValue.getValue(i);
            }
            catch (MissingValueException mve) {
                continue;
            }
            if (where.length() > 0) {
                where = where.append(" OR ");
            }
            where = where.append(whereVar.getColumnName() + " = \"" + v + "\"");
        }
        return where.toString();
    }

    protected static String getAttributedText(Element e, Vector v) {
        return QCParserUtils.getAttributedText(e, v, null);
    }

    protected static String getAttributedText(Element e, Vector<QCStylizedTextElement> v, String prepend) {
        int j;
        String out;
        boolean append;
        int n;
        NodeList nodes = e.getElementsByTagName("LabelEntry");
        int n2 = n = nodes == null ? 0 : nodes.getLength();
        if (prepend == null) {
            append = false;
            out = "";
            j = 0;
        } else {
            append = true;
            out = prepend;
            j = prepend.length();
        }
        v.clear();
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                String font;
                Element child = (Element)nodes.item(i);
                String s = ParserUtils.getElementText((Element)child);
                s = QCStylizedTextElement.replaceUStrings(s);
                int k = s.length();
                out = append ? out + s : s;
                append = true;
                String glyph = QCParserUtils.getString("glyph", child);
                if (glyph != null && glyph.length() != 0 && !glyph.equals("")) {
                    v.add(new QCStylizedTextElement(j, j + k, TextAttribute.CHAR_REPLACEMENT, glyph));
                }
                if ((font = QCParserUtils.getString("attr", child)) != null && font.length() != 0 && !font.equals("")) {
                    v.add(new QCStylizedTextElement(j, j + k, TextAttribute.FONT, font));
                }
                j = out.length();
            }
        } else {
            out = append ? out + ParserUtils.getElementText((Element)e).trim() : ParserUtils.getElementText((Element)e).trim();
            out = QCStylizedTextElement.replaceUStrings(out);
        }
        return out;
    }

    protected static QCOverlay.QCResponseContext getResponseContext(Element e) {
        QCOverlay.QCResponseContext context;
        Element _internal = ParserUtils.getChildWithTagName((String)"_internal", (Element)e);
        if (_internal == null) {
            context = QCOverlay.QCResponseContext.DEADBEEF;
        } else {
            int i = QCParserUtils.getInteger("context", _internal);
            context = QCOverlay.QCResponseContext.fromInteger(i, QCOverlay.QCResponseContext.Y);
        }
        return context;
    }

    public static boolean similarTo(Color a, Color b) {
        boolean rc;
        double threshold = 20.0;
        double ar = a.getRed();
        double br = b.getRed();
        double ag = a.getGreen();
        double bg = b.getGreen();
        double ab = a.getBlue();
        double bb = b.getBlue();
        if (ar == ag && ag == ab && br == bg && bg == bb) {
            double distance = (ar - br) * (ar - br) + (ag - bg) * (ag - bg) + (ab - bb) * (ab - bb);
            rc = (distance = Math.sqrt(distance)) < threshold;
        } else {
            rc = false;
        }
        return rc;
    }
}

