/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph;

import com.sas.analytics.qc.statgraph.QCLimitsParser;
import com.sas.analytics.qc.statgraph.QCStylizedTextElement;
import com.sas.analytics.qc.statgraph.sgchart.composite.QCSimple2DOverlayComposite;
import com.sas.graphics.anno.AbstractAnno;
import com.sas.graphics.anno.AnnotationContainer;
import com.sas.graphics.applets.statgraph.AnnotateParser;
import com.sas.graphics.applets.statgraph.AxisLegendParser;
import com.sas.graphics.applets.statgraph.BandParser;
import com.sas.graphics.applets.statgraph.BlockParser;
import com.sas.graphics.applets.statgraph.EntryConcatParser;
import com.sas.graphics.applets.statgraph.FringeParser;
import com.sas.graphics.applets.statgraph.GraphComponentParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.GridPanelParser;
import com.sas.graphics.applets.statgraph.LayoutDataLatticeParser;
import com.sas.graphics.applets.statgraph.LayoutLatticeParser;
import com.sas.graphics.applets.statgraph.LayoutOverlay3DParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayEquatedParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayMapParser;
import com.sas.graphics.applets.statgraph.LayoutRegionParser;
import com.sas.graphics.applets.statgraph.LegendParser;
import com.sas.graphics.applets.statgraph.ReferenceLineParser;
import com.sas.graphics.applets.statgraph.RotatedJTextPane;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.SeriesParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.StepParser;
import com.sas.graphics.applets.statgraph.TableParser;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.TextAttrs;
import com.sas.graphics.applets.statgraph.sgchart.axis.AbstractAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectGridLines;
import com.sas.graphics.applets.statgraph.sgchart.axis.Wall;
import com.sas.graphics.applets.statgraph.sgchart.composite.AbstractSGComponent;
import com.sas.graphics.applets.statgraph.sgchart.composite.BaseOverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.EntryComposite;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.RB;
import com.sas.graphics.applets.statgraph.sgchart.composite.Simple2DOverlayComposite;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.ColumnMetadata;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ColorEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.Encoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.FillPatternEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.LineEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.PositionEncoder;
import com.sas.graphics.applets.statgraph.sgchart.encoder.ShapeEncoder;
import com.sas.graphics.applets.statgraph.sgchart.entry.AxisLegend;
import com.sas.graphics.applets.statgraph.sgchart.entry.GridPanel;
import com.sas.graphics.applets.statgraph.sgchart.entry.Legend;
import com.sas.graphics.applets.statgraph.sgchart.entry.Table;
import com.sas.graphics.applets.statgraph.sgchart.legend.LegendComponent;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BlockOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BoxOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.DropLineOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.EllipseParmOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.LineParmOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.PieOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ReferenceLineOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ScatterOverlay;
import com.sas.graphics.applets.statgraph.sgchart.range.ContinuousRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DataRange;
import com.sas.graphics.applets.statgraph.sgchart.range.DiscreteRange;
import com.sas.graphics.styles.DataStyleElement;
import com.sas.graphics.util.gtk.AxisStyle;
import com.sas.graphics.util.gtk.StringVectorVariable;
import com.sas.graphics.util.gtk.TextStyle;
import com.sas.text.Message;
import com.sas.text.SASDateTimeFormat;
import com.sas.text.SASFormat;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.TreeMap;
import javax.swing.JComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class QCLayoutOverlayParser {
    public static final String RB_KEY = "QCLayoutOverlayParser.";
    static final int LINEAR_AXIS = 0;
    static final int TIME_AXIS = 1;
    static final int DISCRETE_AXIS = 2;
    static final int LOG_AXIS = 3;
    static int xAxisType = 0;
    static int x2AxisType = 0;
    static int yAxisType = 0;
    static int y2AxisType = 0;
    static int zAxisType = 0;
    static double logBaseX = 10.0;
    static double logBaseX2 = 10.0;
    static double logBaseY = 10.0;
    static double logBaseY2 = 10.0;

    public static AbstractSGComponent load(StatGraph graph, Element elem) {
        return QCLayoutOverlayParser.load(graph, elem, false);
    }

    public static AbstractSGComponent load(StatGraph graph, Element elem, int[] rowColumnAxesType, int[] rowColumn2AxesType) {
        return QCLayoutOverlayParser.load(graph, elem, false, rowColumnAxesType, rowColumn2AxesType);
    }

    public static AbstractSGComponent load(StatGraph graph, Element elem, boolean outmost) {
        return QCLayoutOverlayParser.load(graph, elem, outmost, null, null);
    }

    public static AbstractSGComponent load(StatGraph graph, Element elem, boolean outmost, int[] rowColumnAxesType, int[] rowColumn2AxesType) {
        int i;
        if (!QCLayoutOverlayParser.hasGraphElement(elem)) {
            return QCLayoutOverlayParser.loadNonGraphs(graph, elem);
        }
        graph.style.resetCounters();
        String str = elem.getAttribute("cycleAttrs");
        if (str.length() > 0 && str.equalsIgnoreCase("true")) {
            graph.style.setCycleAttrs(true);
        } else {
            graph.style.setCycleAttrs(false);
        }
        OverlayContainer oc = (OverlayContainer)graph.getObjectFromElement(elem);
        if (oc == null) {
            oc = QCLayoutOverlayParser.initComposite(graph, elem);
        }
        GraphComponentParser.load((StatGraph)graph, (Element)elem, (JComponent)oc, null);
        StatGraph.parseBorderOpts((StatGraph)graph, (JComponent)oc, (Element)elem, null);
        QCSimple2DOverlayComposite soc = (QCSimple2DOverlayComposite)oc.getComposite();
        if (!elem.getNodeName().equals("LayoutPrototype")) {
            str = elem.getAttribute("aspectRatio");
            if (StatGraph.isNumber((String)str)) {
                soc.setAspectRatio(Double.parseDouble(str));
            } else {
                soc.setAspectRatio(-1.0);
            }
        }
        VRectAxis xAxis = new VRectAxis(1, false);
        VRectAxis x2Axis = new VRectAxis(1, false);
        x2Axis.setPosition((byte)0);
        x2Axis.setPrimary(false);
        VRectAxis yAxis = new VRectAxis(2, false);
        VRectAxis y2Axis = new VRectAxis(2, false);
        y2Axis.setPosition((byte)2);
        y2Axis.setPrimary(false);
        QCLayoutOverlayParser.initAxis(graph, xAxis);
        QCLayoutOverlayParser.initAxis(graph, x2Axis);
        QCLayoutOverlayParser.initAxis(graph, yAxis);
        QCLayoutOverlayParser.initAxis(graph, y2Axis);
        QCLayoutOverlayParser.decideAxesType(graph, elem, rowColumnAxesType, rowColumn2AxesType);
        ArrayList plots = new ArrayList();
        Overlay boxOverlay = null;
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            Object overlayContainer;
            String loc;
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            boolean ok = true;
            if (elemTag.equals("ScatterPlot")) {
                ok = QCLayoutOverlayParser.addPlotToList(plots, (Overlay)ScatterParser.load((StatGraph)graph, (Element)((Element)node)), graph, !outmost);
            } else if (elemTag.equals("SeriesPlot")) {
                int curveLabelPosition = 1;
                if (y2Axis.isVisible() && !yAxis.isVisible()) {
                    curveLabelPosition = 0;
                }
                ok = QCLayoutOverlayParser.addPlotToList(plots, (Overlay)SeriesParser.load((StatGraph)graph, (Element)((Element)node), (int)curveLabelPosition), graph, !outmost);
            } else if (elemTag.equals("StepPlot")) {
                int curveLabelPosition = 1;
                if (y2Axis.isVisible() && !yAxis.isVisible()) {
                    curveLabelPosition = 0;
                }
                ok = QCLayoutOverlayParser.addPlotToList(plots, (Overlay)StepParser.load((StatGraph)graph, (Element)((Element)node), (int)curveLabelPosition), graph, !outmost);
            } else if (elemTag.equals("BandPlot")) {
                int curveLabelPosition = 1;
                if (y2Axis.isVisible() && !yAxis.isVisible()) {
                    curveLabelPosition = 0;
                }
                ok = QCLayoutOverlayParser.addPlotToList(plots, (Overlay)BandParser.load((StatGraph)graph, (Element)((Element)node), (int)curveLabelPosition));
            } else if (elemTag.equals("ReferenceLine")) {
                int curveLabelPosition = 1;
                if (y2Axis.isVisible() && !yAxis.isVisible()) {
                    curveLabelPosition = 0;
                }
                ok = QCLayoutOverlayParser.addPlotToList(plots, (Overlay)ReferenceLineParser.load((StatGraph)graph, (Element)((Element)node), (int)curveLabelPosition));
            } else if (elemTag.equals("FringePlot")) {
                ok = QCLayoutOverlayParser.addPlotToList(plots, (Overlay)FringeParser.load((StatGraph)graph, (Element)((Element)node)));
            } else if (elemTag.equals("BlockPlot")) {
                BlockOverlay block = BlockParser.load((StatGraph)graph, (Element)((Element)node));
                String s = ((Element)node).getAttribute("display");
                if (s.length() == 0 || s.equalsIgnoreCase("STANDARD")) {
                    block.setValueOn(false);
                    block.setLabelOn(false);
                }
                ok = QCLayoutOverlayParser.addPlotToList(plots, (Overlay)block);
            } else if (elemTag.equals("InnerMargin")) {
                String loc2 = ((Element)node).getAttribute("align");
                int just = loc2.length() > 0 && loc2.equalsIgnoreCase("top") ? 1 : 2;
                Element elem2 = (Element)node;
                for (Node node2 = elem2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    if (!(node2 instanceof Element)) continue;
                    elemTag = ((Element)node2).getTagName();
                    if (elemTag.equals("BlockPlot")) {
                        BlockOverlay block = BlockParser.load((StatGraph)graph, (Element)((Element)node2));
                        ok = QCLayoutOverlayParser.addPlotToList(plots, (Overlay)block);
                        if (ok) {
                            block.setOverlayJustification(just);
                            continue;
                        }
                        break;
                    }
                    StatGraph.printDebug((String)"Unsupported plot for inner margin.");
                }
            } else if (elemTag.equals("Entry")) {
                JComponent entry = (JComponent)graph.getObjectFromElement((Element)node);
                if (entry == null) {
                    entry = new EntryComposite();
                }
                EntryConcatParser.load((StatGraph)graph, (Element)((Element)node), (JComponent)entry, (JComponent)oc, (int)0);
                loc = ((Element)node).getAttribute("location");
                QCLayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("outside")) {
                    if (entry.getAlignmentX() == 0.5f && entry.getAlignmentY() == 0.5f) {
                        entry.setAlignmentY(0.0f);
                    }
                    oc.addSidebar((Component)entry);
                } else {
                    oc.add((Component)entry, 0);
                }
            } else if (elemTag.equals("DiscreteLegend") || elemTag.equals("MergedLegend")) {
                Legend legend = (Legend)graph.getObjectFromElement((Element)node);
                if (legend == null) {
                    legend = new Legend();
                }
                LegendParser.load((StatGraph)graph, (Element)((Element)node), (JComponent)legend, (JComponent)oc);
                loc = ((Element)node).getAttribute("location");
                QCLayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("inside")) {
                    oc.add((Component)legend, 0);
                } else {
                    if (legend.getAlignmentX() == 0.5f && legend.getAlignmentY() == 0.5f) {
                        legend.setAlignmentY(1.0f);
                    }
                    oc.addLegend((Component)legend);
                }
            } else if (elemTag.equals("AxisLegend")) {
                AxisLegend legend = (AxisLegend)graph.getObjectFromElement((Element)node);
                if (legend == null) {
                    legend = new AxisLegend();
                }
                AxisLegendParser.load((StatGraph)graph, (Element)((Element)node), (JComponent)legend, (JComponent)oc);
                loc = ((Element)node).getAttribute("location");
                QCLayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("inside")) {
                    oc.add((Component)legend, 0);
                } else {
                    if (legend.getAlignmentX() == 0.5f && legend.getAlignmentY() == 0.5f) {
                        legend.setAlignmentY(1.0f);
                    }
                    oc.addLegend((Component)legend);
                }
            } else if (elemTag.equals("ContinuousLegend")) {
                LegendComponent legend = (LegendComponent)graph.getObjectFromElement((Element)node);
                if (legend == null) {
                    legend = new LegendComponent();
                }
                LegendParser.load((StatGraph)graph, (Element)((Element)node), (JComponent)legend, (JComponent)oc);
                loc = ((Element)node).getAttribute("location");
                QCLayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("inside")) {
                    oc.add((Component)legend, 0);
                } else {
                    if (legend.getAlignmentX() == 0.5f && legend.getAlignmentY() == 0.5f) {
                        legend.setAlignmentX(1.0f);
                    }
                    if (legend.getAlignmentY() == 0.0f || legend.getAlignmentY() == 1.0f) {
                        legend.setHorizontal(true);
                    }
                    oc.addLegend((Component)legend);
                }
            } else if (elemTag.equals("GTable")) {
                Table table = (Table)graph.getObjectFromElement((Element)node);
                if (table == null) {
                    table = new Table();
                }
                TableParser.load((StatGraph)graph, (Element)((Element)node), (JComponent)table, (JComponent)oc);
                oc.add((Component)table, 0);
            } else if (elemTag.startsWith("Draw")) {
                AbstractAnno text = AnnotateParser.load((StatGraph)graph, (Element)((Element)node), (AnnotationContainer)oc);
                if (text != null) {
                    if ("back".equalsIgnoreCase(((Element)node).getAttribute("layer"))) {
                        graph.annotationInBackList.add(text);
                    } else {
                        graph.annotationInFrontList.add(text);
                    }
                }
            } else if (elemTag.equals("LayoutGridded")) {
                GridPanel grid = (GridPanel)graph.getObjectFromElement((Element)node);
                if (grid == null) {
                    grid = new GridPanel();
                }
                GridPanelParser.load((StatGraph)graph, (Element)((Element)node), (JComponent)grid, (JComponent)oc);
                loc = ((Element)node).getAttribute("location");
                QCLayoutOverlayParser.checkLocation(loc);
                if (loc.equalsIgnoreCase("outside")) {
                    if (grid.getAlignmentX() == 0.5f && grid.getAlignmentY() == 0.5f) {
                        grid.setAlignmentY(1.0f);
                    }
                    oc.addSidebar((Component)grid);
                } else {
                    oc.add((Component)grid, 0);
                }
            } else if (elemTag.equals("LayoutOverlay")) {
                boolean server = graph.server;
                graph.server = true;
                overlayContainer = (BaseOverlayContainer)QCLayoutOverlayParser.load(graph, (Element)node);
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(overlayContainer.getMinimumSize());
            } else if (elemTag.equals("LayoutOverlayEquated")) {
                boolean server = graph.server;
                graph.server = true;
                overlayContainer = (BaseOverlayContainer)LayoutOverlayEquatedParser.load((StatGraph)graph, (Element)((Element)node));
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(overlayContainer.getMinimumSize());
            } else if (elemTag.equals("LayoutOverlayMap")) {
                boolean server = graph.server;
                graph.server = true;
                overlayContainer = (BaseOverlayContainer)LayoutOverlayMapParser.load((StatGraph)graph, (Element)((Element)node));
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(overlayContainer.getMinimumSize());
            } else if (elemTag.equals("LayoutQCOverlay")) {
                boolean server = graph.server;
                graph.server = true;
                overlayContainer = StatGraph.parseThirdPartyComponent((StatGraph)graph, (Element)((Element)node));
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                ((JComponent)overlayContainer).setPreferredSize(((JComponent)overlayContainer).getMinimumSize());
            } else if (elemTag.equals("LayoutOverlay3D")) {
                boolean server = graph.server;
                graph.server = true;
                overlayContainer = (BaseOverlayContainer)LayoutOverlay3DParser.load((StatGraph)graph, (Element)((Element)node));
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(overlayContainer.getMinimumSize());
            } else if (elemTag.equals("LayoutLattice")) {
                oc.add((Component)LayoutLatticeParser.load((StatGraph)graph, (Element)((Element)node)), 0);
            } else if (elemTag.equals("LayoutDataLattice")) {
                oc.add((Component)LayoutDataLatticeParser.load((StatGraph)graph, (Element)((Element)node)), 0);
            } else if (elemTag.equals("LayoutDataPanel")) {
                oc.add((Component)LayoutDataLatticeParser.load((StatGraph)graph, (Element)((Element)node), (boolean)true), 0);
            } else if (elemTag.equals("LayoutRegion")) {
                oc.add((Component)LayoutRegionParser.load((StatGraph)graph, (Element)((Element)node)), 0);
            }
            if (ok || (str = ((Element)node).getAttribute("required")).length() <= 0 || !str.equalsIgnoreCase("true")) continue;
            oc.removeAll();
            Component msg = QCLayoutOverlayParser.createMessage();
            oc.add(msg);
            return oc;
        }
        if (plots.size() > 0) {
            QCLayoutOverlayParser.setAutomaticAxisTypes(plots, true, xAxis, x2Axis, yAxis, y2Axis, null);
        }
        QCLayoutOverlayParser.parseAxisOptsList(graph, soc, elem, xAxis, x2Axis, yAxis, y2Axis, null);
        QCLayoutOverlayParser.parsePointLabelOpts(graph, soc, elem);
        for (int i2 = 0; i2 < plots.size(); ++i2) {
            Overlay plot = (Overlay)plots.get(i2);
            if (plot instanceof PieOverlay) {
                if (i2 == 0) {
                    PieOverlay pie = (PieOverlay)plot;
                    soc.getWall().setFillOn(false);
                    soc.getWall().setEdgeOn(false);
                    soc.setAxesVisible(false);
                    soc.addOverlay((Overlay)pie);
                    break;
                }
                Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"axis.fmt.txt"));
                StatGraph.printWarning((String)msg.toString((Object)plot.getStmt()));
                continue;
            }
            if (QCLayoutOverlayParser.isCompatibleOverlay(graph, plot)) {
                QCLayoutOverlayParser.addOverlay(plot, soc, xAxis, x2Axis, yAxis, y2Axis, null);
                continue;
            }
            graph.removeNamedGraph(plot);
        }
        if ((str = graph.style.getStyleAttribute("GridLines", "displayOpts")) != null && str.equalsIgnoreCase("on")) {
            if (StatGraph.getOptionAttrsElement((Element)elem, (String)"XAxisOpts") == null) {
                QCLayoutOverlayParser.addAutoGridLine(graph, xAxis, soc);
            }
            if (StatGraph.getOptionAttrsElement((Element)elem, (String)"X2AxisOpts") == null) {
                QCLayoutOverlayParser.addAutoGridLine(graph, x2Axis, soc);
            }
            if (StatGraph.getOptionAttrsElement((Element)elem, (String)"YAxisOpts") == null) {
                QCLayoutOverlayParser.addAutoGridLine(graph, yAxis, soc);
            }
            if (StatGraph.getOptionAttrsElement((Element)elem, (String)"Y2AxisOpts") == null) {
                QCLayoutOverlayParser.addAutoGridLine(graph, y2Axis, soc);
            }
        }
        if (boxOverlay != null && oc.getComposite().contains(boxOverlay) && !boxOverlay.getModel().isAvailable(10)) {
            if (boxOverlay.getOrientation() == 0) {
                xAxis.setVisible(false);
                x2Axis.setVisible(false);
            } else {
                yAxis.setVisible(false);
                y2Axis.setVisible(false);
            }
        }
        VRectAxis[] axes = new VRectAxis[]{xAxis, x2Axis, yAxis, y2Axis};
        VRectAxis[] mirrorAxes = new VRectAxis[]{x2Axis, xAxis, y2Axis, yAxis};
        for (int i3 = 0; i3 < axes.length; ++i3) {
            if (axes[i3].getInputDataRange() == null || mirrorAxes[i3].getInputDataRange() != null) continue;
            String display2 = null;
            if (mirrorAxes[i3] == x2Axis && StatGraph.getOptionAttrsElement((Element)elem, (String)"XAxisOpts") != null) {
                display2 = StatGraph.getOptionAttrsElement((Element)elem, (String)"XAxisOpts").getAttribute("displaySecondary");
            } else if (mirrorAxes[i3] == xAxis && StatGraph.getOptionAttrsElement((Element)elem, (String)"X2AxisOpts") != null) {
                display2 = StatGraph.getOptionAttrsElement((Element)elem, (String)"X2AxisOpts").getAttribute("displaySecondary");
            } else if (mirrorAxes[i3] == y2Axis && StatGraph.getOptionAttrsElement((Element)elem, (String)"YAxisOpts") != null) {
                display2 = StatGraph.getOptionAttrsElement((Element)elem, (String)"YAxisOpts").getAttribute("displaySecondary");
            } else if (mirrorAxes[i3] == yAxis && StatGraph.getOptionAttrsElement((Element)elem, (String)"Y2AxisOpts") != null) {
                display2 = StatGraph.getOptionAttrsElement((Element)elem, (String)"Y2AxisOpts").getAttribute("displaySecondary");
            }
            if (display2 == null || display2.length() == 0 || display2.equalsIgnoreCase("NONE") || !QCLayoutOverlayParser.honorAxisOpts(elem, axes[i3], "displaySecondary")) {
                mirrorAxes[i3].setVisible(false);
                continue;
            }
            mirrorAxes[i3].setVisible(true);
            QCLayoutOverlayParser.copyAxisOptions(axes[i3], mirrorAxes[i3]);
            LayoutOverlayEquatedParser.parseAxisDisplay2Opts((String)display2, (VRectAxis)mirrorAxes[i3]);
            VRectGridLines grid = soc.getGridLines((AbstractAxis)mirrorAxes[i3]);
            if (grid != null) {
                soc.removeGridLines(grid);
            }
            mirrorAxes[i3].setSecondary(true);
            mirrorAxes[i3].setMirrorAxis(axes[i3]);
        }
        ArrayList overlays = soc.getOverlays();
        int parmPlotCnt = 0;
        for (i = 0; i < overlays.size(); ++i) {
            Overlay o = (Overlay)overlays.get(i);
            if (o instanceof LineParmOverlay || o instanceof EllipseParmOverlay && o.getStmt().equalsIgnoreCase("EllipseParm")) {
                boolean axesMappedOk = true;
                if (o.getXAxis().equalsIgnoreCase("x") && !xAxis.isVisible()) {
                    axesMappedOk = false;
                } else if (o.getXAxis().equalsIgnoreCase("x2") && !x2Axis.isVisible()) {
                    axesMappedOk = false;
                }
                if (o.getYAxis().equalsIgnoreCase("y") && !yAxis.isVisible()) {
                    axesMappedOk = false;
                } else if (o.getYAxis().equalsIgnoreCase("y2") && !y2Axis.isVisible()) {
                    axesMappedOk = false;
                }
                if (!axesMappedOk) {
                    soc.removeOverlay(o);
                    if (!(o instanceof EllipseParmOverlay) && !(o instanceof LineParmOverlay)) continue;
                    Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"parmaxis.fmt.txt"));
                    StatGraph.printWarning((String)msg.toString((Object)o.getStmt()));
                    continue;
                }
                ++parmPlotCnt;
            } else if (o instanceof ReferenceLineOverlay || o instanceof DropLineOverlay) {
                ++parmPlotCnt;
            }
            if (xAxis.isVisible() && xAxis.isSecondary()) {
                soc.connect(o, (AbstractAxis)xAxis, (byte)1);
            }
            if (x2Axis.isVisible() && x2Axis.isSecondary()) {
                soc.connect(o, (AbstractAxis)x2Axis, (byte)1);
            }
            if (yAxis.isVisible() && yAxis.isSecondary()) {
                soc.connect(o, (AbstractAxis)yAxis, (byte)2);
            }
            if (!y2Axis.isVisible() || !y2Axis.isSecondary()) continue;
            soc.connect(o, (AbstractAxis)y2Axis, (byte)2);
        }
        if (parmPlotCnt > 0 && parmPlotCnt == overlays.size()) {
            for (i = 0; i < parmPlotCnt; ++i) {
                Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"parm.fmt.txt"));
                StatGraph.printWarning((String)msg.toString((Object)((Overlay)overlays.get(i)).getStmt(), (Object)QCLayoutOverlayParser.getLayoutName(elem)));
            }
            oc.removeAll();
        }
        if (!(xAxis.isVisible() || x2Axis.isVisible() || yAxis.isVisible() || y2Axis.isVisible())) {
            soc.setAxesVisible(false);
        }
        return oc;
    }

    public static AbstractSGComponent loadNonGraphs(StatGraph graph, Element elem) {
        BaseOverlayContainer oc = (BaseOverlayContainer)graph.getObjectFromElement(elem);
        if (oc == null) {
            oc = new BaseOverlayContainer(true, false, false, true);
        }
        QCLayoutOverlayParser.loadNonGraphs(graph, elem, oc);
        return oc;
    }

    public static AbstractSGComponent loadNonGraphs(StatGraph graph, Element elem, BaseOverlayContainer oc) {
        GraphComponentParser.load((StatGraph)graph, (Element)elem, (JComponent)oc, null);
        StatGraph.parseBorderOpts((StatGraph)graph, (JComponent)oc, (Element)elem, null);
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            AbstractAnno text;
            Object overlayContainer;
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            boolean ok = true;
            JComponent comp = (JComponent)graph.getObjectFromElement((Element)node);
            if (elemTag.equals("Entry")) {
                EntryComposite ec;
                JComponent entry = comp != null ? comp : new EntryComposite();
                EntryConcatParser.load((StatGraph)graph, (Element)((Element)node), (JComponent)entry, (JComponent)oc, (int)0);
                if (((Element)node).getAttribute("_id").startsWith("dropsite") && entry instanceof EntryComposite && (ec = (EntryComposite)entry).getCenterComponent() != null) {
                    RotatedJTextPane rjt = (RotatedJTextPane)ec.getCenterComponent();
                    rjt.setText("");
                }
                oc.add((Component)entry, 0);
            } else if (elemTag.equals("DiscreteLegend") || elemTag.equals("MergedLegend")) {
                Legend legend = comp != null ? (Legend)comp : new Legend();
                LegendParser.load((StatGraph)graph, (Element)((Element)node), (JComponent)legend, (JComponent)oc);
                oc.add((Component)legend, 0);
            } else if (elemTag.equals("ContinuousLegend")) {
                LegendComponent legend = comp != null ? (LegendComponent)comp : new LegendComponent();
                LegendParser.load((StatGraph)graph, (Element)((Element)node), (JComponent)legend, (JComponent)oc);
                oc.add((Component)legend, 0);
            } else if (elemTag.equals("GTable")) {
                Table table = comp != null ? (Table)comp : new Table();
                TableParser.load((StatGraph)graph, (Element)((Element)node), (JComponent)table, (JComponent)oc);
                oc.add((Component)table, 0);
            } else if (elemTag.equals("LayoutGridded")) {
                GridPanel grid = comp != null ? (GridPanel)comp : new GridPanel();
                GridPanelParser.load((StatGraph)graph, (Element)((Element)node), (JComponent)grid, (JComponent)oc);
                oc.add((Component)grid, 0);
            } else if (elemTag.equals("LayoutOverlay")) {
                boolean server = graph.server;
                graph.server = true;
                overlayContainer = (BaseOverlayContainer)QCLayoutOverlayParser.load(graph, (Element)node);
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(overlayContainer.getMinimumSize());
            } else if (elemTag.equals("LayoutOverlayEquated")) {
                boolean server = graph.server;
                graph.server = true;
                overlayContainer = (BaseOverlayContainer)LayoutOverlayEquatedParser.load((StatGraph)graph, (Element)((Element)node));
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(overlayContainer.getMinimumSize());
            } else if (elemTag.equals("LayoutOverlayMap")) {
                boolean server = graph.server;
                graph.server = true;
                overlayContainer = (BaseOverlayContainer)LayoutOverlayMapParser.load((StatGraph)graph, (Element)((Element)node));
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(overlayContainer.getMinimumSize());
            } else if (elemTag.equals("LayoutQCOverlay")) {
                boolean server = graph.server;
                graph.server = true;
                overlayContainer = StatGraph.parseThirdPartyComponent((StatGraph)graph, (Element)((Element)node));
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                ((JComponent)overlayContainer).setPreferredSize(((JComponent)overlayContainer).getMinimumSize());
            } else if (elemTag.equals("LayoutOverlay3D")) {
                boolean server = graph.server;
                graph.server = true;
                overlayContainer = (BaseOverlayContainer)LayoutOverlay3DParser.load((StatGraph)graph, (Element)((Element)node));
                graph.server = server;
                oc.add((Component)overlayContainer, 0);
                overlayContainer.setPreferredSize(overlayContainer.getMinimumSize());
            } else if (elemTag.equals("LayoutLattice")) {
                oc.add((Component)LayoutLatticeParser.load((StatGraph)graph, (Element)((Element)node)), 0);
            } else if (elemTag.startsWith("Draw") && (text = AnnotateParser.load((StatGraph)graph, (Element)((Element)node), (AnnotationContainer)oc)) != null) {
                if ("back".equalsIgnoreCase(((Element)node).getAttribute("layer"))) {
                    graph.annotationInBackList.add(text);
                } else {
                    graph.annotationInFrontList.add(text);
                }
            }
            if (ok) continue;
            return null;
        }
        return oc;
    }

    public static AbstractSGComponent loadPlot(StatGraph graph, Element elem, int type) {
        graph.style.resetCounters();
        OverlayContainer oc = (OverlayContainer)graph.getObjectFromElement(elem);
        if (oc == null) {
            oc = QCLayoutOverlayParser.initComposite(graph, elem);
        } else {
            graph.removeObjectFromElement(elem);
        }
        QCSimple2DOverlayComposite soc = (QCSimple2DOverlayComposite)oc.getComposite();
        GraphComponentParser.load((StatGraph)graph, (Element)elem, (JComponent)oc, null);
        StatGraph.parseBorderOpts((StatGraph)graph, (JComponent)oc, (Element)elem, null);
        VRectAxis xAxis = new VRectAxis(1, false);
        VRectAxis x2Axis = new VRectAxis(1, false);
        x2Axis.setPosition((byte)0);
        x2Axis.setPrimary(false);
        VRectAxis yAxis = new VRectAxis(2, false);
        VRectAxis y2Axis = new VRectAxis(2, false);
        y2Axis.setPosition((byte)2);
        y2Axis.setPrimary(false);
        QCLayoutOverlayParser.initAxis(graph, xAxis);
        QCLayoutOverlayParser.initAxis(graph, x2Axis);
        QCLayoutOverlayParser.initAxis(graph, yAxis);
        QCLayoutOverlayParser.initAxis(graph, y2Axis);
        xAxisType = 0;
        x2AxisType = 0;
        yAxisType = 0;
        y2AxisType = 0;
        zAxisType = 0;
        boolean xSecondary = false;
        boolean ySecondary = false;
        if (oc.isHorizontal()) {
            xSecondary = elem.getAttribute("yAxis").equalsIgnoreCase("y2");
            ySecondary = elem.getAttribute("xAxis").equalsIgnoreCase("x2");
        } else {
            xSecondary = elem.getAttribute("xAxis").equalsIgnoreCase("x2");
            ySecondary = elem.getAttribute("yAxis").equalsIgnoreCase("y2");
        }
        QCLayoutOverlayParser.requiredAxesTypeByPlot(graph, elem, !xSecondary, xSecondary, !ySecondary, ySecondary, false, new boolean[5]);
        VRectAxis x1a = xAxis;
        VRectAxis x2a = x2Axis;
        VRectAxis y1a = yAxis;
        VRectAxis y2a = y2Axis;
        if (xSecondary) {
            x1a = x2Axis;
            x2a = xAxis;
        }
        if (ySecondary) {
            y1a = y2Axis;
            y2a = yAxis;
        }
        ScatterOverlay overlay = null;
        switch (type) {
            case 0: {
                overlay = ScatterParser.load((StatGraph)graph, (Element)elem);
                break;
            }
            case 1: {
                int curveLabelPosition = 1;
                if (y2Axis.isVisible() && !yAxis.isVisible()) {
                    curveLabelPosition = 0;
                }
                overlay = SeriesParser.load((StatGraph)graph, (Element)elem, (int)curveLabelPosition);
                break;
            }
            case 2: {
                int curveLabelPosition = 1;
                if (y2Axis.isVisible() && !yAxis.isVisible()) {
                    curveLabelPosition = 0;
                }
                overlay = StepParser.load((StatGraph)graph, (Element)elem, (int)curveLabelPosition);
                break;
            }
            case 16: {
                Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"parmplot.fmt.txt"));
                StatGraph.printWarning((String)msg.toString((Object)"REFERENCELINE", (Object)QCLayoutOverlayParser.getLayoutName(elem.getParentNode())));
                overlay = null;
                break;
            }
            case 6: {
                int curveLabelPosition = 1;
                if (y2Axis.isVisible() && !yAxis.isVisible()) {
                    curveLabelPosition = 0;
                }
                overlay = BandParser.load((StatGraph)graph, (Element)elem, (int)curveLabelPosition);
                break;
            }
            case 13: {
                overlay = FringeParser.load((StatGraph)graph, (Element)elem);
                break;
            }
            case 18: {
                overlay = BlockParser.load((StatGraph)graph, (Element)elem);
                if (StatGraph.getOptionAttrsElement((Element)elem, (String)"XAxisOpts") == null) {
                    soc.setAxesVisible(false);
                }
                soc.getWall().setEdgeOn(false);
            }
        }
        if (overlay == null) {
            return null;
        }
        overlay.setComponentSize(graph.size.width, graph.size.height);
        QCLayoutOverlayParser.setAutomaticAxisTypes((Overlay)overlay, true, xAxis, x2Axis, yAxis, y2Axis, null);
        if (oc.isHorizontal()) {
            QCLayoutOverlayParser.parseAxisOptsList(graph, soc, elem, y1a, y2a, x1a, x2a, null);
        } else {
            QCLayoutOverlayParser.parseAxisOptsList(graph, soc, elem, x1a, x2a, y1a, y2a, null);
        }
        if (!QCLayoutOverlayParser.isCompatibleOverlay(graph, (Overlay)overlay)) {
            return null;
        }
        QCLayoutOverlayParser.addOverlay((Overlay)overlay, soc, xAxis, x2Axis, yAxis, y2Axis, null, oc.isHorizontal());
        if (overlay instanceof BoxOverlay) {
            Overlay[] blocks = ((BoxOverlay)overlay).getBlockOverlays();
            if (blocks != null) {
                for (int i = 0; i < blocks.length; ++i) {
                    QCLayoutOverlayParser.addOverlay(blocks[i], soc, xAxis, x2Axis, yAxis, y2Axis, null, oc.isHorizontal());
                }
            }
            if (!overlay.getModel().isAvailable(10)) {
                if (((BoxOverlay)overlay).getOrientation() == 0) {
                    xAxis.setVisible(false);
                    x2Axis.setVisible(false);
                } else {
                    yAxis.setVisible(false);
                    y2Axis.setVisible(false);
                }
            }
        }
        return oc;
    }

    public static void addOverlay(Overlay overlay, QCSimple2DOverlayComposite soc, VRectAxis xa, VRectAxis x2a, VRectAxis ya, VRectAxis y2a, VRectAxis za) {
        QCLayoutOverlayParser.addOverlay(overlay, soc, xa, x2a, ya, y2a, za, false);
    }

    private static boolean isAxisAffected(Overlay plot, byte dim) {
        boolean affected = true;
        if (plot instanceof ReferenceLineOverlay) {
            ReferenceLineOverlay ref = (ReferenceLineOverlay)plot;
            switch (dim) {
                case 1: {
                    if (!ref.isHorizontal()) break;
                    affected = false;
                    break;
                }
                case 2: {
                    if (ref.isHorizontal()) break;
                    affected = false;
                }
            }
        }
        return affected;
    }

    public static void addOverlay(Overlay overlay, QCSimple2DOverlayComposite soc, VRectAxis xa, VRectAxis x2a, VRectAxis ya, VRectAxis y2a, VRectAxis za, boolean horizontal) {
        soc.addOverlay(overlay);
        boolean xok = true;
        boolean yok = true;
        boolean zok = true;
        if (horizontal) {
            if (overlay.getYAxis().equals("y")) {
                if (!xa.isVisible()) {
                    xa.setVisible(QCLayoutOverlayParser.isAxisAffected(overlay, (byte)1));
                }
                xok = soc.connect(overlay, (AbstractAxis)xa, (byte)1);
            } else {
                if (!x2a.isVisible()) {
                    x2a.setVisible(QCLayoutOverlayParser.isAxisAffected(overlay, (byte)1));
                }
                xok = soc.connect(overlay, (AbstractAxis)x2a, (byte)1);
            }
            if (overlay.getXAxis().equals("x")) {
                if (!ya.isVisible()) {
                    ya.setVisible(QCLayoutOverlayParser.isAxisAffected(overlay, (byte)2));
                }
                yok = soc.connect(overlay, (AbstractAxis)ya, (byte)2);
            } else {
                if (!y2a.isVisible()) {
                    y2a.setVisible(QCLayoutOverlayParser.isAxisAffected(overlay, (byte)2));
                }
                yok = soc.connect(overlay, (AbstractAxis)y2a, (byte)2);
            }
        } else {
            if (overlay.getXAxis().equals("x")) {
                if (!xa.isVisible()) {
                    xa.setVisible(QCLayoutOverlayParser.isAxisAffected(overlay, (byte)1));
                }
                xok = soc.connect(overlay, (AbstractAxis)xa, (byte)1);
            } else {
                if (!x2a.isVisible()) {
                    x2a.setVisible(QCLayoutOverlayParser.isAxisAffected(overlay, (byte)1));
                }
                xok = soc.connect(overlay, (AbstractAxis)x2a, (byte)1);
            }
            if (overlay.getYAxis().equals("y")) {
                if (!ya.isVisible()) {
                    ya.setVisible(QCLayoutOverlayParser.isAxisAffected(overlay, (byte)2));
                }
                yok = soc.connect(overlay, (AbstractAxis)ya, (byte)2);
            } else {
                if (!y2a.isVisible()) {
                    y2a.setVisible(QCLayoutOverlayParser.isAxisAffected(overlay, (byte)2));
                }
                yok = soc.connect(overlay, (AbstractAxis)y2a, (byte)2);
            }
        }
        if (za != null) {
            za.setVisible(true);
            zok = soc.connect(overlay, (AbstractAxis)za, (byte)3);
        }
        if (!(xok && yok && zok)) {
            Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"axis.fmt.txt"));
            StatGraph.printWarning((String)msg.toString((Object)overlay.getStmt()));
            soc.removeOverlay(overlay);
        }
    }

    public static OverlayContainer initComposite(StatGraph graph, Element elem) {
        boolean interactive = !graph.server;
        boolean softwareBuffered = false;
        OverlayContainer oc = (OverlayContainer)graph.getObjectFromElement(elem);
        if (oc == null) {
            oc = new OverlayContainer(true, softwareBuffered, interactive);
        }
        QCSimple2DOverlayComposite soc = new QCSimple2DOverlayComposite();
        oc.setComposite((Simple2DOverlayComposite)soc);
        Wall w = new Wall(true);
        GraphStyle.setDefaultLineStyle((StatGraph)graph, null, (LineAttrs)w.getEdgeStyle(), (String)"WallFill");
        GraphStyle.setDefaultLineStyle((StatGraph)graph, null, (LineAttrs)w.getAxisLineStyle(), (String)"AxisLines");
        String str = elem.getAttribute("wallDisplay");
        if (str.length() == 0) {
            str = graph.style.getStyleAttribute("WallFill", "frameBorder");
            if (str == null || str.equalsIgnoreCase("true")) {
                w.setEdgeOn(true);
            } else {
                w.setEdgeOn(false);
            }
            w.setFillOn(true);
        } else if (str.equalsIgnoreCase("STANDARD")) {
            w.setFillOn(true);
            w.setEdgeOn(true);
        } else if (str.equalsIgnoreCase("NONE")) {
            w.setFillOn(false);
            w.setEdgeOn(false);
        } else if (str.equalsIgnoreCase("ALL")) {
            w.setFillOn(true);
            w.setEdgeOn(true);
        } else {
            w.setFillOn(false);
            w.setEdgeOn(false);
            String[] opts = StatGraph.parseList2String((String)str);
            for (int i = 0; i < opts.length; ++i) {
                if (opts[i].equalsIgnoreCase("outline")) {
                    w.setEdgeOn(true);
                    continue;
                }
                if (opts[i].equalsIgnoreCase("fill")) {
                    w.setFillOn(true);
                    continue;
                }
                w.setFillOn(true);
                w.setEdgeOn(true);
                StatGraph.printOptionError((String)"WALLDISPLAY", (String)opts[i]);
                break;
            }
        }
        if (w.isFillOn()) {
            QCLayoutOverlayParser.parseWallColor(graph, elem, w.getFillStyle());
        }
        soc.setWall(w);
        soc.dataDisplayAntialiased = graph.dataAntialiased;
        soc.axisDisplayAntialiased = graph.axisAntialiased;
        soc.subpixelRendering = graph.isAutoSubpixel;
        oc.setViewportEnabled(0, !graph.server && graph.xAxisViewportEnabled);
        oc.setViewportEnabled(1, !graph.server && graph.xAxisViewportEnabled);
        oc.setViewportEnabled(2, !graph.server && graph.yAxisViewportEnabled);
        oc.setViewportEnabled(3, !graph.server && graph.yAxisViewportEnabled);
        if (!graph.server) {
            if (graph.chartPopupMenu == null) {
                graph.chartPopupMenu = OverlayContainer.createChartPopupMenu();
            }
            oc.setChartPopupMenu(graph.chartPopupMenu);
        }
        if (graph.selectionListener != null) {
            oc.addSelectionListener(graph.selectionListener);
        }
        return oc;
    }

    public static void initAxis(StatGraph graph, VRectAxis axis) {
        if (axis == null) {
            return;
        }
        axis.setGapShrinkScale(graph.getGapShrinkageScale());
        LineAttrs ls = new LineAttrs();
        GraphStyle.setDefaultLineStyle((StatGraph)graph, null, (LineAttrs)ls, (String)"AxisLines");
        Color alc = ls.getColor();
        AxisStyle as = axis.getAxisStyle();
        as.setAxisLineColor(alc);
        as.getMajorTickStyle().setColor(alc);
        as.getMinorTickStyle().setColor(alc);
        as.setLineWidth(ls.getWidth());
        as.getMajorTickStyle().setLineWidth(ls.getWidth());
        as.getMinorTickStyle().setLineWidth(ls.getWidth());
        as.setLineStipple(ls.getStipplePattern(), ls.getStippleFactor());
        GraphStyle.setDefaultTextStyle((StatGraph)graph, null, (TextStyle)as.getTitleStyle(), (String)"LabelText");
        GraphStyle.setDefaultTextStyle((StatGraph)graph, null, (TextStyle)as.getLabelStyle(), (String)"ValueText");
        String str = graph.style.getStyleAttribute("AxisLines", "tickDisplay");
        if (str != null) {
            if (str.equalsIgnoreCase("INSIDE")) {
                axis.getAxisStyle().getMajorTickStyle().setTickMarkJustification(0);
            } else if (str.equalsIgnoreCase("ACROSS")) {
                axis.getAxisStyle().getMajorTickStyle().setTickMarkJustification(2);
            }
        }
    }

    public static void copyAxisOptions(VRectAxis fromAxis, VRectAxis toAxis) {
        toAxis.setAxisStyle(new AxisStyle(fromAxis.getAxisStyle()));
        toAxis.setRectAxisParams(fromAxis.getRectAxisParams());
        toAxis.setValueFormat(fromAxis.getValueFormat());
        toAxis.setUseDataFormat(fromAxis.isUseDataFormat());
        toAxis.setIntegerTicks(fromAxis.isIntegerTicks());
        toAxis.setStartCoverage(fromAxis.getStartCoverage());
        toAxis.setEndCoverage(fromAxis.getEndCoverage());
        toAxis.setMinOffsetBy(fromAxis.getMinOffsetBy());
        toAxis.setMaxOffsetBy(fromAxis.getMaxOffsetBy());
        toAxis.setUserStartOffset(fromAxis.getUserStartOffset());
        toAxis.setUserEndOffset(fromAxis.getUserEndOffset());
        toAxis.setUseTitle(fromAxis.getUseTitle());
        toAxis.setShortTitle(fromAxis.getShortTitle());
        toAxis.setTitlePositionedAtMax(fromAxis.isTitlePositionedAtMax());
        String fit = fromAxis.getFitPolicy();
        if (!toAxis.getPrimary() && toAxis.getDimension() == 1 && fit != null && fit.indexOf("angle315") >= 0) {
            fit = fit.replaceAll("angle315", "angle45");
        }
        if (fit == null) {
            toAxis.setFitPolicy(null);
        } else {
            toAxis.setHonorFitStartegy(fromAxis.isHonorFitStartegy());
            toAxis.setFitPolicy(fit);
        }
        toAxis.setTicks(fromAxis.getTicks());
        toAxis.setDiscreteTicks(fromAxis.getDiscreteTicks());
        toAxis.setTickValuePriority(fromAxis.getTickValuePriority());
        toAxis.setViewportMin(fromAxis.getViewportMin());
        toAxis.setViewportMax(fromAxis.getViewportMax());
        toAxis.setType(fromAxis.getType());
        toAxis.setReverse(fromAxis.isReverse());
        toAxis.setTickLabels(fromAxis.getTickLabels());
        toAxis.setTickValueOrder(fromAxis.getTickValueOrder());
        toAxis.setExtractScale(fromAxis.isExtractScale());
        toAxis.setLogarithmBase(fromAxis.getLogarithmBase());
        toAxis.setLogTickIntervalStyle(fromAxis.getLogTickIntervalStyle());
        toAxis.setTicklabelMaxDecimals(fromAxis.getTickLabelMaxDecimals());
        toAxis.setTicklabelMaxWidth(fromAxis.getTickLabelMaxWidth());
        toAxis.setTicklabelPreferredDecimals(fromAxis.getTickLabelPreferredDecimals());
        toAxis.setMinorNum(fromAxis.getMinorNum());
        toAxis.setGridVisible(fromAxis.isGridVisible());
        toAxis.setGridStyle(fromAxis.getGridStyle());
        toAxis.setAxisLegendFitPolicy(fromAxis.getAxisLegendFitPolicy());
        toAxis.setTicksShownAtMidpoint(fromAxis.isTicksShownAtMidpoint());
    }

    public static void parseGraphOpts(StatGraph graph, Element elem, Overlay overlay) {
        String str = elem.getAttribute("name");
        if (str.length() > 0) {
            graph.addNamedGraph(str, overlay);
            overlay.setName(str);
        }
        if ((str = elem.getAttribute("legendLabel")).length() > 0) {
            str = QCStylizedTextElement.replaceUStrings(str);
            overlay.setLegendLabel(str);
        }
        if ((str = elem.getAttribute("xAxis")).length() > 0) {
            if (str.equalsIgnoreCase("x") || str.equalsIgnoreCase("x2")) {
                overlay.setXAxis(str.toLowerCase());
            } else {
                StatGraph.printOptionError((String)"XAXIS", (String)str);
            }
        }
        if ((str = elem.getAttribute("yAxis")).length() > 0) {
            if (str.equalsIgnoreCase("y") || str.equalsIgnoreCase("y2")) {
                overlay.setYAxis(str.toLowerCase());
            } else {
                StatGraph.printOptionError((String)"YAXIS", (String)str);
            }
        }
        if (StatGraph.isNumber((String)(str = elem.getAttribute("dataTransparency")))) {
            overlay.setDataTransparency(Double.parseDouble(str));
        }
        if ((str = elem.getAttribute("_stmt")).length() > 0) {
            overlay.setStmt(str.toUpperCase());
        }
    }

    static boolean isNumericAxis(int type) {
        return type == 0 || type == 3 || type == 1;
    }

    public static boolean isCompatibleOverlay(StatGraph graph, Overlay overlay) {
        int type;
        if (overlay instanceof ReferenceLineOverlay || overlay instanceof DropLineOverlay) {
            return true;
        }
        if (overlay instanceof LineParmOverlay || overlay instanceof EllipseParmOverlay) {
            int typeY;
            int typeX = overlay.getXAxis().equalsIgnoreCase("x") ? xAxisType : x2AxisType;
            int n = typeY = overlay.getYAxis().equalsIgnoreCase("y") ? yAxisType : y2AxisType;
            if (!(typeX != 0 && typeX != 1 || typeY != 0 && typeY != 1)) {
                return true;
            }
            Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"axis.fmt.txt"));
            StatGraph.printWarning((String)msg.toString((Object)overlay.getStmt()));
            return false;
        }
        DataRange dr = overlay.getDataRange((byte)1);
        if (dr instanceof DiscreteRange && ((DiscreteRange)dr).getValuesSize() > graph.discreteMax) {
            Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"discrete.fmt.txt"));
            StatGraph.printWarning((String)msg.toString((Object)overlay.getStmt()));
            return false;
        }
        int xa = QCLayoutOverlayParser.getAxisType(dr);
        if (!(xa < 0 || xa == (type = overlay.getXAxis().equalsIgnoreCase("x") ? xAxisType : x2AxisType) || QCLayoutOverlayParser.isNumericAxis(xa) && QCLayoutOverlayParser.isNumericAxis(type))) {
            Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"axis.fmt.txt"));
            StatGraph.printWarning((String)msg.toString((Object)overlay.getStmt()));
            return false;
        }
        dr = overlay.getDataRange((byte)2);
        if (dr instanceof DiscreteRange && ((DiscreteRange)dr).getValuesSize() > graph.discreteMax) {
            Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"discrete.fmt.txt"));
            StatGraph.printWarning((String)msg.toString((Object)overlay.getStmt()));
            return false;
        }
        int ya = QCLayoutOverlayParser.getAxisType(dr);
        if (!(ya < 0 || ya == (type = overlay.getYAxis().equalsIgnoreCase("y") ? yAxisType : y2AxisType) || QCLayoutOverlayParser.isNumericAxis(ya) && QCLayoutOverlayParser.isNumericAxis(type))) {
            Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"axis.fmt.txt"));
            StatGraph.printWarning((String)msg.toString((Object)overlay.getStmt()));
            return false;
        }
        dr = overlay.getDataRange((byte)3);
        if (dr instanceof DiscreteRange && ((DiscreteRange)dr).getValuesSize() > graph.discreteMax) {
            Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"discrete.fmt.txt"));
            StatGraph.printWarning((String)msg.toString((Object)overlay.getStmt()));
            return false;
        }
        int za = QCLayoutOverlayParser.getAxisType(dr);
        if (!(za < 0 || za == zAxisType || QCLayoutOverlayParser.isNumericAxis(za) && QCLayoutOverlayParser.isNumericAxis(zAxisType))) {
            Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"axis.fmt.txt"));
            StatGraph.printWarning((String)msg.toString((Object)overlay.getStmt()));
            return false;
        }
        return true;
    }

    static int getAxisType(DataRange dr) {
        if (dr == null) {
            return -1;
        }
        if (dr instanceof DiscreteRange) {
            return 2;
        }
        if (dr.getFormat() instanceof SASDateTimeFormat) {
            return 1;
        }
        return 0;
    }

    static void setAutomaticAxisTypes(Overlay firstPlot, boolean view2D, VRectAxis xa, VRectAxis x2a, VRectAxis ya, VRectAxis y2a, VRectAxis za) {
        int type = QCLayoutOverlayParser.getAxisType(firstPlot.getDataRange((byte)1));
        if (firstPlot.getXAxis().equalsIgnoreCase("x2")) {
            x2AxisType = type;
        } else {
            xAxisType = type;
        }
        type = QCLayoutOverlayParser.getAxisType(firstPlot.getDataRange((byte)2));
        if (firstPlot.getYAxis().equalsIgnoreCase("y2")) {
            y2AxisType = type;
        } else {
            yAxisType = type;
        }
        if (!view2D) {
            zAxisType = QCLayoutOverlayParser.getAxisType(firstPlot.getDataRange((byte)3));
        }
        QCLayoutOverlayParser.setTypeToVRectAxis(xa, xAxisType);
        QCLayoutOverlayParser.setTypeToVRectAxis(x2a, x2AxisType);
        QCLayoutOverlayParser.setTypeToVRectAxis(ya, yAxisType);
        QCLayoutOverlayParser.setTypeToVRectAxis(y2a, y2AxisType);
        QCLayoutOverlayParser.setTypeToVRectAxis(za, zAxisType);
    }

    public static void setAutomaticAxisTypes(ArrayList overlays, boolean view2D, VRectAxis xa, VRectAxis x2a, VRectAxis ya, VRectAxis y2a, VRectAxis za) {
        Overlay firstPlot = null;
        firstPlot = QCLayoutOverlayParser.getFirst2DPlot(overlays, "x");
        if (firstPlot != null) {
            xAxisType = QCLayoutOverlayParser.getAxisType(firstPlot.getDataRange((byte)1));
        }
        if ((firstPlot = QCLayoutOverlayParser.getFirst2DPlot(overlays, "x2")) != null) {
            x2AxisType = QCLayoutOverlayParser.getAxisType(firstPlot.getDataRange((byte)1));
        }
        if ((firstPlot = QCLayoutOverlayParser.getFirst2DPlot(overlays, "y")) != null) {
            yAxisType = QCLayoutOverlayParser.getAxisType(firstPlot.getDataRange((byte)2));
        }
        if ((firstPlot = QCLayoutOverlayParser.getFirst2DPlot(overlays, "y2")) != null) {
            y2AxisType = QCLayoutOverlayParser.getAxisType(firstPlot.getDataRange((byte)2));
        }
        firstPlot = (Overlay)overlays.get(0);
        zAxisType = QCLayoutOverlayParser.getAxisType(firstPlot.getDataRange((byte)3));
        QCLayoutOverlayParser.setTypeToVRectAxis(xa, xAxisType);
        QCLayoutOverlayParser.setTypeToVRectAxis(x2a, x2AxisType);
        QCLayoutOverlayParser.setTypeToVRectAxis(ya, yAxisType);
        QCLayoutOverlayParser.setTypeToVRectAxis(y2a, y2AxisType);
        QCLayoutOverlayParser.setTypeToVRectAxis(za, zAxisType);
    }

    public static boolean addPlotToList(ArrayList overlays, Overlay plot, StatGraph graph, boolean scaleMarker) {
        if (plot == null) {
            return false;
        }
        plot.setComponentSize(graph.size.width, graph.size.height);
        plot.setScaleMarkers(scaleMarker);
        return QCLayoutOverlayParser.addPlotToList(overlays, plot);
    }

    public static boolean addPlotToList(ArrayList overlays, Overlay plot) {
        if (plot != null) {
            overlays.add(plot);
            return true;
        }
        return false;
    }

    static void setTypeToVRectAxis(VRectAxis axis, int type) {
        if (axis == null) {
            return;
        }
        switch (type) {
            case 0: {
                axis.setType(0);
                break;
            }
            case 3: {
                axis.setType(1);
                break;
            }
            case 1: {
                axis.setType(5);
                break;
            }
            case 2: {
                axis.setType(6);
            }
        }
    }

    static Overlay getFirst2DPlot(ArrayList overlays, String str) {
        for (int i = 0; i < overlays.size(); ++i) {
            Overlay overlay = (Overlay)overlays.get(i);
            if (!str.equals("x") && !str.equals("x2") ? overlay.getDataRange((byte)2) == null : overlay.getDataRange((byte)1) == null) continue;
            if (!overlay.getXAxis().equalsIgnoreCase(str) && !overlay.getYAxis().equalsIgnoreCase(str)) continue;
            return overlay;
        }
        return null;
    }

    public static void parseAxisOptsList(StatGraph graph, QCSimple2DOverlayComposite soc, Element elem, VRectAxis xa, VRectAxis x2a, VRectAxis ya, VRectAxis y2a, VRectAxis za) {
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("XAxisOpts")) {
                xa.setVisible(true);
                QCLayoutOverlayParser.parseAxisOpts(graph, soc, (Element)node, xa);
                continue;
            }
            if (elemTag.equals("X2AxisOpts")) {
                x2a.setVisible(true);
                QCLayoutOverlayParser.parseAxisOpts(graph, soc, (Element)node, x2a);
                continue;
            }
            if (elemTag.equals("YAxisOpts")) {
                if (za == null) {
                    ya.setVisible(true);
                    QCLayoutOverlayParser.parseAxisOpts(graph, soc, (Element)node, ya);
                    continue;
                }
                za.setVisible(true);
                QCLayoutOverlayParser.parseAxisOpts(graph, soc, (Element)node, za);
                continue;
            }
            if (elemTag.equals("Y2AxisOpts")) {
                y2a.setVisible(true);
                QCLayoutOverlayParser.parseAxisOpts(graph, soc, (Element)node, y2a);
                continue;
            }
            if (!elemTag.equals("ZAxisOpts")) continue;
            ya.setVisible(true);
            QCLayoutOverlayParser.parseAxisOpts(graph, soc, (Element)node, ya);
        }
    }

    public static void parseAxisOpts(StatGraph graph, QCSimple2DOverlayComposite soc, Element axisOps, VRectAxis axis) {
        QCLayoutOverlayParser.parseAxisOpts(graph, soc, axisOps, axis, false);
    }

    public static void parseAxisCompOpts(StatGraph graph, QCSimple2DOverlayComposite soc, Element axisOps, VRectAxis axis) {
        QCLayoutOverlayParser.parseAxisOpts(graph, soc, axisOps, axis, true);
    }

    static void parseAxisOpts(StatGraph graph, QCSimple2DOverlayComposite soc, Element axisOps, VRectAxis axis, boolean isComp) {
        String hint;
        int type;
        String str = axisOps.getAttribute("type");
        if (str.equalsIgnoreCase("LINEAR")) {
            type = 0;
        } else if (str.equalsIgnoreCase("TIME")) {
            type = 1;
        } else if (str.equalsIgnoreCase("DISCRETE")) {
            type = 2;
        } else if (str.equalsIgnoreCase("LOG")) {
            type = 3;
        } else {
            type = axis.getDimension() == 1 ? (axis.getPrimary() ? xAxisType : x2AxisType) : (axis.getDimension() == 2 ? (axis.getPrimary() ? yAxisType : y2AxisType) : zAxisType);
            if (str.length() > 0 && !str.equalsIgnoreCase("AUTO")) {
                StatGraph.printOptionError((String)"TYPE", (String)str);
            }
        }
        QCLayoutOverlayParser.setTypeToVRectAxis(axis, type);
        if (axis.getDimension() == 1) {
            if (axis.getPrimary()) {
                xAxisType = type;
            } else {
                x2AxisType = type;
            }
        } else if (axis.getDimension() == 2) {
            if (axis.getPrimary()) {
                yAxisType = type;
            } else {
                y2AxisType = type;
            }
        } else {
            zAxisType = type;
        }
        str = axisOps.getAttribute("display");
        AxisStyle as = axis.getAxisStyle();
        if (str.length() != 0 && !str.equalsIgnoreCase("STANDARD") && !str.equalsIgnoreCase("ALL")) {
            as.setAxisLineOn(false);
            as.setMajorTickMarksOn(false);
            as.setTitleOn(false);
            as.setLabelsOn(false);
            if (!str.equalsIgnoreCase("NONE")) {
                String[] opts = StatGraph.parseList2String((String)str);
                for (int i = 0; i < opts.length; ++i) {
                    if (opts[i].equalsIgnoreCase("LINE")) {
                        as.setAxisLineOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("TICKS")) {
                        as.setMajorTickMarksOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("LABEL")) {
                        as.setTitleOn(true);
                        continue;
                    }
                    if (opts[i].equalsIgnoreCase("TICKVALUES")) {
                        as.setLabelsOn(true);
                        continue;
                    }
                    as.setAxisLineOn(true);
                    as.setMajorTickMarksOn(true);
                    as.setTitleOn(true);
                    as.setLabelsOn(true);
                    StatGraph.printOptionError((String)"DISPLAY", (String)opts[i]);
                    break;
                }
            }
        }
        if ((hint = graph.style.getStyleAttribute("GridLines", "displayOpts")) == null) {
            hint = "";
        }
        boolean gridVisible = false;
        str = axisOps.getAttribute("gridDisplay");
        if (str.equalsIgnoreCase("on")) {
            gridVisible = true;
        } else if (str.equalsIgnoreCase("off")) {
            gridVisible = false;
        } else if (str.equalsIgnoreCase("auto_on")) {
            gridVisible = !hint.equalsIgnoreCase("off");
        } else if (str.length() == 0 || str.equalsIgnoreCase("auto_off")) {
            gridVisible = hint.equalsIgnoreCase("on");
        } else {
            StatGraph.printOptionError((String)"GRIDDISPLAY", (String)str);
        }
        axis.setGridVisible(gridVisible);
        VRectGridLines grid = null;
        if (gridVisible) {
            LineAttrs gridStyle = new LineAttrs();
            GraphStyle.setDefaultLineStyle((StatGraph)graph, (String)axisOps.getAttribute("gridAttrs"), (LineAttrs)gridStyle, (String)"GridLines");
            axis.setGridStyle(gridStyle);
            if (soc != null) {
                grid = new VRectGridLines();
                grid.setLineStyle(gridStyle);
                soc.connect(grid, (AbstractAxis)axis);
            }
        }
        if ((str = axisOps.getAttribute("label")).length() > 0) {
            axis.setUseTitle(str);
        }
        if ((str = axisOps.getAttribute("labelFormat")).length() > 0) {
            SASFormat fmt = SASFormat.getInstance((String)str);
            if (fmt == null) {
                try {
                    Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"badfmt.fmt.txt"));
                    StatGraph.printNote((String)msg.toString((Object)"LABELFORMAT", (Object)str));
                }
                catch (MissingResourceException msg) {}
            } else {
                axis.setLabelFormat(fmt);
            }
        }
        if ((str = axisOps.getAttribute("reverse")).length() > 0 && str.equalsIgnoreCase("true")) {
            axis.setReverse(true);
        }
        String string = str = axis.isReverse() ? axisOps.getAttribute("offsetMax") : axisOps.getAttribute("offsetMin");
        if (StatGraph.isNumber((String)str)) {
            axis.setUserStartOffset(Double.parseDouble(str));
            axis.setMinOffsetBy(VRectAxis.OFFSET_BY_NUMBER);
        } else if (str.equalsIgnoreCase("autoCompress")) {
            axis.setMinOffsetBy(VRectAxis.OFFSET_BY_TICKVALUES);
        } else if (str.equalsIgnoreCase("auto")) {
            axis.setMinOffsetBy(VRectAxis.OFFSET_BY_AUTO);
        } else if (str.length() > 0) {
            StatGraph.printOptionError((String)"OFFSETMIN", (String)str);
        }
        String string2 = str = axis.isReverse() ? axisOps.getAttribute("offsetMin") : axisOps.getAttribute("offsetMax");
        if (StatGraph.isNumber((String)str)) {
            axis.setUserEndOffset(Double.parseDouble(str));
            axis.setMaxOffsetBy(VRectAxis.OFFSET_BY_NUMBER);
        } else if (str.equalsIgnoreCase("autoCompress")) {
            axis.setMaxOffsetBy(VRectAxis.OFFSET_BY_TICKVALUES);
        } else if (str.equalsIgnoreCase("auto")) {
            axis.setMaxOffsetBy(VRectAxis.OFFSET_BY_AUTO);
        } else if (str.length() > 0) {
            StatGraph.printOptionError((String)"OFFSETMAX", (String)str);
        }
        str = axisOps.getAttribute("shortLabel");
        if (str.length() > 0) {
            axis.setShortTitle(str);
        }
        if ((str = axisOps.getAttribute("tickStyle")).equalsIgnoreCase("INSIDE")) {
            axis.getAxisStyle().getMajorTickStyle().setTickMarkJustification(0);
        } else if (str.equalsIgnoreCase("ACROSS")) {
            axis.getAxisStyle().getMajorTickStyle().setTickMarkJustification(2);
        } else if (str.length() > 0 && !str.equalsIgnoreCase("OUTSIDE")) {
            StatGraph.printOptionError((String)"TICKSTYLE", (String)str);
        }
        TextAttrs ta = new TextAttrs();
        GraphStyle.setDefaultTextStyle((StatGraph)graph, (String)axisOps.getAttribute("labelAttrs"), (TextStyle)axis.getAxisStyle().getTitleStyle(), (String)"LabelText");
        GraphStyle.setDefaultTextStyle((StatGraph)graph, (String)axisOps.getAttribute("tickValueAttrs"), (TextStyle)axis.getAxisStyle().getLabelStyle(), (String)"ValueText");
        LineAttrs tls = new LineAttrs();
        GraphStyle.setDefaultLineStyle((StatGraph)graph, (String)axisOps.getAttribute("axisLineAttrs"), (LineAttrs)tls, (String)"AxisLines");
        axis.getAxisStyle().setAxisLineColor(tls.getColor());
        axis.getAxisStyle().getMajorTickStyle().setColor(tls.getColor());
        axis.getAxisStyle().getMinorTickStyle().setColor(tls.getColor());
        axis.getAxisStyle().setLineWidth(tls.getWidth());
        axis.getAxisStyle().getMajorTickStyle().setLineWidth(tls.getWidth());
        axis.getAxisStyle().getMinorTickStyle().setLineWidth(tls.getWidth());
        axis.getAxisStyle().setLineStipple(tls.getStipplePattern(), tls.getStippleFactor());
        String elemTag = "";
        for (Node node = axisOps.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("AxisLineAttrs")) {
                LineAttrs ls = new LineAttrs();
                StatGraph.parseLineAttrs((StatGraph)graph, (Element)((Element)node), (LineAttrs)ls);
                axis.getAxisStyle().setAxisLineColor(ls.getColor());
                axis.getAxisStyle().getMajorTickStyle().setColor(ls.getColor());
                axis.getAxisStyle().getMinorTickStyle().setColor(ls.getColor());
                axis.getAxisStyle().setLineWidth(ls.getWidth());
                axis.getAxisStyle().getMajorTickStyle().setLineWidth(ls.getWidth());
                axis.getAxisStyle().getMinorTickStyle().setLineWidth(ls.getWidth());
                axis.getAxisStyle().setLineStipple(ls.getStipplePattern(), ls.getStippleFactor());
                continue;
            }
            if (elemTag.equals("GridAttrs")) {
                if (grid != null) {
                    StatGraph.parseLineAttrs((StatGraph)graph, (Element)((Element)node), (LineAttrs)grid.getLineStyle());
                }
                if (!gridVisible) continue;
                StatGraph.parseLineAttrs((StatGraph)graph, (Element)((Element)node), (LineAttrs)axis.getGridStyle());
                continue;
            }
            if (elemTag.equals("LabelAttrs")) {
                StatGraph.parseTextAttrs((StatGraph)graph, (Element)((Element)node), (TextStyle)axis.getAxisStyle().getTitleStyle());
                continue;
            }
            if (elemTag.equals("TickValueAttrs")) {
                StatGraph.parseTextAttrs((StatGraph)graph, (Element)((Element)node), (TextStyle)axis.getAxisStyle().getLabelStyle());
                continue;
            }
            if (elemTag.equals("LinearOpts")) {
                if (!isComp && type != 0) continue;
                QCLayoutOverlayParser.parseLinearAxisOpts(graph, (Element)node, axis, soc);
                continue;
            }
            if (elemTag.equals("DiscreteOpts")) {
                if (!isComp && type != 2) continue;
                QCLayoutOverlayParser.parseDiscreteAxisOpts(graph, (Element)node, axis);
                if (grid == null || !gridVisible || soc == null) continue;
                grid.setShownAtMidpoint(axis.isTicksShownAtMidpoint());
                continue;
            }
            if (elemTag.equals("TimeOpts")) {
                if (!isComp && type != 1) continue;
                QCLayoutOverlayParser.parseTimeAxisOpts(graph, (Element)node, axis);
                continue;
            }
            if (elemTag.equals("LogOpts")) {
                if (!isComp && type != 3) continue;
                QCLayoutOverlayParser.parseLogarithmicAxisOpts(graph, (Element)node, axis);
                continue;
            }
            if (!elemTag.equals("PercentileOpts") && !elemTag.equals("ProbabilityOpts")) continue;
        }
    }

    public static boolean honorAxisOpts(Element axisOps, VRectAxis axis, String attrName) {
        Element parent = (Element)axisOps.getParentNode();
        while (!parent.getNodeName().equalsIgnoreCase("StatGraph")) {
            parent = (Element)parent.getParentNode();
        }
        NodeList nl = parent.getElementsByTagName("LayoutLattice");
        if (nl == null || nl.getLength() <= 0) {
            return true;
        }
        Element lattice = (Element)nl.item(0);
        if (axis.getDimension() == 1) {
            String str;
            Element colaxis = null;
            if (axis.getPrimary()) {
                str = lattice.getAttribute("columnDataRange");
                if (str.length() == 0 || !str.equalsIgnoreCase("union") && !str.equalsIgnoreCase("unionall")) {
                    return true;
                }
                nl = lattice.getElementsByTagName("ColumnAxes");
                if (nl == null || nl.getLength() <= 0) {
                    return true;
                }
                colaxis = (Element)nl.item(0);
            } else {
                str = lattice.getAttribute("column2DataRange");
                if (str.length() == 0 || !str.equalsIgnoreCase("union") && !str.equalsIgnoreCase("unionall")) {
                    return true;
                }
                nl = lattice.getElementsByTagName("Column2Axes");
                if (nl == null || nl.getLength() <= 0) {
                    return true;
                }
                colaxis = (Element)nl.item(0);
            }
            if (colaxis != null && (nl = colaxis.getElementsByTagName("ColumnAxis")) != null && nl.getLength() > 0) {
                if (attrName.equalsIgnoreCase("viewport")) {
                    for (int i = 0; i < nl.getLength(); ++i) {
                        if (axisOps.getParentNode() != nl.item(i)) continue;
                        return true;
                    }
                } else if (attrName.equalsIgnoreCase("displaySecondary")) {
                    for (int i = 0; i < nl.getLength(); ++i) {
                        if (axisOps != nl.item(i)) continue;
                        return true;
                    }
                }
                return false;
            }
        } else {
            String str;
            Element rowaxis = null;
            if (axis.getPrimary()) {
                str = lattice.getAttribute("rowDataRange");
                if (str.length() == 0 || !str.equalsIgnoreCase("union") && !str.equalsIgnoreCase("unionall")) {
                    return true;
                }
                nl = lattice.getElementsByTagName("RowAxes");
                if (nl == null || nl.getLength() <= 0) {
                    return true;
                }
                rowaxis = (Element)nl.item(0);
            } else {
                str = lattice.getAttribute("row2DataRange");
                if (str.length() == 0 || !str.equalsIgnoreCase("union") && !str.equalsIgnoreCase("unionall")) {
                    return true;
                }
                nl = lattice.getElementsByTagName("Row2Axes");
                if (nl == null || nl.getLength() <= 0) {
                    return true;
                }
                rowaxis = (Element)nl.item(0);
            }
            if (rowaxis != null && (nl = rowaxis.getElementsByTagName("RowAxis")) != null && nl.getLength() > 0) {
                if (attrName.equalsIgnoreCase("viewport")) {
                    for (int i = 0; i < nl.getLength(); ++i) {
                        if (axisOps.getParentNode() != nl.item(i)) continue;
                        return true;
                    }
                } else if (attrName.equalsIgnoreCase("displaySecondary")) {
                    for (int i = 0; i < nl.getLength(); ++i) {
                        if (axisOps != nl.item(i)) continue;
                        return true;
                    }
                }
                return false;
            }
        }
        return true;
    }

    public static void parseLinearAxisOpts(StatGraph graph, Element axisOps, VRectAxis axis, QCSimple2DOverlayComposite soc) {
        String[] labels;
        String str = axisOps.getAttribute("integer");
        if (str.equalsIgnoreCase("true")) {
            axis.setIntegerTicks(true);
        }
        if (StatGraph.isNumber((String)(str = axisOps.getAttribute("nTicks")))) {
            axis.setNTicks(Integer.parseInt(str));
        }
        if ((str = axisOps.getAttribute("minorTicks")).length() > 0 && str.equalsIgnoreCase("true")) {
            axis.setMinorTicksOn(true);
            axis.getRectAxisParams().setMinorNum(1);
        }
        if (axis.isGridVisible()) {
            str = axisOps.getAttribute("minorGrid");
            if (str.equalsIgnoreCase("true")) {
                axis.setMinorGridOn(true);
                axis.getRectAxisParams().setMinorNum(1);
            } else if (str.equalsIgnoreCase("false")) {
                axis.setMinorGridOn(false);
            }
        }
        if (StatGraph.isNumber((String)(str = axisOps.getAttribute("minorTickCount")))) {
            int n = (int)Double.parseDouble(str);
            axis.setUserReqMinorNum(n);
        }
        if (axis.isMinorGridOn()) {
            LineAttrs gridStyle = new LineAttrs();
            GraphStyle.setDefaultLineStyle((StatGraph)graph, (String)axisOps.getAttribute("minorGridAttrs"), (LineAttrs)gridStyle, (String)"MinorGridLines");
            axis.setMinorGridStyle(gridStyle);
        }
        if (StatGraph.isNumber((String)(str = axisOps.getAttribute("thresholdMin")))) {
            axis.setStartCoverage(Double.parseDouble(str));
        }
        if (StatGraph.isNumber((String)(str = axisOps.getAttribute("thresholdMax")))) {
            axis.setEndCoverage(Double.parseDouble(str));
        }
        if ((str = axisOps.getAttribute("tickValueRotation")).length() > 0) {
            if (str.equalsIgnoreCase("diagonal")) {
                axis.setTickValueRotation(0);
            } else if (str.equalsIgnoreCase("vertical")) {
                axis.setTickValueRotation(1);
            } else {
                Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"angle.fmt.txt"));
                StatGraph.printNote((String)msg.toString((Object)"TICKVALUEROTATION", (Object)str));
            }
        }
        if ((str = axisOps.getAttribute("tickValueFitPolicy")).length() > 0) {
            axis.setTickLabeling(str);
        }
        if (QCLayoutOverlayParser.honorAxisOpts(axisOps, axis, "viewport")) {
            str = axisOps.getAttribute("viewMin");
            if (str.length() > 0 && StatGraph.isNumber((String)str)) {
                axis.setViewportMin(Double.parseDouble(str));
            }
            if ((str = axisOps.getAttribute("viewMax")).length() > 0 && StatGraph.isNumber((String)str)) {
                axis.setViewportMax(Double.parseDouble(str));
            }
        }
        double vmin = axis.getViewportMin();
        double vmax = axis.getViewportMax();
        if (!Double.isNaN(vmin) && !Double.isNaN(vmax) && vmin > vmax) {
            axis.setViewportMin(Double.NaN);
            axis.setViewportMax(Double.NaN);
            Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"viewmm.fmt.txt"));
            StatGraph.printNote((String)msg.toString((Object)Double.toString(vmax), (Object)Double.toString(vmin)));
        }
        if ((str = axisOps.getAttribute("tickValuePriority")).length() > 0 && str.equalsIgnoreCase("true")) {
            axis.setTickValuePriority(true);
        }
        if ((str = axisOps.getAttribute("tickValueFormat")).length() > 0) {
            if (!str.equalsIgnoreCase("DATA")) {
                Message msg2;
                SASFormat fmt = SASFormat.getInstance((String)str);
                if (fmt == null) {
                    try {
                        msg2 = new Message(RB.getStringResource((String)RB_KEY, (String)"badfmt.fmt.txt"));
                        StatGraph.printNote((String)msg2.toString((Object)"TICKVALUEFORMAT", (Object)str));
                    }
                    catch (MissingResourceException msg2) {}
                } else if (fmt.isCharacterFormat()) {
                    msg2 = new Message(RB.getStringResource((String)RB_KEY, (String)"formattype.fmt.txt"));
                    StatGraph.printNote((String)msg2.toString((Object)"TICKVALUEFORMAT", (Object)str));
                } else {
                    axis.setValueFormat(fmt);
                }
            } else {
                axis.setUseDataFormat(true);
            }
        }
        if ((str = axisOps.getAttribute("origin")).length() > 0) {
            axis.setOrigin(Double.parseDouble(str));
        }
        Element tickValueElem = null;
        Element tickDisplayElem = null;
        for (Node node = axisOps.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            String elemTag = ((Element)node).getTagName();
            if (elemTag.equals("TickValueFormatOpts")) {
                Element ggood = (Element)node;
                str = ggood.getAttribute("maxWidth");
                if (StatGraph.isNumber((String)str)) {
                    axis.setTicklabelMaxWidth(Integer.parseInt(str));
                }
                if (StatGraph.isNumber((String)(str = ggood.getAttribute("maxDecimals")))) {
                    axis.setTicklabelMaxDecimals(Integer.parseInt(str));
                }
                if (StatGraph.isNumber((String)(str = ggood.getAttribute("preferredDecmals")))) {
                    axis.setTicklabelPreferredDecimals(Integer.parseInt(str));
                }
                if (!(str = ggood.getAttribute("extractScale")).equalsIgnoreCase("true")) continue;
                axis.setExtractScale(true);
                continue;
            }
            if (elemTag.equals("TickValues")) {
                tickValueElem = (Element)node;
                continue;
            }
            if (elemTag.equals("TickDisplays")) {
                tickDisplayElem = (Element)node;
                continue;
            }
            if (!elemTag.equals("TickValueSequence")) continue;
            Element tvs = (Element)node;
            double start = 0.0;
            double end = 0.0;
            double increment = 0.0;
            str = tvs.getAttribute("start");
            if (StatGraph.isNumber((String)str)) {
                start = Double.parseDouble(str);
            }
            if (StatGraph.isNumber((String)(str = tvs.getAttribute("end")))) {
                end = Double.parseDouble(str);
            }
            if (StatGraph.isNumber((String)(str = tvs.getAttribute("increment")))) {
                increment = Double.parseDouble(str);
            }
            if (start < end) {
                if (start + increment < start || start + increment > end) {
                    Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"tickinc.fmt.txt"));
                    StatGraph.printNote((String)msg.toString((Object)str));
                    continue;
                }
            } else if (start > end) {
                if (start + increment > start || start + increment < end) {
                    Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"tickinc.fmt.txt"));
                    StatGraph.printNote((String)msg.toString((Object)str));
                    continue;
                }
            } else if (increment != 0.0) {
                Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"tickinc.fmt.txt"));
                StatGraph.printNote((String)msg.toString((Object)str));
                continue;
            }
            if (increment != 0.0) {
                int i;
                int intervals = (int)Math.ceil((end - start) / increment);
                double[] tList = new double[intervals + 1];
                if (increment > 0.0) {
                    for (i = 0; i < intervals + 1; ++i) {
                        tList[i] = i < intervals ? start + (double)i * increment : end;
                    }
                } else {
                    for (i = 0; i < intervals + 1; ++i) {
                        tList[i] = i == 0 ? end : start + (double)(intervals - i) * increment;
                    }
                }
                axis.setTicks(tList);
                continue;
            }
            double[] tList = new double[]{start};
            axis.setTicks(tList);
        }
        if (tickValueElem != null && tickDisplayElem != null) {
            TreeMap map = QCLayoutOverlayParser.parseTickValueAndDisplayLists(tickValueElem, tickDisplayElem);
            int size = map.size();
            double[] ticks = new double[size];
            String[] labels2 = new String[size];
            Iterator iter = map.keySet().iterator();
            for (int n = 0; n < size; ++n) {
                Object key = iter.next();
                ticks[n] = (Double)key;
                labels2[n] = (String)map.get(key);
            }
            if (ticks != null && ticks.length > 0) {
                axis.setTicks(ticks);
            }
            if (labels2 != null && labels2.length > 0) {
                axis.setTickLabels(labels2);
            }
        } else if (tickValueElem != null) {
            double[] ticks = StatGraph.parseDoubleValueList(tickValueElem, (String)"Value", (boolean)true);
            if (ticks != null && ticks.length > 0) {
                axis.setTicks(ticks);
            }
        } else if (tickDisplayElem != null && (labels = StatGraph.parseStringValueList(tickDisplayElem, (String)"Value")) != null && labels.length > 0) {
            axis.setTickLabels(labels);
        }
    }

    private static TreeMap parseTickValueAndDisplayLists(Element tickValueElem, Element tickDisplayElem) {
        TreeMap<Double, String> pair = new TreeMap<Double, String>();
        String elemTag = "";
        Node nodeD = tickDisplayElem.getFirstChild();
        for (Node nodeV = tickValueElem.getFirstChild(); nodeV != null; nodeV = nodeV.getNextSibling()) {
            Node child;
            Node child2;
            Double value = null;
            if (nodeV instanceof Element && (elemTag = ((Element)nodeV).getTagName()).equals("Value") && (child2 = ((Element)nodeV).getFirstChild()) != null) {
                value = new Double(child2.getNodeValue());
            }
            String display = "";
            if (nodeD != null && nodeD instanceof Element && (elemTag = ((Element)nodeD).getTagName()).equals("Value") && (child = ((Element)nodeD).getFirstChild()) != null) {
                display = child.getNodeValue();
            }
            if (value != null) {
                pair.put(value, display);
            }
            nodeD = nodeD == null ? null : nodeD.getNextSibling();
        }
        return pair;
    }

    public static void parseDiscreteAxisOpts(StatGraph graph, Element axisOps, VRectAxis axis) {
        String str = axisOps.getAttribute("tickValueFormat");
        if (str.length() > 0 && !str.equalsIgnoreCase("DATA")) {
            SASFormat fmt = SASFormat.getInstance((String)str);
            if (fmt != null) {
                if (fmt.isCharacterFormat()) {
                    axis.setValueFormat(fmt);
                }
            } else {
                try {
                    Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"badfmt.fmt.txt"));
                    StatGraph.printNote((String)msg.toString((Object)"TICKVALUEFORMAT", (Object)str));
                }
                catch (MissingResourceException msg) {
                    // empty catch block
                }
            }
        }
        if ((str = axisOps.getAttribute("tickValueFitPolicy")).length() > 0) {
            if (str.equalsIgnoreCase("EXTRACT") || str.equalsIgnoreCase("EXTRACTALWAYS")) {
                boolean auto = str.equalsIgnoreCase("EXTRACT");
                Element parentAxisOpts = (Element)axisOps.getParentNode();
                str = parentAxisOpts.getAttribute("name");
                if (str.length() > 0) {
                    graph.addNamedAxis(str, axis);
                    if (auto) {
                        axis.setAxisLegendFitPolicy(1);
                    } else {
                        axis.setAxisLegendFitPolicy(2);
                    }
                }
            } else {
                axis.setTickLabeling(str);
            }
        }
        if ((str = axisOps.getAttribute("tickValueOrder")).length() > 0) {
            if (str.equalsIgnoreCase("ASCENDING")) {
                axis.setTickValueOrder(1);
            } else if (str.equalsIgnoreCase("DESCENDING")) {
                axis.setTickValueOrder(2);
            }
        }
        if ((str = axisOps.getAttribute("tickPosition")).equalsIgnoreCase("MIDPOINT")) {
            axis.setTicksShownAtMidpoint(true);
        } else if (str.equalsIgnoreCase("INBETWEEN")) {
            axis.setTicksShownAtMidpoint(false);
        } else if (str.length() > 0) {
            StatGraph.printOptionError((String)"TICKPOSITION", (String)str);
        }
        for (Node node = axisOps.getFirstChild(); node != null; node = node.getNextSibling()) {
            String[] ticks;
            Element tickElem;
            if (!(node instanceof Element)) continue;
            String elemTag = ((Element)node).getTagName();
            if (elemTag.equals("TickDisplays")) {
                tickElem = (Element)node;
                String[] labels = StatGraph.parseStringValueList((Element)tickElem, (String)"Value");
                if (labels == null || labels.length <= 0) continue;
                if (StatGraph.MPC > 0 && graph.pageNo >= 0) {
                    int s = StatGraph.MPC * graph.pageNo;
                    int e = s + StatGraph.MPC;
                    String[] useLabels = new String[StatGraph.MPC];
                    for (int i = s; i < e; ++i) {
                        useLabels[i - s] = i < labels.length ? labels[i] : "";
                    }
                    axis.setTickLabels(useLabels);
                    continue;
                }
                axis.setTickLabels(labels);
                continue;
            }
            if (!elemTag.equals("TickValues") || (ticks = StatGraph.parseStringValueList((Element)(tickElem = (Element)node), (String)"Value")) == null || ticks.length <= 0) continue;
            axis.setDiscreteTicks(ticks);
        }
    }

    public static void parseTimeAxisOpts(StatGraph graph, Element axisOps, VRectAxis axis) {
        String str = axisOps.getAttribute("minorTicks");
        if (str.length() > 0 && str.equalsIgnoreCase("true")) {
            axis.getRectAxisParams().setMinorNum(12);
        } else {
            axis.getRectAxisParams().setMinorNum(0);
        }
        if (axis.isGridVisible()) {
            str = axisOps.getAttribute("minorGrid");
            if (str.equalsIgnoreCase("true")) {
                axis.setMinorGridOn(true);
                axis.getRectAxisParams().setMinorNum(12);
            } else if (str.equalsIgnoreCase("false")) {
                axis.setMinorGridOn(false);
            }
        }
        if (axis.isMinorGridOn()) {
            LineAttrs gridStyle = new LineAttrs();
            GraphStyle.setDefaultLineStyle((StatGraph)graph, (String)axisOps.getAttribute("minorGridAttrs"), (LineAttrs)gridStyle, (String)"MinorGridLines");
            axis.setMinorGridStyle(gridStyle);
        }
        if ((str = axisOps.getAttribute("splitTickValue")).length() > 0 && str.equalsIgnoreCase("false")) {
            axis.getRectAxisParams().setSplitTickValue(false);
        }
        if ((str = axisOps.getAttribute("interval")).length() > 0) {
            if (str.equalsIgnoreCase("second")) {
                axis.getRectAxisParams().setTimeInterval(10);
            } else if (str.equalsIgnoreCase("minute")) {
                axis.getRectAxisParams().setTimeInterval(15);
            } else if (str.equalsIgnoreCase("hour")) {
                axis.getRectAxisParams().setTimeInterval(20);
            } else if (str.equalsIgnoreCase("day")) {
                axis.getRectAxisParams().setTimeInterval(25);
            } else if (str.equalsIgnoreCase("tenday")) {
                axis.getRectAxisParams().setTimeInterval(35);
            } else if (str.equalsIgnoreCase("week")) {
                axis.getRectAxisParams().setTimeInterval(30);
            } else if (str.equalsIgnoreCase("semimonth")) {
                axis.getRectAxisParams().setTimeInterval(40);
            } else if (str.equalsIgnoreCase("month")) {
                axis.getRectAxisParams().setTimeInterval(45);
            } else if (str.equalsIgnoreCase("quarter")) {
                axis.getRectAxisParams().setTimeInterval(50);
            } else if (str.equalsIgnoreCase("semiyear")) {
                axis.getRectAxisParams().setTimeInterval(55);
            } else if (str.equalsIgnoreCase("year")) {
                axis.getRectAxisParams().setTimeInterval(60);
            } else {
                axis.getRectAxisParams().setTimeInterval(0);
                if (!str.equalsIgnoreCase("auto")) {
                    StatGraph.printOptionError((String)"INTERVAL", (String)str);
                }
            }
        }
        if ((str = axisOps.getAttribute("minorTickInterval")).length() > 0) {
            if (str.equalsIgnoreCase("second")) {
                axis.getRectAxisParams().setMinorTimeInterval(10);
            } else if (str.equalsIgnoreCase("minute")) {
                axis.getRectAxisParams().setMinorTimeInterval(15);
            } else if (str.equalsIgnoreCase("hour")) {
                axis.getRectAxisParams().setMinorTimeInterval(20);
            } else if (str.equalsIgnoreCase("day")) {
                axis.getRectAxisParams().setMinorTimeInterval(25);
            } else if (str.equalsIgnoreCase("tenday")) {
                axis.getRectAxisParams().setMinorTimeInterval(35);
            } else if (str.equalsIgnoreCase("week")) {
                axis.getRectAxisParams().setMinorTimeInterval(30);
            } else if (str.equalsIgnoreCase("semimonth")) {
                axis.getRectAxisParams().setMinorTimeInterval(40);
            } else if (str.equalsIgnoreCase("month")) {
                axis.getRectAxisParams().setMinorTimeInterval(45);
            } else if (str.equalsIgnoreCase("quarter")) {
                axis.getRectAxisParams().setMinorTimeInterval(50);
            } else if (str.equalsIgnoreCase("semiyear")) {
                axis.getRectAxisParams().setMinorTimeInterval(55);
            } else if (str.equalsIgnoreCase("year")) {
                axis.getRectAxisParams().setMinorTimeInterval(60);
            } else {
                axis.getRectAxisParams().setMinorTimeInterval(0);
                if (!str.equalsIgnoreCase("auto")) {
                    StatGraph.printOptionError((String)"INTERVAL", (String)str);
                }
            }
        }
        if ((str = axisOps.getAttribute("tickValueFitPolicy")).length() > 0) {
            axis.setTickLabeling(str);
        }
        if ((str = axisOps.getAttribute("tickValueFormat")).length() > 0) {
            if (!str.equalsIgnoreCase("DATA")) {
                SASFormat fmt = SASFormat.getInstance((String)str);
                if (fmt == null) {
                    try {
                        Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"badfmt.fmt.txt"));
                        StatGraph.printNote((String)msg.toString((Object)"TICKVALUEFORMAT", (Object)str));
                    }
                    catch (MissingResourceException missingResourceException) {}
                } else {
                    axis.setValueFormat(fmt);
                }
            } else {
                axis.setUseDataFormat(true);
            }
        }
        if ((str = axisOps.getAttribute("viewMin")).length() > 0 && StatGraph.isNumber((String)str)) {
            axis.setViewportMin(Double.parseDouble(str));
        }
        if ((str = axisOps.getAttribute("viewMax")).length() > 0 && StatGraph.isNumber((String)str)) {
            axis.setViewportMax(Double.parseDouble(str));
        }
        double vmin = axis.getViewportMin();
        double vmax = axis.getViewportMax();
        if (!Double.isNaN(vmin) && !Double.isNaN(vmax) && vmin >= vmax) {
            axis.setViewportMin(Double.NaN);
            axis.setViewportMax(Double.NaN);
            Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"viewmm.fmt.txt"));
            StatGraph.printNote((String)msg.toString((Object)Double.toString(vmax), (Object)Double.toString(vmin)));
        }
        if ((str = axisOps.getAttribute("tickValuePriority")).length() > 0 && str.equalsIgnoreCase("true")) {
            axis.setTickValuePriority(true);
        }
        for (Node node = axisOps.getFirstChild(); node != null; node = node.getNextSibling()) {
            String elemTag;
            if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("TickValues")) continue;
            axis.setTicks(StatGraph.parseDoubleValueList((Element)((Element)node), (String)"Value", (boolean)true));
            axis.getRectAxisParams().setMinorNum(0);
        }
    }

    public static void parseLogarithmicAxisOpts(StatGraph graph, Element axisOps, VRectAxis axis) {
        Message msg;
        double d;
        String str = axisOps.getAttribute("base");
        if (StatGraph.isNumber((String)str)) {
            double base = Double.parseDouble(str);
            if (base == 2.0 || base == 10.0) {
                axis.setLogarithmBase(base);
            } else {
                StatGraph.printOptionError((String)"BASE", (String)str);
            }
        } else if (str.length() > 0 && str.equalsIgnoreCase("E")) {
            axis.setLogarithmBase(Math.E);
        } else if (str.length() > 0) {
            StatGraph.printOptionError((String)"BASE", (String)str);
        }
        str = axisOps.getAttribute("tickIntervalStyle");
        if (str.length() > 0) {
            if (str.equalsIgnoreCase("LOGEXPONENT")) {
                axis.setLogTickIntervalStyle(1);
            } else if (str.equalsIgnoreCase("LOGEXPAND")) {
                axis.setLogTickIntervalStyle(0);
            } else if (str.equalsIgnoreCase("LINEAR")) {
                axis.setLogTickIntervalStyle(2);
                axis.setTickLabeling("THINLOGARITHMIC");
            } else if (!str.equalsIgnoreCase("AUTO")) {
                StatGraph.printOptionError((String)"TICKINTERVALSTYLE", (String)str);
            }
        }
        if (axis.getLogarithmBase() == 10.0 && axis.getLogTickIntervalStyle() != 2 && (str = axisOps.getAttribute("minorTicks")).length() > 0 && str.equalsIgnoreCase("true")) {
            axis.getRectAxisParams().setMinorNum(10);
        }
        if ((str = axisOps.getAttribute("viewMin")).length() > 0 && StatGraph.isNumber((String)str)) {
            d = Double.parseDouble(str);
            if (d <= 0.0) {
                msg = new Message(RB.getStringResource((String)RB_KEY, (String)"logvmin.fmt.txt"));
                StatGraph.printNote((String)msg.toString((Object)Double.toString(d)));
            } else {
                axis.setViewportMin(d);
            }
        }
        if ((str = axisOps.getAttribute("viewMax")).length() > 0 && StatGraph.isNumber((String)str)) {
            d = Double.parseDouble(str);
            if (d <= 0.0) {
                msg = new Message(RB.getStringResource((String)RB_KEY, (String)"logvmax.fmt.txt"));
                StatGraph.printNote((String)msg.toString((Object)Double.toString(d)));
            } else {
                axis.setViewportMax(d);
            }
        }
        double vmin = axis.getViewportMin();
        double vmax = axis.getViewportMax();
        if (!Double.isNaN(vmin) && !Double.isNaN(vmax) && vmin >= vmax) {
            axis.setViewportMin(Double.NaN);
            axis.setViewportMax(Double.NaN);
            Message msg2 = new Message(RB.getStringResource((String)RB_KEY, (String)"viewmm.fmt.txt"));
            StatGraph.printNote((String)msg2.toString((Object)Double.toString(vmax), (Object)Double.toString(vmin)));
        }
        if (StatGraph.isNumber((String)(str = axisOps.getAttribute("thresholdMin")))) {
            axis.setStartCoverage(Double.parseDouble(str));
        }
        if (StatGraph.isNumber((String)(str = axisOps.getAttribute("thresholdMax")))) {
            axis.setEndCoverage(Double.parseDouble(str));
        }
        if ((str = axisOps.getAttribute("tickValuePriority")).length() > 0 && str.equalsIgnoreCase("true")) {
            axis.setTickValuePriority(true);
        }
        for (Node node = axisOps.getFirstChild(); node != null; node = node.getNextSibling()) {
            String elemTag;
            if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("TickValues")) continue;
            Element tickElem = (Element)node;
            double[] ticks = StatGraph.parseDoubleValueList((Element)tickElem, (String)"Value", (boolean)true);
            boolean okTicks = true;
            for (int i = 0; i < ticks.length; ++i) {
                if (!(ticks[i] <= 0.0)) continue;
                Message msg3 = new Message(RB.getStringResource((String)RB_KEY, (String)"logtick.fmt.txt"));
                StatGraph.printNote((String)msg3.toString((Object)Double.toString(ticks[i])));
                okTicks = false;
                break;
            }
            if (!okTicks) continue;
            axis.setTicks(ticks);
        }
    }

    public static void parsePointLabelOpts(StatGraph graph, QCSimple2DOverlayComposite soc, Element elem) {
        String str = elem.getAttribute("maxHLabelOffset");
        if (str.length() > 0) {
            soc.setMaxHLabelShift(Integer.parseInt(str));
        }
        if ((str = elem.getAttribute("maxVLabelOffset")).length() > 0) {
            soc.setMaxVLabelShift(Integer.parseInt(str));
        }
        if ((str = elem.getAttribute("hLabelOffsetStep")).length() > 0) {
            soc.setHLabelShiftDelta(Integer.parseInt(str));
        }
        if ((str = elem.getAttribute("vLabelOffsetStep")).length() > 0) {
            soc.setVLabelShiftDelta(Integer.parseInt(str));
        }
        if ((str = elem.getAttribute("showPointLabels")).equalsIgnoreCase("NONE")) {
            soc.setShowPointLabels(2);
        } else if (str.equalsIgnoreCase("ALL")) {
            soc.setShowPointLabels(1);
        } else if (str.equalsIgnoreCase("CUSTOM")) {
            soc.setShowPointLabels(3);
        }
    }

    public static void addAutoGridLine(StatGraph graph, VRectAxis axis, QCSimple2DOverlayComposite soc) {
        if (axis.isVisible() && soc.getGridLines((AbstractAxis)axis) == null) {
            VRectGridLines grid = new VRectGridLines();
            GraphStyle.setDefaultLineStyle((StatGraph)graph, null, (LineAttrs)grid.getLineStyle(), (String)"GridLines");
            soc.connect(grid, (AbstractAxis)axis);
        }
    }

    static short dim2role(byte dim) {
        short role = -1;
        switch (dim) {
            case 4: {
                role = 6;
                break;
            }
            case 16: {
                role = 45;
                break;
            }
            case 17: {
                role = 46;
                break;
            }
            case 15: {
                role = 36;
                break;
            }
            case 6: {
                role = 8;
                break;
            }
            case 21: {
                role = 111;
            }
        }
        return role;
    }

    public static void parseWhere(StatGraph graph, CRD crd, Overlay plot) {
        if (graph.whereExpression == null) {
            return;
        }
        if (crd.getSrcModel().name == null || !crd.getSrcModel().name.equalsIgnoreCase(graph.whereDataModelName)) {
            return;
        }
        crd.whereVars = graph.whereVars;
        crd.whereExpression = graph.whereExpression;
        crd.allWhereExpressions = graph.allWhereExpressions;
        plot.xUnionAllPages = plot.getXAxis().equalsIgnoreCase("x") ? graph.xUnionAllPages : graph.x2UnionAllPages;
        plot.yUnionAllPages = plot.getYAxis().equalsIgnoreCase("y") ? graph.yUnionAllPages : graph.y2UnionAllPages;
    }

    public static void setDiscreteEncoder(StatGraph graph, Overlay overlay, byte dim) {
        QCLayoutOverlayParser.setDiscreteEncoder(graph, overlay, dim, (short)-1, -1.0, true);
    }

    public static void setDiscreteEncoder(StatGraph graph, Overlay overlay, byte dim, boolean grouped) {
        QCLayoutOverlayParser.setDiscreteEncoder(graph, overlay, dim, (short)-1, -1.0, grouped);
    }

    public static void setDiscreteEncoder(StatGraph graph, Overlay overlay, byte dim, short role) {
        QCLayoutOverlayParser.setDiscreteEncoder(graph, overlay, dim, role, -1.0, true);
    }

    public static void setDiscreteEncoder(StatGraph graph, Overlay overlay, byte dim, short role, boolean grouped) {
        QCLayoutOverlayParser.setDiscreteEncoder(graph, overlay, dim, role, -1.0, grouped);
    }

    public static void setDiscreteEncoder(StatGraph graph, Overlay overlay, byte dim, double transparency) {
        QCLayoutOverlayParser.setDiscreteEncoder(graph, overlay, dim, (short)-1, transparency, true);
    }

    public static void setDiscreteEncoder(StatGraph graph, Overlay overlay, byte dim, double transparency, boolean grouped) {
        QCLayoutOverlayParser.setDiscreteEncoder(graph, overlay, dim, (short)-1, transparency, grouped);
    }

    public static void setDiscreteEncoder(StatGraph graph, Overlay overlay, byte dim, short role, double transparency) {
        QCLayoutOverlayParser.setDiscreteEncoder(graph, overlay, dim, role, transparency, true);
    }

    public static boolean isMissing(Object o, boolean numeric) {
        if (numeric && o.equals(".")) {
            return true;
        }
        return ((String)o).trim().equals("");
    }

    public static void setDiscreteEncoder(StatGraph graph, Overlay overlay, byte dim, short role, double transparency, boolean grouped) {
        Object[] vals;
        short newRole = role >= 0 ? role : QCLayoutOverlayParser.dim2role(dim);
        Object[] objectArray = vals = StatGraph.isOLAP() ? overlay.getUniqueValues(newRole) : overlay.getRawUniqueValues(newRole);
        if (vals == null || vals.length == 0) {
            return;
        }
        boolean numeric = StatGraph.isOLAP() ? false : overlay.getModel().getColumnClass((int)newRole) == Double.class;
        DataStyleElement missingElem = graph.style.getGraphStyle().getDataStyleElement("Missing");
        if (missingElem == null) {
            missingElem = graph.style.getGraphStyle().getDataStyleElement("GraphDataStyleDefault");
        }
        Color missingColor = missingElem.getDefaultColor();
        Color missingContrastColor = missingElem.getContrastColor();
        int missingSymbol = missingElem.getMarkerSymbol();
        LineAttrs missingLineAttrs = new LineAttrs();
        missingLineAttrs.setColor(missingContrastColor);
        missingLineAttrs.setLinePattern(missingElem.getLineStyle());
        int missingFillPattern = missingElem.getFillType();
        ColorEncoder encoder = null;
        DiscreteRange dr = new DiscreteRange(vals);
        HashMap table = new HashMap();
        Enumeration e = dr.getEnumeration();
        HashMap<String, Serializable> topLevels = StatGraph.isOLAP() ? new HashMap<String, Serializable>() : null;
        switch (dim) {
            case 4: 
            case 24: {
                while (e.hasMoreElements()) {
                    Color c;
                    Object o = e.nextElement();
                    if (o == null) continue;
                    if (topLevels != null) {
                        String str = Overlay.getTopLevelValue((String)((String)o));
                        if (!topLevels.containsKey(str)) {
                            c = QCLayoutOverlayParser.isMissing(str, false) ? missingColor : (grouped ? graph.style.getGroupNextFillColor() : graph.style.getNextFillColor());
                            topLevels.put(str, c);
                        } else {
                            c = (Color)topLevels.get(str);
                        }
                    } else if (QCLayoutOverlayParser.isMissing(o, numeric)) {
                        c = missingColor;
                    } else {
                        Color color = c = grouped ? graph.style.getGroupNextFillColor() : graph.style.getNextFillColor();
                    }
                    if (transparency >= 0.0) {
                        table.put(o, Overlay.applyTransparency((Color)c, (double)transparency));
                        continue;
                    }
                    table.put(o, overlay.applyDataTransparency(c));
                }
                encoder = new ColorEncoder(dr, table);
                encoder.colorArray = grouped ? graph.style.getGroupFillColorList() : graph.style.fillColorList;
                break;
            }
            case 16: 
            case 17: 
            case 23: 
            case 54: {
                while (e.hasMoreElements()) {
                    Color c;
                    Object o = e.nextElement();
                    if (o == null) continue;
                    if (topLevels != null) {
                        String str = Overlay.getTopLevelValue((String)((String)o));
                        if (!topLevels.containsKey(str)) {
                            c = QCLayoutOverlayParser.isMissing(str, false) ? missingContrastColor : (grouped ? graph.style.getGroupNextContrastColor() : graph.style.getNextContrastColor());
                            topLevels.put(str, c);
                        } else {
                            c = (Color)topLevels.get(str);
                        }
                    } else if (QCLayoutOverlayParser.isMissing(o, numeric)) {
                        c = missingContrastColor;
                    } else {
                        Color color = c = grouped ? graph.style.getGroupNextContrastColor() : graph.style.getNextContrastColor();
                    }
                    if (transparency >= 0.0) {
                        table.put(o, Overlay.applyTransparency((Color)c, (double)transparency));
                        continue;
                    }
                    table.put(o, overlay.applyDataTransparency(c));
                }
                encoder = new ColorEncoder(dr, table);
                encoder.colorArray = grouped ? graph.style.getGroupContrastColorList() : graph.style.contrastColorList;
                break;
            }
            case 15: 
            case 55: {
                while (e.hasMoreElements()) {
                    LineAttrs la;
                    Object o = e.nextElement();
                    if (o == null) continue;
                    if (topLevels != null) {
                        String str = Overlay.getTopLevelValue((String)((String)o));
                        if (!topLevels.containsKey(str)) {
                            la = QCLayoutOverlayParser.isMissing(str, false) ? missingLineAttrs : (grouped ? graph.style.getGroupNextLineStyle() : graph.style.getNextLineStyle());
                            topLevels.put(str, (Serializable)la);
                        } else {
                            la = (LineAttrs)topLevels.get(str);
                        }
                    } else {
                        la = QCLayoutOverlayParser.isMissing(o, numeric) ? missingLineAttrs : (grouped ? graph.style.getGroupNextLineStyle() : graph.style.getNextLineStyle());
                    }
                    table.put(o, (Serializable)la);
                }
                encoder = new LineEncoder(dr, table);
                ((LineEncoder)encoder).styleArray = grouped ? graph.style.getGroupLineStyleList() : graph.style.lineStyleList;
                break;
            }
            case 6: {
                while (e.hasMoreElements()) {
                    Integer ms;
                    Object o = e.nextElement();
                    if (o == null) continue;
                    if (topLevels != null) {
                        String str = Overlay.getTopLevelValue((String)((String)o));
                        if (!topLevels.containsKey(str)) {
                            ms = QCLayoutOverlayParser.isMissing(str, false) ? new Integer(missingSymbol) : new Integer(grouped ? graph.style.getGroupNextMarkerSymbol() : graph.style.getNextMarkerSymbol());
                            topLevels.put(str, ms);
                        } else {
                            ms = (Integer)topLevels.get(str);
                        }
                    } else {
                        ms = QCLayoutOverlayParser.isMissing(o, numeric) ? new Integer(missingSymbol) : new Integer(grouped ? graph.style.getGroupNextMarkerSymbol() : graph.style.getNextMarkerSymbol());
                    }
                    table.put(o, ms);
                }
                encoder = new ShapeEncoder(dr, table);
                ((ShapeEncoder)encoder).shapeArray = grouped ? graph.style.getGroupMarkerSymbolList() : graph.style.markerSymbolList;
                break;
            }
            case 21: {
                while (e.hasMoreElements()) {
                    Integer fp;
                    Object o = e.nextElement();
                    if (o == null) continue;
                    if (topLevels != null) {
                        String str = Overlay.getTopLevelValue((String)((String)o));
                        if (!topLevels.containsKey(str)) {
                            fp = QCLayoutOverlayParser.isMissing(str, false) ? new Integer(missingFillPattern) : new Integer(grouped ? graph.style.getGroupNextFillPattern() : graph.style.getNextFillPattern());
                            topLevels.put(str, fp);
                        } else {
                            fp = (Integer)topLevels.get(str);
                        }
                    } else {
                        fp = QCLayoutOverlayParser.isMissing(o, numeric) ? new Integer(missingFillPattern) : new Integer(grouped ? graph.style.getGroupNextFillPattern() : graph.style.getNextFillPattern());
                    }
                    table.put(o, fp);
                }
                encoder = new FillPatternEncoder(dr, table);
                ((FillPatternEncoder)encoder).patternArray = grouped ? graph.style.getGroupFillPatternList() : graph.style.fillPatternList;
                break;
            }
            case 22: {
                while (e.hasMoreElements()) {
                    Color c;
                    Object o = e.nextElement();
                    if (o == null) continue;
                    if (topLevels != null) {
                        String str = Overlay.getTopLevelValue((String)((String)o));
                        if (!topLevels.containsKey(str)) {
                            c = QCLayoutOverlayParser.isMissing(str, false) ? missingContrastColor : (grouped ? graph.style.getGroupNextContrastColor() : graph.style.getNextContrastColor());
                            topLevels.put(str, c);
                        } else {
                            c = (Color)topLevels.get(str);
                        }
                    } else if (QCLayoutOverlayParser.isMissing(o, numeric)) {
                        c = missingContrastColor;
                    } else {
                        Color color = c = grouped ? graph.style.getGroupNextContrastColor() : graph.style.getNextContrastColor();
                    }
                    if (transparency >= 0.0) {
                        table.put(o, Overlay.applyTransparency((Color)c, (double)transparency));
                        continue;
                    }
                    table.put(o, overlay.applyDataTransparency(c));
                }
                encoder = new ColorEncoder(dr, table);
                encoder.colorArray = grouped ? graph.style.getGroupContrastColorList() : graph.style.contrastColorList;
            }
        }
        overlay.setEncoder(dim, encoder);
    }

    public static void setContinuousEncoder(StatGraph graph, Overlay overlay, byte dim) {
        DataRange range = overlay.getDataRange(dim);
        if (range instanceof ContinuousRange) {
            PositionEncoder encoder = new PositionEncoder((DataRange)((ContinuousRange)range));
            overlay.setEncoder(dim, (Encoder)encoder);
        }
    }

    public static boolean isIndexVarAssigned(CRD crd) {
        return crd.isAvailable(42) || crd.isAvailable(41) || crd.isAvailable(43) || crd.isAvailable(44);
    }

    public static void resolveReferences(Container container, Component oldComponent, Component[] newComponents) {
        OverlayContainer oc = null;
        String name = null;
        if (container instanceof OverlayContainer) {
            oc = (OverlayContainer)container;
        }
        Component[] components = container.getComponents();
        int index = -1;
        for (int i = 0; index < 0 && i < components.length; ++i) {
            if (!components[i].equals(oldComponent)) continue;
            index = i;
            if (oc == null) continue;
            name = oc.getLayoutComponentName(oldComponent);
        }
        container.remove(oldComponent);
        if (name != null) {
            oc.add(newComponents[newComponents.length - 1], index, name);
        } else {
            container.add(newComponents[newComponents.length - 1], index);
        }
    }

    public static boolean hasGraphElement(Element elem) {
        return QCLayoutOverlayParser.getFirstPlot(elem) != null;
    }

    public static String getFirstPlot(Element elem) {
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("QCBlockPlot")) {
                return elemTag;
            }
            if (elemTag.equals("QCPhaseBoxPlot")) {
                return elemTag;
            }
            if (elemTag.equals("QCBoxPlotParm") || elemTag.equals("BoxPlotParm")) {
                return elemTag;
            }
            if (elemTag.equals("QCLimitsPlot")) {
                return elemTag;
            }
            if (elemTag.equals("QCNeedlePlot") || elemTag.equals("NeedlePlot")) {
                return elemTag;
            }
            if (elemTag.equals("QCScatterPlot") || elemTag.equals("ScatterPlot")) {
                return elemTag;
            }
            if (elemTag.equals("QCSeriesPlot") || elemTag.equals("SeriesPlot")) {
                return elemTag;
            }
            if (!elemTag.equals("QCStarPlot")) continue;
            return elemTag;
        }
        return null;
    }

    public static void parseRoleTipStuff(Element elem, DataModel model, RoleColumnMap map, Overlay overlay) {
        String str;
        Element labelElem;
        Element formatElem;
        Element roleElem = StatGraph.getOptionAttrsElement((Element)elem, (String)"Roles");
        if (roleElem != null) {
            QCLayoutOverlayParser.parseRoleNames(roleElem, model, overlay);
        }
        if ((formatElem = StatGraph.getOptionAttrsElement((Element)elem, (String)"TipFormats")) != null) {
            QCLayoutOverlayParser.parseTipFormats(formatElem, overlay);
        }
        if ((labelElem = StatGraph.getOptionAttrsElement((Element)elem, (String)"TipLabels")) != null) {
            QCLayoutOverlayParser.parseTipLabels(labelElem, overlay);
        }
        if ((str = elem.getAttribute("tip")).length() > 0) {
            String[] tipRoles = StatGraph.parseList2String((String)str);
            int cnt = 0;
            HashMap<Integer, String> roleMap = new HashMap<Integer, String>();
            for (int i = 0; i < tipRoles.length; ++i) {
                ColumnMetadata cmd = overlay.getRoleMetadata(tipRoles[i].toUpperCase());
                if (cmd == null) continue;
                roleMap.put(300 + cnt, tipRoles[i]);
                String tipVarID = cmd.getName();
                int tipcol = model.getColumn(tipVarID);
                map.map(300 + cnt++, tipcol);
            }
            overlay.setTipRoleMap(roleMap);
        }
    }

    public static void parseRoleNames(Element elem, StatGraph graph, Overlay overlay) {
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            String varID;
            String name;
            String dataName;
            DataModel model;
            Element thisElem;
            if (!(node instanceof Element) || !(elemTag = (thisElem = (Element)node).getTagName()).equals("Role")) continue;
            String role = thisElem.getAttribute("name");
            Node child = thisElem.getFirstChild();
            if (child == null || !(model = graph.getData(dataName = StatGraph.getDataName((String)(name = child.getNodeValue())))).hasColumn(varID = StatGraph.getVarID((String)name))) continue;
            int col = model.getColumn(varID);
            overlay.addRole(role.toUpperCase(), model.getColumnLabel(col));
        }
    }

    public static void parseTipFormats(Element elem, Overlay overlay) {
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element thisElem;
            if (!(node instanceof Element) || !(elemTag = (thisElem = (Element)node).getTagName()).equals("TipFormat")) continue;
            String role = thisElem.getAttribute("name");
            Node child = thisElem.getFirstChild();
            if (child == null) continue;
            String format = child.getNodeValue();
            ColumnMetadata cmd = overlay.getRoleMetadata(role.toUpperCase());
            if (cmd == null) continue;
            cmd.setFormat(format);
        }
    }

    public static void parseTipLabels(Element elem, Overlay overlay) {
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            Element thisElem;
            if (!(node instanceof Element) || !(elemTag = (thisElem = (Element)node).getTagName()).equals("TipLabel")) continue;
            String role = thisElem.getAttribute("name");
            Node child = thisElem.getFirstChild();
            if (child == null) continue;
            String label = child.getNodeValue();
            ColumnMetadata cmd = overlay.getRoleMetadata(role.toUpperCase());
            if (cmd == null) continue;
            cmd.setLabel(label);
        }
    }

    public static Component createMessage() {
        RotatedJTextPane textPane = new RotatedJTextPane();
        textPane.setOpaque(false);
        textPane.setText("Required plot is invalid, all plots are removed.");
        return textPane;
    }

    public static void decideAxesType(StatGraph graph, Element elem, int[] rowColumnAxesType, int[] rowColumn2AxesType) {
        Node node;
        boolean overlay3D = elem.getTagName().equals("LayoutOverlay3D");
        boolean userSetXType = false;
        boolean userSetX2Type = overlay3D;
        boolean userSetYType = false;
        boolean userSetY2Type = overlay3D;
        boolean userSetZType = !overlay3D;
        String elemTag = "";
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            elemTag = ((Element)node).getTagName();
            if (elemTag.equals("XAxisOpts")) {
                userSetXType = QCLayoutOverlayParser.isUserSetAxisType((Element)node, "X");
                continue;
            }
            if (elemTag.equals("X2AxisOpts")) {
                userSetX2Type = QCLayoutOverlayParser.isUserSetAxisType((Element)node, "X2");
                continue;
            }
            if (elemTag.equals("YAxisOpts")) {
                userSetYType = QCLayoutOverlayParser.isUserSetAxisType((Element)node, "Y");
                continue;
            }
            if (elemTag.equals("Y2AxisOpts")) {
                userSetY2Type = QCLayoutOverlayParser.isUserSetAxisType((Element)node, "Y2");
                continue;
            }
            if (!elemTag.equals("ZAxisOpts")) continue;
            userSetZType = QCLayoutOverlayParser.isUserSetAxisType((Element)node, "Z");
        }
        if (rowColumnAxesType != null) {
            if (rowColumnAxesType[0] != -1) {
                userSetYType = true;
                yAxisType = rowColumnAxesType[0];
            }
            if (rowColumnAxesType[1] != -1) {
                userSetXType = true;
                xAxisType = rowColumnAxesType[1];
            }
        }
        if (rowColumn2AxesType != null) {
            if (rowColumn2AxesType[0] != -1) {
                userSetY2Type = true;
                y2AxisType = rowColumn2AxesType[0];
            }
            if (rowColumn2AxesType[1] != -1) {
                userSetX2Type = true;
                x2AxisType = rowColumn2AxesType[1];
            }
        }
        if (userSetXType && userSetX2Type && userSetYType && userSetY2Type && userSetZType) {
            return;
        }
        boolean[] defined = new boolean[]{userSetXType, userSetX2Type, userSetYType, userSetY2Type, userSetZType};
        for (node = elem.getLastChild(); node != null; node = node.getPreviousSibling()) {
            String str;
            if (!(node instanceof Element) || !QCLayoutOverlayParser.isPrimaryPlot((Element)node) || !(str = ((Element)node).getAttribute("primary")).equalsIgnoreCase("true")) continue;
            boolean x = false;
            boolean x2 = false;
            boolean y = false;
            boolean y2 = false;
            boolean z = false;
            str = ((Element)node).getAttribute("xAxis");
            if (str.equalsIgnoreCase("X2")) {
                if (!userSetX2Type) {
                    x2 = true;
                }
            } else if (!userSetXType) {
                x = true;
            }
            if ((str = ((Element)node).getAttribute("yAxis")).equalsIgnoreCase("Y2")) {
                if (!userSetY2Type) {
                    y2 = true;
                }
            } else if (!userSetYType) {
                y = true;
            }
            if (overlay3D && !userSetZType) {
                z = true;
            }
            QCLayoutOverlayParser.requiredAxesTypeByPlot(graph, (Element)node, x, x2, y, y2, z, defined);
            userSetXType = defined[0];
            userSetX2Type = defined[1];
            userSetYType = defined[2];
            userSetY2Type = defined[3];
            userSetZType = defined[4];
            if (!userSetXType || !userSetX2Type || !userSetYType || !userSetY2Type || !userSetZType) continue;
            return;
        }
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !QCLayoutOverlayParser.isPrimaryPlot((Element)node)) continue;
            boolean x = false;
            boolean x2 = false;
            boolean y = false;
            boolean y2 = false;
            boolean z = false;
            String str = ((Element)node).getAttribute("xAxis");
            if (str.equalsIgnoreCase("X2")) {
                if (!userSetX2Type) {
                    x2 = true;
                }
            } else if (!userSetXType) {
                x = true;
            }
            if ((str = ((Element)node).getAttribute("yAxis")).equalsIgnoreCase("Y2")) {
                if (!userSetY2Type) {
                    y2 = true;
                }
            } else if (!userSetYType) {
                y = true;
            }
            if (overlay3D && !userSetZType) {
                z = true;
            }
            QCLayoutOverlayParser.requiredAxesTypeByPlot(graph, (Element)node, x, x2, y, y2, z, defined);
            userSetXType = defined[0];
            userSetX2Type = defined[1];
            userSetYType = defined[2];
            userSetY2Type = defined[3];
            userSetZType = defined[4];
            if (!userSetXType || !userSetX2Type || !userSetYType || !userSetY2Type || !userSetZType) continue;
            return;
        }
    }

    private static void requiredAxesTypeByPlot(StatGraph graph, Element elem, boolean x, boolean x2, boolean y, boolean y2, boolean z, boolean[] defined) {
        int[] types;
        if (!(x || x2 || y || y2 || z)) {
            return;
        }
        String elemTag = elem.getTagName();
        if (elemTag.equals("SeriesPlot")) {
            int[] types2 = QCLayoutOverlayParser.getXYVariableTypes(graph, elem);
            if (types2 != null) {
                QCLayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types2, defined);
            }
        } else if (elemTag.equals("ScatterPlot")) {
            int[] types3 = QCLayoutOverlayParser.getXYVariableTypes(graph, elem);
            if (types3 != null) {
                QCLayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types3, defined);
            }
        } else if (elemTag.equals("QCLimitsPlot") && (types = QCLimitsParser.getVariableTypes(graph, elem)) != null) {
            QCLayoutOverlayParser.setAxisTypes(x, x2, y, y2, z, types, defined);
        }
    }

    private static int[] getXYVariableTypes(StatGraph graph, Element elem) {
        int[] types = new int[3];
        String str = elem.getAttribute("x");
        String dataName = StatGraph.getDataName((String)str);
        String xVarID = StatGraph.getVarID((String)str);
        str = elem.getAttribute("y");
        String yVarID = StatGraph.getVarID((String)str);
        DataModel model = graph.getData(dataName);
        int xcol = model.getColumn(xVarID);
        int ycol = model.getColumn(yVarID);
        ColumnMetadata cmd = (ColumnMetadata)model.getColumnLabel(xcol);
        if (cmd.getType() == 2) {
            if (QCLayoutOverlayParser.valueCountHasExceededMaximum(model, xVarID, graph.discreteMax)) {
                return null;
            }
            types[0] = 2;
        } else {
            types[0] = cmd.getFormat() instanceof SASDateTimeFormat ? 1 : 0;
        }
        cmd = (ColumnMetadata)model.getColumnLabel(ycol);
        if (cmd.getType() == 2) {
            return null;
        }
        if (cmd.getFormat() instanceof SASDateTimeFormat) {
            return null;
        }
        types[1] = 0;
        types[2] = 0;
        return types;
    }

    private static void setAxisTypes(boolean x, boolean x2, boolean y, boolean y2, boolean z, int[] types, boolean[] defined) {
        if (x) {
            xAxisType = types[0];
            defined[0] = true;
        }
        if (x2) {
            x2AxisType = types[0];
            defined[1] = true;
        }
        if (y) {
            yAxisType = types[1];
            defined[2] = true;
        }
        if (y2) {
            y2AxisType = types[1];
            defined[3] = true;
        }
        if (z) {
            zAxisType = types[2];
            defined[4] = true;
        }
    }

    private static boolean isPrimaryPlot(Element elem) {
        String elemTag = elem.getTagName();
        return elemTag.equals("ScatterPlot") || elemTag.equals("SeriesPlot") || elemTag.equals("StepPlot") || elemTag.equals("NeedlePlot") || elemTag.equals("VectorPlot") || elemTag.equals("BandPlot") || elemTag.equals("HistogramParm") || elemTag.equals("BarChartParm") || elemTag.equals("BarParm") || elemTag.equals("WaterfallChart") || elemTag.equals("Dendrogram") || elemTag.equals("BubblePlot") || elemTag.equals("ParetoLine") || elemTag.equals("HeatmapParm") || elemTag.equals("BoxPlotParm") || elemTag.equals("BoxParm") || elemTag.equals("HighLowParm") || elemTag.equals("ContourPlotParm") || elemTag.equals("ContourParm") || elemTag.equals("SurfacePlotParm") || elemTag.equals("SurfaceParm") || elemTag.equals("BiHistogram3DParm");
    }

    private static boolean isUserSetAxisType(Element elem, String which) {
        boolean userSet = false;
        int type = 0;
        String str = elem.getAttribute("type");
        if (str.equalsIgnoreCase("LINEAR")) {
            type = 0;
            userSet = true;
        } else if (str.equalsIgnoreCase("TIME")) {
            type = 1;
            userSet = true;
        } else if (str.equalsIgnoreCase("DISCRETE")) {
            type = 2;
            userSet = true;
        } else if (str.equalsIgnoreCase("LOG")) {
            type = 3;
            userSet = true;
            String elemTag = "";
            for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element) || !(elemTag = ((Element)node).getTagName()).equals("LogOpts")) continue;
                double base = -1.0;
                str = ((Element)node).getAttribute("base");
                if (StatGraph.isNumber((String)str)) {
                    base = Double.parseDouble(str);
                } else if (str.length() > 0 && str.equalsIgnoreCase("E")) {
                    base = Math.E;
                }
                if (base != 10.0 && base != 2.0 && base != Math.E) continue;
                if (which.equals("X")) {
                    logBaseX = base;
                    continue;
                }
                if (which.equals("X2")) {
                    logBaseX2 = base;
                    continue;
                }
                if (which.equals("Y")) {
                    logBaseY = base;
                    continue;
                }
                if (!which.equals("Y2")) continue;
                logBaseY2 = base;
            }
        }
        if (which.equals("X")) {
            xAxisType = type;
        } else if (which.equals("X2")) {
            x2AxisType = type;
        } else if (which.equals("Y")) {
            yAxisType = type;
        } else if (which.equals("Y2")) {
            y2AxisType = type;
        } else if (which.equals("Z")) {
            zAxisType = type;
        }
        return userSet;
    }

    public static void checkLocation(String loc) {
        if (loc.length() > 0 && !loc.equalsIgnoreCase("outside") && !loc.equalsIgnoreCase("inside")) {
            StatGraph.printOptionError((String)"LOCATION", (String)loc);
        }
    }

    public static void parseWallColor(StatGraph graph, Element elem, FillAttrs fillStyle) {
        GraphStyle.setDefaultFillStyle((StatGraph)graph, (String)"", (FillAttrs)fillStyle, (String)"WallFill");
        if (elem.hasAttribute("wallColor")) {
            Color wc = StatGraph.parseAttrColor((String)"wallColor", (StatGraph)graph, (Element)elem);
            if (wc != null) {
                fillStyle.setColor(wc);
            }
        }
    }

    public static String getLayoutName(Node node) {
        return node.getNodeName().substring(6).toUpperCase();
    }

    public static boolean hasTooManyGroups(StatGraph graph, DataModel model, String groupVarID) {
        if (QCLayoutOverlayParser.valueCountHasExceededMaximum(model, groupVarID, graph.groupMax)) {
            Message msg = new Message(RB.getStringResource((String)RB_KEY, (String)"group.fmt.txt"));
            StatGraph.printWarning((String)msg.toString((Object)groupVarID));
            return true;
        }
        return false;
    }

    public static boolean valueCountHasExceededMaximum(DataModel model, String varID, int maximum) {
        if (varID.length() <= 0) {
            return false;
        }
        int gcol = model.getColumn(varID);
        String[] values = model.getColumnAsClassColumn(gcol, true);
        StringVectorVariable var = new StringVectorVariable();
        var.connectFrom(values);
        int n = var.getUniqueValueCount();
        return n > maximum;
    }

    public static String getRoleValue(Element roleElement, String find) {
        if (roleElement == null) {
            return null;
        }
        String tagName = "";
        for (Node node = roleElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node child;
            String role;
            Element elem;
            if (!(node instanceof Element) || !(tagName = (elem = (Element)node).getTagName()).equals("Role") || !(role = elem.getAttribute("name")).equalsIgnoreCase(find) || (child = elem.getFirstChild()) == null) continue;
            String name = child.getNodeValue();
            return name;
        }
        return null;
    }

    public static String getRoleValueStartsWith(Element roleElement, String find) {
        if (roleElement == null) {
            return null;
        }
        String tagName = "";
        find = find.toUpperCase();
        for (Node node = roleElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node child;
            Element elem;
            if (!(node instanceof Element) || !(tagName = (elem = (Element)node).getTagName()).equals("Role")) continue;
            String role = elem.getAttribute("name");
            if (!(role = role.toUpperCase()).startsWith(find) || (child = elem.getFirstChild()) == null) continue;
            String name = child.getNodeValue();
            return name;
        }
        return null;
    }

    public static String getRoleDataName(Element roleElement, String find) {
        if (roleElement == null) {
            return null;
        }
        String tagName = "";
        for (Node node = roleElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node child;
            String role;
            Element elem;
            if (!(node instanceof Element) || !(tagName = (elem = (Element)node).getTagName()).equals("Role") || !(role = elem.getAttribute("name")).equalsIgnoreCase(find) || (child = elem.getFirstChild()) == null) continue;
            String name = child.getNodeValue();
            String dataName = StatGraph.getDataName((String)name);
            return dataName;
        }
        return null;
    }

    public static String getRoleColumn(Element roleElement, String find) {
        if (roleElement == null) {
            return null;
        }
        String tagName = "";
        for (Node node = roleElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node child;
            String role;
            Element elem;
            if (!(node instanceof Element) || !(tagName = (elem = (Element)node).getTagName()).equals("Role") || !(role = elem.getAttribute("name")).equalsIgnoreCase(find) || (child = elem.getFirstChild()) == null) continue;
            String name = child.getNodeValue();
            String dataName = StatGraph.getDataName((String)name);
            String varID = StatGraph.getVarID((String)name);
            return varID;
        }
        return null;
    }

    public static String getRoleColumnStartsWith(Element roleElement, String find) {
        if (roleElement == null) {
            return null;
        }
        String tagName = "";
        for (Node node = roleElement.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node child;
            String role;
            Element elem;
            if (!(node instanceof Element) || !(tagName = (elem = (Element)node).getTagName()).equals("Role") || !(role = elem.getAttribute("name")).startsWith(find) || (child = elem.getFirstChild()) == null) continue;
            String name = child.getNodeValue();
            String dataName = StatGraph.getDataName((String)name);
            String varID = StatGraph.getVarID((String)name);
            return varID;
        }
        return null;
    }

    public static void parseRoleNames(Element elem, DataModel model, Overlay overlay) {
        String elemTag = "";
        for (Node node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            String name;
            String varID;
            Element thisElem;
            if (!(node instanceof Element) || !(elemTag = (thisElem = (Element)node).getTagName()).equals("Role")) continue;
            String role = thisElem.getAttribute("name");
            Node child = thisElem.getFirstChild();
            if (child == null || !model.hasColumn(varID = StatGraph.getVarID((String)(name = child.getNodeValue())))) continue;
            int col = model.getColumn(varID);
            if (!model.hasColumn(varID)) continue;
            overlay.addRole(role.toUpperCase(), model.getColumnLabel(col));
        }
    }
}

