/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph;

import com.sas.analytics.qc.statgraph.QCLayoutOverlayParser;
import com.sas.analytics.qc.statgraph.QCParserUtils;
import com.sas.analytics.qc.statgraph.QCShewhart;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCBlockOverlay;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.LayoutOverlayParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.FillAttrs;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.data.CRD;
import com.sas.graphics.applets.statgraph.sgchart.data.DataModel;
import com.sas.graphics.applets.statgraph.sgchart.data.RoleColumnMap;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.silk.xml.parsers.ParserUtils;
import com.sas.graphics.util.gtk.TextStyle;
import org.w3c.dom.Element;

public final class QCBlockParser {
    public static final String RB_KEY = "QCBlockParser.";

    public static QCBlockOverlay load(StatGraph graph, Element elem) {
        QCBlockOverlay block = (QCBlockOverlay)((Object)graph.getObjectFromElement(elem));
        if (block == null) {
            block = new QCBlockOverlay();
        }
        return QCBlockParser.load(graph, block, elem) ? block : null;
    }

    public static boolean load(StatGraph graph, QCBlockOverlay plot, Element e) {
        Element _internal;
        Element roleElement;
        LayoutOverlayParser.parseGraphOpts((StatGraph)graph, (Element)e, (Overlay)plot);
        String dataName = StatGraph.getDataName((String)e.getAttribute("xStart"));
        DataModel m = graph.getData(dataName);
        if (m == null) {
            return false;
        }
        RoleColumnMap map = new RoleColumnMap();
        String var = e.getAttribute("xStart");
        String varID = StatGraph.getVarID((String)var);
        int col = m.getColumn(varID);
        Object cmd = m.getColumnLabel(col);
        if (!StatGraph.checkVariable((String)"XSTART", (Object)cmd, null, (int)1, (boolean)true)) {
            graph.removeNamedGraph((Overlay)plot);
            return false;
        }
        map.map(754, col);
        plot.addRole("XSTART", cmd);
        var = e.getAttribute("xEnd");
        varID = StatGraph.getVarID((String)var);
        col = m.getColumn(varID);
        cmd = m.getColumnLabel(col);
        if (!StatGraph.checkVariable((String)"XEND", (Object)cmd, null, (int)1, (boolean)true)) {
            graph.removeNamedGraph((Overlay)plot);
            return false;
        }
        map.map(755, col);
        plot.addRole("XEND", cmd);
        var = e.getAttribute("blockIndex");
        boolean valid = StatGraph.isValidVar((String)var);
        if (valid) {
            varID = StatGraph.getVarID((String)var);
            col = m.getColumn(varID);
            cmd = m.getColumnLabel(col);
            if (!StatGraph.checkVariable((String)"BLOCKINDEX", (Object)cmd, null, (int)1, (boolean)true)) {
                graph.removeNamedGraph((Overlay)plot);
                return false;
            }
            map.map(757, col);
            plot.addRole("BLOCKINDEX", cmd);
        }
        if (valid = StatGraph.isValidVar((String)(var = e.getAttribute("blockValue")))) {
            varID = StatGraph.getVarID((String)var);
            col = m.getColumn(varID);
            cmd = m.getColumnLabel(col);
            if (!StatGraph.checkVariable((String)"BLOCKVALUE", (Object)cmd, null, (int)1, (boolean)true)) {
                graph.removeNamedGraph((Overlay)plot);
                return false;
            }
        } else {
            graph.removeNamedGraph((Overlay)plot);
            return false;
        }
        map.map(758, col);
        plot.addRole("BLOCKVALUE", cmd);
        map.map(5, col);
        plot.addRole("BLOCK", cmd);
        var = e.getAttribute("class");
        valid = StatGraph.isValidVar((String)var);
        boolean classVar = false;
        if (valid) {
            varID = StatGraph.getVarID((String)var);
            col = m.getColumn(varID);
            cmd = m.getColumnLabel(col);
            if (!StatGraph.checkVariable((String)"BLOCKLABEL", (Object)cmd, null, (int)1, (boolean)true)) {
                graph.removeNamedGraph((Overlay)plot);
                return false;
            }
            map.map(759, col);
            plot.addRole("BLOCKLABEL", cmd);
            map.map(3, col);
            plot.addRole("GROUP", cmd);
            classVar = true;
        }
        if ((roleElement = StatGraph.getOptionAttrsElement((Element)e, (String)"Roles")) != null) {
            String index;
            String phase;
            QCLayoutOverlayParser.parseRoleNames(roleElement, m, (Overlay)plot);
            var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_PHASELIMITS");
            if (m.hasColumn(var)) {
                col = m.getColumn(var);
                cmd = m.getColumnLabel(col);
                map.map(768, col);
                plot.addRole("PHASELIMITS", cmd);
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_PHASEUCL"))) {
                col = m.getColumn(var);
                cmd = m.getColumnLabel(col);
                if (var.equalsIgnoreCase("PHASEUCL1")) {
                    map.map(771, col);
                    plot.addRole("PHASE_UCL1", cmd);
                } else if (var.equalsIgnoreCase("PHASEUCL2")) {
                    map.map(774, col);
                    plot.addRole("PHASE_UCL2", cmd);
                }
            } else {
                var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_PHASEUCL1");
                if (m.hasColumn(var)) {
                    col = m.getColumn(var);
                    cmd = m.getColumnLabel(col);
                    map.map(771, col);
                    plot.addRole("PHASE_UCL1", cmd);
                }
                if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_PHASEUCL2"))) {
                    col = m.getColumn(var);
                    cmd = m.getColumnLabel(col);
                    map.map(774, col);
                    plot.addRole("PHASE_UCL2", cmd);
                }
            }
            var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_PHASECTL");
            if (m.hasColumn(var)) {
                col = m.getColumn(var);
                cmd = m.getColumnLabel(col);
                if (var.equalsIgnoreCase("PHASECTL1")) {
                    map.map(772, col);
                    plot.addRole("PHASE_CTL1", cmd);
                } else if (var.equalsIgnoreCase("PHASECTL2")) {
                    map.map(775, col);
                    plot.addRole("PHASE_CTL2", cmd);
                }
            } else {
                var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_PHASECTL1");
                if (m.hasColumn(var)) {
                    col = m.getColumn(var);
                    cmd = m.getColumnLabel(col);
                    map.map(772, col);
                    plot.addRole("PHASE_CTL1", cmd);
                }
                if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_PHASECTL2"))) {
                    col = m.getColumn(var);
                    cmd = m.getColumnLabel(col);
                    map.map(775, col);
                    plot.addRole("PHASE_CTL2", cmd);
                }
            }
            var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_PHASELCL");
            if (m.hasColumn(var)) {
                col = m.getColumn(var);
                cmd = m.getColumnLabel(col);
                if (var.equalsIgnoreCase("PHASELCL1")) {
                    map.map(773, col);
                    plot.addRole("PHASE_LCL1", cmd);
                } else if (var.equalsIgnoreCase("PHASELCL2")) {
                    map.map(776, col);
                    plot.addRole("PHASE_LCL2", cmd);
                }
            } else {
                var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_PHASELCL1");
                if (m.hasColumn(var)) {
                    col = m.getColumn(var);
                    cmd = m.getColumnLabel(col);
                    map.map(773, col);
                    plot.addRole("PHASE_LCL1", cmd);
                }
                if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_PHASELCL2"))) {
                    col = m.getColumn(var);
                    cmd = m.getColumnLabel(col);
                    map.map(776, col);
                    plot.addRole("PHASE_LCL2", cmd);
                }
            }
            var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_ALTLABEL");
            if (m.hasColumn(var)) {
                col = m.getColumn(var);
                cmd = m.getColumnLabel(col);
                map.map(760, col);
                plot.addRole("BLOCKALTLABEL", cmd);
            }
            if (m.hasColumn(var = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_FILLINDEX"))) {
                col = m.getColumn(var);
                cmd = m.getColumnLabel(col);
                map.map(6, col);
                map.map(761, col);
                plot.addRole("BLOCKFILLINDEX", cmd);
            }
            String name = QCLayoutOverlayParser.getRoleValue(roleElement, "INTERNAL_SUBGRP");
            dataName = StatGraph.getDataName((String)name);
            DataModel m2 = graph.getData(dataName);
            QCLayoutOverlayParser.parseRoleNames(roleElement, m2, (Overlay)plot);
            if (m2 != null) {
                RoleColumnMap map2 = new RoleColumnMap();
                var = StatGraph.getVarID((String)name);
                if (m2.hasColumn(var)) {
                    col = m2.getColumn(var);
                    cmd = m2.getColumnLabel(col);
                    map2.map(10, col);
                    plot.addRole("X", cmd);
                }
                CRD crd2 = new CRD();
                crd2.setSrcModel(m2);
                crd2.setSrcMap(map2);
                LayoutOverlayParser.parseWhere((StatGraph)graph, (CRD)crd2, (Overlay)plot);
                plot.setSubgrpModel(crd2);
            }
            if ((name = QCLayoutOverlayParser.getRoleValueStartsWith(roleElement, "INTERNAL_VREF")) != null && (m2 = graph.getData(dataName = StatGraph.getDataName((String)name))) != null) {
                QCLayoutOverlayParser.parseRoleNames(roleElement, m2, (Overlay)plot);
                phase = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_VREF_PHASE");
                index = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_VREF_INDEX");
                plot.setVRefPhaseVar(phase);
                plot.setVRefIndexVar(index);
            }
            if ((name = QCLayoutOverlayParser.getRoleValueStartsWith(roleElement, "INTERNAL_SREF")) != null && (m2 = graph.getData(dataName = StatGraph.getDataName((String)name))) != null) {
                QCLayoutOverlayParser.parseRoleNames(roleElement, m2, (Overlay)plot);
                phase = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_SREF_PHASE");
                index = QCLayoutOverlayParser.getRoleColumn(roleElement, "INTERNAL_SREF_INDEX");
                plot.setSRefPhaseVar(phase);
                plot.setSRefIndexVar(index);
            }
        }
        if (!QCBlockParser.loadInternal(graph, plot, _internal = ParserUtils.getChildWithTagName((String)"_internal", (Element)e))) {
            // empty if block
        }
        QCBlockOverlay.BlockType type = plot.getBlockType();
        boolean outline = false;
        boolean fill = false;
        boolean values = false;
        boolean label = false;
        String str = QCParserUtils.getString("display", e);
        if (str.length() == 0) {
            plot.setLegend(false);
        } else if (str.equalsIgnoreCase("standard") || str.equalsIgnoreCase("all")) {
            outline = true;
            fill = true;
            values = true;
            label = true;
        } else {
            String[] opts = StatGraph.parseList2String((String)str);
            for (int i = 0; i < opts.length; ++i) {
                str = opts[i];
                if (str.equalsIgnoreCase("outline")) {
                    outline = true;
                    continue;
                }
                if (str.equalsIgnoreCase("fill")) {
                    fill = true;
                    continue;
                }
                if (str.equalsIgnoreCase("values")) {
                    values = true;
                    continue;
                }
                if (!str.equalsIgnoreCase("label") || !classVar) continue;
                label = true;
            }
        }
        plot.setRefLine(outline);
        plot.setRefFill(fill);
        plot.setLabels(label);
        plot.setLegend(values);
        if (values && type == QCBlockOverlay.BlockType.PHASE) {
            QCShewhart.setPhaseLegend(true);
        }
        plot.setLegendPosition(QCBlockOverlay.LegendPosition.NONE);
        plot.setRepeat(false);
        plot.setRefLineType(1);
        int i = QCParserUtils.getInteger("fitType", e);
        QCBlockOverlay.LabelFit fitType = QCBlockOverlay.LabelFit.fromInteger(i, QCBlockOverlay.LabelFit.TRUNCATED);
        plot.setFitType(fitType);
        if (label) {
            str = QCParserUtils.getString("labelPosition", e);
            QCBlockOverlay.LabelPosition labelPosition = QCBlockOverlay.LabelPosition.fromString(str, QCBlockOverlay.LabelPosition.ABOVE);
            plot.setLabelPosition(labelPosition);
        } else {
            plot.setLabelPosition(QCBlockOverlay.LabelPosition.NONE);
        }
        str = QCParserUtils.getString("fillType", e, "multicolor");
        plot.setBlockFillType(str);
        double d = QCParserUtils.getDouble("dataTransparency", e, 0.8);
        plot.setBlockFillTransparency(d);
        plot.setLegendFill(true);
        plot.setFrame(true);
        plot.setVFrame(true);
        plot.setHFrame(true);
        String contextName = graph.style.getContextName();
        plot.setContextName(contextName);
        TextStyle uni = new TextStyle();
        GraphStyle.setDefaultTextStyle((StatGraph)graph, null, (TextStyle)uni, (String)"UnicodeText");
        plot.setUnicodeLabelStyle(uni);
        FillAttrs fs = plot.getWallAttrs();
        GraphStyle.setDefaultFillStyle((StatGraph)graph, (String)e.getAttribute("wallAttrs"), (FillAttrs)fs, (String)"WallFill");
        Element e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"WallAttrs");
        if (e2 != null) {
            StatGraph.parseFillAttrs((StatGraph)graph, (Element)e2, (FillAttrs)fs);
        }
        fs = plot.getBackgroundAttrs();
        GraphStyle.setDefaultFillStyle((StatGraph)graph, (String)e.getAttribute("backgroundAttrs"), (FillAttrs)fs, (String)"Backfill");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"BackgroundAttrs");
        if (e2 != null) {
            StatGraph.parseFillAttrs((StatGraph)graph, (Element)e2, (FillAttrs)fs);
        }
        LineAttrs ls = plot.getBorderAttrs();
        GraphStyle.setDefaultDataLineStyle((StatGraph)graph, (String)e.getAttribute("axisAttrs"), (LineAttrs)ls, (String)"AxisLines");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"AxisAttrs");
        if (e2 != null) {
            StatGraph.parseLineAttrs((StatGraph)graph, (Element)e2, (LineAttrs)ls);
        }
        TextStyle ts = plot.getTextStyle();
        GraphStyle.setDefaultTextStyle((StatGraph)graph, (String)e.getAttribute("valueAttrs"), (TextStyle)ts, (String)"ValueText");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"ValueAttrs");
        if (e2 != null) {
            StatGraph.parseTextAttrs((StatGraph)graph, (Element)e2, (TextStyle)ts);
        }
        ts = plot.getLabelStyle();
        GraphStyle.setDefaultTextStyle((StatGraph)graph, (String)e.getAttribute("labelAttrs"), (TextStyle)ts, (String)"ValueText");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"LabelAttrs");
        if (e2 != null) {
            StatGraph.parseTextAttrs((StatGraph)graph, (Element)e2, (TextStyle)ts);
        }
        fs = plot.getBlockAttrs();
        GraphStyle.setDefaultFillStyle((StatGraph)graph, (String)e.getAttribute("fillAttrs"), (FillAttrs)fs, (String)"Block");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"FillAttrs");
        if (e2 != null) {
            StatGraph.parseFillAttrs((StatGraph)graph, (Element)e2, (FillAttrs)fs);
            plot.setRefFillOpacity(fs.getTransparency());
        }
        fs = plot.getAltBlockAttrs();
        GraphStyle.setDefaultFillStyle((StatGraph)graph, (String)e.getAttribute("altFillAttrs"), (FillAttrs)fs, (String)"AltBlock");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"AltFillAttrs");
        if (e2 != null) {
            StatGraph.parseFillAttrs((StatGraph)graph, (Element)e2, (FillAttrs)fs);
        }
        fs = plot.getHeaderAttrs();
        GraphStyle.setDefaultFillStyle((StatGraph)graph, (String)e.getAttribute("labelFillAttrs"), (FillAttrs)fs, (String)"BlockHeader");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"LabelFillAttrs");
        if (e2 != null) {
            StatGraph.parseFillAttrs((StatGraph)graph, (Element)e2, (FillAttrs)fs);
        }
        ls = plot.getRefLineAttrs();
        GraphStyle.setDefaultLineStyle((StatGraph)graph, null, (LineAttrs)ls, (String)"Reference");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"ReferenceLineAttrs");
        if (e2 != null) {
            StatGraph.parseLineAttrs((StatGraph)graph, (Element)e2, (LineAttrs)ls);
        }
        fs = plot.getRefFillAttrs();
        GraphStyle.setDefaultFillStyle((StatGraph)graph, null, (FillAttrs)fs, (String)"GraphDataStyleDefault");
        e2 = StatGraph.getOptionAttrsElement((Element)e, (String)"DataDefaultAttrs");
        if (e2 != null) {
            StatGraph.parseFillAttrs((StatGraph)graph, (Element)e2, (FillAttrs)fs);
        }
        LineAttrs grid = new LineAttrs();
        GraphStyle.setDefaultLineStyle((StatGraph)graph, null, (LineAttrs)grid, (String)"GridLines");
        fs = plot.getAltRefFillAttrs();
        fs.setColor(grid.getColor());
        CRD crd = new CRD();
        crd.setSrcModel(m);
        crd.setSrcMap(map);
        LayoutOverlayParser.parseWhere((StatGraph)graph, (CRD)crd, (Overlay)plot);
        plot.setModel(crd);
        graph.style.recordCurrentCounters();
        int contextCount = graph.style.getContextCount();
        if (crd.isAvailable(6)) {
            graph.style.setContextCount(contextCount);
            QCLayoutOverlayParser.setDiscreteEncoder(graph, (Overlay)plot, (byte)4, plot.getBlockAttrs().getTransparency());
        }
        if (LayoutOverlayParser.isIndexVarAssigned((CRD)crd)) {
            graph.style.setContextCount(contextCount);
        }
        graph.style.resetToCurrentCounters();
        return true;
    }

    static boolean loadInternal(StatGraph graph, QCBlockOverlay plot, Element _internal) {
        if (_internal == null) {
            return false;
        }
        boolean debug = QCParserUtils.getBoolean("debug", _internal, false);
        boolean rotate = QCParserUtils.getBoolean("rotate", _internal, false);
        int i = QCParserUtils.getInteger("context", _internal);
        QCBlockOverlay.BlockType type = QCBlockOverlay.BlockType.fromInteger(i, QCBlockOverlay.BlockType.BLOCK);
        plot.setBlockType(type);
        plot.setPhaseBoxResponse(false);
        i = QCParserUtils.getInteger("yPad", _internal, 1);
        i = graph.scaleLineThickness(i);
        plot.setHeightPadding(i);
        boolean b = QCParserUtils.getBoolean("border", _internal, true);
        plot.setLegendOutline(b);
        return true;
    }
}

