/*
 * Decompiled with CFR 0.152.
 */
package com.sas.analytics.qc.statgraph;

import com.sas.analytics.qc.statgraph.QCBlockParser;
import com.sas.analytics.qc.statgraph.QCBoxParmParser;
import com.sas.analytics.qc.statgraph.QCLayoutInternalParser;
import com.sas.analytics.qc.statgraph.QCLayoutOverlayParser;
import com.sas.analytics.qc.statgraph.QCLimitsParser;
import com.sas.analytics.qc.statgraph.QCNeedleParser;
import com.sas.analytics.qc.statgraph.QCParserUtils;
import com.sas.analytics.qc.statgraph.QCPhaseBoxParser;
import com.sas.analytics.qc.statgraph.QCReferenceLineParser;
import com.sas.analytics.qc.statgraph.QCScatterParser;
import com.sas.analytics.qc.statgraph.QCSeriesParser;
import com.sas.analytics.qc.statgraph.QCShewhart;
import com.sas.analytics.qc.statgraph.QCShewhartChart;
import com.sas.analytics.qc.statgraph.QCStarParser;
import com.sas.analytics.qc.statgraph.QCVaryLineParser;
import com.sas.analytics.qc.statgraph.sgchart.composite.QCSimple2DOverlayComposite;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCBlockOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCBoxParmOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCLayoutInternalOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCLimitsOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCNeedleOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCPhaseBoxOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCReferenceLineOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCScatterOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCSeriesOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCStarOverlay;
import com.sas.analytics.qc.statgraph.sgchart.overlays.QCVaryLineOverlay;
import com.sas.graphics.anno.AbstractAnno;
import com.sas.graphics.anno.AnnotationContainer;
import com.sas.graphics.applets.statgraph.AnnotateParser;
import com.sas.graphics.applets.statgraph.AxisLegendParser;
import com.sas.graphics.applets.statgraph.BoxParser;
import com.sas.graphics.applets.statgraph.EntryConcatParser;
import com.sas.graphics.applets.statgraph.GraphComponentParser;
import com.sas.graphics.applets.statgraph.GraphStyle;
import com.sas.graphics.applets.statgraph.GridPanelParser;
import com.sas.graphics.applets.statgraph.LayoutDataLatticeParser;
import com.sas.graphics.applets.statgraph.LayoutLatticeParser;
import com.sas.graphics.applets.statgraph.LayoutOverlay3DParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayEquatedParser;
import com.sas.graphics.applets.statgraph.LayoutOverlayMapParser;
import com.sas.graphics.applets.statgraph.LayoutRegionParser;
import com.sas.graphics.applets.statgraph.LegendParser;
import com.sas.graphics.applets.statgraph.NeedleParser;
import com.sas.graphics.applets.statgraph.ReferenceLineParser;
import com.sas.graphics.applets.statgraph.ScatterParser;
import com.sas.graphics.applets.statgraph.SeriesParser;
import com.sas.graphics.applets.statgraph.StatGraph;
import com.sas.graphics.applets.statgraph.sgchart.attrs.LineAttrs;
import com.sas.graphics.applets.statgraph.sgchart.axis.VRectAxis;
import com.sas.graphics.applets.statgraph.sgchart.composite.BaseOverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.EntryComposite;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayContainer;
import com.sas.graphics.applets.statgraph.sgchart.composite.OverlayInnerMargin;
import com.sas.graphics.applets.statgraph.sgchart.entry.AxisLegend;
import com.sas.graphics.applets.statgraph.sgchart.entry.GridPanel;
import com.sas.graphics.applets.statgraph.sgchart.entry.Legend;
import com.sas.graphics.applets.statgraph.sgchart.legend.LegendComponent;
import com.sas.graphics.applets.statgraph.sgchart.overlays.BoxOverlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.Overlay;
import com.sas.graphics.applets.statgraph.sgchart.overlays.ReferenceLineOverlay;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.JComponent;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class LayoutQCOverlayParser {
    public static JComponent load(StatGraph graph, Element elem) {
        Component msg;
        QCType type;
        boolean ok;
        Node node;
        if (!QCLayoutOverlayParser.hasGraphElement(elem)) {
            return QCLayoutOverlayParser.loadNonGraphs(graph, elem);
        }
        graph.style.resetCounters();
        QCLayoutInternalOverlay qcInternal = LayoutQCOverlayParser.initializeQCEnvironment(graph, elem);
        String str = elem.getAttribute("cycleAttrs");
        if (str.length() > 0 && str.equalsIgnoreCase("true")) {
            graph.style.setCycleAttrs(true);
        } else {
            graph.style.setCycleAttrs(false);
        }
        OverlayContainer oc = (OverlayContainer)graph.getObjectFromElement(elem);
        if (oc == null) {
            oc = QCLayoutOverlayParser.initComposite(graph, elem);
        }
        GraphComponentParser.load((StatGraph)graph, (Element)elem, (JComponent)oc, null);
        StatGraph.parseBorderOpts((StatGraph)graph, (JComponent)oc, (Element)elem, null);
        QCSimple2DOverlayComposite soc = (QCSimple2DOverlayComposite)oc.getComposite();
        QCShewhartChart chart = soc.getChart();
        QCShewhart.addChart(chart, true);
        if (!elem.getNodeName().equals("LayoutPrototype")) {
            str = elem.getAttribute("aspectRatio");
            if (StatGraph.isNumber((String)str)) {
                soc.setAspectRatio(Double.parseDouble(str));
            } else {
                soc.setAspectRatio(-1.0);
            }
        }
        VRectAxis xAxis = new VRectAxis(1, false);
        VRectAxis yAxis = new VRectAxis(2, false);
        QCLayoutOverlayParser.initAxis(graph, xAxis);
        QCLayoutOverlayParser.initAxis(graph, yAxis);
        QCLayoutOverlayParser.decideAxesType(graph, elem, null, null);
        ArrayList plots = new ArrayList();
        boolean useQCBox = QCShewhart.useQCBoxPlotParm;
        boolean useQCNeedle = QCShewhart.useQCNeedlePlot;
        boolean useQCScatter = QCShewhart.useQCScatterPlot;
        boolean useQCSeries = QCShewhart.useQCSeriesPlot;
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            ok = true;
            type = LayoutQCOverlayParser.getOverlayType((Element)node);
            switch (type) {
                case O_QCBOXPARMPLOT: {
                    if (useQCBox) {
                        QCBoxParmOverlay qcBox = QCBoxParmParser.load(graph, (Element)node);
                        ok = QCLayoutOverlayParser.addPlotToList(plots, qcBox, graph, true);
                        if (!ok) break;
                        chart.addResponseOverlay(qcBox);
                        break;
                    }
                    BoxOverlay overlay = BoxParser.load((StatGraph)graph, (Element)((Element)node));
                    ok = QCLayoutOverlayParser.addPlotToList(plots, (Overlay)overlay, graph, true);
                    break;
                }
                case O_QCNEEDLEPLOT: {
                    if (useQCNeedle) {
                        QCNeedleOverlay qcNeedle = QCNeedleParser.load(graph, (Element)node);
                        ok = QCLayoutOverlayParser.addPlotToList(plots, qcNeedle, graph, true);
                        if (!ok) break;
                        chart.addResponseOverlay(qcNeedle);
                        break;
                    }
                    BoxOverlay overlay = NeedleParser.load((StatGraph)graph, (Element)((Element)node));
                    ok = QCLayoutOverlayParser.addPlotToList(plots, (Overlay)overlay, graph, true);
                    break;
                }
                case O_QCSCATTERPLOT: {
                    boolean markerScaling;
                    if (useQCScatter) {
                        QCScatterOverlay qcScatter = QCScatterParser.load(graph, (Element)node);
                        ok = QCLayoutOverlayParser.addPlotToList(plots, qcScatter, graph, markerScaling = qcScatter.getScaleMarkers());
                        if (!ok) break;
                        chart.addResponseOverlay(qcScatter);
                        break;
                    }
                    BoxOverlay overlay = ScatterParser.load((StatGraph)graph, (Element)((Element)node));
                    ok = QCLayoutOverlayParser.addPlotToList(plots, (Overlay)overlay, graph, true);
                    break;
                }
                case O_QCSERIESPLOT: {
                    boolean markerScaling;
                    if (useQCSeries) {
                        QCSeriesOverlay qcSeries = QCSeriesParser.load(graph, (Element)node, 1);
                        ok = QCLayoutOverlayParser.addPlotToList(plots, qcSeries, graph, markerScaling = qcSeries.getScaleMarkers());
                        if (!ok) break;
                        chart.addResponseOverlay(qcSeries);
                        break;
                    }
                    BoxOverlay overlay = SeriesParser.load((StatGraph)graph, (Element)((Element)node), (int)1);
                    ok = QCLayoutOverlayParser.addPlotToList(plots, (Overlay)overlay, graph, true);
                    break;
                }
                case O_QCSTARPLOT: {
                    QCStarOverlay qcStar = QCStarParser.load(graph, (Element)node);
                    ok = QCLayoutOverlayParser.addPlotToList(plots, qcStar);
                    if (!ok) break;
                    chart.addResponseOverlay(qcStar);
                    break;
                }
            }
            if (ok || (str = ((Element)node).getAttribute("required")).length() <= 0 || !str.equalsIgnoreCase("true")) continue;
            oc.removeAll();
            msg = QCLayoutOverlayParser.createMessage();
            oc.add(msg);
            return oc;
        }
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            ok = true;
            type = LayoutQCOverlayParser.getOverlayType((Element)node);
            switch (type) {
                case O_QCBLOCKPLOT: {
                    QCBlockOverlay qcBlock = QCBlockParser.load(graph, (Element)node);
                    ok = QCLayoutOverlayParser.addPlotToList(plots, qcBlock);
                    if (!ok) break;
                    chart.addBlockOverlay(qcBlock);
                    break;
                }
                case O_QCPHASEBOXPLOT: {
                    QCPhaseBoxOverlay qcPhaseBox = QCPhaseBoxParser.load(graph, (Element)node);
                    ok = QCLayoutOverlayParser.addPlotToList(plots, qcPhaseBox);
                    if (!ok) break;
                    chart.addPhaseBoxOverlay(qcPhaseBox);
                    break;
                }
                case O_QCLIMITSPLOT: {
                    QCLimitsOverlay qcLimits = QCLimitsParser.load(graph, (Element)node);
                    ok = QCLayoutOverlayParser.addPlotToList(plots, qcLimits);
                    if (!ok) break;
                    chart.addLimitsOverlay(qcLimits);
                    break;
                }
            }
            if (ok || (str = ((Element)node).getAttribute("required")).length() <= 0 || !str.equalsIgnoreCase("true")) continue;
            oc.removeAll();
            msg = QCLayoutOverlayParser.createMessage();
            oc.add(msg);
            return oc;
        }
        QCBlockOverlay refOverlay = chart.getRefOverlay(QCBlockOverlay.BlockType.PHASEREF);
        for (node = elem.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element)) continue;
            ok = true;
            type = LayoutQCOverlayParser.getOverlayType((Element)node);
            switch (type) {
                case O_QCREFERENCELINE: {
                    QCReferenceLineOverlay qcref = QCReferenceLineParser.load(graph, (Element)node, 1, refOverlay);
                    ok = QCLayoutOverlayParser.addPlotToList(plots, qcref);
                    if (!ok) break;
                    chart.addQCOverlay(qcref);
                    break;
                }
                case O_REFERENCELINE: {
                    ReferenceLineOverlay ref = ReferenceLineParser.load((StatGraph)graph, (Element)((Element)node), (int)1);
                    ok = QCLayoutOverlayParser.addPlotToList(plots, (Overlay)ref);
                    break;
                }
                case O_QCVARYLINE: {
                    QCVaryLineOverlay qcVaryLine = QCVaryLineParser.load(graph, (Element)node);
                    ok = QCLayoutOverlayParser.addPlotToList(plots, qcVaryLine);
                    if (!ok) break;
                    chart.addQCOverlay(qcVaryLine);
                    break;
                }
                case O_INNERMARGIN: {
                    String loc = ((Element)node).getAttribute("align");
                    int just = 2;
                    if (loc.length() > 0 && loc.equalsIgnoreCase("top")) {
                        just = 1;
                    } else if (loc.length() > 0 && loc.equalsIgnoreCase("left")) {
                        just = 3;
                    } else if (loc.length() > 0 && loc.equalsIgnoreCase("right")) {
                        just = 4;
                    }
                    OverlayInnerMargin oim = new OverlayInnerMargin(just);
                    String str2 = ((Element)node).getAttribute("opaque");
                    if (str2.length() > 0 && str2.equalsIgnoreCase("true")) {
                        Color c;
                        oim.setOpaque(true);
                        if (((Element)node).hasAttribute("backgroundColor") && (c = StatGraph.parseAttrColor((String)"backgroundColor", (StatGraph)graph, (Element)((Element)node))) != null) {
                            oim.setBackground(c);
                        }
                    }
                    if ((str2 = ((Element)node).getAttribute("separator")).length() > 0 && str2.equalsIgnoreCase("true")) {
                        oim.setSeparatorOn(true);
                        GraphStyle.setDefaultLineStyle((StatGraph)graph, (String)((Element)node).getAttribute("separatorAttrs"), (LineAttrs)oim.getSeparatorAttrs(), (String)"AxisLines");
                    }
                    if ((str2 = ((Element)node).getAttribute("gutter")).length() > 0 && StatGraph.isLineThickness((String)str2)) {
                        oim.setGutter(graph.unit2GapThickness(str2));
                    }
                    if ((str2 = ((Element)node).getAttribute("pad")).length() > 0 && StatGraph.isLineThickness((String)str2)) {
                        int pad = graph.unit2GapThickness(str2);
                        oim.setPad(pad, pad, pad, pad);
                    } else {
                        Element padAttrs = StatGraph.getOptionAttrsElement((Element)((Element)node), (String)"PadAttrs");
                        if (padAttrs != null) {
                            int top = -1;
                            int left = -1;
                            int bottom = -1;
                            int right = -1;
                            str = padAttrs.getAttribute("top");
                            if (StatGraph.isLineThickness((String)str)) {
                                top = graph.unit2GapThickness(str);
                            }
                            if (StatGraph.isLineThickness((String)(str = padAttrs.getAttribute("left")))) {
                                left = graph.unit2GapThickness(str);
                            }
                            if (StatGraph.isLineThickness((String)(str = padAttrs.getAttribute("bottom")))) {
                                bottom = graph.unit2GapThickness(str);
                            }
                            if (StatGraph.isLineThickness((String)(str = padAttrs.getAttribute("right")))) {
                                right = graph.unit2GapThickness(str);
                            }
                            oim.setPad(top, left, bottom, right);
                        }
                    }
                    Element elem2 = (Element)node;
                    for (Node node2 = elem2.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                        if (!(node2 instanceof Element)) continue;
                        String elemTag = ((Element)node2).getTagName();
                        if (elemTag.equals("QCBlockPlot")) {
                            QCBlockOverlay qcBlock = QCBlockParser.load(graph, (Element)node2);
                            ok = QCLayoutOverlayParser.addPlotToList(plots, qcBlock);
                            if (!ok) continue;
                            qcBlock.setOverlayJustification(just);
                            chart.addBlockOverlay(qcBlock);
                            oim.addOverlay((Overlay)qcBlock);
                            continue;
                        }
                        if (elemTag.equals("SeparatorAttrs")) {
                            if (!oim.isSeparatorOn()) continue;
                            StatGraph.parseLineAttrs((StatGraph)graph, (Element)((Element)node2), (LineAttrs)oim.getSeparatorAttrs());
                            continue;
                        }
                        if (elemTag.equals("PadAttrs")) continue;
                        StatGraph.printDebug((String)"Unsupported plot for inner margin.");
                    }
                    if (oim.getOverlays().size() <= 0) break;
                    soc.addOverlayInnerMargin(oim);
                    break;
                }
                case O_ENTRY: {
                    JComponent entry = (JComponent)graph.getObjectFromElement((Element)node);
                    if (entry == null) {
                        entry = new EntryComposite();
                    }
                    EntryConcatParser.load((StatGraph)graph, (Element)((Element)node), (JComponent)entry, (JComponent)oc, (int)0);
                    String loc = ((Element)node).getAttribute("location");
                    QCLayoutOverlayParser.checkLocation(loc);
                    if (loc.equalsIgnoreCase("outside")) {
                        if (entry.getAlignmentX() == 0.5f && entry.getAlignmentY() == 0.5f) {
                            entry.setAlignmentY(0.0f);
                        }
                        oc.addSidebar((Component)entry);
                        break;
                    }
                    oc.add((Component)entry, 0);
                    break;
                }
                case O_DISCRETELEGEND: 
                case O_MERGEDLEGEND: {
                    Legend discreteLegend = (Legend)graph.getObjectFromElement((Element)node);
                    if (discreteLegend == null) {
                        discreteLegend = new Legend();
                    }
                    LegendParser.load((StatGraph)graph, (Element)((Element)node), (JComponent)discreteLegend, (JComponent)oc);
                    String loc = ((Element)node).getAttribute("location");
                    QCLayoutOverlayParser.checkLocation(loc);
                    if (loc.equalsIgnoreCase("inside")) {
                        oc.add((Component)discreteLegend, 0);
                        break;
                    }
                    if (discreteLegend.getAlignmentX() == 0.5f && discreteLegend.getAlignmentY() == 0.5f) {
                        discreteLegend.setAlignmentY(1.0f);
                    }
                    oc.addLegend((Component)discreteLegend);
                    break;
                }
                case O_AXISLEGEND: {
                    AxisLegend axisLegend = (AxisLegend)graph.getObjectFromElement((Element)node);
                    if (axisLegend == null) {
                        axisLegend = new AxisLegend();
                    }
                    AxisLegendParser.load((StatGraph)graph, (Element)((Element)node), (JComponent)axisLegend, (JComponent)oc);
                    String loc = ((Element)node).getAttribute("location");
                    QCLayoutOverlayParser.checkLocation(loc);
                    if (loc.equalsIgnoreCase("inside")) {
                        oc.add((Component)axisLegend, 0);
                        break;
                    }
                    if (axisLegend.getAlignmentX() == 0.5f && axisLegend.getAlignmentY() == 0.5f) {
                        axisLegend.setAlignmentY(1.0f);
                    }
                    oc.addLegend((Component)axisLegend);
                    break;
                }
                case O_CONTINUOUSLEGEND: {
                    LegendComponent continuousLegend = (LegendComponent)graph.getObjectFromElement((Element)node);
                    if (continuousLegend == null) {
                        continuousLegend = new LegendComponent();
                    }
                    LegendParser.load((StatGraph)graph, (Element)((Element)node), (JComponent)continuousLegend, (JComponent)oc);
                    String loc = ((Element)node).getAttribute("location");
                    QCLayoutOverlayParser.checkLocation(loc);
                    if (loc.equalsIgnoreCase("inside")) {
                        oc.add((Component)continuousLegend, 0);
                        break;
                    }
                    if (continuousLegend.getAlignmentX() == 0.5f && continuousLegend.getAlignmentY() == 0.5f) {
                        continuousLegend.setAlignmentX(1.0f);
                    }
                    if (continuousLegend.getAlignmentY() == 0.0f || continuousLegend.getAlignmentY() == 1.0f) {
                        continuousLegend.setHorizontal(true);
                    }
                    oc.addLegend((Component)continuousLegend);
                    break;
                }
                case O_DRAW: {
                    AbstractAnno text = AnnotateParser.load((StatGraph)graph, (Element)((Element)node), (AnnotationContainer)oc);
                    if (text == null) break;
                    if ("back".equalsIgnoreCase(((Element)node).getAttribute("layer"))) {
                        graph.annotationInBackList.add(text);
                        break;
                    }
                    graph.annotationInFrontList.add(text);
                    break;
                }
                case O_LAYOUTGRIDDED: {
                    GridPanel grid = (GridPanel)graph.getObjectFromElement((Element)node);
                    if (grid == null) {
                        grid = new GridPanel();
                    }
                    GridPanelParser.load((StatGraph)graph, (Element)((Element)node), (JComponent)grid, (JComponent)oc);
                    String loc = ((Element)node).getAttribute("location");
                    QCLayoutOverlayParser.checkLocation(loc);
                    if (loc.equalsIgnoreCase("outside")) {
                        if (grid.getAlignmentX() == 0.5f && grid.getAlignmentY() == 0.5f) {
                            grid.setAlignmentY(1.0f);
                        }
                        oc.addSidebar((Component)grid);
                        break;
                    }
                    oc.add((Component)grid, 0);
                    break;
                }
                case O_LAYOUTOVERLAY: {
                    boolean server = graph.server;
                    graph.server = true;
                    BaseOverlayContainer overlayContainer = (BaseOverlayContainer)QCLayoutOverlayParser.load(graph, (Element)node);
                    graph.server = server;
                    oc.add((Component)overlayContainer, 0);
                    overlayContainer.setPreferredSize(overlayContainer.getMinimumSize());
                    break;
                }
                case O_LAYOUTOVERLAYEQUATED: {
                    boolean server = graph.server;
                    graph.server = true;
                    BaseOverlayContainer overlayContainer = (BaseOverlayContainer)LayoutOverlayEquatedParser.load((StatGraph)graph, (Element)((Element)node));
                    graph.server = server;
                    oc.add((Component)overlayContainer, 0);
                    overlayContainer.setPreferredSize(overlayContainer.getMinimumSize());
                    break;
                }
                case O_LAYOUTOVERLAYMAP: {
                    boolean server = graph.server;
                    graph.server = true;
                    BaseOverlayContainer overlayContainer = (BaseOverlayContainer)LayoutOverlayMapParser.load((StatGraph)graph, (Element)((Element)node));
                    graph.server = server;
                    oc.add((Component)overlayContainer, 0);
                    overlayContainer.setPreferredSize(overlayContainer.getMinimumSize());
                    break;
                }
                case O_LAYOUTQCOVERLAY: {
                    boolean server = graph.server;
                    graph.server = true;
                    JComponent qcOverlayContainer = LayoutQCOverlayParser.load(graph, (Element)node);
                    graph.server = server;
                    oc.add((Component)qcOverlayContainer, 0);
                    ((Component)qcOverlayContainer).setPreferredSize(((Component)qcOverlayContainer).getMinimumSize());
                    break;
                }
                case O_LAYOUTOVERLAY3D: {
                    boolean server = graph.server;
                    graph.server = true;
                    BaseOverlayContainer overlayContainer = (BaseOverlayContainer)LayoutOverlay3DParser.load((StatGraph)graph, (Element)((Element)node));
                    graph.server = server;
                    oc.add((Component)overlayContainer, 0);
                    overlayContainer.setPreferredSize(overlayContainer.getMinimumSize());
                    break;
                }
                case O_LAYOUTLATTICE: {
                    oc.add((Component)LayoutLatticeParser.load((StatGraph)graph, (Element)((Element)node)), 0);
                    break;
                }
                case O_LAYOUTDATALATTICE: {
                    oc.add((Component)LayoutDataLatticeParser.load((StatGraph)graph, (Element)((Element)node)), 0);
                    break;
                }
                case O_LAYOUTDATAPANEL: {
                    oc.add((Component)LayoutDataLatticeParser.load((StatGraph)graph, (Element)((Element)node), (boolean)true), 0);
                    break;
                }
                case O_LAYOUTREGION: {
                    oc.add((Component)LayoutRegionParser.load((StatGraph)graph, (Element)((Element)node)), 0);
                    break;
                }
            }
            if (ok || (str = ((Element)node).getAttribute("required")).length() <= 0 || !str.equalsIgnoreCase("true")) continue;
            oc.removeAll();
            Component msg2 = QCLayoutOverlayParser.createMessage();
            oc.add(msg2);
            return oc;
        }
        String select = QCShewhart.select;
        for (int i = 0; i < plots.size(); ++i) {
            Object o = plots.get(i);
            if (o == null || !(o instanceof QCOverlay)) continue;
            QCOverlay qc = (QCOverlay)((Object)o);
            qc.setSelect(select);
            qc.createPhaseIndexVar(refOverlay);
        }
        chart.initializeLimits();
        if (plots.size() > 0) {
            QCLayoutOverlayParser.setAutomaticAxisTypes(plots, true, xAxis, null, yAxis, null, null);
        }
        QCLayoutOverlayParser.parseAxisOptsList(graph, soc, elem, xAxis, null, yAxis, null, null);
        QCLayoutOverlayParser.parsePointLabelOpts(graph, soc, elem);
        for (int i = 0; i < plots.size(); ++i) {
            Overlay plot = (Overlay)plots.get(i);
            if (QCLayoutOverlayParser.isCompatibleOverlay(graph, plot)) {
                QCLayoutOverlayParser.addOverlay(plot, soc, xAxis, null, yAxis, null, null);
                continue;
            }
            graph.removeNamedGraph(plot);
        }
        str = graph.style.getStyleAttribute("GridLines", "displayOpts");
        if (str != null && str.equalsIgnoreCase("on")) {
            if (StatGraph.getOptionAttrsElement((Element)elem, (String)"XAxisOpts") == null) {
                QCLayoutOverlayParser.addAutoGridLine(graph, xAxis, soc);
            }
            if (StatGraph.getOptionAttrsElement((Element)elem, (String)"YAxisOpts") == null) {
                QCLayoutOverlayParser.addAutoGridLine(graph, yAxis, soc);
            }
        }
        ArrayList overlays = soc.getOverlays();
        int parmPlotCnt = 0;
        for (int i = 0; i < overlays.size(); ++i) {
            Overlay o = (Overlay)overlays.get(i);
            if (!(o instanceof ReferenceLineOverlay)) continue;
            ++parmPlotCnt;
        }
        if (parmPlotCnt > 0 && parmPlotCnt == overlays.size()) {
            oc.removeAll();
        }
        if (!xAxis.isVisible() && !yAxis.isVisible()) {
            soc.setAxesVisible(false);
        }
        return oc;
    }

    private static QCLayoutInternalOverlay initializeQCEnvironment(StatGraph graph, Element e) {
        QCLayoutInternalOverlay qcInternal = null;
        for (Node node = e.getFirstChild(); node != null; node = node.getNextSibling()) {
            String elemTag;
            QCType type;
            if (!(node instanceof Element) || (type = LayoutQCOverlayParser.getOverlayType(elemTag = ((Element)node).getTagName())) != QCType.O_LAYOUTQCOVERLAY_INTERNAL) continue;
            qcInternal = QCLayoutInternalParser.load(graph, (Element)node);
            break;
        }
        if (qcInternal == null) {
            StatGraph.printError((String)"The <QCInternalLayout> xml tagset is required.");
            StatGraph.printNote((String)"Please add this tagset to the <LayoutQCOverlay> tagset.");
        } else {
            QCShewhart.reset();
            QCShewhart.set(qcInternal);
            QCShewhart.setStatGraph(graph);
        }
        return qcInternal;
    }

    private static QCType getOverlayType(String tag) {
        if (tag.equals("LayoutQCOverlay_Internal")) {
            return QCType.O_LAYOUTQCOVERLAY_INTERNAL;
        }
        if (tag.equals("QCBlockPlot")) {
            return QCType.O_QCBLOCKPLOT;
        }
        if (tag.equals("QCPhaseBoxPlot")) {
            return QCType.O_QCPHASEBOXPLOT;
        }
        if (tag.equals("QCBoxPlotParm")) {
            return QCType.O_QCBOXPARMPLOT;
        }
        if (tag.equals("QCLimitsPlot")) {
            return QCType.O_QCLIMITSPLOT;
        }
        if (tag.equals("QCNeedlePlot")) {
            return QCType.O_QCNEEDLEPLOT;
        }
        if (tag.equals("QCScatterPlot")) {
            return QCType.O_QCSCATTERPLOT;
        }
        if (tag.equals("QCSeriesPlot")) {
            return QCType.O_QCSERIESPLOT;
        }
        if (tag.equals("QCStarPlot")) {
            return QCType.O_QCSTARPLOT;
        }
        if (tag.equals("QCVaryLinePlot")) {
            return QCType.O_QCVARYLINE;
        }
        if (tag.equals("QCReferenceLine")) {
            return QCType.O_QCREFERENCELINE;
        }
        if (tag.equals("InnerMargin")) {
            return QCType.O_INNERMARGIN;
        }
        if (tag.equals("ReferenceLine")) {
            return QCType.O_REFERENCELINE;
        }
        if (tag.equals("Entry")) {
            return QCType.O_ENTRY;
        }
        if (tag.equals("DiscreteLegend")) {
            return QCType.O_DISCRETELEGEND;
        }
        if (tag.equals("MergedLegend")) {
            return QCType.O_MERGEDLEGEND;
        }
        if (tag.equals("AxisLegend")) {
            return QCType.O_AXISLEGEND;
        }
        if (tag.equals("ContinuousLegend")) {
            return QCType.O_CONTINUOUSLEGEND;
        }
        if (tag.equals("Draw")) {
            return QCType.O_DRAW;
        }
        if (tag.equals("LayoutGridded")) {
            return QCType.O_LAYOUTGRIDDED;
        }
        if (tag.equals("LayoutOverlay")) {
            return QCType.O_LAYOUTOVERLAY;
        }
        if (tag.equals("LayoutOverlayEquated")) {
            return QCType.O_LAYOUTOVERLAYEQUATED;
        }
        if (tag.equals("LayoutOverlayMap")) {
            return QCType.O_LAYOUTOVERLAYMAP;
        }
        if (tag.equals("LayoutQCOverlay")) {
            return QCType.O_LAYOUTQCOVERLAY;
        }
        if (tag.equals("LayoutOverlay3D")) {
            return QCType.O_LAYOUTOVERLAY3D;
        }
        if (tag.equals("LayoutLattice")) {
            return QCType.O_LAYOUTLATTICE;
        }
        if (tag.equals("LayoutDataLattice")) {
            return QCType.O_LAYOUTDATALATTICE;
        }
        if (tag.equals("LayoutDataPanel")) {
            return QCType.O_LAYOUTDATAPANEL;
        }
        if (tag.equals("LayoutRegion")) {
            return QCType.O_LAYOUTREGION;
        }
        return QCType.O_INVALID;
    }

    private static QCType getOverlayType(Element e) {
        String tag = e.getTagName();
        QCType type = LayoutQCOverlayParser.getOverlayType(tag);
        QCOverlay.QCResponseContext context = QCParserUtils.getResponseContext(e);
        String str = context.toString();
        switch (type) {
            case O_QCSERIESPLOT: {
                if (context != QCOverlay.QCResponseContext.VARYREF) break;
                type = QCType.O_QCVARYLINE;
                break;
            }
            case O_REFERENCELINE: {
                type = QCType.O_QCREFERENCELINE;
                break;
            }
        }
        return type;
    }

    public static void parsingDone() {
    }

    private static enum QCType {
        O_LAYOUTQCOVERLAY_INTERNAL,
        O_QCBLOCKPLOT,
        O_QCPHASEBOXPLOT,
        O_QCBOXPARMPLOT,
        O_QCLIMITSPLOT,
        O_QCNEEDLEPLOT,
        O_QCSCATTERPLOT,
        O_QCSERIESPLOT,
        O_QCSTARPLOT,
        O_QCVARYLINE,
        O_QCREFERENCELINE,
        O_REFERENCELINE,
        O_INNERMARGIN,
        O_ENTRY,
        O_DISCRETELEGEND,
        O_MERGEDLEGEND,
        O_AXISLEGEND,
        O_CONTINUOUSLEGEND,
        O_DRAW,
        O_LAYOUTGRIDDED,
        O_LAYOUTOVERLAY,
        O_LAYOUTOVERLAYEQUATED,
        O_LAYOUTOVERLAYMAP,
        O_LAYOUTQCOVERLAY,
        O_LAYOUTOVERLAY3D,
        O_LAYOUTLATTICE,
        O_LAYOUTDATALATTICE,
        O_LAYOUTDATAPANEL,
        O_LAYOUTREGION,
        O_INVALID;

    }
}

