/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.codepolicy.SASScope;
import com.sas.util.ColorNames;
import com.sas.util.transforms.RB;
import com.sas.util.transforms.TransformInputOutputInterface;
import java.awt.Color;
import java.util.NoSuchElementException;

@SASScope
public class StringToColorTransform2
implements TransformInputOutputInterface {
    static final String RB_KEY = "StringToColorTransform2.";
    static final long serialVersionUID = -6338082646826508490L;
    public static final StringToColorTransform2 defaultInstance = new StringToColorTransform2();
    protected static ColorNames colorNames = null;

    @Override
    public Object transform(Object input) {
        return this.transform((String)input, true);
    }

    public Color transform(String input, boolean searchSystemColors) {
        Color color;
        if (input == null) {
            return null;
        }
        if (input.length() == 0) {
            return null;
        }
        colorNames = new ColorNames(searchSystemColors);
        try {
            color = colorNames.getColor(input);
            int rgb = color.getRGB();
            color = new Color(rgb);
        }
        catch (NoSuchElementException e) {
            color = StringToColorTransform2.newColor(input);
            int rgb = color.getRGB();
            color = new Color(rgb);
        }
        return color;
    }

    public static Color newColor(String name) {
        int tempNameLength;
        String tempName = name;
        if (name.startsWith("0x") || name.startsWith("cx")) {
            tempName = name.substring(2, name.length());
        }
        if ((tempNameLength = tempName.length()) > 8) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "illegal.ex.txt"));
        }
        if (tempNameLength > 6) {
            tempName = tempName.substring(tempNameLength - 6, tempNameLength);
        }
        try {
            return new Color(Integer.parseInt(tempName, 16));
        }
        catch (NumberFormatException ne) {
            throw new IllegalArgumentException(RB.getStringResource(RB_KEY, "illegal.ex.txt"));
        }
    }

    @Override
    public Class getInputClass() {
        return String.class;
    }

    @Override
    public Class getOutputClass() {
        return Color.class;
    }
}

