/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.transforms;

import com.sas.ComponentException;
import com.sas.beans.Introspector;
import com.sas.text.Message;
import com.sas.util.transforms.IdentityTransform;
import com.sas.util.transforms.RB;
import com.sas.util.transforms.TransformException;
import com.sas.util.transforms.TransformInterface;
import java.beans.BeanInfo;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class BaseTransforms {
    public static final String RB_KEY = "BaseTransforms.";
    public static BaseTransforms defaultInstance = new BaseTransforms();
    protected boolean defaultTransformsRegistered;
    protected Class registryConfigRelativeClass;
    protected String registryConfigName;
    protected Object[][] primitiveClassNamesMap = new Object[][]{{"byte", Byte.TYPE}, {"char", Character.TYPE}, {"int", Integer.TYPE}, {"short", Short.TYPE}, {"long", Long.TYPE}, {"float", Float.TYPE}, {"double", Double.TYPE}, {"boolean", Boolean.TYPE}, {"java.lang.String[]", String[].class}};
    protected Hashtable inputClasses = new Hashtable();

    public BaseTransforms() {
        this(BaseTransforms.class, "BaseTransformRegistry.config");
    }

    public BaseTransforms(Class registryConfigRelativeClass, String registryConfigName) {
        this.registryConfigRelativeClass = registryConfigRelativeClass;
        this.registryConfigName = registryConfigName;
    }

    public void registerTransforms(Properties properties) {
        int transformCount;
        String number = properties.getProperty("Transforms.count");
        try {
            transformCount = Integer.parseInt(number);
        }
        catch (NumberFormatException nfe) {
            throw new IllegalStateException(nfe.getMessage());
        }
        try {
            for (int i = 1; i <= transformCount; ++i) {
                String registryInfo = properties.getProperty("transform" + i);
                int sourceCommaIndex = registryInfo.indexOf(",");
                if (sourceCommaIndex != -1) {
                    String sourceClassName = registryInfo.substring(0, sourceCommaIndex).trim();
                    int targetCommaIndex = (registryInfo = registryInfo.substring(sourceCommaIndex + 1)).indexOf(",");
                    if (targetCommaIndex != -1) {
                        String targetClassName = registryInfo.substring(0, targetCommaIndex).trim();
                        String transformClassName = registryInfo.substring(targetCommaIndex + 1).trim();
                        try {
                            Class sourceClass = this.forName(sourceClassName);
                            Class targetClass = this.forName(targetClassName);
                            Class transformClass = this.forName(transformClassName);
                            TransformInterface transform = (TransformInterface)transformClass.newInstance();
                            this.registerTransform(sourceClass, targetClass, transform);
                            continue;
                        }
                        catch (IllegalArgumentException iarge) {
                            throw new ComponentException(Message.format(RB.getStringResource(RB_KEY, "errorLoadingClass.fmt.txt"), (Object)iarge.getMessage()));
                        }
                        catch (ClassNotFoundException cnfe) {
                            throw new ComponentException(Message.format(RB.getStringResource(RB_KEY, "errorLoadingClass.fmt.txt"), (Object)cnfe.getMessage()));
                        }
                        catch (IllegalAccessException iae) {
                            throw new ComponentException(Message.format(RB.getStringResource(RB_KEY, "errorInstantiatingClass.fmt.txt"), (Object)iae.getMessage()));
                        }
                        catch (InstantiationException ie) {
                            throw new ComponentException(Message.format(RB.getStringResource(RB_KEY, "errorInstantiatingClass.fmt.txt"), (Object)ie.getMessage()));
                        }
                    }
                    throw new IllegalStateException(Message.format(RB.getStringResource(RB_KEY, "invalidTransformFormat.fmt.txt"), (Object)new Integer(i)));
                }
                throw new IllegalStateException(Message.format(RB.getStringResource(RB_KEY, "invalidTransformFormat.fmt.txt"), (Object)new Integer(i)));
            }
        }
        catch (StringIndexOutOfBoundsException sioobe) {
            throw new IllegalStateException(Message.format(RB.getStringResource(RB_KEY, "invalidTransformFormat.fmt.txt"), (Object)sioobe.getMessage()));
        }
    }

    protected void registerDefaultTransforms() {
        if (this.defaultTransformsRegistered) {
            return;
        }
        this.defaultTransformsRegistered = true;
        Properties properties = new Properties();
        try {
            properties.load(this.registryConfigRelativeClass.getResourceAsStream(this.registryConfigName));
        }
        catch (IOException ioe) {
            throw new IllegalArgumentException(ioe.getMessage());
        }
        this.registerTransforms(properties);
    }

    protected Class forName(String name) throws ClassNotFoundException {
        for (int i = 0; i < this.primitiveClassNamesMap.length; ++i) {
            if (!name.equals(this.primitiveClassNamesMap[i][0])) continue;
            return (Class)this.primitiveClassNamesMap[i][1];
        }
        return Class.forName(name);
    }

    public void registerTransform(Class inputClass, Class outputClass, TransformInterface converterClass) {
        this.registerDefaultTransforms();
        if (this.inputClasses.containsKey(inputClass)) {
            Hashtable outputClasses = (Hashtable)this.inputClasses.get(inputClass);
            outputClasses.put(outputClass, converterClass);
        } else {
            Hashtable<Class, TransformInterface> outputClasses = new Hashtable<Class, TransformInterface>();
            outputClasses.put(outputClass, converterClass);
            this.inputClasses.put(inputClass, outputClasses);
        }
    }

    public void unregisterTransform(Class inputClass, Class outputClass, TransformInterface converterClass) {
        Hashtable outputClasses;
        this.registerDefaultTransforms();
        if (this.inputClasses.containsKey(inputClass) && (outputClasses = (Hashtable)this.inputClasses.get(inputClass)).containsKey(outputClass)) {
            outputClasses.remove(outputClass);
        }
    }

    private boolean isTrivialTransform(Class inputClass, Class outputClass) {
        return inputClass == outputClass || outputClass == Object.class || outputClass.isAssignableFrom(inputClass);
    }

    public boolean isTransformable(Class inputClass, Class outputClass) {
        if (this.isTrivialTransform(inputClass, outputClass)) {
            return true;
        }
        return this.lookupTransform(inputClass, outputClass) != null;
    }

    public TransformInterface lookupTransform(Class inputClass, Class outputClass) {
        if (this.isTrivialTransform(inputClass, outputClass)) {
            return IdentityTransform.identityTransform;
        }
        this.registerDefaultTransforms();
        while (inputClass != null) {
            Hashtable outputClasses;
            if (this.inputClasses.containsKey(inputClass) && (outputClasses = (Hashtable)this.inputClasses.get(inputClass)) != null && outputClasses.containsKey(outputClass)) {
                Object outputClassNameOrObject = outputClasses.get(outputClass);
                if (outputClassNameOrObject instanceof TransformInterface) {
                    return (TransformInterface)outputClassNameOrObject;
                }
                if (outputClassNameOrObject instanceof String) {
                    try {
                        Class<?> transformClass = Class.forName((String)outputClassNameOrObject);
                        TransformInterface transform = (TransformInterface)transformClass.newInstance();
                        return transform;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            inputClass = inputClass.getSuperclass();
        }
        return null;
    }

    public TransformInterface[] getRegisteredTransforms() {
        this.registerDefaultTransforms();
        Vector<TransformInterface> transformNames = new Vector<TransformInterface>();
        Enumeration inputEnum = this.inputClasses.keys();
        while (inputEnum.hasMoreElements()) {
            Class inputClass = (Class)inputEnum.nextElement();
            Hashtable outputClasses = (Hashtable)this.inputClasses.get(inputClass);
            Enumeration outputEnum = outputClasses.keys();
            while (outputEnum.hasMoreElements()) {
                Class outputClass = (Class)outputEnum.nextElement();
                TransformInterface transform = (TransformInterface)outputClasses.get(outputClass);
                if (transformNames.contains(transform)) continue;
                transformNames.addElement(transform);
            }
        }
        Object[] transformArray = new TransformInterface[transformNames.size()];
        transformNames.copyInto(transformArray);
        return transformArray;
    }

    public boolean isTransformable(Object source, String sourceProperty, Object target, String targetProperty) {
        Class<?> sourceType = null;
        Class<?> targetType = null;
        PropertyDescriptor targetPropertyDescriptor = null;
        try {
            BeanInfo sourceBeanInfo = Introspector.getBeanInfo(source.getClass());
            PropertyDescriptor sourcePropertyDescriptor = Introspector.getPropertyDescriptor(sourceProperty, sourceBeanInfo);
            if (sourcePropertyDescriptor == null) {
                throw new ComponentException(Message.format(RB.getStringResource(RB_KEY, "propertyDescSource.fmt.txt"), (Object)"Transforms::isTransformable()", (Object)sourceProperty));
            }
            sourceType = sourcePropertyDescriptor.getPropertyType();
            BeanInfo targetBeanInfo = Introspector.getBeanInfo(target.getClass());
            targetPropertyDescriptor = Introspector.getPropertyDescriptor(targetProperty, targetBeanInfo);
            if (targetPropertyDescriptor == null) {
                String error = Message.format(RB.getStringResource(RB_KEY, "propertyDescTarget.fmt.txt"), (Object)"Transforms::isTransformable()", (Object)targetProperty);
                System.out.println(error);
                throw new ComponentException(error);
            }
            targetType = targetPropertyDescriptor.getPropertyType();
            if (sourcePropertyDescriptor.getReadMethod() == null || targetPropertyDescriptor.getWriteMethod() == null) {
                return false;
            }
        }
        catch (Exception e) {
            System.out.println(Message.format(RB.getStringResource(RB_KEY, "propertyInfo.fmt.txt"), (Object)"Transforms::isTransformable()", (Object)e.toString()));
            e.printStackTrace();
        }
        if (!this.isTrivialTransform(sourceType, targetType)) {
            TransformInterface converterInstance = this.lookupTransform(sourceType, targetType);
            if (converterInstance == null) {
                converterInstance = this.lookupTransform(Object.class, targetType);
                return converterInstance != null;
            }
            return true;
        }
        return true;
    }

    public Object transform(Object value, Class targetType) throws TransformException {
        TransformInterface transform = this.lookupTransform(value.getClass(), targetType);
        if (transform != null) {
            return transform.transform(value);
        }
        throw new TransformException(Message.format(RB.getStringResource(RB_KEY, "unableToTransform.fmt.txt"), (Object)targetType.getClass().getName()));
    }
}

