/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util.log;

import com.sas.util.log.CommonLoggerInterface;
import java.text.MessageFormat;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Logger;

public abstract class AbstractLoggerAdapter
implements CommonLoggerInterface {
    private final Logger logger;

    public AbstractLoggerAdapter(Logger logger) {
        if (logger == null) {
            throw new IllegalArgumentException("logger cannot be null");
        }
        this.logger = logger;
    }

    @Override
    public void debug(String message) {
        this.logger.debug(message);
    }

    @Override
    public final void debug(String message1, String message2) {
        if (this.isDebugEnabled()) {
            String message = message1 + " " + message2;
            this.debug(message);
        }
    }

    @Override
    public void debug(String message, Throwable t) {
        this.logger.debug(message, t);
    }

    @Override
    public void error(String message) {
        this.logger.error(message);
    }

    @Override
    public final void error(String pattern, String message) {
        if (this.isErrorEnabled()) {
            String formattedMessage = this.formatMessage(pattern, message);
            this.error(formattedMessage);
        }
    }

    @Override
    public final void error(String pattern, String message, Throwable t) {
        if (this.isErrorEnabled()) {
            String formattedMessage = this.formatMessage(pattern, message);
            this.error(formattedMessage, t);
        }
    }

    @Override
    public void error(String message, Throwable t) {
        this.logger.error(message, t);
    }

    @Override
    public void fatal(String message) {
        this.logger.error(message);
    }

    @Override
    public void fatal(String message, Throwable t) {
        this.logger.fatal(message, t);
    }

    @Override
    public void info(String message) {
        this.logger.info(message);
    }

    @Override
    public final void info(String pattern, String message) {
        if (this.isInfoEnabled()) {
            String formattedMessage = this.formatMessage(pattern, message);
            this.info(formattedMessage);
        }
    }

    @Override
    public void info(String message, Throwable t) {
        this.logger.info(message, t);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.logger.isDebugEnabled();
    }

    @Override
    public boolean isErrorEnabled() {
        return this.logger.isErrorEnabled();
    }

    @Override
    public boolean isInfoEnabled() {
        return this.logger.isInfoEnabled();
    }

    @Override
    public boolean isWarnEnabled() {
        return this.logger.isWarnEnabled();
    }

    @Override
    public void warn(String message) {
        this.logger.warn(message);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.logger.warn(message, t);
    }

    @Override
    public final void warn(String pattern, String message) {
        if (this.isWarnEnabled()) {
            String formattedMessage = this.formatMessage(pattern, message);
            this.warn(formattedMessage);
        }
    }

    @Override
    public final void warn(String pattern, String message, Throwable t) {
        if (this.isWarnEnabled()) {
            String formattedMessage = this.formatMessage(pattern, message);
            this.warn(formattedMessage, t);
        }
    }

    protected void log(Level level, String message) {
        this.logger.log(level, message);
    }

    protected abstract boolean isEnabledFor(Level var1);

    private String formatMessage(String pattern, String message) {
        return pattern != null ? MessageFormat.format(pattern, message) : null;
    }
}

