/*
 * Decompiled with CFR 0.152.
 */
package com.sas.util;

import com.sas.beans.ExtendedBeanInfo;
import com.sas.codepolicy.SASScope;
import com.sas.util.RB;
import java.awt.Color;
import java.awt.SystemColor;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;

@SASScope
public class ColorNames {
    protected boolean showSystemColors = true;
    private Map map;
    static final String RB_KEY = "ColorNames.";

    public static ExtendedBeanInfo getExtendedBeanInfo() {
        String[][][] propertyMetadata = new String[][][]{};
        ExtendedBeanInfo ebi = new ExtendedBeanInfo();
        ebi.propertyMetadata = propertyMetadata;
        return ebi;
    }

    public ColorNames() {
        this(true, true);
    }

    public ColorNames(boolean showSystemColors) {
        this(true, showSystemColors);
    }

    public ColorNames(boolean showColors, boolean showSystemColors) {
        this.map = new HashMap();
        if (showColors) {
            this.setColorNameList();
        }
        this.showSystemColors = showSystemColors;
        if (showSystemColors) {
            this.setSystemColorList();
        }
    }

    public ColorNames(Enumeration e) {
        while (e.hasMoreElements()) {
            this.add((Color)e.nextElement());
        }
    }

    public void add(String name, int hexValue) {
        Color c = new Color(hexValue);
        if (!this.map.containsKey(c)) {
            this.map.put(c, name.toLowerCase());
        }
    }

    public void add(String name, Color c) {
        if (!this.map.containsKey(c)) {
            this.map.put(c, name.toLowerCase());
        }
    }

    public void add(int hexValue) {
        Color c = new Color(hexValue);
        if (!this.map.containsKey(c)) {
            this.map.put(c, Integer.toHexString(hexValue));
        }
    }

    public void add(Object c) {
        if (c instanceof Color || c instanceof SystemColor) {
            int rgb = ((Color)c).getRGB();
            if (!this.map.containsKey(c)) {
                this.map.put(c, Integer.toHexString(rgb));
            }
        } else {
            throw new ClassCastException(RB.getStringResource(RB_KEY, "invalidobj.ex.txt"));
        }
    }

    public void setShowSystemColors(boolean bool) {
        if (this.showSystemColors != bool) {
            this.map.clear();
            this.setColorNameList();
            this.showSystemColors = bool;
            if (this.showSystemColors) {
                this.setSystemColorList();
            }
        }
    }

    public boolean getShowSystemColors() {
        return this.showSystemColors;
    }

    private void setColorNameList() {
        this.map.put(Color.black, RB.getStringResource(RB_KEY, "black.txt"));
        this.map.put(Color.blue, RB.getStringResource(RB_KEY, "blue.txt"));
        this.map.put(Color.cyan, RB.getStringResource(RB_KEY, "cyan.txt"));
        this.map.put(Color.darkGray, RB.getStringResource(RB_KEY, "darkgray.txt"));
        this.map.put(Color.gray, RB.getStringResource(RB_KEY, "gray.txt"));
        this.map.put(Color.green, RB.getStringResource(RB_KEY, "green.txt"));
        this.map.put(Color.lightGray, RB.getStringResource(RB_KEY, "lightgray.txt"));
        this.map.put(Color.magenta, RB.getStringResource(RB_KEY, "magenta.txt"));
        this.map.put(Color.orange, RB.getStringResource(RB_KEY, "orange.txt"));
        this.map.put(Color.pink, RB.getStringResource(RB_KEY, "pink.txt"));
        this.map.put(Color.red, RB.getStringResource(RB_KEY, "red.txt"));
        this.map.put(Color.white, RB.getStringResource(RB_KEY, "white.txt"));
        this.map.put(Color.yellow, RB.getStringResource(RB_KEY, "yellow.txt"));
    }

    private void setSystemColorList() {
        this.map.put(SystemColor.activeCaption, "ACTIVE_CAPTION");
        this.map.put(SystemColor.activeCaptionBorder, "ACTIVE_CAPTION_BORDER");
        this.map.put(SystemColor.activeCaptionText, "ACTIVE_CAPTION_TEXT");
        this.map.put(SystemColor.control, "CONTROL");
        this.map.put(SystemColor.controlDkShadow, "CONTROL_DK_SHADOW");
        this.map.put(SystemColor.controlHighlight, "CONTROL_HIGHLIGHT");
        this.map.put(SystemColor.controlLtHighlight, "CONTROL_LT_HIGHLIGHT");
        this.map.put(SystemColor.controlShadow, "CONTROL_SHADOW");
        this.map.put(SystemColor.controlText, "CONTROL_TEXT");
        this.map.put(SystemColor.desktop, "DESKTOP");
        this.map.put(SystemColor.inactiveCaption, "INACTIVE_CAPTION");
        this.map.put(SystemColor.inactiveCaptionBorder, "INACTIVE_CAPTION_BORDER");
        this.map.put(SystemColor.inactiveCaptionText, "INACTIVE_CAPTION_TEXT");
        this.map.put(SystemColor.info, "INFO");
        this.map.put(SystemColor.infoText, "INFO_TEXT");
        this.map.put(SystemColor.menu, "MENU");
        this.map.put(SystemColor.menuText, "MENU_TEXT");
        this.map.put(SystemColor.scrollbar, "SCROLLBAR");
        this.map.put(SystemColor.text, "TEXT");
        this.map.put(SystemColor.textHighlight, "TEXT_HIGHLIGHT");
        this.map.put(SystemColor.textHighlightText, "TEXT_HIGHLIGHT_TEXT");
        this.map.put(SystemColor.textInactiveText, "TEXT_INACTIVE_TEXT");
        this.map.put(SystemColor.textText, "TEXT_TEXT");
        this.map.put(SystemColor.window, "WINDOW");
        this.map.put(SystemColor.windowBorder, "WINDOW_BORDER");
        this.map.put(SystemColor.windowText, "WINDOW_TEXT");
    }

    public Color getColor(String colorName) {
        Color color = this.findKey(colorName);
        if (color != null) {
            return color;
        }
        color = this.findKey(colorName.toLowerCase());
        if (color != null) {
            return color;
        }
        color = this.findKey(colorName.toUpperCase());
        if (color != null) {
            return color;
        }
        throw new NoSuchElementException(RB.getStringResource(RB_KEY, "colorNotFound.ex.txt"));
    }

    private Color findKey(String colorName) {
        if (colorName == null || !this.map.containsValue(colorName)) {
            return null;
        }
        for (Color color : this.map.keySet()) {
            if (!colorName.equals((String)this.map.get(color))) continue;
            return color;
        }
        return null;
    }

    public String getColorName(Color color) {
        if (this.map.containsKey(color)) {
            return (String)this.map.get(color);
        }
        throw new NoSuchElementException(RB.getStringResource(RB_KEY, "colorNotFound.ex.txt"));
    }
}

