/*
 * Decompiled with CFR 0.152.
 */
package com.sas.text;

import com.sas.text.DateTimeValue;
import com.sas.text.SASFormatEntry;
import com.sas.text.SingleEntry;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Vector;

public class QuarterDateTime
extends DateTimeValue {
    private static final long serialVersionUID = 1L;
    private static String[] fnames = new String[]{"DTYYQC"};
    private static int DTYYQC = 0;
    private static Object[] quarterFormats;
    private SimpleDateFormat sdfMonth = new SimpleDateFormat("MM", Locale.US);

    protected QuarterDateTime() {
        this.sdfMonth.setLenient(false);
    }

    @Override
    public StringBuffer format(double dateTimeValue) {
        this.sdfMonth.setTimeZone(this.getTimeZone());
        String formatName = this.info.getBaseFormat();
        long javaDate = 0L;
        if (formatName.equals(fnames[DTYYQC])) {
            javaDate = this.SASDateTimeToJavaDate(dateTimeValue, this.getTimeZone());
        }
        this.date.setTime(javaDate);
        Integer iMonth = Integer.valueOf(this.sdfMonth.format(this.date));
        int quarter = (int)(iMonth.doubleValue() / 3.0 + 0.67);
        StringBuffer result = this.formatValue(javaDate, false);
        result.append(quarter);
        this.insertLeadingBlanks(result);
        return result;
    }

    static Object[] getDefinedFormats() {
        if (quarterFormats == null) {
            Vector<SingleEntry> temp = new Vector<SingleEntry>(20, 5);
            String className = QuarterDateTime.class.getName();
            SingleEntry entry = new SingleEntry("DTYYQCw", className);
            ((SASFormatEntry)entry).addPattern(6, 6, "yyyy:", true);
            ((SASFormatEntry)entry).addPattern(4, 5, "yy:");
            temp.addElement(entry);
            quarterFormats = new Object[temp.size()];
            temp.copyInto(quarterFormats);
        }
        return quarterFormats;
    }
}

