/*
 * Decompiled with CFR 0.152.
 */
package com.sas.security;

import com.sas.codepolicy.SASScope;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Vector;

@SASScope
public class PermissionCombiner
implements DomainCombiner {
    ProtectionDomain[] domains;

    public PermissionCombiner(ProtectionDomain[] d) {
        this.domains = d;
    }

    @Override
    public ProtectionDomain[] combine(ProtectionDomain[] current, ProtectionDomain[] assigned) {
        ProtectionDomain pd;
        int i;
        Vector<ProtectionDomain> s = new Vector<ProtectionDomain>();
        if (current != null) {
            for (i = 0; i < current.length; ++i) {
                pd = current[i];
                if (!this.implies(pd, this.domains)) {
                    pd = this.cloneAndAddPermissions(pd);
                }
                s.addElement(pd);
            }
        }
        if (assigned != null) {
            for (i = 0; i < assigned.length; ++i) {
                pd = assigned[i];
                if (s.contains(pd)) continue;
                if (!this.implies(pd, this.domains)) {
                    pd = this.cloneAndAddPermissions(pd);
                }
                s.addElement(pd);
            }
        }
        Object[] combined = new ProtectionDomain[s.size()];
        s.copyInto(combined);
        return combined;
    }

    private boolean implies(ProtectionDomain pd, ProtectionDomain[] testDomains) {
        boolean flag = false;
        for (int i = 0; i < testDomains.length; ++i) {
            Enumeration<Permission> p = testDomains[i].getPermissions().elements();
            while (p.hasMoreElements()) {
                flag = true;
                Permission d = p.nextElement();
                if (pd.implies(d)) continue;
                return false;
            }
        }
        return flag;
    }

    private ProtectionDomain cloneAndAddPermissions(ProtectionDomain protectionDomain) {
        Permissions newPermissions = new Permissions();
        PermissionCollection permissionCollection = protectionDomain.getPermissions();
        if (permissionCollection != null) {
            Enumeration<Permission> perms = permissionCollection.elements();
            while (perms.hasMoreElements()) {
                ((PermissionCollection)newPermissions).add(perms.nextElement());
            }
        }
        for (int i = 0; i < this.domains.length; ++i) {
            Enumeration<Permission> p = this.domains[i].getPermissions().elements();
            while (p.hasMoreElements()) {
                Permission d = p.nextElement();
                if (protectionDomain.implies(d)) continue;
                ((PermissionCollection)newPermissions).add(d);
            }
        }
        return new ProtectionDomain(protectionDomain.getCodeSource(), newPermissions);
    }
}

