/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net;

import com.sas.codepolicy.SASScope;
import com.sas.codepolicy.SubjectToChange;

@SASScope(value="ALL")
@SubjectToChange
public class UnicodeURLEncoder {
    private static final char[] hex = "0123456789ABCDEF".toCharArray();
    private static final char[] decode = new char[103];
    public static final UnicodeURLEncoder defaultInstance;

    public static final String encode(String string) {
        return defaultInstance.encodeString(string);
    }

    public static final String decode(String string) {
        return defaultInstance.decodeString(string);
    }

    public String encodeString(String in) {
        int len = 0;
        int l = in.length();
        for (int i = 0; i < l; ++i) {
            char ch = in.charAt(i);
            if (ch > '\u00ff') {
                len += 6;
                continue;
            }
            ++len;
        }
        StringBuffer buffer = new StringBuffer(len);
        int l2 = in.length();
        for (int i = 0; i < l2; ++i) {
            char ch = in.charAt(i);
            if (ch > '\u00ff' || ch == '\\') {
                buffer.append('\\').append('u').append(hex[ch >> 12 & 0xF]).append(hex[ch >> 8 & 0xF]).append(hex[ch >> 4 & 0xF]).append(hex[ch & 0xF]);
                continue;
            }
            buffer.append(ch);
        }
        String s = buffer.toString();
        return s;
    }

    public String decodeString(String in) {
        try {
            int len = 0;
            int l = in.length();
            for (int i = 0; i < l; ++i) {
                char ch = in.charAt(i);
                if (ch == '\\') {
                    i += 5;
                }
                ++len;
            }
            StringBuffer buffer = new StringBuffer(len);
            int l2 = in.length();
            for (int i = 0; i < l2; ++i) {
                char ch = in.charAt(i);
                if (ch == '\\') {
                    ch = in.charAt(++i);
                    char a = in.charAt(++i);
                    char b = in.charAt(++i);
                    char c = in.charAt(++i);
                    char d = in.charAt(++i);
                    ch = (char)(decode[a] << 12 | decode[b] << 8 | decode[c] << 4 | decode[d]);
                }
                buffer.append(ch);
            }
            String s = buffer.toString();
            return s;
        }
        catch (IndexOutOfBoundsException e) {
            throw new IllegalArgumentException(in);
        }
    }

    static {
        for (int i = 0; i < hex.length; ++i) {
            UnicodeURLEncoder.decode[UnicodeURLEncoder.hex[i]] = (char)i;
            UnicodeURLEncoder.decode[Character.toLowerCase((char)UnicodeURLEncoder.hex[i])] = (char)i;
        }
        defaultInstance = new UnicodeURLEncoder();
    }
}

