/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net;

import com.sas.net.BaseResourceLocator;
import com.sas.net.ResourceLocatorInterface;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;

public class FileResourceLocator
extends BaseResourceLocator
implements ResourceLocatorInterface {
    static final long serialVersionUID = -1793970847181329099L;

    public FileResourceLocator() {
    }

    public FileResourceLocator(String resourceName) {
        super(resourceName);
    }

    @Override
    public URL getResource() throws MalformedURLException {
        if (this.getResourceName() != null) {
            File file = new File(this.getResourceName());
            return file.toURL();
        }
        return null;
    }

    @Override
    public String encode() {
        return new String("File: ~<" + this.getResourceName() + ">~");
    }

    public static ResourceLocatorInterface decode(String resource) {
        FileResourceLocator frl = new FileResourceLocator();
        if (resource.startsWith("File: ")) {
            frl.setResourceName(resource.substring(8, resource.length() - 2));
            return frl;
        }
        return null;
    }

    @Override
    protected ResourceLocatorInterface createInstance(String resource) {
        return FileResourceLocator.decode(resource);
    }
}

