/*
 * Decompiled with CFR 0.152.
 */
package com.sas.net;

import com.sas.net.AppletResourceLocator;
import com.sas.net.ClassResourceLocator;
import com.sas.net.ContextResourceLocator;
import com.sas.net.FileResourceLocator;
import com.sas.net.ResourceLocatorInterface;
import com.sas.util.Util;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlException;
import javax.swing.event.SwingPropertyChangeSupport;

public class BaseResourceLocator
implements ResourceLocatorInterface,
Serializable,
Cloneable {
    static final long serialVersionUID = -4196827828100369237L;
    public static final int WEBAF = 1;
    public static final int WEBEIS = 2;
    public static final int RUNTIME = 3;
    protected String _resource;
    protected transient SwingPropertyChangeSupport _pcs = new SwingPropertyChangeSupport(this);

    public BaseResourceLocator() {
    }

    public BaseResourceLocator(String resourceName) {
        this();
        this.setResourceName(resourceName);
    }

    @Override
    public String getResourceName() {
        return this._resource;
    }

    @Override
    public void setResourceName(String newValue) {
        if (newValue != null && (newValue.length() == 0 || newValue.equals("null"))) {
            newValue = null;
        }
        if (!Util.equal(this._resource, newValue)) {
            String oldValue = this._resource;
            this._resource = newValue;
            this.firePropertyChange("resourceName", oldValue, newValue);
        }
    }

    @Override
    public URL getResource() throws MalformedURLException {
        if (this.getResourceName() != null) {
            return new URL(this.getResourceName());
        }
        return null;
    }

    public String toString() {
        String retValue = this.getClass().getName();
        URL resource = null;
        try {
            resource = this.getResource();
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (resource != null) {
            retValue = retValue + ": " + resource.toExternalForm();
        }
        return retValue;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ResourceLocatorInterface)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        try {
            URL url1 = this.getResource();
            URL url2 = ((ResourceLocatorInterface)obj).getResource();
            if (url1 != null && url2 != null) {
                return Util.equal(url1.toExternalForm(), url2.toExternalForm());
            }
            return Util.equal(url1, url2);
        }
        catch (MalformedURLException ex) {
            return false;
        }
    }

    public int getMode() {
        try {
            String webAFdir = System.getProperty("webaf.project.directory");
            if (webAFdir != null && webAFdir.length() != 0) {
                return 1;
            }
        }
        catch (AccessControlException webAFdir) {
            // empty catch block
        }
        try {
            String webEISdir = System.getProperty("webeis.document.directory");
            if (webEISdir != null && webEISdir.length() != 0) {
                return 2;
            }
        }
        catch (AccessControlException accessControlException) {
            // empty catch block
        }
        return 3;
    }

    public String getProjectDirectory() {
        int mode = this.getMode();
        if (mode == 1) {
            return System.getProperty("webaf.project.directory");
        }
        if (mode == 2) {
            return System.getProperty("webeis.document.directory");
        }
        return System.getProperty("user.dir");
    }

    public String encode() {
        return new String("URL: ~<" + this.getResourceName() + ">~");
    }

    public static ResourceLocatorInterface decode(String resource) {
        BaseResourceLocator brl = new BaseResourceLocator();
        if (resource.startsWith("URL: ")) {
            brl.setResourceName(resource.substring(7, resource.length() - 2));
            return brl;
        }
        return null;
    }

    protected ResourceLocatorInterface createInstance(String resource) {
        return BaseResourceLocator.decode(resource);
    }

    public Object clone() {
        return this.createInstance(this.encode());
    }

    public static ResourceLocatorInterface getResourceLocator(String code) {
        ResourceLocatorInterface rl = BaseResourceLocator.decode(code);
        if (rl == null && (rl = AppletResourceLocator.decode(code)) == null && (rl = ClassResourceLocator.decode(code)) == null && (rl = ContextResourceLocator.decode(code)) == null) {
            rl = FileResourceLocator.decode(code);
        }
        return rl;
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        try {
            stream.defaultReadObject();
        }
        finally {
            this._pcs = new SwingPropertyChangeSupport(this);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this._pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this._pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this._pcs.removePropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this._pcs.removePropertyChangeListener(propertyName, listener);
    }

    public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        this._pcs.firePropertyChange(propertyName, oldValue, newValue);
    }

    public void firePropertyChange(PropertyChangeEvent evt) {
        this._pcs.firePropertyChange(evt);
    }
}

