/*
 * Decompiled with CFR 0.152.
 */
package com.sas.io;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ReplacementOutputStream
extends FilterOutputStream {
    private byte[] targetSequence = null;
    private byte[] replacementSequence = null;
    private byte[] buffer = null;
    private int bufferLength = 0;
    private int dataLength = 0;
    private int index = 0;
    private byte target = 0;

    public ReplacementOutputStream(OutputStream out, byte[] targetSequence, byte[] replacementSequence) {
        super(out);
        if (targetSequence == null || targetSequence.length == 0) {
            throw new IllegalArgumentException();
        }
        this.replacementSequence = replacementSequence;
        if (targetSequence.length > 1) {
            this.targetSequence = targetSequence;
            this.bufferLength = targetSequence.length;
            this.buffer = new byte[this.bufferLength];
        } else {
            this.target = targetSequence[0];
        }
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.targetSequence == null) {
            if (this.target == (byte)b) {
                if (this.replacementSequence != null) {
                    this.out.write(this.replacementSequence);
                }
            } else {
                this.out.write(b);
            }
        } else {
            this.buffer[this.index] = (byte)b;
            ++this.dataLength;
            this.index = (this.index + 1) % this.bufferLength;
            if (this.dataLength == this.bufferLength) {
                if (ReplacementOutputStream.arraysEqual(this.buffer, this.index, this.targetSequence)) {
                    if (this.replacementSequence != null) {
                        this.out.write(this.replacementSequence);
                    }
                    this.index = 0;
                    this.dataLength = 0;
                } else {
                    this.out.write(this.buffer[this.index]);
                    --this.dataLength;
                }
            }
        }
    }

    @Override
    public synchronized void write(byte[] b, int o, int l) throws IOException {
        int i;
        if (this.targetSequence == null) {
            for (i = 0; i < l && this.target != b[i + o]; ++i) {
            }
            if (i == l) {
                this.out.write(b, o, l);
                return;
            }
        }
        for (i = 0; i < l; ++i) {
            this.write(b[i + o]);
        }
    }

    public synchronized void writeNoReplacement(int b) throws IOException {
        this.flush();
        this.out.write(b);
    }

    public void writeNoReplacement(byte[] b) throws IOException {
        this.writeNoReplacement(b, 0, b.length);
    }

    public synchronized void writeNoReplacement(byte[] b, int o, int l) throws IOException {
        this.flush();
        this.out.write(b, o, l);
    }

    @Override
    public synchronized void flush() throws IOException {
        if (this.dataLength > 0) {
            if (this.index > this.dataLength) {
                this.out.write(this.buffer, 0, this.dataLength);
            } else {
                for (int i = 0; i < this.dataLength; ++i) {
                    this.out.write(this.buffer[(this.index + i + 1) % this.bufferLength]);
                }
            }
            this.index = 0;
            this.dataLength = 0;
        }
        this.out.flush();
    }

    protected static boolean arraysEqual(byte[] a1, int offset, byte[] a2) {
        int l = a2.length;
        for (int i = 0; i < l; ++i) {
            if (a1[(i + offset) % l] == a2[i]) continue;
            return false;
        }
        return true;
    }
}

