/*
 * Decompiled with CFR 0.152.
 */
package com.sas.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.PushbackInputStream;

public class ReplacementInputStream
extends FilterInputStream {
    private PushbackInputStream pStream = null;
    private int index = 0;
    private boolean replaced = false;
    private byte[] buffer = null;
    private byte[] targetSequence = null;
    private byte[] replacementSequence = null;

    public ReplacementInputStream(PushbackInputStream in, byte[] targetSequence, byte[] replacementSequence) {
        super(in);
        if (targetSequence == null || targetSequence.length == 0) {
            throw new IllegalArgumentException();
        }
        this.pStream = in;
        this.targetSequence = targetSequence;
        this.replacementSequence = replacementSequence;
        this.buffer = new byte[targetSequence.length];
    }

    @Override
    public synchronized int read() throws IOException {
        int b = -1;
        do {
            int j;
            if (this.replaced) {
                if (this.index < this.replacementSequence.length) {
                    b = this.replacementSequence[this.index++] & 0xFF;
                    continue;
                }
                this.replaced = false;
                continue;
            }
            int i = 0;
            while ((j = this.pStream.read(this.buffer, i, this.buffer.length - i)) >= 0 && (i += j) < this.buffer.length) {
            }
            if (i == 0) {
                return -1;
            }
            if (i == this.buffer.length && ReplacementInputStream.arraysEqual(this.buffer, this.targetSequence)) {
                this.replaced = true;
                this.index = 0;
                continue;
            }
            b = this.buffer[0] & 0xFF;
            this.pStream.unread(this.buffer, 1, i - 1);
        } while (b == -1);
        return b;
    }

    @Override
    public synchronized int read(byte[] b, int o, int l) throws IOException {
        for (int i = 0; i < l; ++i) {
            int e = this.read();
            if (e < 0) {
                return i > 0 ? i : -1;
            }
            b[o + i] = (byte)e;
        }
        return l;
    }

    @Override
    public synchronized long skip(long n) throws IOException {
        for (long i = 0L; i < n; ++i) {
            int e = this.read();
            if (e >= 0) continue;
            return i;
        }
        return n;
    }

    @Override
    public synchronized int available() throws IOException {
        int replacementLength;
        int i = this.pStream.available();
        int targetLength = this.targetSequence.length;
        int n = replacementLength = this.replacementSequence == null ? 0 : this.replacementSequence.length;
        if (replacementLength < targetLength) {
            return i / targetLength * replacementLength + i % targetLength;
        }
        return i;
    }

    private static boolean arraysEqual(byte[] b1, byte[] b2) {
        for (int i = 0; i < b1.length; ++i) {
            if (b1[i] == b2[i]) continue;
            return false;
        }
        return true;
    }
}

