/*
 * Decompiled with CFR 0.152.
 */
package com.sas.io;

import com.sas.io.InputStreamProviderInterface;
import com.sas.io.RemoteInputStreamInterface;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.UndeclaredThrowableException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;

public class RemoteInputStream
extends UnicastRemoteObject
implements RemoteInputStreamInterface {
    private transient InputStream is;

    public RemoteInputStream(InputStream is) throws RemoteException {
        this.is = is;
    }

    public RemoteInputStream(InputStream is, int port, RMIClientSocketFactory csf, RMIServerSocketFactory ssf) throws RemoteException {
        super(port, csf, ssf);
        this.is = is;
    }

    @Override
    public int available() throws IOException {
        return this.is.available();
    }

    @Override
    public void close() throws IOException {
        try {
            RemoteInputStream.unexportObject(this, true);
        }
        catch (NoSuchObjectException noSuchObjectException) {
            // empty catch block
        }
        this.is.close();
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.is.mark(readlimit);
    }

    @Override
    public boolean markSupported() {
        return this.is.markSupported();
    }

    @Override
    public int read() throws IOException {
        return this.is.read();
    }

    @Override
    public byte[] read(int maxread) throws IOException {
        byte[] b = new byte[maxread];
        int nread = this.is.read(b);
        if (nread < 0) {
            return null;
        }
        if (nread < maxread) {
            byte[] newb = new byte[nread];
            for (int i = 0; i < nread; ++i) {
                newb[i] = b[i];
            }
            b = newb;
        }
        return b;
    }

    @Override
    public synchronized void reset() throws IOException {
        this.is.reset();
    }

    @Override
    public long skip(long n) throws IOException {
        return this.is.skip(n);
    }

    public static InputStream getInputStream(InputStreamProviderInterface provider, Object streamID) throws IOException, RemoteException {
        InputStream f;
        try {
            f = provider.getInputStream(streamID);
        }
        catch (UnmarshalException e) {
            RemoteInputStreamInterface ris = provider.getRemoteInputStream(streamID);
            f = new Proxy(ris);
        }
        return f;
    }

    private static class Proxy
    extends InputStream {
        private transient RemoteInputStreamInterface is;

        public Proxy(RemoteInputStreamInterface is) {
            this.is = is;
        }

        @Override
        public int available() throws IOException {
            return this.is.available();
        }

        @Override
        public void close() throws IOException {
            this.is.close();
        }

        @Override
        public synchronized void mark(int readlimit) {
            try {
                this.is.mark(readlimit);
            }
            catch (RemoteException e) {
                throw new UndeclaredThrowableException(e);
            }
        }

        @Override
        public boolean markSupported() {
            try {
                return this.is.markSupported();
            }
            catch (RemoteException e) {
                throw new UndeclaredThrowableException(e);
            }
        }

        @Override
        public int read() throws IOException {
            return this.is.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            byte[] tempbuf = this.is.read(b.length);
            if (tempbuf == null) {
                return -1;
            }
            for (int i = 0; i < tempbuf.length; ++i) {
                b[i] = tempbuf[i];
            }
            return tempbuf.length;
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            byte[] tempbuf = this.is.read(len);
            if (tempbuf == null) {
                return -1;
            }
            for (int i = 0; i < tempbuf.length; ++i) {
                b[off++] = tempbuf[i];
            }
            return tempbuf.length;
        }

        @Override
        public synchronized void reset() throws IOException {
            this.is.reset();
        }

        @Override
        public long skip(long n) throws IOException {
            return this.is.skip(n);
        }
    }
}

