/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseRangeDataType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.DateType;
import com.sas.datatypes.MonthType;
import com.sas.datatypes.QuarterType;
import com.sas.datatypes.TimeRangeType;
import com.sas.datatypes.TimeStampRangeType;
import com.sas.datatypes.WeekType;
import com.sas.datatypes.WeekdayType;
import com.sas.datatypes.YearType;
import com.sas.util.DatePeriod;
import com.sas.util.DateTypes;
import com.sas.util.ValueItem;
import com.sas.util.macrovar.MacroInfoSourceFacade;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope
public class DateRangeType
extends BaseRangeDataType {
    public static final DateRangeType DEFAULT_INSTANCE_DATE = new DateRangeType(DateType.DEFAULT_INSTANCE);
    public static final DateRangeType DEFAULT_INSTANCE_MONTH = new DateRangeType(MonthType.DEFAULT_INSTANCE);
    public static final DateRangeType DEFAULT_INSTANCE_QUARTER = new DateRangeType(QuarterType.DEFAULT_INSTANCE);
    public static final DateRangeType DEFAULT_INSTANCE_WEEK = new DateRangeType(WeekType.DEFAULT_INSTANCE);
    public static final DateRangeType DEFAULT_INSTANCE_YEAR = new DateRangeType(YearType.DEFAULT_INSTANCE);
    public static final DateRangeType DEFAULT_INSTANCE_WEEKDAY = new DateRangeType(WeekdayType.DEFAULT_INSTANCE);
    public static final DateRangeType DEFAULT_LOCAL_INSTANCE_DATE = new DateRangeType(DateType.DEFAULT_LOCAL_INSTANCE);
    public static final DateRangeType DEFAULT_LOCAL_INSTANCE_MONTH = new DateRangeType(MonthType.DEFAULT_LOCAL_INSTANCE);
    public static final DateRangeType DEFAULT_LOCAL_INSTANCE_QUARTER = new DateRangeType(QuarterType.DEFAULT_LOCAL_INSTANCE);
    public static final DateRangeType DEFAULT_LOCAL_INSTANCE_WEEK = new DateRangeType(WeekType.DEFAULT_LOCAL_INSTANCE);
    public static final DateRangeType DEFAULT_LOCAL_INSTANCE_YEAR = new DateRangeType(YearType.DEFAULT_LOCAL_INSTANCE);
    public static final DateRangeType DEFAULT_LOCAL_INSTANCE_WEEKDAY = new DateRangeType(WeekdayType.DEFAULT_LOCAL_INSTANCE);
    private DataTypeInterface dateType;

    public static DateRangeType getDateRangeDataTypeByDateType(DateTypes dateType) {
        if (dateType == DateTypes.DATE) {
            return DEFAULT_INSTANCE_DATE;
        }
        if (dateType == DateTypes.MONTH) {
            return DEFAULT_INSTANCE_MONTH;
        }
        if (dateType == DateTypes.QUARTER) {
            return DEFAULT_INSTANCE_QUARTER;
        }
        if (dateType == DateTypes.TIMESTAMP) {
            return TimeStampRangeType.DEFAULT_INSTANCE_TIMESTAMP;
        }
        if (dateType == DateTypes.TIME) {
            return TimeRangeType.DEFAULT_INSTANCE_TIME;
        }
        if (dateType == DateTypes.WEEK) {
            return DEFAULT_INSTANCE_WEEK;
        }
        if (dateType == DateTypes.YEAR) {
            return DEFAULT_INSTANCE_YEAR;
        }
        if (dateType == DateTypes.WEEKDAY) {
            return DEFAULT_INSTANCE_WEEKDAY;
        }
        return null;
    }

    public DateRangeType() {
        this.dateType = DateType.DEFAULT_INSTANCE;
    }

    public DateRangeType(DataTypeInterface dateType) {
        this.dateType = dateType;
    }

    public void setDataType(DataTypeInterface dataType) {
        this.dateType = dataType;
    }

    public DataTypeInterface getDataType() {
        return this.dateType;
    }

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        if (inputValue instanceof List && ((List)inputValue).size() == 1) {
            inputValue = ((List)inputValue).get(0);
        }
        if (inputValue instanceof Date[] && ((Date[])inputValue).length == 2) {
            Date[] da = (Date[])inputValue;
            Date[] rv = new Date[]{(Date)this.getRangeMinMaxDataType().coerceValue(da[0], inputLocale), (Date)this.getRangeMinMaxDataType().coerceValue(da[1], inputLocale)};
            return rv;
        }
        if (inputValue instanceof ValueItem) {
            return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
        }
        if (inputValue instanceof String) {
            String toDecode = (String)inputValue;
            String[] minMaxValues = toDecode.split("--");
            if (minMaxValues.length == 2) {
                return this.coerceValue(new String[]{minMaxValues[0].trim(), minMaxValues[1].trim()}, inputLocale);
            }
        } else if (inputValue instanceof Object[]) {
            Object[] toDecode = (Object[])inputValue;
            if (toDecode.length == 2) {
                Object upper;
                Date[] values = new Date[2];
                Object lower = this.dateType.coerceValue(toDecode[0], inputLocale);
                if (lower instanceof Date) {
                    values[0] = (Date)lower;
                }
                if ((upper = this.dateType.coerceValue(toDecode[1], inputLocale)) instanceof Date) {
                    values[1] = (Date)upper;
                }
                return values;
            }
        } else if (inputValue == null) {
            return null;
        }
        throw new IllegalArgumentException("Unable to convert value to Date range type: " + inputValue);
    }

    @Override
    public Object coerceValueFromPersistedString(String input) throws IllegalArgumentException {
        String[] values = (input = input.trim()).split("--");
        if (values.length != 2) {
            throw new IllegalArgumentException("Unable to convert value to range with 2 values");
        }
        Date[] returnValue = new Date[]{(Date)this.dateType.coerceValueFromPersistedString(values[0]), (Date)this.dateType.coerceValueFromPersistedString(values[1])};
        return returnValue;
    }

    @Override
    public String getPersistanceString(Object value) {
        if (value instanceof Object[] && ((Object[])value).length == 2) {
            Object[] obj = (Object[])value;
            String min = this.dateType.getPersistanceString(obj[0] instanceof DatePeriod && !((DatePeriod)obj[0]).isRelativeDate() ? ((DatePeriod)obj[0]).getStartOfPeriod() : obj[0]);
            String max = this.dateType.getPersistanceString(obj[1] instanceof DatePeriod && !((DatePeriod)obj[1]).isRelativeDate() ? ((DatePeriod)obj[1]).getEndOfPeriod() : obj[1]);
            StringBuffer buf = new StringBuffer(min);
            buf.append("--").append(max);
            return buf.toString();
        }
        return this.dateType.getPersistanceString(value);
    }

    @Override
    public String getValueAsString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        String stringValue = null;
        if (value instanceof Object[]) {
            Object[] obj = (Object[])value;
            String value1 = this.getRangeMinMaxDataType().getValueAsString(obj[0] instanceof DatePeriod ? ((DatePeriod)obj[0]).getStartOfPeriod() : obj[0], outputLocale);
            String value2 = this.getRangeMinMaxDataType().getValueAsString(obj[1] instanceof DatePeriod ? ((DatePeriod)obj[1]).getEndOfPeriod() : obj[1], outputLocale);
            stringValue = this.replaceNull(value1) + " " + "--" + " " + this.replaceNull(value2);
        } else {
            stringValue = this.getRangeMinMaxDataType().getValueAsString(value, outputLocale);
        }
        return stringValue;
    }

    @Override
    public String getDisplayString(Object value, Locale outputLocale) {
        String stringValue = null;
        if (value instanceof Object[]) {
            Object[] obj = (Object[])value;
            String value1 = this.getRangeMinMaxDataType().getDisplayString(obj[0] instanceof DatePeriod && !((DatePeriod)obj[0]).isRelativeDate() ? ((DatePeriod)obj[0]).getStartOfPeriod() : obj[0], outputLocale);
            String value2 = this.getRangeMinMaxDataType().getDisplayString(obj[1] instanceof DatePeriod && !((DatePeriod)obj[1]).isRelativeDate() ? ((DatePeriod)obj[1]).getEndOfPeriod() : obj[1], outputLocale);
            stringValue = this.replaceNull(value1) + " " + "--" + " " + this.replaceNull(value2);
        } else {
            stringValue = this.getRangeMinMaxDataType().getDisplayString(value, outputLocale);
        }
        return stringValue;
    }

    @Override
    public int getSQLType() {
        return this.dateType.getSQLType();
    }

    @Override
    public DataTypeInterface getRangeMinMaxDataType() {
        return this.dateType;
    }

    @Override
    public Object[] getRangeDefaultValue() {
        return new Date[2];
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        Object out = this.coerceValue(value, inputLocale);
        if (null != out && out instanceof Date[] && ((Date[])out).length == 2) {
            Date[] out2 = (Date[])out;
            Date[] retVal = new Date[]{(Date)this.dateType.copyValue(out2[0], inputLocale), (Date)this.dateType.copyValue(out2[1], inputLocale)};
            return retVal;
        }
        return out;
    }

    @Override
    public Map getMacroVariableValues(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        if (value == null) {
            return this.getMacroVariablesForNull(macroInfoSource);
        }
        Object[] rangeValue = (Object[])value;
        HashMap map = new HashMap(2);
        Map minValueMap = this.getRangeMinMaxDataType().getMacroVariableValues(new MacroInfoSourceFacade(macroInfoSource, "_min"), rangeValue[0], locale);
        map.putAll(minValueMap);
        Map maxValueMap = this.getRangeMinMaxDataType().getMacroVariableValues(new MacroInfoSourceFacade(macroInfoSource, "_max"), rangeValue[1], locale);
        map.putAll(maxValueMap);
        return map;
    }
}

