/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDataType;
import com.sas.datatypes.RB;
import com.sas.models.datasources.BaseDataSource;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.models.metadataSource.MetadataSource;
import com.sas.text.Message;
import com.sas.util.ValueItem;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope
public class DataSourceType
extends BaseDataType {
    public static final String RB_KEY = "DataSourceType.";
    public static final DataSourceType DEFAULT_INSTANCE = new DataSourceType();

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        if (inputValue instanceof List && ((List)inputValue).size() == 1) {
            inputValue = ((List)inputValue).get(0);
        }
        if (inputValue == null) {
            return inputValue;
        }
        if (inputValue instanceof DataSourceInterface) {
            return inputValue;
        }
        if (inputValue instanceof MetadataSource) {
            MetadataSource mds = (MetadataSource)inputValue;
            Long type = 0L;
            if ("InformationMap.Relational".equals(mds.getMetadataType())) {
                type = 4L;
            } else if ("InformationMap.OLAP".equals(mds.getMetadataType())) {
                type = 8L;
            } else if ("Table".equals(mds.getMetadataType()) || "PhysicalTable".equals(mds.getMetadataType())) {
                type = 1L;
            } else if ("Cube".equals(mds.getMetadataType())) {
                type = 2L;
            }
            if (type != 0L) {
                return new BaseDataSource(type, mds.getMetadataSourceURL());
            }
        } else {
            if (inputValue instanceof ValueItem) {
                return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
            }
            if (inputValue instanceof String) {
                return this.createDataSourceFromString((String)inputValue);
            }
            if (inputValue instanceof String[] && ((String[])inputValue).length == 1) {
                return this.coerceValue(((String[])inputValue)[0], inputLocale);
            }
        }
        throw new IllegalArgumentException(Message.format(RB.getStringResource(RB_KEY, "dataSourceValueNotValid.ex.txt", inputLocale), inputValue));
    }

    private DataSourceInterface createDataSourceFromString(String text) {
        String[] splitText = text.split(" :: ");
        if (splitText.length != 2) {
            BaseDataSource dataSource = new BaseDataSource(1L, text);
            return dataSource;
        }
        String dataSourceLocation = splitText[0];
        String dataSourceType = splitText[1];
        return new BaseDataSource(Long.parseLong(dataSourceType), dataSourceLocation);
    }

    @Override
    public String getValueAsString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        return ((DataSourceInterface)value).getDataSourceLocation() + " :: " + ((DataSourceInterface)value).getDataSourceType();
    }

    @Override
    public Object coerceValueFromPersistedString(String input) {
        Object obj = this.coerceValue(input, Locale.US);
        return obj;
    }

    @Override
    public String getPersistanceString(Object value) throws IllegalArgumentException {
        return this.getValueAsString(value, Locale.US);
    }

    @Override
    public String getDisplayString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        return ((DataSourceInterface)value).getDataSourceLocation();
    }

    @Override
    public int getSQLType() {
        return 2000;
    }

    @Override
    public int getExpressionUsage() {
        return 1111;
    }

    @Override
    public Map getMacroVariableValues(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        if (value == null) {
            return this.getMacroVariablesForNull(macroInfoSource);
        }
        DataSourceInterface source = (DataSourceInterface)value;
        HashMap<String, String> map = new HashMap<String, String>(2);
        if (source.getDataSourceLocation() != null) {
            map.put(baseMacroVariableName, source.getDataSourceLocation());
            map.put(baseMacroVariableName + "_type", source.getDataSourceType() + "");
        }
        return map;
    }

    @Override
    public Collection getPossibleMacroVariableExtensions() {
        ArrayList<String> extensions = new ArrayList<String>(2);
        extensions.add("");
        extensions.add("_type");
        return extensions;
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        Object retVal = this.coerceValue(value, inputLocale);
        if (retVal != null && retVal instanceof DataSourceInterface && retVal == value) {
            DataSourceInterface dsc;
            try {
                dsc = (DataSourceInterface)((DataSourceInterface)retVal).clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            return dsc;
        }
        return retVal;
    }
}

