/*
 * Decompiled with CFR 0.152.
 */
package com.sas.datatypes;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.BaseDataType;
import com.sas.datatypes.DataSourceType;
import com.sas.datatypes.RB;
import com.sas.models.datasources.BaseDataSource;
import com.sas.models.datasources.BaseDataSourceColumn;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.text.Message;
import com.sas.util.ValueItem;
import com.sas.util.macrovar.MacroVariableOptionInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

@SASScope
public class DataSourceColumnType
extends BaseDataType {
    public static final String RB_KEY = "DataSourceColumnType.";
    public static final DataSourceColumnType DEFAULT_INSTANCE = new DataSourceColumnType();

    @Override
    public Object coerceValue(Object inputValue, Locale inputLocale) throws IllegalArgumentException {
        if (inputValue instanceof List && ((List)inputValue).size() == 1) {
            inputValue = ((List)inputValue).get(0);
        }
        if (inputValue == null) {
            return inputValue;
        }
        if (inputValue instanceof DataSourceColumnInterface) {
            return inputValue;
        }
        if (inputValue instanceof ValueItem) {
            return this.coerceValue(((ValueItem)inputValue).getValue(), inputLocale);
        }
        if (inputValue instanceof String) {
            return this.createDataSourceColumnFromString((String)inputValue, inputLocale);
        }
        if (inputValue instanceof String[] && ((String[])inputValue).length == 1) {
            return this.coerceValue(((String[])inputValue)[0], inputLocale);
        }
        throw new IllegalArgumentException(Message.format(RB.getStringResource(RB_KEY, "dataSourceColumnValueNotValid.ex.txt", inputLocale), inputValue));
    }

    private DataSourceColumnInterface createDataSourceColumnFromString(String text, Locale inputLocale) throws IllegalArgumentException {
        String[] splitText = text.trim().split(" :: ");
        if (splitText.length != 5) {
            throw new IllegalArgumentException(Message.format(RB.getStringResource(RB_KEY, "dataSourceColumnValueNotValid.ex.txt", inputLocale), (Object)text));
        }
        String dataSourceLocation = splitText[0];
        String dataSourceType = splitText[1];
        String columnName = splitText[2];
        String columnLabel = splitText[3];
        String columnType = splitText[4];
        return this.newDataSourceColumn(dataSourceLocation, Long.parseLong(dataSourceType), columnName, columnLabel, Long.parseLong(columnType));
    }

    private DataSourceColumnInterface newDataSourceColumn(String dataSourceLocation, long dataSourceType, String columnName, String columnLabel, long columnType) {
        BaseDataSource dataSource = new BaseDataSource(dataSourceType, dataSourceLocation);
        BaseDataSourceColumn dataSourceColumn = new BaseDataSourceColumn(dataSource, columnName, columnLabel, columnType);
        return dataSourceColumn;
    }

    @Override
    public String getValueAsString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        return DataSourceType.DEFAULT_INSTANCE.getValueAsString(((DataSourceColumnInterface)value).getDataSource(), outputLocale) + " :: " + ((DataSourceColumnInterface)value).getColumnName() + " :: " + ((DataSourceColumnInterface)value).getColumnLabel() + " :: " + ((DataSourceColumnInterface)value).getColumnType();
    }

    @Override
    public String getDisplayString(Object value, Locale outputLocale) {
        if (value == null) {
            return null;
        }
        return ((DataSourceColumnInterface)value).getColumnLabel();
    }

    @Override
    public Object coerceValueFromPersistedString(String input) {
        Object obj = this.coerceValue(input, Locale.US);
        return obj;
    }

    @Override
    public String getPersistanceString(Object value) throws IllegalArgumentException {
        return this.getValueAsString(value, Locale.US);
    }

    @Override
    public int getSQLType() {
        return 2000;
    }

    @Override
    public int getExpressionUsage() {
        return 1111;
    }

    @Override
    public Map getMacroVariableValues(MacroVariableOptionInterface macroInfoSource, Object value, Locale locale) {
        String baseMacroVariableName = macroInfoSource.getMacroVariableBaseName();
        if (value == null) {
            return this.getMacroVariablesForNull(macroInfoSource);
        }
        DataSourceColumnInterface dsc = (DataSourceColumnInterface)value;
        HashMap<String, String> map = new HashMap<String, String>(2);
        if (dsc.getColumnName() != null) {
            map.put(baseMacroVariableName, dsc.getColumnName());
            map.put(baseMacroVariableName + "_type", dsc.getColumnType() + "");
        }
        if (dsc.getDataSource() != null && dsc.getDataSource().getDataSourceLocation() != null) {
            map.put(baseMacroVariableName + "_path", dsc.getDataSource().getDataSourceLocation());
            map.put(baseMacroVariableName + "_source_type", dsc.getDataSource().getDataSourceType() + "");
        }
        return map;
    }

    @Override
    public Collection getPossibleMacroVariableExtensions() {
        ArrayList<String> extensions = new ArrayList<String>(2);
        extensions.add("");
        extensions.add("_path");
        return extensions;
    }

    @Override
    public Object copyValue(Object value, Locale inputLocale) throws IllegalArgumentException {
        Object retVal = this.coerceValue(value, inputLocale);
        if (retVal != null && retVal instanceof DataSourceColumnInterface && retVal == value) {
            DataSourceColumnInterface dsc;
            try {
                dsc = (DataSourceColumnInterface)((DataSourceColumnInterface)retVal).clone();
            }
            catch (CloneNotSupportedException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            return dsc;
        }
        return retVal;
    }
}

