/*
 * Decompiled with CFR 0.152.
 */
package com.sas.beans;

import com.sas.GlobalInfoTable;
import com.sas.InitializeInterface;
import com.sas.beans.BaseCustomizerUtil;
import com.sas.beans.ParentWindowRequestor;
import com.sas.beans.PropertyChangeEvent;
import com.sas.beans.PropertyChangeListenerList;
import com.sas.beans.Util;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Window;
import java.beans.Customizer;
import java.beans.PropertyChangeListener;

public abstract class PropertyEditor
implements java.beans.PropertyEditor,
PropertyChangeListener,
ParentWindowRequestor {
    protected PropertyChangeListenerList propertyChangeListeners = new PropertyChangeListenerList();
    protected Object value;
    protected Window parentWindow;

    @Override
    public void setValue(Object value) {
        if (this.value != null) {
            Util.removePropertyChangeListener(this.value, this);
        }
        this.value = value;
        if (value != null) {
            Util.addPropertyChangeListener(value, this);
        }
        this.firePropertyChange();
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public boolean isPaintable() {
        return false;
    }

    @Override
    public void paintValue(Graphics g, Rectangle rect) {
    }

    @Override
    public String getJavaInitializationString() {
        return "";
    }

    @Override
    public String getAsText() {
        return null;
    }

    @Override
    public void setAsText(String text) {
    }

    @Override
    public String[] getTags() {
        return null;
    }

    protected Class findCustomEditorClass() {
        String className;
        Class customizerClass = null;
        if (this.value != null) {
            customizerClass = BaseCustomizerUtil.getCustomizerClass(this.value);
        }
        if (customizerClass == null && (className = this.getClass().getName()).endsWith("Editor")) {
            String withoutEditor = className.substring(0, className.length() - 6);
            String customizerName = withoutEditor + "Customizer";
            try {
                Class<Customizer> beansCustomizerClass = Customizer.class;
                customizerClass = GlobalInfoTable.loadClass(customizerName);
                if (beansCustomizerClass.isAssignableFrom(customizerClass)) {
                    return customizerClass;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return customizerClass;
    }

    public static Component createCustomEditor(Class customizerClass, Object value) {
        try {
            Component customEditor = (Component)customizerClass.newInstance();
            if (customEditor instanceof InitializeInterface) {
                ((InitializeInterface)((Object)customEditor)).initialize();
            }
            if (customEditor instanceof Customizer) {
                ((Customizer)((Object)customEditor)).setObject(value);
            }
            return customEditor;
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Component getCustomEditor() {
        Class customizerClass = this.findCustomEditorClass();
        if (customizerClass != null) {
            return PropertyEditor.createCustomEditor(customizerClass, this.getValue());
        }
        return null;
    }

    public Window getParentWindow() {
        return this.parentWindow;
    }

    @Override
    public void setParentWindow(Window w) {
        this.parentWindow = w;
    }

    @Override
    public boolean supportsCustomEditor() {
        Class customizerClass = this.findCustomEditorClass();
        return customizerClass != null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.add(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeListeners.remove(listener);
    }

    public void firePropertyChange() {
        this.propertyChangeListeners.propertyChange(new PropertyChangeEvent(this, null, null, null));
    }

    @Override
    public void propertyChange(java.beans.PropertyChangeEvent e) {
        this.firePropertyChange();
    }
}

