/*
 * Decompiled with CFR 0.152.
 */
package com.sas;

import com.sas.RB;
import com.sas.codepolicy.SASScope;
import com.sas.util.Countable;
import com.sas.util.Enum;
import com.sas.util.transforms.MissingValuesToStringTransform;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Locale;

@SASScope(value="ALL")
public final class MissingValues
extends Enum
implements Countable,
Serializable {
    private static final long serialVersionUID = 3156997940011565966L;
    private static final int FLOAT_MISSING_VALUE = -3080192;
    private static MissingValues first = null;
    private long longValue;
    public static final int count = 29;
    public static final MissingValues Z = new MissingValues("Z", 28, -30786325577728L);
    public static final MissingValues Y = new MissingValues("Y", 27, -29686813949952L);
    public static final MissingValues X = new MissingValues("X", 26, -28587302322176L);
    public static final MissingValues W = new MissingValues("W", 25, -27487790694400L);
    public static final MissingValues V = new MissingValues("V", 24, -26388279066624L);
    public static final MissingValues U = new MissingValues("U", 23, -25288767438848L);
    public static final MissingValues T = new MissingValues("T", 22, -24189255811072L);
    public static final MissingValues S = new MissingValues("S", 21, -23089744183296L);
    public static final MissingValues R = new MissingValues("R", 20, -21990232555520L);
    public static final MissingValues Q = new MissingValues("Q", 19, -20890720927744L);
    public static final MissingValues P = new MissingValues("P", 18, -19791209299968L);
    public static final MissingValues O = new MissingValues("O", 17, -18691697672192L);
    public static final MissingValues N = new MissingValues("N", 16, -17592186044416L);
    public static final MissingValues M = new MissingValues("M", 15, -16492674416640L);
    public static final MissingValues L = new MissingValues("L", 14, -15393162788864L);
    public static final MissingValues K = new MissingValues("K", 13, -14293651161088L);
    public static final MissingValues J = new MissingValues("J", 12, -13194139533312L);
    public static final MissingValues I = new MissingValues("I", 11, -12094627905536L);
    public static final MissingValues H = new MissingValues("H", 10, -10995116277760L);
    public static final MissingValues G = new MissingValues("G", 9, -9895604649984L);
    public static final MissingValues F = new MissingValues("F", 8, -8796093022208L);
    public static final MissingValues E = new MissingValues("E", 7, -7696581394432L);
    public static final MissingValues D = new MissingValues("D", 6, -6597069766656L);
    public static final MissingValues C = new MissingValues("C", 5, -5497558138880L);
    public static final MissingValues B = new MissingValues("B", 4, -4398046511104L);
    public static final MissingValues A = new MissingValues("A", 3, -3298534883328L);
    public static final MissingValues Dot = new MissingValues("Dot", 2, -2199023255552L);
    public static final MissingValues UNDERSCORE = new MissingValues("UNDERSCORE", 1, -1099511627776L);
    public static final MissingValues _BLANK_ = new MissingValues("_BLANK_", 0, -1L);

    @Override
    public int count() {
        return 29;
    }

    public MissingValues getNext() {
        return (MissingValues)this.next;
    }

    @Override
    public Enum getNextEnum() {
        return this.next;
    }

    @Override
    public int getIndex() {
        return this.getIndex(this, first);
    }

    public static MissingValues get(int index) {
        return (MissingValues)MissingValues.get(index, (Enum)first);
    }

    public static MissingValues getEnum(int value) {
        return (MissingValues)MissingValues.getEnum(value, first);
    }

    public static MissingValues get(String name) {
        MissingValues enumer = (MissingValues)MissingValues.get(name, (Enum)first);
        if (enumer == null && name != null) {
            if (".".equals(name)) {
                enumer = Dot;
            } else if ("._".equals(name)) {
                enumer = UNDERSCORE;
            } else if (name.startsWith(".") && name.length() == 2) {
                enumer = MissingValues.get(name.substring(1, 2).toUpperCase());
            } else {
                String upperName = name.toUpperCase();
                if (!upperName.equals(name)) {
                    enumer = MissingValues.get(upperName);
                }
            }
        }
        return enumer;
    }

    public static MissingValues toMissingValue(float floatValue) {
        int rawValue = Float.floatToRawIntBits(floatValue);
        if (rawValue == -3080192) {
            return Dot;
        }
        return null;
    }

    public static MissingValues toMissingValue(double doubleValue) {
        if (!Double.isNaN(doubleValue)) {
            return null;
        }
        long rawValue = Double.doubleToRawLongBits(doubleValue);
        for (MissingValues e = MissingValues.getFirst(); e != null; e = e.getNext()) {
            if (e.longValue != rawValue) continue;
            return e;
        }
        return null;
    }

    public float getFloatValue() {
        return Float.intBitsToFloat(-3080192);
    }

    public double getDoubleValue() {
        return Double.longBitsToDouble(this.longValue);
    }

    public void write(ObjectOutputStream os) throws IOException {
        os.writeInt(this.getValue());
    }

    public static MissingValues read(ObjectInputStream is) throws IOException {
        int value = is.readInt();
        MissingValues enumer = MissingValues.getEnum(value);
        if (enumer == null) {
            throw new IOException();
        }
        return enumer;
    }

    public static MissingValues getFirst() {
        return first;
    }

    public static MissingValues[] getEnums() {
        MissingValues[] enums = new MissingValues[29];
        int i = 0;
        for (MissingValues e = MissingValues.getFirst(); e != null; e = e.getNext()) {
            enums[i++] = e;
        }
        return enums;
    }

    @SASScope
    public MissingValues() {
        this("Dot", 2, -2199023255552L);
    }

    private MissingValues(String name, int value, long rawValue) {
        super(name, value);
        this.longValue = rawValue;
        this.next = first;
        first = this;
    }

    @SASScope
    public static MissingValues getCharacterMissingValues(String input) {
        MissingValues retVal = null;
        if (null != input) {
            input = input.toUpperCase();
        }
        if ("_BLANK_".equals(input)) {
            retVal = _BLANK_;
        }
        return retVal;
    }

    @SASScope
    public static MissingValues getNumericMissingValues(String input) {
        MissingValues retVal = null;
        if (null != input) {
            input = input.toUpperCase();
        }
        if (".".equals(input)) {
            retVal = Dot;
        } else if (".A".equals(input)) {
            retVal = A;
        } else if (".B".equals(input)) {
            retVal = B;
        } else if (".C".equals(input)) {
            retVal = C;
        } else if (".D".equals(input)) {
            retVal = D;
        } else if (".E".equals(input)) {
            retVal = E;
        } else if (".F".equals(input)) {
            retVal = F;
        } else if (".G".equals(input)) {
            retVal = G;
        } else if (".H".equals(input)) {
            retVal = H;
        } else if (".I".equals(input)) {
            retVal = I;
        } else if (".J".equals(input)) {
            retVal = J;
        } else if (".K".equals(input)) {
            retVal = K;
        } else if (".L".equals(input)) {
            retVal = L;
        } else if (".M".equals(input)) {
            retVal = M;
        } else if (".N".equals(input)) {
            retVal = N;
        } else if (".O".equals(input)) {
            retVal = O;
        } else if (".P".equals(input)) {
            retVal = P;
        } else if (".Q".equals(input)) {
            retVal = Q;
        } else if (".R".equals(input)) {
            retVal = R;
        } else if (".S".equals(input)) {
            retVal = S;
        } else if (".T".equals(input)) {
            retVal = T;
        } else if (".U".equals(input)) {
            retVal = U;
        } else if (".V".equals(input)) {
            retVal = V;
        } else if (".W".equals(input)) {
            retVal = W;
        } else if (".X".equals(input)) {
            retVal = X;
        } else if (".Y".equals(input)) {
            retVal = Y;
        } else if (".Z".equals(input)) {
            retVal = Z;
        } else if ("._".equals(input)) {
            retVal = UNDERSCORE;
        }
        return retVal;
    }

    @SASScope
    public static String toDisplayString(MissingValues input, Locale locale) {
        String retVal = null;
        if (null != input) {
            retVal = input.equals(_BLANK_) || input.equals(Dot) ? RB.getStringResource("MissingValues.missing.forUserInterface.txt", locale) : (String)MissingValuesToStringTransform.defaultInstance.transform(input);
        }
        return retVal;
    }

    @SASScope
    public static String toQueryString(MissingValues input) {
        String retVal = null;
        if (null != input) {
            retVal = input.equals(_BLANK_) ? " " : (String)MissingValuesToStringTransform.defaultInstance.transform(input);
        }
        return retVal;
    }

    protected Object readResolve() throws ObjectStreamException {
        int v = this.getValue();
        if (v == 0) {
            return _BLANK_;
        }
        if (v == 1) {
            return UNDERSCORE;
        }
        if (v == 2) {
            return Dot;
        }
        if (v == 3) {
            return A;
        }
        if (v == 4) {
            return B;
        }
        if (v == 5) {
            return C;
        }
        if (v == 6) {
            return D;
        }
        if (v == 7) {
            return E;
        }
        if (v == 8) {
            return F;
        }
        if (v == 9) {
            return G;
        }
        if (v == 10) {
            return H;
        }
        if (v == 11) {
            return I;
        }
        if (v == 12) {
            return J;
        }
        if (v == 13) {
            return K;
        }
        if (v == 14) {
            return L;
        }
        if (v == 15) {
            return M;
        }
        if (v == 16) {
            return N;
        }
        if (v == 17) {
            return O;
        }
        if (v == 18) {
            return P;
        }
        if (v == 19) {
            return Q;
        }
        if (v == 20) {
            return R;
        }
        if (v == 21) {
            return S;
        }
        if (v == 22) {
            return T;
        }
        if (v == 23) {
            return U;
        }
        if (v == 24) {
            return V;
        }
        if (v == 25) {
            return W;
        }
        if (v == 26) {
            return X;
        }
        if (v == 27) {
            return Y;
        }
        if (v == 28) {
            return Z;
        }
        return null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeInt(this.getValue());
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        super.setValue(in.readInt());
    }
}

