/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.webservices;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.visuals.LayoutConstants;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.logical.webservices.RB;
import com.sas.web.services.common.WebServiceInfo;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextField;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

@SASScope
public class WebServiceKeywordsAndNamespacePanel
extends WsDescriptionWizardTab
implements LayoutConstants,
ListSelectionListener {
    private static final long serialVersionUID = 1L;
    private JLabel _lblKeywords;
    private JList _lstKeywords;
    private JScrollPane _scrKeywords;
    private JButton _btnAddKeyword;
    private JButton _btnDeleteKeyword;
    private WebServiceInfo _wsInfo;
    private JLabel _lblNamespace;
    private WATextField _txtNamespace;

    public WebServiceKeywordsAndNamespacePanel(WebServiceInfo webServiceInfo) {
        super(RB.getStringResource("WSKANP.Wiz.txt"));
        this._wsInfo = webServiceInfo;
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        this.setName(RB.getStringResource("WSKANP.Tab.txt"));
        this.setHelpProduct("webservices");
        this.setHelpTopic("namespacewin");
        this._txtNamespace = new WATextField();
        this._txtNamespace.setMaxCharacters(200);
        this._txtNamespace.setToolTipText(RB.getStringResource("WSKANP.Namespace.tip"));
        this._lblNamespace = UtilGui.createLabelForComponent((Component)this._txtNamespace, (String)RB.getStringResource("WSKANP.Lbl.Namespace.txt"));
        this._lstKeywords = new JList(this._wsInfo.getKeywordListModel());
        this._lstKeywords.putClientProperty("html.disable", Boolean.TRUE);
        this._lstKeywords.setVisibleRowCount(6);
        this._lstKeywords.setToolTipText(RB.getStringResource("WSKANP.KeywordList.tip"));
        this._lstKeywords.setSelectionMode(0);
        this._lstKeywords.addListSelectionListener(this);
        this._scrKeywords = new JScrollPane(this._lstKeywords);
        this._lblKeywords = UtilGui.createLabelForComponent((Component)this._scrKeywords, (String)RB.getStringResource("WSKANP.KeywordList.Label.txt"));
        this._btnAddKeyword = UtilGui.createButton((String)RB.getStringResource("WSKANP.KeywordList.AddButton.txt"));
        this._btnAddKeyword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                String keyword = WebServiceKeywordsAndNamespacePanel.this.doAddKeyword(WebServiceKeywordsAndNamespacePanel.this._wsInfo.getKeywordListModel());
                if (keyword != null) {
                    WebServiceKeywordsAndNamespacePanel.this._wsInfo.getKeywordListModel().addElement(keyword);
                }
            }
        });
        this._btnDeleteKeyword = UtilGui.createButton((String)RB.getStringResource("WSKANP.Btn.DeleteKeyword.txt"));
        this._btnDeleteKeyword.setEnabled(false);
        this._btnDeleteKeyword.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                int selected = WebServiceKeywordsAndNamespacePanel.this._lstKeywords.getSelectedIndex();
                if (selected != -1) {
                    WebServiceKeywordsAndNamespacePanel.this._wsInfo.getKeywordListModel().remove(selected);
                    if (WebServiceKeywordsAndNamespacePanel.this._wsInfo.getKeywordListModel().getSize() == 0) {
                        WebServiceKeywordsAndNamespacePanel.this._btnDeleteKeyword.setEnabled(false);
                    }
                }
            }
        });
    }

    protected String doAddKeyword(DefaultListModel currentKeywords) {
        Container tla = this.getTopLevelAncestor();
        WAStandardDialog keywordDialog = null;
        WAPanel keywordPanel = new WAPanel();
        WATextField txtKeyword = new WATextField();
        txtKeyword.setMaxCharacters(60);
        txtKeyword.setToolTipText(RB.getStringResource("WSKANP.KeywordDialog.tip"));
        JLabel lblKeywordName = UtilGui.createLabelForComponent((Component)txtKeyword, (String)RB.getStringResource("WSKANP.KeywordDialog.Label.txt"));
        keywordPanel.setLayout((LayoutManager)new GridBagLayout());
        int row = 0;
        keywordPanel.add((Component)lblKeywordName, (Object)new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_TOP_ROW, 0, 0));
        keywordPanel.add((Component)txtKeyword, (Object)new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_TOP_ROW, 0, 0));
        String dialogTitle = RB.getStringResource("WSKANP.KeywordDialog.Title.txt");
        if (tla instanceof Frame) {
            keywordDialog = new WAStandardDialog((Frame)tla, dialogTitle, true, keywordPanel);
        } else if (tla instanceof Dialog) {
            keywordDialog = new WAStandardDialog((Dialog)tla, dialogTitle, true, keywordPanel);
        }
        keywordDialog.setResizable(true);
        boolean valid = false;
        int retval = 1;
        String keywordAdded = null;
        while (!valid && retval != 2) {
            keywordDialog.show();
            retval = keywordDialog.getReturnValue();
            keywordAdded = txtKeyword.getText().trim();
            if (retval != 2 && keywordAdded.equals("")) {
                MessageUtil.displayMessage((String)RB.getStringResource("WSKANP.KeywordDialog.EmptyKeyword.title.txt"), (String)RB.getStringResource("WSKANP.KeywordDialog.EmptyKeyword.txt"), (int)0, (int)-1);
                valid = false;
                continue;
            }
            if (retval != 2 && currentKeywords.contains(keywordAdded)) {
                MessageUtil.displayMessage((String)RB.getStringResource("WSKANP.KeywordDialog.DuplicateKeyword.txt"), (String)RB.getStringResource("WSKANP.KeywordDialog.DuplicateKeyword.title.txt"), (int)0, (int)-1);
                valid = false;
                continue;
            }
            valid = true;
        }
        if (retval == 1) {
            return txtKeyword.getText();
        }
        return null;
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        int row = 0;
        this.add(this._lblNamespace, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        this.add((Component)this._txtNamespace, new GridBagConstraints(1, row, 0, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_ROW, 0, 0));
        ++row;
        JPanel pnlKeywordsButtons = new JPanel();
        GridLayout gridLayout = new GridLayout(2, 1);
        gridLayout.setVgap(5);
        pnlKeywordsButtons.setLayout(gridLayout);
        pnlKeywordsButtons.add(this._btnAddKeyword);
        pnlKeywordsButtons.add(this._btnDeleteKeyword);
        this.add(this._lblKeywords, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        this.add(this._scrKeywords, new GridBagConstraints(1, row, -1, 1, 1.0, 1.0, 18, 1, NEXT_INSETS_IN_ROW, 0, 0));
        this.add(pnlKeywordsButtons, new GridBagConstraints(2, row, 0, 1, 0.0, 0.0, 18, 0, NEXT_INSETS_IN_ROW, 0, 0));
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this._lstKeywords.setEnabled(editable);
        this._scrKeywords.setEnabled(editable);
        this._btnAddKeyword.setEnabled(editable);
        this._lblKeywords.setEnabled(editable);
    }

    public boolean validateData() {
        String namespaceStr = this._txtNamespace.getText();
        if (namespaceStr != null && !namespaceStr.trim().equals("")) {
            try {
                new URI(namespaceStr.trim());
            }
            catch (URISyntaxException e) {
                MessageUtil.displayMessage((String)MessageFormat.format(RB.getStringResource("GSSIT.Namespace.fmt.txt"), RB.getStringResource("WSIP.UrlErr.title.txt")), (String)RB.getStringResource("COM.IntError.title.txt"), (int)0);
                return false;
            }
        }
        this.moveDataToStore();
        this.setDataChanged(true);
        return true;
    }

    public void moveDataToView() {
        this._txtNamespace.setText(this._wsInfo.getDeployedWebServiceNamespace());
    }

    public void moveDataToStore() {
        this._wsInfo.setDeployedWebServiceNamespace(this._txtNamespace.getText());
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (saveToModel) {
            this.moveDataToStore();
        } else {
            this.moveDataToView();
        }
        return true;
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        Object source = arg0.getSource();
        if (source instanceof JList) {
            JList sourceList = (JList)source;
            if (sourceList.getSelectedIndex() != -1) {
                this._btnDeleteKeyword.setEnabled(true);
            } else {
                this._btnDeleteKeyword.setEnabled(false);
            }
        }
    }
}

