/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.webservices;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.visuals.LayoutConstants;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.logical.webservices.RB;
import com.sas.web.services.common.WebServiceInfo;
import com.sas.workspace.WATextField;
import com.sas.workspace.WsDescriptionWizardTab;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;

@SASScope
public class WebServiceConfirmationPanel
extends WsDescriptionWizardTab
implements LayoutConstants {
    private static final long serialVersionUID = 1L;
    private WebServiceInfo _wsInfo;
    static final Logger log = Logger.getLogger(WebServiceConfirmationPanel.class.getName());
    private JLabel _lblUrl;
    private WATextField _txtUrl;
    private JLabel _lblName;
    private WATextField _txtName;
    private JLabel _lblStps;
    private JList _lstStps;
    private JScrollPane _scrollPaneStps;
    private JLabel _lblKeywords;
    private JList _lstKeywords;
    private JScrollPane _scrKeywords;
    private JLabel _lblNamespace;
    private WATextField _txtNamespace;

    public WebServiceConfirmationPanel(WebServiceInfo webServiceInfo) {
        super(RB.getStringResource("WSCP.Wiz.txt"));
        this._wsInfo = webServiceInfo;
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        this.setName(RB.getStringResource("WSCP.Tab.txt"));
        this.setHelpProduct("webservices");
        this.setHelpTopic("confirmdeploywin");
        this._txtUrl = new WATextField();
        this._txtUrl.setMaxCharacters(2083);
        this._txtUrl.setToolTipText(RB.getStringResource("WSIP.Url.tip"));
        this._txtUrl.setEditable(false);
        this._lblUrl = UtilGui.createLabelForComponent((Component)this._txtUrl, (String)RB.getStringResource("WSIP.Lbl.Url.txt"));
        this._txtName = new WATextField();
        this._txtName.setMaxCharacters(60);
        this._txtName.setToolTipText(RB.getStringResource("WSIP.WebServiceName.tip"));
        this._txtName.setEditable(false);
        this._lblName = UtilGui.createLabelForComponent((Component)this._txtName, (String)RB.getStringResource("WSIP.Lbl.WebServiceName.txt"));
        this._txtNamespace = new WATextField();
        this._txtNamespace.setToolTipText(RB.getStringResource("WSKANP.Namespace.tip"));
        this._txtNamespace.setEditable(false);
        this._lblNamespace = UtilGui.createLabelForComponent((Component)this._txtNamespace, (String)RB.getStringResource("WSKANP.Lbl.Namespace.txt"));
        this._lstStps = new JList();
        this._scrollPaneStps = new JScrollPane(this._lstStps);
        this._scrollPaneStps.setToolTipText(RB.getStringResource("WSCP.STPS.tip"));
        this._lblStps = UtilGui.createLabelForComponent((Component)this._scrollPaneStps, (String)RB.getStringResource("WSCP.Lbl.STPS.txt"));
        this._lstKeywords = new JList(this._wsInfo.getKeywordListModel());
        this._scrKeywords = new JScrollPane(this._lstKeywords);
        this._scrKeywords.setToolTipText(RB.getStringResource("WSKANP.KeywordList.tip"));
        this._lblKeywords = UtilGui.createLabelForComponent((Component)this._scrKeywords, (String)RB.getStringResource("WSKANP.KeywordList.Label.txt"));
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        int row = 0;
        this.add(this._lblUrl, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        this.add((Component)this._txtUrl, new GridBagConstraints(1, row, 0, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_ROW, 0, 0));
        this.add(this._lblName, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        this.add((Component)this._txtName, new GridBagConstraints(1, row, 0, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_ROW, 0, 0));
        this.add(this._lblNamespace, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        this.add((Component)this._txtNamespace, new GridBagConstraints(1, row, 0, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_ROW, 0, 0));
        this.add(this._lblStps, new GridBagConstraints(0, ++row, 3, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        this.add(this._scrollPaneStps, new GridBagConstraints(0, ++row, 3, 1, 1.0, 1.0, 10, 1, FIRST_INSETS_IN_ROW, 0, 0));
        this.add(this._lblKeywords, new GridBagConstraints(0, ++row, 3, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        this.add(this._scrKeywords, new GridBagConstraints(0, ++row, 3, 1, 1.0, 1.0, 10, 1, FIRST_INSETS_IN_ROW, 0, 0));
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this._txtUrl.setEditable(editable);
        this._txtName.setEditable(editable);
    }

    public void moveDataToView() {
        this._txtName.setText(this._wsInfo.getDeployedWebServiceName());
        this._txtUrl.setText(this._wsInfo.getWebServiceMakerUrl());
        this._txtNamespace.setText(this._wsInfo.getDeployedWebServiceNamespace());
        String[] stps = this._wsInfo.getStoredProcesses();
        if (stps != null) {
            this._lstStps = new JList<String>(stps);
            this._scrollPaneStps.getViewport().setView(this._lstStps);
        } else {
            this._lstStps = new JList();
            this._scrollPaneStps.getViewport().setView(this._lstStps);
        }
    }

    public boolean doDataExchange(boolean saveToModel) {
        if (saveToModel) {
            return true;
        }
        this.moveDataToView();
        return true;
    }
}

