/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.webservices;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.promotion.ConnectionPoint;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportNameValidatorInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@SASScope
public class GeneratedSoapServiceNameValidator
implements ImportNameValidatorInterface {
    protected static final String DC_INXML = "<DeployedComponent Id=''{0}'' />";
    protected static final String DC_TEMPLATE = "<SoftwareComponent Id=\"\" Name=\"\"><DescriptiveComponent /></SoftwareComponent>";
    protected static final String DUPLICATE_DC_XMLSELECT = "<XMLSelect search=\"*[@Name=''{0}''][DescriptiveComponent/SoftwareComponent[@Id=''{1}'']]\" />";

    public boolean validateName(ImportItemInterface importItem, ImportOperationInterface importOperation) throws MdException {
        MdObjectStore mdStore = importOperation.getStore();
        String parentId = null;
        for (ConnectionPoint cp : importItem.getConnectionPoints()) {
            if (!cp.getMetadataType().equals("SoftwareComponent")) continue;
            parentId = cp.getTargetID();
        }
        try {
            if (parentId != null) {
                Pattern p = Pattern.compile("[ ]");
                Matcher m = p.matcher(importItem.getName());
                String serviceName = m.replaceAll("");
                String xmlSelect = MessageFormat.format(DUPLICATE_DC_XMLSELECT, serviceName, parentId);
                List duplicateNamedDcs = importOperation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)mdStore, importOperation.getRepositoryID(), "DeployedComponent", 152, xmlSelect);
                return duplicateNamedDcs.size() <= 0;
            }
            importOperation.getLogger().warn((Object)"Parent SoftwareComponent was not found");
            return true;
        }
        catch (RemoteException e) {
            throw new MdException((Throwable)e);
        }
    }
}

