/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.webservices;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.visuals.SmartWsDescriptionWizardTab;
import com.sas.metadata.logical.webservices.GeneratedSoapServiceLogicalObject;
import com.sas.metadata.logical.webservices.RB;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Property;
import com.sas.services.ServiceException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.user.UserContextInterface;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.adapters.ProportionalSpacePartitioner;
import com.sas.visuals.adapters.SpacePartitionerInterface;
import com.sas.workspace.Workspace;
import java.awt.LayoutManager;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

@SASScope
public class GeneratedSoapServiceInfoTab
extends SmartWsDescriptionWizardTab {
    private GeneratedSoapServiceLogicalObject gssLogicalObject;
    private JScrollPane storedProcessesScrollBox;
    private JList storedProcessesList;
    private JLabel storedProcessesLabel;
    private MdObjectStore mdObjectStore;
    private DeployedComponent gssDeployedComponent;
    private JLabel namespaceLabel;
    private JTextField namespaceTextBox;
    public static final String namespacePropertyName = "Namespace";
    private static final long serialVersionUID = 1L;

    public void saveSettingsAndCleanUp() {
        super.saveSettingsAndCleanUp();
        try {
            if (this.gssDeployedComponent != null) {
                this.gssDeployedComponent.dispose();
                this.gssDeployedComponent = null;
            }
            if (this.mdObjectStore != null) {
                this.mdObjectStore.dispose();
                this.mdObjectStore = null;
            }
        }
        catch (RemoteException e) {
            e.printStackTrace();
        }
    }

    public GeneratedSoapServiceInfoTab(GeneratedSoapServiceLogicalObject gssLO) {
        this.gssLogicalObject = gssLO;
        this.setHelpProduct("shared");
        this.setHelpTopic("webserv_servicetab");
        this.setName(RB.getStringResource("GSSIT.Tab.txt"));
        this.setDescription(RB.getStringResource("GSSIT.Tab.txt"));
        this.layoutWidgets();
    }

    protected void layoutWidgets() {
        int numRows = 4;
        int numCols = 1;
        AutoSizingGridLayout layout = new AutoSizingGridLayout(numRows, numCols, 5, 5, true, true, true);
        double[] sizes = new double[numRows];
        int[] mins = new int[numRows];
        this.setLayout((LayoutManager)layout);
        this.namespaceLabel = new JLabel(RB.getStringResource("WSKANP.Lbl.Namespace.txt"));
        sizes[0] = -2.0;
        mins[0] = 0;
        this.add(this.namespaceLabel);
        this.namespaceTextBox = new JTextField();
        this.namespaceTextBox.setEditable(false);
        sizes[1] = -2.0;
        mins[1] = 0;
        this.add(this.namespaceTextBox);
        this.storedProcessesLabel = new JLabel(RB.getStringResource("GSSIT.StoredProcessList.txt"));
        sizes[2] = -2.0;
        mins[2] = 0;
        this.add(this.storedProcessesLabel);
        this.storedProcessesList = new JList();
        this.storedProcessesScrollBox = new JScrollPane(this.storedProcessesList);
        sizes[3] = 1.0;
        mins[3] = 200;
        this.add(this.storedProcessesScrollBox);
        ProportionalSpacePartitioner psp = new ProportionalSpacePartitioner(sizes, mins, null);
        layout.setRowSpacePartitioner((SpacePartitionerInterface)psp);
    }

    protected void smartPopulateStore() throws MdException, RemoteException {
        super.smartPopulateStore();
        this.mdObjectStore = this.gssLogicalObject.getTypeInterface().getObjectFactory().getFactory().getMdFactory().createObjectStore();
        this.gssDeployedComponent = this.gssLogicalObject.getUnderlyingDeployedComponent(this.mdObjectStore);
    }

    public void moveDataToView() throws MdException, RemoteException {
        super.moveDataToView();
        AssociationList classifierMaps = this.gssDeployedComponent.getImplementedObjects();
        Vector<String> storedProcesses = new Vector<String>();
        try {
            Workspace workspace = Workspace.getWorkspace();
            UserContextInterface userContext = workspace.getUserContext();
            ServerInterface serverInterface = userContext.getAuthServer();
            for (ClassifierMap cm : classifierMaps) {
                String infoSvcsKey = cm.getId() + "/" + cm.getCMetadataType();
                MetadataInterface storedProcess = serverInterface.fetch(infoSvcsKey);
                PathUrl path = storedProcess.getPathUrl();
                storedProcesses.add(path.getDisplayPath());
            }
        }
        catch (ServiceException e) {
            throw new RemoteException(e.getMessage(), e.getCause());
        }
        AssociationList properties = this.gssDeployedComponent.getProperties();
        boolean namespaceFound = false;
        for (Property prop : properties) {
            if (!prop.getName().equalsIgnoreCase(namespacePropertyName)) continue;
            this.namespaceTextBox.setText(prop.getDefaultValue());
            namespaceFound = true;
            break;
        }
        if (!namespaceFound) {
            this.namespaceTextBox.setText(RB.getStringResource("GSSIT.NamespaceMissing.txt"));
        }
        this.storedProcessesList.setListData(storedProcesses);
    }
}

