/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.webservices;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.storedprocess.StoredProcessConnectionType;
import com.sas.metadata.logical.webservices.GeneratedSoapServiceImportItem;
import com.sas.metadata.logical.webservices.GeneratedSoapServiceImportOptionsPanel;
import com.sas.metadata.logical.webservices.GeneratedSoapServiceNameValidator;
import com.sas.metadata.logical.webservices.RB;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ConnectionPoint;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportNameValidatorInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.visuals.PromotionOptionsInterface;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.Keyword;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.metadata.remote.Tree;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.user.UserContextInterface;
import com.sas.svcs.commons.webservice.omrclient.ServiceRegistryHelper;
import com.sas.svcs.registry.client.ServiceRegistryInterface;
import com.sas.web.services.common.WebServiceMaker;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JPanel;
import org.apache.axis2.AxisFault;
import org.springframework.remoting.httpinvoker.HttpInvokerProxyFactoryBean;

@SASScope
public class GeneratedSoapServiceImportListener
extends AbstractImportListener
implements PromotionOptionsInterface {
    protected GeneratedSoapServiceImportOptionsPanel _optionsPanel;
    protected static GeneratedSoapServiceNameValidator _nameValidator;
    public static final String REGISTERED_SAS_SERVICES_TREE_NAME = "Registered SAS Services";
    protected static final Class[] CONNECTION_TYPES;

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    public GeneratedSoapServiceImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public int importContent(ImportOperationInterface operation, List objects) throws TransportException, IOException {
        int retVal = 0;
        boolean fail = false;
        TransportException importException = null;
        for (GeneratedSoapServiceImportItem item : objects) {
            DeployedComponent targetObject = null;
            try {
                List mdObjects = operation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)operation.getStore(), operation.getFoundationRepositoryID(), "SoftwareComponent", 389, "<XMLSelect search=\"*[DeployedComponents/DeployedComponent[@Id='" + item.getTargetID() + "']]\" /><Templates><SoftwareComponent><DeployedComponents /></SoftwareComponent><DeployedComponent Name=\"\" ><SourceConnections /><ImplementedObjects /></DeployedComponent><TCPIPConnection CommunicationProtocol=\"\" HostName=\"\" Port=\"\" Service=\"\" /></Templates>");
                if (mdObjects != null && mdObjects.size() > 0) {
                    SoftwareComponent sc = (SoftwareComponent)mdObjects.get(0);
                    WebServiceMaker wsm = null;
                    ArrayList<MetadataInterface> classifierMaps = null;
                    for (DeployedComponent dc : sc.getDeployedComponents()) {
                        if (dc.getName().equals("WebServiceMaker")) {
                            wsm = new WebServiceMaker(dc);
                        } else if (dc.getId().equals(item.getTargetID())) {
                            targetObject = dc;
                            classifierMaps = new ArrayList<MetadataInterface>();
                            for (Object implementedObject : dc.getImplementedObjects()) {
                                if (!(implementedObject instanceof ClassifierMap)) continue;
                                classifierMaps.add(PromotionUtil.getSmartObject((PromotionInterface)operation, (CMetadata)((ClassifierMap)implementedObject)));
                            }
                        }
                        if (wsm == null || classifierMaps == null) continue;
                        break;
                    }
                    if (wsm == null || classifierMaps == null) {
                        fail = true;
                        importException = new TransportException(MessageFormat.format(RB.getStringResource("GSSIL.ImportContent.MetadataError.fmt.txt"), item.getName()));
                        break;
                    }
                    List existingServices = wsm.listWebServices(operation.getUserContext());
                    if (existingServices.contains(item.getName())) {
                        retVal = 4;
                        operation.getLogger().warn((Object)MessageFormat.format(RB.getStringResource("GSSIL.ExistingServiceWarning.fmt.txt"), item.getName()));
                        if (item.isOverwriteService()) {
                            // empty if block
                        }
                    } else {
                        Object connection;
                        String[] paths = new String[classifierMaps.size()];
                        int i = 0;
                        Iterator cmIt = classifierMaps.iterator();
                        while (cmIt.hasNext()) {
                            String spPath;
                            PathUrl path = ((MetadataInterface)cmIt.next()).getPathUrl();
                            paths[i] = spPath = path.getDisplayPath();
                            ++i;
                        }
                        String namespace = null;
                        AssociationList targetProperties = targetObject.getProperties();
                        for (Property prop : targetProperties) {
                            if (!prop.getName().equalsIgnoreCase("Namespace") || prop.getDefaultValue().trim().equals("")) continue;
                            namespace = prop.getDefaultValue().trim();
                            break;
                        }
                        AssociationList keywordsList = targetObject.getKeywords();
                        String[] keywords = new String[keywordsList.size()];
                        int keywordIndex = 0;
                        for (Keyword keyword : keywordsList) {
                            keywords[keywordIndex] = keyword.getName();
                            ++keywordIndex;
                        }
                        URL newService = wsm.makeWebService(item.getName(), paths, namespace, keywords, operation.getUserContext(), false);
                        TCPIPConnection sourceConnection = null;
                        Iterator sourceIt = targetObject.getSourceConnections().iterator();
                        while (!(!sourceIt.hasNext() || (connection = sourceIt.next()) instanceof TCPIPConnection && (sourceConnection = (TCPIPConnection)connection).getName().equals("Connection URI"))) {
                        }
                        if (sourceConnection == null) {
                            fail = true;
                            importException = new TransportException(MessageFormat.format(RB.getStringResource("GSSIL.ImportContent.MetadataError.fmt.txt"), item.getName()));
                            break;
                        }
                        sourceConnection.setHostName(newService.getHost());
                        sourceConnection.setPort(newService.getPort() != -1 ? newService.getPort() : 80);
                        sourceConnection.setApplicationProtocol(newService.getProtocol());
                        sourceConnection.setService(newService.getPath());
                    }
                }
            }
            catch (MdException e) {
                fail = true;
                importException = new TransportException((Throwable)e, e.getLocalizedMessage());
            }
            catch (ServiceException e) {
                fail = true;
                importException = new TransportException((Throwable)e, e.getLocalizedMessage());
            }
            catch (AxisFault e) {
                fail = true;
                importException = new TransportException((Throwable)e, MessageFormat.format(RB.getStringResource("GSSIL.ImportContent.AxisFault.fmt.txt"), item.getName()));
            }
            if (fail) {
                retVal = 8;
                if (targetObject != null) {
                    targetObject.delete();
                }
                if (importException == null) continue;
                throw importException;
            }
            try {
                targetObject.updateMetadataAll();
                UserContextInterface userContext = operation.getSessionContext().getUserContext();
                String clientUrl = ServiceRegistryHelper.getClientAccessURL((UserContextInterface)userContext);
                HttpInvokerProxyFactoryBean proxyFactory = new HttpInvokerProxyFactoryBean();
                proxyFactory.setServiceUrl(clientUrl);
                proxyFactory.setServiceInterface(ServiceRegistryInterface.class);
                proxyFactory.afterPropertiesSet();
                ServiceRegistryInterface serviceRegistry = (ServiceRegistryInterface)proxyFactory.getObject();
                serviceRegistry.reload();
            }
            catch (IllegalStateException e) {
                throw new TransportException((Throwable)e, e.getLocalizedMessage());
            }
            catch (ServiceException e) {
                throw new TransportException((Throwable)e, e.getLocalizedMessage());
            }
            catch (MdException e) {
                retVal = 4;
                operation.getLogger().warn((Object)MessageFormat.format(RB.getStringResource("GSSIL.ImportContent.MetadataError.fmt.txt"), item.getName()));
            }
        }
        return retVal;
    }

    public ImportItemInterface createImportItem(String name, String id, TransportableTypeInterface type) {
        return new GeneratedSoapServiceImportItem(name, id, type);
    }

    public JPanel getOptionsPanel(ExportItemInterface[] items, ExportOperationInterface handler) {
        return null;
    }

    public JPanel getOptionsPanel(ImportItemInterface[] items, ImportOperationInterface handler) {
        return null;
    }

    public synchronized ImportNameValidatorInterface getNameValidatorInterface() {
        if (_nameValidator == null) {
            _nameValidator = new GeneratedSoapServiceNameValidator();
        }
        return _nameValidator;
    }

    public void saveSettings() {
        if (this._optionsPanel != null) {
            this._optionsPanel.saveSettings();
        }
    }

    public int updateObjects(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        for (ImportItemInterface item : objects) {
            try {
                ArrayList<String> complexObjects = new ArrayList<String>(1);
                complexObjects.add("Tree");
                DeployedComponent dc = (DeployedComponent)operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)operation.getStore(), "DeployedComponent", item.getTargetID(), null, complexObjects, "", 1);
                Pattern p = Pattern.compile("[ ]");
                Matcher m = p.matcher(dc.getName());
                dc.setName(m.replaceAll(""));
                boolean hasWipKeyword = false;
                Iterator keywordIt = dc.getKeywords().iterator();
                while (keywordIt.hasNext()) {
                    if (!((Keyword)keywordIt.next()).getName().equals("WIP")) continue;
                    hasWipKeyword = true;
                    break;
                }
                if (!hasWipKeyword) continue;
                dc.setClassIdentifier(dc.getName() + " SOAP");
                List registeredSasServicesTrees = operation.getMetadataFactory().getOMIUtil().getMetadataObjectsSubset((MdStore)operation.getStore(), operation.getRepositoryID(), "Tree", 128, "<XMLSelect search=\"*[@Name='Registered SAS Services']\" />");
                if (registeredSasServicesTrees == null || registeredSasServicesTrees.size() <= 0 || ((Tree)registeredSasServicesTrees.get(0)).getPublicType() != null && !((Tree)registeredSasServicesTrees.get(0)).getPublicType().equals("")) continue;
                dc.getTrees().add((Object)((Tree)registeredSasServicesTrees.get(0)));
            }
            catch (RemoteException e) {
                throw new MetadataPromotionException((Throwable)e);
            }
            catch (MdException e) {
                throw new MetadataPromotionException((Throwable)e);
            }
        }
        return 0;
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List objects) throws MetadataPromotionException {
        for (Object importItem : objects) {
            if (!(importItem instanceof GeneratedSoapServiceImportItem)) continue;
            boolean foundSP = false;
            GeneratedSoapServiceImportItem item = (GeneratedSoapServiceImportItem)((Object)importItem);
            List connectionPoints = item.getConnectionPoints();
            for (ConnectionPoint connectionPoint : connectionPoints) {
                if (connectionPoint.getPublicType() == null || !connectionPoint.getPublicType().equals("StoredProcess")) continue;
                foundSP = true;
            }
            if (foundSP) continue;
            throw new MetadataPromotionException("No stored processes found. A Generated SOAP Service must have at least one stored process.");
        }
        return 0;
    }

    public int updateConnectionPoints(ImportOperationInterface operation, List objects, List connections) throws MetadataPromotionException {
        for (Object cur : objects) {
            if (!(cur instanceof GeneratedSoapServiceImportItem)) continue;
            List connectionPoints = ((GeneratedSoapServiceImportItem)((Object)cur)).getConnectionPoints();
            for (ConnectionPoint connectionPoint : connectionPoints) {
                if (connectionPoint.getMetadataType().equals("SoftwareComponent")) {
                    try {
                        List scObjs = null;
                        connectionPoint.addSourceSearch("*[@Name='BI Web Services for .NET 9.2']");
                        connectionPoint.addSourceSearch("*[@Name='BI Web Services for Java 9.4']");
                        Iterator sourceSearchIt = connectionPoint.getSourceSearchList().iterator();
                        while (sourceSearchIt.hasNext()) {
                            String xmlSelect = "<XMLSelect search=\"" + (String)sourceSearchIt.next() + "\" />";
                            scObjs = operation.getMetadataFactory().getOMIUtil().getMetadataObjectsNoCache(connectionPoint.getMetadataType(), operation.getRepositoryID(), xmlSelect, 8320);
                            if (scObjs == null || scObjs.size() <= 0) continue;
                            break;
                        }
                        if (scObjs == null || scObjs.size() <= 0) continue;
                        Map map = (Map)scObjs.get(0);
                        connectionPoint.setTargetID((String)map.get("Id"));
                        connections.add(connectionPoint);
                        continue;
                    }
                    catch (MdException e) {
                        throw new MetadataPromotionException((Throwable)e);
                    }
                    catch (RemoteException e) {
                        throw new MetadataPromotionException((Throwable)e);
                    }
                }
                if (connectionPoint.getPublicType() == null || !connectionPoint.getPublicType().equals("StoredProcess") || connectionPoint.getTargetID() != null || operation.getImportItem(connectionPoint.getSourceID(), connectionPoint.getPublicType()) != null) continue;
                throw new MetadataPromotionException("No stored processes found. A Generated SOAP Service must have at least one stored process.");
            }
        }
        return 0;
    }

    static {
        CONNECTION_TYPES = new Class[]{StoredProcessConnectionType.class};
    }
}

