/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.webservices;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.DeployedComponent;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.SoftwareComponent;
import com.sas.metadata.remote.TCPIPConnection;
import com.sas.services.ServiceException;
import com.sas.services.user.UserContextInterface;
import com.sas.web.services.common.WebServiceMaker;
import com.sas.workspace.Workspace;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import org.apache.axis2.AxisFault;

@SASScope
public class DeleteGeneratedSoapService {
    public static boolean Delete(DeployedComponent deployedComponent) throws RemoteException, MdException {
        return DeleteGeneratedSoapService.DeleteWebService(deployedComponent);
    }

    private static boolean DeleteWebService(DeployedComponent deployedComponent) throws RemoteException, MdException {
        WebServiceMaker webServiceMaker = null;
        SoftwareComponent parent = deployedComponent.getDescriptiveComponent();
        if (parent != null) {
            AssociationList siblings = parent.getDeployedComponents();
            for (DeployedComponent sibling : siblings) {
                if (!sibling.getName().equals("WebServiceMaker")) continue;
                webServiceMaker = new WebServiceMaker(sibling);
                break;
            }
            if (webServiceMaker != null) {
                UserContextInterface uc = Workspace.getWorkspace().getUserContext();
                try {
                    webServiceMaker.deleteService(deployedComponent.getName(), uc);
                    return true;
                }
                catch (ServiceException e) {
                    return DeleteGeneratedSoapService.DeleteServiceFromDCURL(deployedComponent, uc);
                }
                catch (AxisFault e) {
                    return DeleteGeneratedSoapService.DeleteServiceFromDCURL(deployedComponent, uc);
                }
            }
            return false;
        }
        return false;
    }

    private static boolean DeleteServiceFromDCURL(DeployedComponent deployedComponent, UserContextInterface uc) {
        try {
            TCPIPConnection tcpip = null;
            WebServiceMaker webServiceMaker = null;
            AssociationList sourceConnections = deployedComponent.getSourceConnections();
            for (TCPIPConnection current : sourceConnections) {
                if (!current.getName().equals("Connection URI")) continue;
                tcpip = current;
                break;
            }
            if (tcpip != null) {
                String newService = null;
                newService = tcpip.getService().endsWith(".asmx") ? tcpip.getService().substring(0, tcpip.getService().lastIndexOf(47) + 1) + "WebServiceMaker.asmx" : tcpip.getService().substring(0, tcpip.getService().lastIndexOf(47) + 1) + "WebServiceMaker";
                webServiceMaker = new WebServiceMaker(new URL(tcpip.getCommunicationProtocol(), tcpip.getHostName(), tcpip.getPort(), newService));
                webServiceMaker.deleteService(deployedComponent.getName(), uc);
                return true;
            }
            return false;
        }
        catch (RemoteException e) {
            return false;
        }
        catch (MdException e) {
            return false;
        }
        catch (MalformedURLException e) {
            return false;
        }
        catch (ServiceException e) {
            return false;
        }
    }
}

