/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocessreport;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.storedprocessreport.LogicalObject;
import com.sas.metadata.logical.storedprocessreport.NewStoredProcessReportWizard;
import com.sas.metadata.logical.storedprocessreport.ObjectFactory;
import com.sas.metadata.logical.storedprocessreport.RB;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.ConfigGeneralPanel;
import com.sas.metadata.logical.visuals.NewObjectActionInterface;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Transformation;
import com.sas.metadata.remote.Tree;
import com.sas.publicobjects.storedprocessreport.RRSupport;
import com.sas.publicobjects.storedprocessreport.StoredProcessReportInterface;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.text.Message;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import javax.swing.AbstractAction;

class NewStoredProcessReportAction
extends AbstractAction
implements NewObjectActionInterface {
    private final ObjectFactory _objectFactory;
    private final TypeInterface _type;
    private Tree _tree;
    private final Frame _frame;
    private final FolderInterface _folderInterface;
    private Config _config;
    private Transformation _transformation;

    NewStoredProcessReportAction(Frame frame, FolderInterface folderInterface, Tree tree, ObjectFactory objectFactory, TypeInterface type, Config config) {
        this._frame = frame;
        this._folderInterface = folderInterface;
        this._tree = tree;
        this._objectFactory = objectFactory;
        this._type = type;
        this._config = config;
        UtilGui.setLabelAndMnemonicOnAction((AbstractAction)this, (String)RB.getStringResource("NSPRA.CtxtMenuItm.txt"));
        this.putValue("SmallIcon", this._type.getIcon(2));
        this.putValue("ShortDescription", RB.getStringResource("NSPRA.ToolTip.txt"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent e) {
        block14: {
            try {
                String reposid = UtilMetadata.get8CharReposidFromFQID((String)this._folderInterface.getID());
                this._transformation = (Transformation)UtilMetadata.createANewComplexObjectInANewStore((String)"SP Report", (String)"Transformation", (String)reposid);
                if (this._tree == null) {
                    try {
                        this._tree = (Tree)UtilMetadata.getJOMAObjectFromLogicalObject((LogicalObjectInterface)this._folderInterface, (MdObjectStore)((MdObjectStore)this._transformation.getObjectStore()));
                    }
                    catch (MdException e1) {
                        UtilGui.displayMdException((MdException)e1);
                        return;
                    }
                }
                this._transformation.setPublicType("Report.StoredProcess");
                this._transformation.setUsageVersion(ObjectFactory.CURRENT_VERSION.encode());
                String repositoryFQID = UtilMetadata.makeRepositoryFQIDFromRoot((Root)this._tree);
                if (this._config == null) {
                    this._config = new Config();
                }
                if (this._config.getInitValue(ConfigGeneralPanel.HELP_PRODUCT, null) == null) {
                    this._config.setInitValue(ConfigGeneralPanel.HELP_PRODUCT, (Object)"newstprpt");
                }
                if (this._config.getInitValue(ConfigGeneralPanel.HELP_TOPIC, null) == null) {
                    this._config.setInitValue(ConfigGeneralPanel.HELP_TOPIC, (Object)"namewin");
                }
                this._config.setVisible(ConfigGeneralPanel.CONTEXT, false);
                this._config.setVisible(ConfigGeneralPanel.TYPE, false);
                this._config.setVisible(ConfigGeneralPanel.CREATED, false);
                this._config.setVisible(ConfigGeneralPanel.MODIFIED, false);
                NewStoredProcessReportWizard wizard = new NewStoredProcessReportWizard(this._type, this._frame, this._transformation, repositoryFQID, this._tree, this._config);
                wizard.show();
                if (wizard.getReturnValue() != 1) break block14;
                this._frame.setCursor(Cursor.getPredefinedCursor(3));
                MdObjectStore newStore = null;
                try {
                    newStore = (MdObjectStore)this._transformation.getObjectStore();
                    Tree treeInNewStore = (Tree)UtilMetadata.locateExistingObject((MdObjectStore)newStore, (String)"Tree", (String)this._tree.getFQID());
                    this._transformation.getTrees().add((Object)treeInNewStore);
                    newStore.updatedMetadataAll();
                    this._transformation = (Transformation)UtilMetadata.locateExistingObject((MdObjectStore)newStore, (String)"Transformation", (String)this._transformation.getFQID());
                    LogicalObject lo = new LogicalObject(this._transformation, this._type, this._objectFactory.getFactory());
                    this.firePropertyChange(Factory.EVENT_MEMBER_ADDED, null, (Object)lo);
                    this.createHighWaterMark(this._transformation);
                }
                catch (MdException mde) {
                    UtilGui.displayMdException((MdException)mde);
                }
                finally {
                    if (newStore != null) {
                        newStore.dispose();
                    }
                    this._frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            catch (RemoteException re) {
                UtilGui.displayRemoteException((RemoteException)re);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createHighWaterMark(Transformation transformation) {
        try {
            UtilPlatformServices.DetachedTransaction dt = UtilPlatformServices.getDetachedTransaction();
            try {
                StoredProcessReportInterface spri = (StoredProcessReportInterface)dt.getSmartObject((Root)transformation);
                if (spri == null) {
                    throw new ServiceException(RB.getStringResource(Message.format((String)"COM.noSmartObj.txt", (Object)transformation.getFQID())));
                }
                PathUrl pathUrl = spri.getPathUrl();
                if (pathUrl == null) {
                    throw new ServiceException(RB.getStringResource(Message.format((String)"COM.noPathURL.txt", (Object)transformation.getFQID())));
                }
                RRSupport rrSupport = new RRSupport((MetadataInterface)spri);
                rrSupport.createHighWaterMark(pathUrl);
            }
            finally {
                dt.rollback();
            }
        }
        catch (Exception e) {
            String msg = Message.format((String)RB.getStringResource("NSPRA.contentErr.txt"), (Object)e.getMessage());
            UtilGui.displayWarning((String)msg);
            Factory.getInstance().warn((Throwable)e, msg);
        }
    }

    public String getActionLabel() {
        return RB.getStringResource("NSPRA.NewMenuLabel.txt");
    }
}

