/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.iom.SASIOMDefs.GenericError;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.bicommon.UtilPromotion;
import com.sas.metadata.logical.common.PrivateObjectImportUtility;
import com.sas.metadata.logical.prompts.PromptConnectionType;
import com.sas.metadata.logical.prompts.PromptGroupConnectionType;
import com.sas.metadata.logical.server.AppServerConnectionType;
import com.sas.metadata.logical.server.BasePathConnectionType;
import com.sas.metadata.logical.server.DirectoryPathSubstitutionType;
import com.sas.metadata.logical.server.OtherServerConnectionType;
import com.sas.metadata.logical.storedprocess.MetadataManipulator;
import com.sas.metadata.logical.storedprocess.ObjectFactory;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.storedprocess.SourceCodeRepositoryConnectionType;
import com.sas.metadata.logical.storedprocess.StoredProcessImportItem;
import com.sas.metadata.logical.storedprocess.StoredProcessPromotionOptionsPanel;
import com.sas.metadata.logical.storedprocess.UtilMetadataSP;
import com.sas.metadata.logical.table.TableConnectionType;
import com.sas.metadata.promotion.AbstractImportListener;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionPoint;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ContentHelper;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.ImportItemInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.MissingResourceHandler;
import com.sas.metadata.promotion.MissingResourceInterface;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.promotion.PropertiesManager;
import com.sas.metadata.promotion.StatusMessageUtil;
import com.sas.metadata.promotion.visuals.PromotionOptionsInterface;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdFactory;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.ServerContext;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.services.information.metadata.prompt.BaseOMRPromptInterface;
import com.sas.services.storedprocess.metadata.DataSourceOrTarget;
import com.sas.services.storedprocess.metadata.DataTable;
import com.sas.services.storedprocess.metadata.StoredProcess;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import com.sas.util.UsageVersion;
import com.sas.workspace.WsAppServer;
import com.sas.workspace.WsAppServerFailException;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;

@SASScope
public class StoredProcessImportListener
extends AbstractImportListener
implements PromotionOptionsInterface {
    static String SOURCE_CODE_DIRECTORY = "SOURCE_CODE_DIRECTORY";
    static String DATA_TABLE_PREFIX = "STORED_PROCESS_DATA_TABLE:";
    private static int DATA_TABLE_PLUS_FQID_PREFIX_LENGTH = DATA_TABLE_PREFIX.length() + 18;
    static String template = "<Template><ClassifierMap><SourceCode><File FileName=\"\"><Directories><Directory/></Directories></File></SourceCode><ClassifierTargets><Report ReportType=\"\"><ReportLocation><ArchiveFile><Directories><Directory/></Directories></ArchiveFile><Directory IsRelative=\"\" DirectoryName=\"\"><Parent><Directory /></Parent><Properties><Property PropertyName=\"\" DefaultValue=\"\"/></Properties></Directory></ReportLocation></Report></ClassifierTargets></ClassifierMap></Template>";
    static final Class[] CONNECTION_TYPES = PrivateObjectImportUtility.appendPromptConnectionTypes((Class[])new Class[]{AppServerConnectionType.class, OtherServerConnectionType.class, BasePathConnectionType.class, SourceCodeRepositoryConnectionType.class, TableConnectionType.class, PromptConnectionType.class, PromptGroupConnectionType.class});
    static final Class[] SUBSTITUTION_TYPES = new Class[]{DirectoryPathSubstitutionType.class};
    private HashSet _itemesWithMissingContent = new HashSet();
    private boolean _importingPre92Package;
    private HashMap _davServerConnectionPtsMap = new HashMap();
    private StoredProcessPromotionOptionsPanel _optionsPanel;

    public StoredProcessImportListener(TransportableTypeInterface type) {
        super(type);
    }

    public ImportItemInterface createImportItem(String name, String id, TransportableTypeInterface type) {
        return new StoredProcessImportItem(name, id, type);
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    public Class[] getSubstitutionTypes() {
        return SUBSTITUTION_TYPES;
    }

    public int analyzeObjectsToImport(ImportOperationInterface operation, List importItems) throws MetadataPromotionException {
        if (operation.isProjectRepository()) {
            throw new MetadataPromotionException(RB.getStringResource("SPIL.ProjectRepos.txt"));
        }
        this._importingPre92Package = operation.getPackageFileVersion() < 9200;
        PropertiesManager propertiesManager = operation.getPropertiesManager();
        this._itemesWithMissingContent.clear();
        this._davServerConnectionPtsMap.clear();
        Log importLogger = operation.getLogger();
        MissingResourceHandler resourceHandler = operation.getResourceHandler();
        int retVal = 0;
        ConnectionManagerInterface cmi = operation.getConnectionManager();
        Map map = operation.getAssociationsForObjects(importItems, template);
        Set entrySet = map.entrySet();
        if (entrySet.size() != importItems.size()) {
            throw new MetadataPromotionException("ImportOperationInterface.getAssociationsForObjects returned " + entrySet.size() + " instead of " + importItems.size() + " objects.");
        }
        Iterator it = entrySet.iterator();
        int i = 0;
        int count = importItems.size();
        while (it.hasNext()) {
            String serverContext;
            Map.Entry me = it.next();
            ImportItemInterface iif = (ImportItemInterface)importItems.get(i++);
            String name = iif.getName();
            if (!iif.getID().equals(me.getKey())) {
                throw new MetadataPromotionException("ImportOperationInterface.getAssociationsForObjects output list is not in sync with input list.");
            }
            if (!(iif instanceof StoredProcessImportItem)) {
                throw new MetadataPromotionException("ImportItemInterface is a " + iif.getClass() + " and not a StoredProcessImportItem.");
            }
            UsageVersion uv = iif.getUsageVersion();
            boolean post92 = uv != null && uv.compareTo((Object)ObjectFactory.NINETWO_VERSION) > 0;
            this.fireDisplayMessage(StatusMessageUtil.createAnalyzingMessage((TypeInterface)iif.getTypeInterface(), (String)name, (int)i, (int)count));
            List connectionPoints = iif.getConnectionPoints();
            Iterator it1 = connectionPoints.iterator();
            ConnectionPoint logicalServerCP = null;
            ConnectionPoint serverContextCP = null;
            while (it1.hasNext()) {
                ConnectionPoint testCP = (ConnectionPoint)it1.next();
                if (post92) {
                    if (!testCP.getMetadataType().equalsIgnoreCase("ServerContext")) continue;
                    serverContextCP = testCP;
                    break;
                }
                if (!testCP.getMetadataType().equalsIgnoreCase("LogicalServer")) continue;
                logicalServerCP = testCP;
                break;
            }
            if (post92) {
                if (serverContextCP == null) {
                    importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.BadSPNoSrvrCtxt.fmt.txt"), (Object)iif.getName(), (Object)iif.getID()));
                    retVal = 8;
                    continue;
                }
                serverContext = serverContextCP.getName();
            } else {
                if (logicalServerCP == null) {
                    importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.BadSPNoLogSrvr.fmt.txt"), (Object)iif.getName(), (Object)iif.getID()));
                    retVal = 8;
                    continue;
                }
                serverContext = AppServerConnectionType.getServerContextName(logicalServerCP);
                if (serverContext == null) {
                    throw new MetadataPromotionException("Couldn't find Server Context name for " + logicalServerCP.getSourceID() + "associated with Stored Process " + iif.getID() + ".");
                }
            }
            Map classifierMap = (Map)me.getValue();
            List files = (List)classifierMap.get("SourceCode");
            if (files.size() != 1 && !post92) {
                importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.BadSPNot1File.fmt.txt"), (Object)iif.getName(), (Object)iif.getID()));
                retVal = 8;
                continue;
            }
            boolean post92SourceInMetadata = false;
            String directoryPath = null;
            String fileName = null;
            if (files.size() == 1) {
                Map file = (Map)files.get(0);
                fileName = (String)file.get("FileName");
                List directories = (List)file.get("Directories");
                if (directories.size() != 1) {
                    importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.BadSPNot1SrcDir.fmt.txt"), (Object)iif.getName(), (Object)iif.getID()));
                    retVal = 8;
                    continue;
                }
                Map directory = (Map)directories.get(0);
                String directoryId = (String)directory.get("Id");
                ConnectionPointInterface directoryCP = cmi.getConnection(directoryId);
                if (directoryCP == null) {
                    importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.BadSPNoSrcDirCP.fmt.txt"), (Object)iif.getName(), (Object)iif.getID()));
                    retVal = 8;
                    continue;
                }
                directoryPath = PromotionUtil.getAttrValue((String)directoryCP.getSourceSearchString(), (String)"DirectoryName");
                directoryCP.addUserDefinedProperty(SOURCE_CODE_DIRECTORY, "yes");
            } else {
                post92SourceInMetadata = true;
            }
            if (this._importingPre92Package) {
                List reports = (List)classifierMap.get("ClassifierTargets");
                for (int j = 0; j < reports.size(); ++j) {
                    ConnectionPointInterface directoryCP;
                    String directoryId;
                    Map directory;
                    String objectType;
                    Map object;
                    List reportLocationAssoc;
                    Map report = (Map)reports.get(0);
                    String reportType = (String)report.get("ReportType");
                    if (reportType.equalsIgnoreCase("SPResultsPermanentFilePackage")) {
                        reportLocationAssoc = (List)report.get("ReportLocation");
                        if (reportLocationAssoc.size() != 1) {
                            importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.BadSPNot1RepLoc.fmt.txt"), (Object)iif.getName(), (Object)iif.getID()));
                            retVal = 8;
                            continue;
                        }
                        object = (Map)reportLocationAssoc.get(0);
                        objectType = (String)object.get("MetadataObjectType");
                        if (objectType.equals("ArchiveFile")) {
                            List directories = (List)object.get("Directories");
                            if (directories.size() != 1) {
                                importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.BadSPNot1ArcDir.fmt.txt"), (Object)iif.getName(), (Object)iif.getID()));
                                retVal = 8;
                                continue;
                            }
                            directory = (Map)directories.get(0);
                        } else if (objectType.equals("Directory")) {
                            directory = object;
                        } else {
                            importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.BadSPInvRepLocObj.fmt.txt"), (Object)iif.getName(), (Object)iif.getID(), (Object)objectType));
                            retVal = 8;
                            continue;
                        }
                        directoryId = (String)directory.get("Id");
                        directoryCP = cmi.getConnection(directoryId);
                        if (directoryCP == null) {
                            importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.BadSPNoArcDirCP.fmt.txt"), (Object)iif.getName(), (Object)iif.getID()));
                            retVal = 8;
                            continue;
                        }
                        String serverName = serverContext;
                        String path = PromotionUtil.getAttrValue((String)directoryCP.getSourceSearchString(), (String)"DirectoryName");
                        propertiesManager.createSubstitutionProperty(iif, "DirPath.ApplicationServer", serverName);
                        propertiesManager.createSubstitutionProperty(iif, StoredProcess.SUBSTITUTION_PROPERTY_ARCHIVE_PATH, path);
                        StoredProcessImportItem spii = (StoredProcessImportItem)iif;
                        if (spii._913_substitutionKeys == null) {
                            spii._913_substitutionKeys = new HashSet();
                        } else {
                            spii._913_substitutionKeys.clear();
                        }
                        spii._913_substitutionKeys.add("DirPath.ApplicationServer");
                        spii._913_substitutionKeys.add(StoredProcess.SUBSTITUTION_PROPERTY_ARCHIVE_PATH);
                        continue;
                    }
                    if (!reportType.equalsIgnoreCase("SPResultsPermanentWebdavPackage")) continue;
                    reportLocationAssoc = (List)report.get("ReportLocation");
                    if (reportLocationAssoc.size() != 1) {
                        importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.BadSPNot1RepLoc.fmt.txt"), (Object)iif.getName(), (Object)iif.getID()));
                        retVal = 8;
                        continue;
                    }
                    object = (Map)reportLocationAssoc.get(0);
                    objectType = (String)object.get("MetadataObjectType");
                    if (objectType.equals("Directory")) {
                        String attrStr;
                        String directoryName;
                        directory = object;
                        directoryId = (String)directory.get("Id");
                        directoryCP = cmi.getConnection(directoryId);
                        if (directoryCP == null) {
                            String isRelative = (String)directory.get("IsRelative");
                            if (isRelative.equals("0")) {
                                importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.BadSPDir0IsRel.fmt.txt"), (Object)directoryId, (Object)iif.getName(), (Object)iif.getID()));
                                retVal = 8;
                                continue;
                            }
                            List properties = (List)directory.get("Properties");
                            Map parent = null;
                            for (int k = 0; k < properties.size(); ++k) {
                                String propertyValue;
                                Map property = (Map)properties.get(k);
                                String propertyName = (String)property.get("PropertyName");
                                if (!propertyName.equals("FileSystemType") || !(propertyValue = (String)property.get("DefaultValue")).equals("WebDAV")) continue;
                                List parents = (List)directory.get("Parent");
                                if (parents == null) {
                                    importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.BadSPNoDAVBasePathParent.fmt.txt"), (Object)directoryId, (Object)iif.getName(), (Object)iif.getID()));
                                    retVal = 8;
                                    continue;
                                }
                                if (parents.size() != 1) {
                                    importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.BadSPNot1Parent.fmt.txt"), (Object)directoryId, (Object)iif.getName(), (Object)iif.getID()));
                                    retVal = 8;
                                    continue;
                                }
                                parent = (Map)parents.get(0);
                                break;
                            }
                            if (parent == null) {
                                importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.BadSPMissnProp.fmt.txt"), (Object)iif.getName(), (Object)iif.getID(), (Object)"FileSystemType", (Object)"WebDAV"));
                                retVal = 8;
                                continue;
                            }
                            directoryId = (String)parent.get("Id");
                            directoryCP = cmi.getConnection(directoryId);
                            if (directoryCP == null) {
                                importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.BadSPNoDAVBasePathCP.fmt.txt"), (Object)iif.getName(), (Object)iif.getID()));
                                retVal = 8;
                                continue;
                            }
                        }
                        if ((directoryName = PromotionUtil.getAttrValue((String)(attrStr = directoryCP.getSourceSearchString()), (String)"DirectoryName")) == null || directoryName.length() == 0) {
                            importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.BadSPMissnDirNam.fmt.txt"), (Object)directoryCP.getSourceID(), (Object)iif.getName(), (Object)iif.getID()));
                            retVal = 8;
                            continue;
                        }
                        String davServerName = PromotionUtil.getValue((String)attrStr, (String)"DeployedComponents/*[@Name");
                        if (davServerName == null || davServerName.length() == 0) {
                            importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.BadSPMissnDirNam.fmt.txt"), (Object)directoryCP.getSourceID(), (Object)iif.getName(), (Object)iif.getID()));
                            retVal = 8;
                            continue;
                        }
                        if (this._davServerConnectionPtsMap.get(davServerName) == null) {
                            ConnectionPointInterface pt = operation.getConnectionManager().createUnknownConnection("ServerComponent", davServerName);
                            pt.addAssociatedObject((PromotionItemInterface)iif);
                            String ss = "*[@ClassIdentifier='DAC0D7F0-10DA-11D6-8816-AA0004006D06' and @Name='" + davServerName + "']";
                            pt.addSourceSearch(ss);
                            this._davServerConnectionPtsMap.put(davServerName, pt);
                        }
                        int index = attrStr.indexOf("DeployedComponents/*[@Name");
                        int insertionPoint = index + "DeployedComponents/*[".length();
                        String search = attrStr.substring(0, insertionPoint) + "@ClassIdentifier='" + "DAC0D7F0-10DA-11D6-8816-AA0004006D06" + "' and " + attrStr.substring(insertionPoint);
                        directoryCP.addSourceSearch(search);
                        continue;
                    }
                    importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.BadSPInvRepLocObj.fmt.txt"), (Object)iif.getName(), (Object)iif.getID(), (Object)objectType));
                    retVal = 8;
                }
            }
            if (operation.getPromotionType() == 2 || !this.includeContentForItem(iif, operation) || post92SourceInMetadata) continue;
            try {
                ContentHandlerInterface contentHandler = operation.getContentHandler();
                Map streamMap = contentHandler.getBinaryContent(iif.getID());
                Collection streams = streamMap.values();
                int numberOfStreams = streams.size();
                if (numberOfStreams == 0) {
                    StringBuffer sb = new StringBuffer();
                    if (directoryPath != null && directoryPath.length() > 0) {
                        sb.append(directoryPath);
                        int backwardSlash = directoryPath.indexOf(92);
                        int forwardSlash = directoryPath.indexOf(47);
                        if (backwardSlash > -1 && forwardSlash == -1) {
                            sb.append("\\");
                        } else {
                            sb.append("/");
                        }
                    }
                    sb.append(fileName);
                    String type = RB.getStringResource("Common.SourceCode.txt");
                    MissingResourceInterface resource = resourceHandler.createMissingResource(type, sb.toString());
                    resource.addDependentObject(iif);
                    this._itemesWithMissingContent.add(iif);
                    continue;
                }
                for (InputStream is : streams) {
                    is.close();
                }
            }
            catch (Exception e) {
                String msg = UtilMisc.getMessage((String)RB.getStringResource("SPIL.CannotGetContent.fmt.txt"), (Object)iif.getName());
                importLogger.error((Object)msg, (Throwable)e);
                retVal = 8;
            }
        }
        return retVal;
    }

    public int importContent(ImportOperationInterface operation, List objects) throws TransportException, IOException {
        class SPImportInfo {
            ImportItemInterface _importItem;
            ClassifierMap _classifierMap;
            ObjectFactory.SourceLocation _sourceLocation;
            String _originalFQID;
            String _originalName;

            SPImportInfo(String originalName, ClassifierMap classifierMap, ObjectFactory.SourceLocation sl, String originalFQID, ImportItemInterface importItem) {
                this._classifierMap = classifierMap;
                this._sourceLocation = sl;
                this._originalFQID = originalFQID;
                this._originalName = originalName;
                this._importItem = importItem;
            }
        }
        if (operation.getPromotionType() == 2) {
            return 0;
        }
        Log importLogger = operation.getLogger();
        if (importLogger.isDebugEnabled() && UtilMetadataSP.INCLUDE_SOURCE_CODE_PROPERTY != null) {
            importLogger.debug((Object)("Include source code property set to: " + UtilMetadataSP.INCLUDE_SOURCE_CODE_PROPERTY));
        }
        int retVal = 0;
        HashMap<ServerContext, ArrayList<SPImportInfo>> map = new HashMap<ServerContext, ArrayList<SPImportInfo>>();
        for (ImportItemInterface item : objects) {
            ServerContext sc;
            if (!this.includeContentForItem(item, operation) || this._itemesWithMissingContent.contains(item)) continue;
            this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("SPEL.StatusIndicator.fmt.txt"), (Object)item.getName()));
            ObjectFactory.SourceLocation sl = null;
            ClassifierMap cm = null;
            try {
                cm = (ClassifierMap)UtilMetadata.locateExistingObject((MdObjectStore)operation.getStore(), (String)"ClassifierMap", (String)item.getTargetID(), (String)"<Templates><ClassifierMap><ComputeLocations/><SourceCode/></ClassifierMap><File><Directories/></File><Directory><Properties/><DeployedComponents/></Directory></Templates>");
                sl = UtilMetadataSP.getSourceCodeLocation(cm);
            }
            catch (MdException e) {
                retVal = 8;
                importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.NoContentBadSP.fmt.txt"), (Object)e.getMessage()));
                continue;
            }
            if (sl.isSourceInMetadata()) continue;
            Directory dir = sl.getStoredProcessRepository();
            try {
                sc = (ServerContext)dir.getDeployedComponents().iterator().next();
            }
            catch (MdException e) {
                retVal = 8;
                importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.NoContentBadSP.fmt.txt"), (Object)e.getMessage()));
                continue;
            }
            ArrayList<SPImportInfo> importInfoList = (ArrayList<SPImportInfo>)map.get(sc);
            if (importInfoList == null) {
                importInfoList = new ArrayList<SPImportInfo>();
                map.put(sc, importInfoList);
            }
            importInfoList.add(new SPImportInfo(item.getName(), cm, sl, item.getID(), item));
        }
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        for (Map.Entry me : map.entrySet()) {
            boolean openSucceeded;
            ServerContext sc = (ServerContext)me.getKey();
            List importInfoList = (List)me.getValue();
            String failureMsg = null;
            WsAppServer wsAppServer = null;
            try {
                wsAppServer = ContentHelper.openAppServerConnection((PromotionInterface)operation, (ServerContext)sc);
                openSucceeded = true;
            }
            catch (WsAppServerFailException e1) {
                openSucceeded = false;
                failureMsg = UtilMisc.getMessage((String)RB.getStringResource("COM.ImpExpNoConn.fmt.txt"), (Object)sc.getName(), (Object)e1.getMessage());
            }
            for (SPImportInfo spImportInfo : importInfoList) {
                String fqid = spImportInfo._originalFQID;
                String name = spImportInfo._originalName;
                importLogger.info((Object)UtilMisc.getMessage((String)UtilPromotion.getPromotionLogFormatString(), (Object)spImportInfo._importItem.getTypeInterface().getDisplayType(), (Object)spImportInfo._importItem.toString(), (Object)spImportInfo._classifierMap.getFQID()));
                Map streamMap = contentHandler.getBinaryContent(fqid);
                Collection streams = streamMap.values();
                int numberOfStreams = streams.size();
                if (numberOfStreams == 0) {
                    if (retVal == 0) {
                        retVal = 4;
                    }
                    importLogger.warn((Object)RB.getStringResource("SPIL.NoContentInPkg.txt"));
                    continue;
                }
                if (numberOfStreams == 1) {
                    if (openSucceeded) {
                        InputStream is = (InputStream)streams.iterator().next();
                        String fileInAString = contentHandler.readStream(is, "UTF-8");
                        is.close();
                        try {
                            String fullPath = wsAppServer.getFileFullPath(spImportInfo._sourceLocation.getStoredProcessRepository().getDirectoryName(), spImportInfo._sourceLocation.getStoredProcessFile().getFileName());
                            StoredProcessImportListener.writeFile(wsAppServer, fileInAString, fullPath);
                            importLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.ContentWrttn.fmt.txt"), (Object)spImportInfo._sourceLocation.getStoredProcessFile().getFileName(), (Object)spImportInfo._sourceLocation.getStoredProcessRepository().getDirectoryName()));
                        }
                        catch (GenericError e) {
                            Throwable exceptionForErrorMessage = e;
                            boolean errorLogged = false;
                            try {
                                if (!wsAppServer.doesFileExist(spImportInfo._sourceLocation.getStoredProcessRepository().getDirectoryName())) {
                                    errorLogged = true;
                                    importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.NoContentNoDir.fmt.txt"), (Object)spImportInfo._sourceLocation.getStoredProcessFile().getFileName(), (Object)spImportInfo._sourceLocation.getStoredProcessRepository().getDirectoryName(), (Object)sc.getName()));
                                }
                            }
                            catch (GenericError e1) {
                                exceptionForErrorMessage = e1;
                            }
                            catch (WsAppServerFailException e1) {
                                exceptionForErrorMessage = e1;
                            }
                            retVal = 8;
                            if (errorLogged) continue;
                            importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.NoContentNoAccess.fmt.txt"), (Object)spImportInfo._sourceLocation.getStoredProcessFile().getFileName(), (Object)spImportInfo._sourceLocation.getStoredProcessRepository().getDirectoryName(), (Object)sc.getName(), (Object)exceptionForErrorMessage.getMessage()));
                        }
                        catch (WsAppServerFailException e) {
                            retVal = 8;
                            importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.NoContentNoAccess.fmt.txt"), (Object)spImportInfo._sourceLocation.getStoredProcessFile().getFileName(), (Object)spImportInfo._sourceLocation.getStoredProcessRepository().getDirectoryName(), (Object)sc.getName(), (Object)e.getMessage()));
                        }
                        catch (Exception e) {
                            retVal = 8;
                            importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.NoContentNoAccess.fmt.txt"), (Object)spImportInfo._sourceLocation.getStoredProcessFile().getFileName(), (Object)spImportInfo._sourceLocation.getStoredProcessRepository().getDirectoryName(), (Object)sc.getName(), (Object)e.toString()));
                        }
                        continue;
                    }
                    retVal = 8;
                    importLogger.error((Object)failureMsg);
                    continue;
                }
                throw new TransportException("Mulitple (" + numberOfStreams + ") package entries for " + name + "(" + fqid + ")");
            }
            if (wsAppServer == null) continue;
            wsAppServer.dispose();
        }
        return retVal;
    }

    static void writeFile(WsAppServer wsAppServer, String fileInAString, String fullPath) throws WsAppServerFailException, GenericError {
        wsAppServer.writeFile(fileInAString, fullPath, "", -27994);
    }

    private boolean includeContentForItem(ImportItemInterface importItem, ImportOperationInterface operation) {
        boolean includeContent = true;
        String exclude = operation.getPropertiesFile().getProperty(importItem.getID() + "_ExcludeContent");
        if (exclude != null && exclude.equalsIgnoreCase("true")) {
            includeContent = false;
        } else if (!((StoredProcessImportItem)importItem).getIncludeContent()) {
            includeContent = false;
        }
        return includeContent;
    }

    public JPanel getOptionsPanel(ExportItemInterface[] items, ExportOperationInterface operation) {
        return null;
    }

    public JPanel getOptionsPanel(ImportItemInterface[] items, ImportOperationInterface operation) {
        if (this._optionsPanel == null) {
            this._optionsPanel = new StoredProcessPromotionOptionsPanel(operation.getPromotionType());
        }
        this._optionsPanel.populateImportOptions(items, operation.getPropertiesFile());
        return this._optionsPanel;
    }

    public void saveSettings() {
        this._optionsPanel.saveSettings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int updateObjects(ImportOperationInterface operation, List topLevelObjects) throws MetadataPromotionException {
        Log importLogger = operation.getLogger();
        if (importLogger == null) {
            throw new MetadataPromotionException(RB.getStringResource("SPIL.NoLog.txt"));
        }
        MdFactory factory = Factory.getInstance().getMdFactory();
        PropertiesManager propertiesManager = operation.getPropertiesManager();
        boolean hadException = false;
        Iterator it = topLevelObjects.iterator();
        ArrayList<BaseOMRPromptInterface> promptsSmartObjects = new ArrayList<BaseOMRPromptInterface>();
        HashMap<String, PhysicalTableInterface> tableMap = new HashMap<String, PhysicalTableInterface>();
        while (it.hasNext()) {
            StoredProcessImportItem spiItem = (StoredProcessImportItem)((Object)it.next());
            MdObjectStore store = null;
            try {
                StoredProcessInterface spi;
                if (this._importingPre92Package) {
                    store = factory.createObjectStore();
                    ClassifierMap cm = (ClassifierMap)UtilMetadata.locateExistingObject((MdObjectStore)store, (String)"ClassifierMap", (String)spiItem.getTargetID());
                    HashMap<String, String> map = new HashMap<String, String>();
                    if (spiItem._913_substitutionKeys != null && !spiItem._913_substitutionKeys.isEmpty()) {
                        for (String key : spiItem._913_substitutionKeys) {
                            String value = propertiesManager.getSubstitutionPropertyValue((ImportItemInterface)spiItem, key);
                            map.put(key, value);
                            propertiesManager.removeSubstitutionProperty((ImportItemInterface)spiItem, key);
                        }
                    }
                    MetadataManipulator mm = new MetadataManipulator(cm, map);
                    mm.convertTo92();
                    mm.writeXML();
                    store.updatedMetadataAll();
                }
                if ((spi = (StoredProcessInterface)PromotionUtil.getSmartObject((PromotionInterface)operation, (String)spiItem.getTargetID(), (String)"ClassifierMap")) == null) {
                    hadException = true;
                    importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.NoSmartObj.fmt.txt"), (Object)spiItem.getTargetID()));
                    continue;
                }
                BaseOMRPromptInterface promptSmartObject = spi.getPrompt();
                promptsSmartObjects.add(promptSmartObject);
                boolean post92 = spi.getUsageVersion().encode() > ObjectFactory.NINETWO_VERSION.encode();
                if (!post92) continue;
                tableMap.clear();
                String udpPrefix = DATA_TABLE_PREFIX + spiItem.getID() + ":";
                for (Object o : spiItem.getConnectionPoints()) {
                    ConnectionPointInterface cpi = (ConnectionPointInterface)o;
                    Map userDefinedproperties = cpi.getUserDefinedProperties();
                    if (userDefinedproperties == null) continue;
                    for (String key : userDefinedproperties.keySet()) {
                        if (!key.startsWith(udpPrefix)) continue;
                        String tableName = key.substring(DATA_TABLE_PLUS_FQID_PREFIX_LENGTH);
                        MetadataInterface mi = PromotionUtil.getSmartObject((PromotionInterface)operation, (String)cpi.getTargetID(), (String)cpi.getMetadataType());
                        if (mi instanceof PhysicalTableInterface) {
                            tableMap.put(tableName, (PhysicalTableInterface)mi);
                            continue;
                        }
                        hadException = true;
                        importLogger.error((Object)UtilMisc.getMessage((String)RB.getStringResource("SPIL.NoTabSmartObj.fmt.txt"), (Object)spiItem.getTargetID(), (Object)cpi.getTargetPath()));
                    }
                }
                if (tableMap.size() <= 0) continue;
                List dsotList = spi.getDataSourcesAndTargets();
                for (DataSourceOrTarget dsot : dsotList) {
                    DataTable dataTable;
                    String name;
                    if (!(dsot instanceof DataTable) || !tableMap.containsKey(name = (dataTable = (DataTable)dsot).getParameterName())) continue;
                    dataTable.setTemplateTable((PhysicalTableInterface)tableMap.get(name));
                }
                spi.setDataSourcesAndTargets(dsotList);
                spi.update();
            }
            catch (RemoteException e) {
                hadException = true;
                importLogger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (ServiceException e) {
                hadException = true;
                importLogger.error((Object)e.getMessage(), (Throwable)e);
            }
            catch (MdException e) {
                hadException = true;
                importLogger.error((Object)e.getMessage(), (Throwable)e);
            }
            finally {
                if (store == null) continue;
                try {
                    store.dispose();
                }
                catch (RemoteException e) {
                    hadException = true;
                    importLogger.error((Object)e.getMessage(), (Throwable)e);
                }
            }
        }
        try {
            PrivateObjectImportUtility.updatePromptPaths((ImportOperationInterface)operation, promptsSmartObjects);
        }
        catch (RemoteException e) {
            hadException = true;
            importLogger.error((Object)e.getMessage(), (Throwable)e);
        }
        catch (ServiceException e) {
            hadException = true;
            importLogger.error((Object)e.getMessage(), (Throwable)e);
        }
        return hadException ? 8 : 0;
    }
}

