/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.RelatedObjectsInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.bicommon.UtilPromotion;
import com.sas.metadata.logical.storedprocess.UtilMetadataSP;
import com.sas.metadata.promotion.DefaultExportItem;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PrimaryType;
import com.sas.metadata.remote.Root;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;

@SASScope
public class StoredProcessExportItem
extends DefaultExportItem
implements RelatedObjectsInterface {
    private boolean _includeContent = true;

    public StoredProcessExportItem(String name, String id, TransportableTypeInterface type) {
        super(name, id, type);
        if (UtilMetadataSP.INCLUDE_SOURCE_CODE_PROPERTY != null && UtilMetadataSP.INCLUDE_SOURCE_CODE_PROPERTY.equalsIgnoreCase(Boolean.FALSE.toString())) {
            this._includeContent = false;
        }
    }

    public void setIncludeContent(boolean include) {
        this._includeContent = include;
    }

    public boolean getIncludeContent() {
        return this._includeContent;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<SimpleLogicalObjectInterface> getRelatedObjects(int relationshipType) throws LogicalTypeException {
        ArrayList<SimpleLogicalObjectInterface> list = new ArrayList<SimpleLogicalObjectInterface>();
        try {
            MdObjectStore mdStore = this._exportOperation.getMetadataFactory().createObjectStore();
            int options = 284;
            String template = relationshipType == 1 ? "<Templates><ClassifierMap><Implementors/><SourceTransformations/></ClassifierMap></Templates>" : "<Templates><ClassifierMap><SourceTransformations/></ClassifierMap></Templates>";
            try {
                ClassifierMap sp = (ClassifierMap)this._exportOperation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)mdStore, "ClassifierMap", this.getID(), null, null, template, options);
                if (sp == null) {
                    throw new LogicalTypeException("Couldn't find corresponding metadata object for stored process \"" + this.getName() + "\" with id " + this.getID() + ".");
                }
                Factory factory = Factory.getInstance();
                if (relationshipType == 1) {
                    Root root;
                    for (Object o : sp.getImplementors()) {
                        root = (Root)o;
                        if (!(root instanceof PrimaryType) || !((PrimaryType)root).getPublicType().equalsIgnoreCase("Service.SoapGenerated")) continue;
                        list.add(factory.getSimpleObject(root));
                    }
                    Object object = sp.getSourceTransformations().iterator();
                    while (true) {
                        String publicType;
                        Object o;
                        if (!object.hasNext()) {
                            object = list;
                            return object;
                        }
                        o = object.next();
                        root = (Root)o;
                        if (!(root instanceof PrimaryType) || !(publicType = ((PrimaryType)root).getPublicType()).startsWith("InformationMap") && !publicType.equalsIgnoreCase("Report.StoredProcess")) continue;
                        list.add(factory.getSimpleObject(root));
                    }
                }
                if (relationshipType != 0) return list;
                UtilPromotion.getPromptValueSources((PromotionInterface)this._exportOperation, (SimpleLogicalObjectInterface)this, list);
                for (Object o : sp.getSourceTransformations()) {
                    Root root = (Root)o;
                    if (!(root instanceof PrimaryType) || !((PrimaryType)root).getPublicType().equalsIgnoreCase("Job")) continue;
                    list.add(factory.getSimpleObject(root));
                }
                ArrayList<SimpleLogicalObjectInterface> arrayList = list;
                return arrayList;
            }
            catch (MdException mde) {
                throw new LogicalTypeException((Exception)((Object)mde));
            }
            finally {
                mdStore.dispose();
            }
        }
        catch (RemoteException e) {
            throw new LogicalTypeException((Exception)e);
        }
    }
}

