/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.meta.SASOMI.ISecurity;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.storedprocess.RepositoryManagerTableModel;
import com.sas.metadata.logical.storedprocess.RepositoryPropertyPanel;
import com.sas.metadata.logical.storedprocess.SourceCodeRepositoryConnectionPanel;
import com.sas.metadata.logical.storedprocess.SourceCodeRepositoryElement;
import com.sas.metadata.logical.storedprocess.SourceCodeRepositoryElementInterface;
import com.sas.metadata.logical.storedprocess.UtilMetadataSP;
import com.sas.metadata.logical.visuals.LayoutConstants;
import com.sas.metadata.logical.visuals.MetadataDialog;
import com.sas.metadata.logical.visuals.MetadataDialogPanel;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.promotion.AbstractConnectionType;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.DependentConnectionMapping;
import com.sas.metadata.promotion.DependentConnectionTypeInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.promotion.visuals.AbstractPromotionPanel;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.SecurityUtil;
import com.sas.metadata.remote.ServerContext;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

class SourceCodeRepositoryManagerComponent
extends AbstractPromotionPanel
implements LayoutConstants {
    private JTable _tableRepositories;
    protected RepositoryManagerTableModel _repositoryTableModel;
    private JScrollPane _scrRepositories;
    private JButton _buttonAdd;
    private ImportOperationInterface _operation;
    private DependentConnectionTypeInterface _connectionType;
    private SourceCodeRepositoryConnectionPanel _connectionPanel;
    private Map _directoryCache = new HashMap();
    private ServerContext _targetServer = null;
    private SourceConnectionInterface _source;
    private boolean _defaultFound = true;

    public SourceCodeRepositoryManagerComponent(ImportOperationInterface operation, SourceCodeRepositoryConnectionPanel connectionPanel) {
        this._operation = operation;
        this._connectionPanel = connectionPanel;
        this._connectionType = (DependentConnectionTypeInterface)connectionPanel.getConnectionType();
        this.initialize();
        this.layoutWidgets();
    }

    public String getLabel() {
        return RB.getStringResource("SCRMC.SourceCodeRepositories.txt");
    }

    public void loadComponent(Object sourceData, Object targetData) {
        try {
            if (sourceData instanceof SourceConnectionInterface) {
                DependentConnectionMapping mapping;
                SourceConnectionInterface sourceServer;
                this._source = (SourceConnectionInterface)sourceData;
                ConnectionTypeInterface serverType = this._connectionType.getDependentType();
                TargetConnectionInterface target = serverType.getTargetConnection(sourceServer = (mapping = this._connectionType.getDependentConnectionMapping()).getDependentConnection(this._source));
                if (target != null) {
                    this._targetServer = (ServerContext)target.getMetadataObject();
                }
            }
            this._defaultFound = targetData != null;
            if (this._targetServer != null) {
                ArrayList directories = (ArrayList)this._directoryCache.get(this._targetServer.getId());
                if (directories == null) {
                    directories = new ArrayList();
                    UtilMetadataSP.findAllRepositoryContextsForServerContext(2, this._targetServer, directories, null);
                    this._directoryCache.put(this._targetServer.getId(), directories);
                }
                this._repositoryTableModel.removeAll();
                for (Directory dir : directories) {
                    this._repositoryTableModel.addRepository(new SourceCodeRepositoryElement(dir));
                }
                this._repositoryTableModel.sortRepositories();
                this._repositoryTableModel.fireTableDataChanged();
            }
            this.setEnabledStateOfButtons();
        }
        catch (Exception e) {
            this._operation.getLogger().warn((Object)RB.getStringResource("SCRMC.LoadingError.txt"));
        }
    }

    private void initialize() {
        this._repositoryTableModel = new RepositoryManagerTableModel();
        this._tableRepositories = new JTable(this._repositoryTableModel);
        this._tableRepositories.setShowHorizontalLines(false);
        this._tableRepositories.setShowVerticalLines(false);
        this._tableRepositories.setSelectionMode(0);
        this._scrRepositories = new JScrollPane(this._tableRepositories);
        this._buttonAdd = UtilGui.createButton((String)RB.getStringResource("COM.Btn.Add0.txt"));
        this._buttonAdd.setToolTipText(RB.getStringResource("SCRMC.AddButtonToolTip.txt"));
        this._buttonAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    SourceCodeRepositoryElementInterface re = SourceCodeRepositoryManagerComponent.this.doAddRepository();
                    if (re != null) {
                        SourceCodeRepositoryManagerComponent.this._repositoryTableModel.addRepository(re);
                        SourceCodeRepositoryManagerComponent.this._repositoryTableModel.sortRepositories();
                        SourceCodeRepositoryManagerComponent.this._repositoryTableModel.fireTableDataChanged();
                        SourceCodeRepositoryManagerComponent.this.setSelection(re.getDirectory());
                    }
                }
                catch (RemoteException e) {
                    UtilGui.displayRemoteException((RemoteException)e);
                }
            }
        });
    }

    private void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        JPanel amrParmButtonsPanel = new JPanel();
        GridLayout gridLayout = new GridLayout(1, 1);
        gridLayout.setVgap(5);
        amrParmButtonsPanel.setLayout(gridLayout);
        amrParmButtonsPanel.add(this._buttonAdd);
        this.add(this._scrRepositories, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.add(amrParmButtonsPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 18, 0, NEXT_INSETS_IN_TOP_ROW, 0, 0));
    }

    protected void setSelection(String nameToBeShownSelected) {
        int row = this._repositoryTableModel.locateRowFor(nameToBeShownSelected);
        if (row != -1) {
            this._tableRepositories.changeSelection(row, 0, false, false);
        }
    }

    private void setEnabledStateOfButtons() {
        try {
            boolean editingPermitted = this.isAddEditDeleteEnableable();
            this._buttonAdd.setEnabled(editingPermitted);
        }
        catch (RemoteException e) {
            UtilGui.displayRemoteException((RemoteException)e);
        }
    }

    protected SourceCodeRepositoryElementInterface doAddRepository() throws RemoteException {
        String[] reposNames = this.getExistingNames();
        if (this._targetServer != null) {
            MdObjectStore addStore = this._operation.getMetadataFactory().createObjectStore(null, "AddSourceCodeRepository Store");
            try {
                int retVal;
                ServerContext server = (ServerContext)this._operation.getMetadataFactory().createComplexMetadataObject(addStore, this._targetServer.getName(), "ServerContext", this._targetServer.getId());
                Directory directory = (Directory)this._operation.getMetadataFactory().createComplexMetadataObject(addStore, "SP Source Directory", "Directory", server.getRepositoryID());
                directory.getDeployedComponents().add((Object)server);
                RepositoryPropertyPanel panel = new RepositoryPropertyPanel(directory, 1, reposNames);
                MetadataDialog dialog = MetadataDialog.createInstance((JComponent)((Object)this), (CMetadata)directory, (String)RB.getStringResource("RMP.AddSCRepos.DlgTitle.txt"), (MetadataDialogPanel)panel);
                if (!this._defaultFound && this._source != null) {
                    panel.setIsPrepopulatingOnAdd(true);
                    directory.setDirectoryName(this._source.getDisplayName());
                    ConnectionPointInterface pt = this._source.getConnectionPoint();
                    if (pt.getDescription() != null) {
                        directory.setDesc(pt.getDescription());
                    }
                }
                if ((retVal = dialog.doModal()) == 1) {
                    String id = dialog.getFqid();
                    MdObjectStore store = this._operation.getStore();
                    directory = (Directory)this._operation.getMetadataFactory().getOMIUtil().getMetadataAllDepths((MdStore)store, "Directory", id, null, null, "", 8);
                    if (directory != null) {
                        if (this._connectionType instanceof AbstractConnectionType) {
                            AbstractConnectionType type = (AbstractConnectionType)this._connectionType;
                            TargetConnectionInterface target = type.createTargetConnection((CMetadata)directory, directory.getDirectoryName());
                            this._connectionPanel.setTargetSelectionValue(this._source, target, true);
                            List directories = (List)this._directoryCache.get(this._targetServer.getId());
                            if (directories != null) {
                                directories.add(directory);
                            }
                        }
                        return new SourceCodeRepositoryElement(directory);
                    }
                }
            }
            catch (MdException e) {
                UtilGui.displayMdException((MdException)e);
                return null;
            }
        }
        return null;
    }

    protected boolean isAddEditDeleteEnableable() throws RemoteException {
        if (this._targetServer == null) {
            return false;
        }
        ISecurity is = Factory.getInstance().getISecurity();
        if (is != null) {
            try {
                return SecurityUtil.isWriteAuthorized((ISecurity)is, (String)"ServerContext", (String)this._targetServer.getId());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private String[] getExistingNames() {
        int count = this._repositoryTableModel.getRowCount();
        String[] reposNames = new String[count];
        for (int i = 0; i < count; ++i) {
            reposNames[i] = (String)this._repositoryTableModel.getValueAt(i, 0);
        }
        return reposNames;
    }
}

