/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.meta.SASOMI.ISecurity;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.ObjectContainer;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.server.RepositoryListElement;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.storedprocess.RepositoryManagerVC;
import com.sas.metadata.logical.storedprocess.RepositoryPropertyPanel;
import com.sas.metadata.logical.storedprocess.SourceCodeRepositoryElement;
import com.sas.metadata.logical.storedprocess.SourceCodeRepositoryElementInterface;
import com.sas.metadata.logical.visuals.MetadataDialog;
import com.sas.metadata.logical.visuals.MetadataDialogPanel;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.AbstractTransformation;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerContext;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import org.omg.CORBA.BooleanHolder;
import org.omg.CORBA.StringHolder;

class RepositoryManagerPanel
extends RepositoryManagerVC {
    private ServerContext _displayedServerContext;
    private LogicalServer _displayedLogicalServer;
    private boolean _serverContextBased;
    private ObjectContainer _directoryContainer;
    private DefaultComboBoxModel _modelForInitialization;
    private ServerContext _serverContextForDisplayedServer;
    private String _displayedDirectory;
    private Factory _factory;

    RepositoryManagerPanel(DefaultComboBoxModel model, ObjectContainer directoryContainer, LogicalServer displayedLogicalServer, Factory factory) throws RemoteException {
        this._modelForInitialization = model;
        this._directoryContainer = directoryContainer;
        RepositoryListElement rle = (RepositoryListElement)model.getSelectedItem();
        this._displayedDirectory = rle != null && rle.isReal() ? rle.getDirectory().getDirectoryName() : "";
        this._displayedLogicalServer = displayedLogicalServer;
        this._factory = factory;
    }

    RepositoryManagerPanel(DefaultComboBoxModel model, ObjectContainer directoryContainer, ServerContext displayedServerContext, Factory factory) throws RemoteException {
        this._modelForInitialization = model;
        this._directoryContainer = directoryContainer;
        RepositoryListElement rle = (RepositoryListElement)model.getSelectedItem();
        this._displayedDirectory = rle != null && rle.isReal() ? rle.getDirectory().getDirectoryName() : "";
        this._displayedServerContext = displayedServerContext;
        this._factory = factory;
        this._serverContextBased = true;
    }

    protected void smartPopulateStore() throws MdException, RemoteException {
        this.setServerContextForDisplayedServer();
        MdObjectStore objectStore = this._serverContextBased ? (MdObjectStore)this._displayedServerContext.getObjectStore() : (MdObjectStore)this._displayedLogicalServer.getObjectStore();
        int count = this._modelForInitialization.getSize();
        for (int i = 0; i < count; ++i) {
            RepositoryListElement re = (RepositoryListElement)this._modelForInitialization.getElementAt(i);
            if (!re.isReal()) continue;
            Directory directory = (Directory)UtilMetadata.copyExistingObjectIntoDifferentStore((MdObjectStore)objectStore, (CMetadata)re.getDirectory());
            this._repositoryTableModel.addRepository(new SourceCodeRepositoryElement(directory));
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        this._repositoryTableModel.fireTableDataChanged();
        Directory dirToBeShownSelected = (Directory)this._directoryContainer.getObject();
        if (dirToBeShownSelected != null) {
            this.setSelection(dirToBeShownSelected.getDirectoryName());
        }
    }

    public void moveDataToStore() throws MdException {
        SourceCodeRepositoryElement re = (SourceCodeRepositoryElement)this.getSelection();
        Directory d = re == null ? null : re._directory;
        this._directoryContainer.setObject((Object)d);
    }

    @Override
    protected boolean doRemoveRepository(SourceCodeRepositoryElementInterface rei) throws RemoteException {
        SourceCodeRepositoryElement re = (SourceCodeRepositoryElement)rei;
        try {
            Directory directory = re._directory;
            List list = this.getListOfFilesAttachedToDirectory(directory);
            int count = list.size();
            if (count > 0) {
                ArrayList fileList = new ArrayList(count);
                boolean onlyStoredProcessesInList = this.constructList(list, fileList);
                String message = Message.format((ResourceBundle)RB.getResources(), (String)(onlyStoredProcessesInList ? "RMP.DelErrA.txt" : "RMP.DelErrB.txt"), (Object)new Integer(count));
                MessageUtil.displayListMessage((String)message, fileList, (String)RB.getStringResource("RMP.DelErr.DlgTitle.txt"), (int)0, (int)-1);
                return false;
            }
            count = this.countOfLibrariesAttachedToDirectory(directory);
            if (count > 0) {
                String message = Message.format((ResourceBundle)RB.getResources(), (String)"RMP.DelErrLib.txt", (Object)new Integer(count));
                MessageUtil.displayMessage((String)message, (String)RB.getStringResource("RMP.DelErr.DlgTitle.txt"), (int)0, (int)-1);
                return false;
            }
            String text = Message.format((ResourceBundle)RB.getResources(), (String)"RMP.DelDlgText.fmt.txt", (Object)directory.getDirectoryName());
            if (MessageUtil.displayMessage((String)text, (String)RB.getStringResource("COM.ConfDel.DlgTitle.txt"), (int)3, (int)0) == 1) {
                return false;
            }
            UtilMetadata.deleteAllProperties((Root)directory);
            directory.delete();
        }
        catch (MdException md) {
            UtilGui.displayMdException((MdException)md);
            return false;
        }
        return true;
    }

    @Override
    protected boolean doModifyRepository(SourceCodeRepositoryElementInterface rei) throws RemoteException {
        String[] reposNames = this.getExistingNames();
        boolean proceedWithModify = true;
        SourceCodeRepositoryElement re = (SourceCodeRepositoryElement)rei;
        Directory d = re._directory;
        int numberAllowedBeforeConfirmationNeeded = d.getDirectoryName().equals(this._displayedDirectory) ? 1 : 0;
        try {
            List list = this.getListOfFilesAttachedToDirectory(d);
            int count = list.size();
            if (count > numberAllowedBeforeConfirmationNeeded) {
                ArrayList fileList = new ArrayList(count);
                boolean onlyStoredProcessesInList = this.constructList(list, fileList);
                String message = Message.format((ResourceBundle)RB.getResources(), (String)(onlyStoredProcessesInList ? "RMP.ModWarnA.txt" : "RMP.ModWarnB.txt"), (Object)new Integer(count));
                boolean bl = proceedWithModify = MessageUtil.displayListMessage((String)message, fileList, (String)RB.getStringResource("RMP.ModWarn.DlgTitle.txt"), (int)2, (int)2) == 0;
            }
            if (proceedWithModify && (count = this.countOfLibrariesAttachedToDirectory(d)) > 0) {
                String message = Message.format((ResourceBundle)RB.getResources(), (String)"RMP.ModWarnLib.txt", (Object)new Integer(count));
                proceedWithModify = MessageUtil.displayMessage((String)message, (String)RB.getStringResource("RMP.ModWarn.DlgTitle.txt"), (int)2, (int)2) == 0;
            }
        }
        catch (MdException md) {
            UtilGui.displayMdException((MdException)md);
            return false;
        }
        if (!proceedWithModify) {
            return false;
        }
        String oldName = rei.getDirectory();
        String oldDesc = rei.getDescription();
        Directory dCopy = (Directory)UtilMetadata.createAChildStoreAndCopyObjectIntoIt((CMetadata)d);
        RepositoryPropertyPanel repositoryPropertyPanel = new RepositoryPropertyPanel(dCopy, 2, reposNames);
        MetadataDialog dialog = MetadataDialog.createInstance((JComponent)((Object)this), (CMetadata)dCopy, (String)RB.getStringResource("RMP.ModSCRepos.DlgTitle.txt"), (MetadataDialogPanel)repositoryPropertyPanel);
        dialog.doModal();
        String newName = d.getDirectoryName();
        String newDesc = d.getDesc();
        return !oldName.equals(newName) || !oldDesc.equals(newDesc);
    }

    private List getListOfFilesAttachedToDirectory(Directory d) throws MdException, RemoteException {
        String repositoryFQID = UtilMetadata.makeRepositoryFQIDFromRoot((Root)d);
        int flags = 10652;
        String options = "<Templates><Directory><Files/></Directory></Templates><XMLSELECT search=\"Directory[@Id='" + d.getFQID() + "']\"/>";
        MdStore store = d.getObjectStore();
        store.getFactory().getOMIUtil().getMetadataObjectsSubset(store, repositoryFQID, "Directory", flags, options);
        return d.getFiles();
    }

    private int countOfLibrariesAttachedToDirectory(Directory d) throws MdException, RemoteException {
        String repositoryFQID = UtilMetadata.makeRepositoryFQIDFromRoot((Root)d);
        int flags = 10652;
        String options = "<Templates><Directory><UsedByPackages/></Directory></Templates><XMLSELECT search=\"Directory[@Id='" + d.getFQID() + "']\"/>";
        MdStore store = d.getObjectStore();
        store.getFactory().getOMIUtil().getMetadataObjectsSubset(store, repositoryFQID, "Directory", flags, options);
        return d.getUsedByPackages().size();
    }

    private boolean constructList(List list, List fileList) throws MdException, RemoteException {
        int count = list.size();
        boolean onlyStoredProcessesInList = true;
        for (int i = 0; i < count; ++i) {
            AbstractTransformation at = null;
            File f = (File)list.get(i);
            at = f.getAssociatedTransformation();
            String spName = at != null ? at.getName() : "";
            String fileName = f != null ? f.getFileName() : "";
            String line = Message.format((ResourceBundle)RB.getResources(), (String)"RMP.DelMod1.fmt.txt", (Object)spName, (Object)fileName);
            if (at instanceof ClassifierMap) {
                if (!at.getTransformRole().equalsIgnoreCase("StoredProcess")) {
                    onlyStoredProcessesInList = false;
                }
            } else {
                onlyStoredProcessesInList = false;
            }
            fileList.add(line);
            if (i != 20 || count <= 21) continue;
            fileList.add(RB.getStringResource(onlyStoredProcessesInList ? "RMP.DelMod2A.fmt.txt" : "RMP.DelMod2B.fmt.txt"));
            break;
        }
        return onlyStoredProcessesInList;
    }

    @Override
    protected SourceCodeRepositoryElementInterface doAddRepository() throws RemoteException {
        String[] reposNames = this.getExistingNames();
        Directory directory = (Directory)UtilMetadata.createANewComplexObjectInANewChildStore((CMetadata)this._serverContextForDisplayedServer, (String)"SP Source Directory", (String)"Directory");
        MetadataDialog dialog = MetadataDialog.createInstance((JComponent)((Object)this), (CMetadata)directory, (String)RB.getStringResource("RMP.AddSCRepos.DlgTitle.txt"), (MetadataDialogPanel)new RepositoryPropertyPanel(directory, 1, reposNames));
        int retVal = dialog.doModal();
        try {
            if (retVal == 1) {
                directory = (Directory)((MdObjectStore)this._serverContextForDisplayedServer.getObjectStore()).getObject(dialog.getFqid(), true);
                directory.getDeployedComponents().add((Object)this._serverContextForDisplayedServer);
                return new SourceCodeRepositoryElement(directory);
            }
        }
        catch (MdException e) {
            UtilGui.displayMdException((MdException)e);
            return null;
        }
        return null;
    }

    @Override
    protected boolean isAddEditDeleteEnableable() throws RemoteException {
        if (this._serverContextForDisplayedServer == null) {
            return false;
        }
        ISecurity is = this._factory.getISecurity();
        if (is != null) {
            String resource = "OMSOBJ:ServerContext/" + this._serverContextForDisplayedServer.getFQID();
            StringHolder permissionCondition = new StringHolder();
            BooleanHolder authorized = new BooleanHolder();
            try {
                is.IsAuthorized("", resource, "WriteMetadata", permissionCondition, authorized);
                return authorized.value;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return true;
    }

    private String[] getExistingNames() {
        int count = this._repositoryTableModel.getRowCount();
        String[] reposNames = new String[count];
        for (int i = 0; i < count; ++i) {
            reposNames[i] = (String)this._repositoryTableModel.getValueAt(i, 0);
        }
        return reposNames;
    }

    private void setServerContextForDisplayedServer() throws MdException, RemoteException {
        if (this._serverContextBased) {
            this._serverContextForDisplayedServer = this._displayedServerContext;
        } else {
            Iterator it = this._displayedLogicalServer.getUsedByComponents().iterator();
            this._serverContextForDisplayedServer = null;
            while (it.hasNext()) {
                Object c = it.next();
                if (!(c instanceof ServerContext)) continue;
                this._serverContextForDisplayedServer = (ServerContext)c;
                break;
            }
            if (this._serverContextForDisplayedServer == null) {
                MessageUtil.displayMessage((String)RB.getStringResource("RMP.InitErr.txt"), (String)RB.getStringResource("RMP.InitErr.DlgTitle.txt"), (int)0, (int)-1);
            }
        }
    }
}

