/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.codepolicy.SASScope;
import com.sas.metadata.logical.storedprocess.MetadataManipulator;
import com.sas.metadata.logical.storedprocess.OutputParameterPanel;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.visuals.LayoutConstants;
import com.sas.metadata.logical.visuals.MetadataDialog;
import com.sas.metadata.logical.visuals.MetadataDialogPanel;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.MdException;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

@SASScope
public class OutputParametersPanel
extends WAPanel
implements LayoutConstants,
ListSelectionListener {
    private JTable _table;
    private OutputParameterTableModel _tableModel;
    private JScrollPane _scrollPane;
    private JButton _buttonNew;
    private JButton _buttonEdit;
    private JButton _buttonDelete;
    private MetadataManipulator _metadataManipulator;

    public OutputParametersPanel(MetadataManipulator metadataManipulator) {
        this._metadataManipulator = metadataManipulator;
        AutoSizingGridLayout ouputParmsLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, true, true);
        ouputParmsLayout.setRemainderColumn(1);
        this.setLayout((LayoutManager)ouputParmsLayout);
        this._tableModel = new OutputParameterTableModel();
        this._table = new JTable(this._tableModel);
        this._table.setDefaultRenderer(Object.class, (TableCellRenderer)new UtilGui.NoHtmlTableCellRenderer());
        this._table.setToolTipText(RB.getStringResource("COM.Table.Tooltip.txt"));
        this._table.getSelectionModel().addListSelectionListener(this);
        this._table.setSelectionMode(0);
        this._scrollPane = new JScrollPane(this._table);
        this._scrollPane.setPreferredSize(new Dimension(450, 200));
        this._buttonNew = UtilGui.createButton((String)RB.getStringResource("COM.Btn.New0.txt"));
        this._buttonNew.setEnabled(true);
        this._buttonEdit = UtilGui.createButton((String)RB.getStringResource("COM.Btn.Mod0.txt"));
        this._buttonEdit.setEnabled(false);
        this._buttonDelete = UtilGui.createButton((String)RB.getStringResource("COM.Btn.Del0.txt"));
        this._buttonDelete.setEnabled(false);
        JPanel nedParmButtonsPanel = new JPanel();
        AutoSizingGridLayout buttonLayout = new AutoSizingGridLayout(3, 1, 5, 5, false, false, true);
        nedParmButtonsPanel.setLayout((LayoutManager)buttonLayout);
        nedParmButtonsPanel.add(this._buttonNew);
        nedParmButtonsPanel.add(this._buttonEdit);
        nedParmButtonsPanel.add(this._buttonDelete);
        this.add(this._scrollPane);
        this.add(nedParmButtonsPanel);
        this.createListeners();
    }

    private void createListeners() {
        this._buttonNew.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OutputParameter op = OutputParametersPanel.this.doNew();
                if (op != null) {
                    OutputParametersPanel.this._tableModel.addOutputParameter(op);
                    OutputParametersPanel.this._tableModel.fireTableDataChanged();
                    OutputParametersPanel.this.setSelection(op);
                }
            }
        });
        this._buttonEdit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OutputParameter op;
                int selected = OutputParametersPanel.this._table.getSelectedRow();
                if (selected != -1 && OutputParametersPanel.this.doEdit(op = OutputParametersPanel.this._tableModel.getOutputParameterElementAt(selected))) {
                    OutputParametersPanel.this._tableModel.fireTableDataChanged();
                }
            }
        });
        this._buttonDelete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                OutputParameter op;
                int selected = OutputParametersPanel.this._table.getSelectedRow();
                if (selected != -1 && OutputParametersPanel.this.doDelete(op = OutputParametersPanel.this._tableModel.getOutputParameterElementAt(selected))) {
                    OutputParametersPanel.this._tableModel.removeOutputParameter(op);
                    OutputParametersPanel.this._tableModel.fireTableDataChanged();
                    OutputParametersPanel.this.setEnabledStateOfButtons();
                }
            }
        });
    }

    private boolean doDelete(OutputParameter op) {
        String msg = Message.format((ResourceBundle)RB.getResources(), (String)"OPsP.ConfDel.msg.fmt.txt", (Object)op._name);
        return MessageUtil.displayMessage((String)msg, (String)RB.getStringResource("COM.ConfDel.DlgTitle.txt"), (int)3, (int)0) == 0;
    }

    private OutputParameter doNew() {
        OutputParameter parameter = new OutputParameter();
        OutputParameterPanel outputParameterPanel = new OutputParameterPanel(parameter, 1, this._tableModel.generateListOfExistingNames());
        MetadataDialog dialog = MetadataDialog.createInstance((JComponent)((Object)this), null, (String)RB.getStringResource("OPsP.NewParm.DlgTitle.txt"), (MetadataDialogPanel)outputParameterPanel);
        int retVal = dialog.doModal();
        if (retVal == 1) {
            return parameter;
        }
        return null;
    }

    protected boolean doEdit(OutputParameter op) {
        OutputParameterPanel outputParameterPanel = new OutputParameterPanel(op, 2, this._tableModel.generateListOfExistingNames());
        MetadataDialog dialog = MetadataDialog.createInstance((JComponent)((Object)this), null, (String)RB.getStringResource(this.isEditable() ? "OPsP.ModParm.DlgTitle.txt" : "OPsP.ViewParm.DlgTitle.txt"), (MetadataDialogPanel)outputParameterPanel);
        dialog.setEditable(this.isEditable());
        int retVal = dialog.doModal();
        return retVal == 1;
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.setEnabledStateOfButtons();
    }

    public void writeParmsToXML() throws ParserConfigurationException, MdException, RemoteException {
        int numOfParms = this._tableModel._data.size();
        Document document = this._metadataManipulator.getDocumentCreatingItIfItDoesNotExist();
        Element spE = this._metadataManipulator.getStoredProcessXMLElementCreatingItIfItDoesNotExist();
        NodeList list = spE.getElementsByTagName("OutputParameters");
        ArrayList<Node> tempList = new ArrayList<Node>();
        for (int i = 0; i < list.getLength(); ++i) {
            tempList.add(list.item(i));
        }
        Iterator it = tempList.iterator();
        while (it.hasNext()) {
            spE.removeChild((Node)it.next());
        }
        Element outputParmsE = document.createElement("OutputParameters");
        for (int i = 0; i < numOfParms; ++i) {
            boolean hasLabel;
            OutputParameter op = (OutputParameter)this._tableModel._data.get(i);
            Element parmE = document.createElement("Parameter");
            parmE.setAttribute("Name", op._name);
            parmE.setAttribute("Type", op._type);
            boolean hasDesc = op._description != null && op._description.length() > 0;
            boolean bl = hasLabel = op._label != null && op._label.length() > 0;
            if (hasDesc || hasLabel) {
                Element cultureE = document.createElement("Culture");
                if (hasLabel) {
                    Element labelE = document.createElement("Label");
                    labelE.appendChild(document.createTextNode(op._label));
                    cultureE.appendChild(labelE);
                }
                if (hasDesc) {
                    Element descriptionE = document.createElement("Description");
                    descriptionE.appendChild(document.createTextNode(op._description));
                    cultureE.appendChild(descriptionE);
                }
                parmE.appendChild(cultureE);
            }
            outputParmsE.appendChild(parmE);
        }
        spE.appendChild(outputParmsE);
    }

    public void readParmsFromXML() throws MdException {
        this._tableModel._data.clear();
        Element spE = this._metadataManipulator.getStoredProcessXMLElementIfExists();
        if (spE == null) {
            return;
        }
        NodeList list = spE.getElementsByTagName("OutputParameters");
        if (list.getLength() == 0) {
            return;
        }
        if (list.getLength() > 1) {
            throw new MdException(RB.getStringResource("OPsP.MultplOPTag.txt"));
        }
        Element outputParametersE = (Element)list.item(0);
        list = outputParametersE.getElementsByTagName("Parameter");
        for (int i = 0; i < list.getLength(); ++i) {
            Element parmE = (Element)list.item(i);
            OutputParameter op = new OutputParameter();
            op._name = parmE.getAttribute("Name");
            op._type = parmE.getAttribute("Type");
            op._description = "";
            op._label = "";
            NodeList cultureElements = parmE.getElementsByTagName("Culture");
            boolean seenValidCulture = false;
            for (int j = 0; j < cultureElements.getLength(); ++j) {
                Element cultureE = (Element)cultureElements.item(j);
                String xmlLangValue = cultureE.getAttribute("xml:lang");
                if (xmlLangValue.length() != 0) continue;
                if (seenValidCulture) {
                    throw new MdException(RB.getStringResource("OPsP.MultplVldCultr.txt"));
                }
                seenValidCulture = true;
                NodeList cultureChildren = cultureE.getChildNodes();
                for (int k = 0; k < cultureChildren.getLength(); ++k) {
                    Element labelOrDesc;
                    Node nn = cultureChildren.item(k);
                    if (nn.getNodeType() != 1 || !(labelOrDesc = (Element)nn).getTagName().equals("Label") && !labelOrDesc.getTagName().equals("Description")) continue;
                    NodeList labelChildren = labelOrDesc.getChildNodes();
                    for (int l = 0; l < labelChildren.getLength(); ++l) {
                        Node tt = labelChildren.item(l);
                        if (tt.getNodeType() != 3) continue;
                        Text text = (Text)tt;
                        if (labelOrDesc.getTagName().equals("Label")) {
                            op._label = text.getNodeValue();
                            continue;
                        }
                        op._description = text.getNodeValue();
                    }
                }
            }
            this._tableModel.addOutputParameter(op);
        }
        this._tableModel.fireTableDataChanged();
    }

    protected void setSelection(OutputParameter op) {
        int row = this._tableModel.locateRowFor(op);
        if (row != -1) {
            this._table.changeSelection(row, 0, false, false);
        }
    }

    private void setEnabledStateOfButtons() {
        boolean editingPermitted = this.isEditable();
        this._buttonNew.setEnabled(editingPermitted);
        boolean rowSelected = this._table.getSelectedRow() >= 0;
        this._buttonEdit.setEnabled(rowSelected);
        this._buttonDelete.setEnabled(rowSelected && editingPermitted);
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        Util.configureMnemonicForButton((AbstractButton)this._buttonEdit, (String)RB.getStringResource(this.isEditable() ? "COM.Btn.Mod0.txt" : "COM.Btn.View0.txt"));
        this.setEnabledStateOfButtons();
    }

    class OutputParameter {
        String _label;
        String _name;
        String _type;
        String _description;

        OutputParameter() {
        }
    }

    static class OutputParameterTableModel
    extends AbstractTableModel {
        private List<OutputParameter> _data = new ArrayList<OutputParameter>();

        OutputParameterTableModel() {
        }

        private String[] generateListOfExistingNames() {
            int len = this._data.size();
            String[] names = new String[len];
            for (int i = 0; i < len; ++i) {
                OutputParameter op = this._data.get(i);
                names[i] = op._name;
            }
            return names;
        }

        OutputParameter getOutputParameterElementAt(int row) {
            return this._data.get(row);
        }

        void addOutputParameter(OutputParameter op) {
            this._data.add(op);
        }

        void removeOutputParameter(OutputParameter op) {
            this._data.remove(op);
        }

        int locateRowFor(OutputParameter matchOP) {
            Iterator<OutputParameter> it = this._data.iterator();
            int i = 0;
            while (it.hasNext()) {
                OutputParameter op = it.next();
                if (op == matchOP) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        @Override
        public int getColumnCount() {
            return 4;
        }

        @Override
        public int getRowCount() {
            return this._data.size();
        }

        @Override
        public String getColumnName(int c) {
            switch (c) {
                case 0: {
                    return RB.getStringResource("OPsP.Lbl.Label.txt");
                }
                case 1: {
                    return RB.getStringResource("OPsP.Lbl.Name.txt");
                }
                case 2: {
                    return RB.getStringResource("OPsP.Lbl.Type.txt");
                }
                case 3: {
                    return RB.getStringResource("OPsP.Lbl.Desc.txt");
                }
            }
            return "";
        }

        @Override
        public Object getValueAt(int row, int col) {
            OutputParameter op = this._data.get(row);
            switch (col) {
                case 0: {
                    return op._label;
                }
                case 1: {
                    return op._name;
                }
                case 2: {
                    return OutputParameterPanel.findDisplayString(op._type);
                }
                case 3: {
                    return op._description;
                }
            }
            return "";
        }
    }
}

