/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.storedprocess.OutputParametersPanel;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.visuals.EditableComboBox;
import com.sas.metadata.logical.visuals.ListElementInterface;
import com.sas.metadata.logical.visuals.MetadataDialogPanel;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.MdException;
import com.sas.services.util.Names;
import com.sas.text.Message;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.HashMap;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JScrollPane;

final class OutputParameterPanel
extends MetadataDialogPanel {
    private static OPPTypeElement SELECT_A_TYPE = new OPPTypeElement("", RB.getStringResource("OPP.SelTyp.txt"));
    private static OPPTypeElement TYPE_DATE = new OPPTypeElement("Date", RB.getStringResource("OPP.Typ.Date.txt"));
    private static OPPTypeElement TYPE_DOUBLE = new OPPTypeElement("Double", RB.getStringResource("OPP.Typ.Dbl.txt"));
    private static OPPTypeElement TYPE_INTEGER = new OPPTypeElement("Integer", RB.getStringResource("OPP.Typ.Int.txt"));
    private static OPPTypeElement TYPE_TIME = new OPPTypeElement("Time", RB.getStringResource("OPP.Typ.Time.txt"));
    private static OPPTypeElement TYPE_TIMESTAMP = new OPPTypeElement("TimeStamp", RB.getStringResource("OPP.Typ.TimeStamp.txt"));
    private static OPPTypeElement TYPE_STRING = new OPPTypeElement("String", RB.getStringResource("OPP.Typ.String.txt"));
    private static HashMap _xmlTypeToDisplayTypeMap = new HashMap(6);
    private DefaultComboBoxModel _typeComboBoxModel;
    private OutputParametersPanel.OutputParameter _parameter;
    private int _context;
    private String[] _existingParameterNames;
    private String _originalName;
    private JLabel _lblName;
    private WATextField _txtName;
    private JLabel _lblType;
    private EditableComboBox _cbType;
    private JLabel _lblLabel;
    private WATextField _txtLabel;
    private JLabel _lblDescription;
    private JScrollPane _scrDescription;
    private WATextArea _txtDescription;

    static String findDisplayString(String xmlType) {
        String displayType = (String)_xmlTypeToDisplayTypeMap.get(xmlType);
        if (displayType == null) {
            displayType = xmlType;
        }
        return displayType;
    }

    OutputParameterPanel(OutputParametersPanel.OutputParameter parameter, int context, String[] existingParameterNames) {
        this._parameter = parameter;
        this._context = context;
        this._existingParameterNames = existingParameterNames;
        this._typeComboBoxModel = new DefaultComboBoxModel();
        this._typeComboBoxModel.addElement(SELECT_A_TYPE);
        this._typeComboBoxModel.addElement(TYPE_DATE);
        this._typeComboBoxModel.addElement(TYPE_DOUBLE);
        this._typeComboBoxModel.addElement(TYPE_INTEGER);
        this._typeComboBoxModel.addElement(TYPE_TIME);
        this._typeComboBoxModel.addElement(TYPE_TIMESTAMP);
        this._typeComboBoxModel.addElement(TYPE_STRING);
        this.initialize();
        this.layoutWidgets();
    }

    public void initialize() {
        this.setHelpProduct("storedprocess");
        this.setHelpTopic(this._context == 1 ? "stp_newoutputparamwin" : "stp_modifyoutputparamwin");
        this._txtName = new WATextField();
        this._txtName.setMaxCharacters(32);
        this._txtName.setToolTipText(RB.getStringResource("COM.Tooltip.Name.txt"));
        this._lblName = UtilGui.createLabelForComponent((Component)this._txtName, (String)RB.getStringResource("COM.Lbl.Name0.txt"));
        this._cbType = new EditableComboBox(this._typeComboBoxModel, false){

            protected void doListItemSelected(ListElementInterface le) {
            }
        };
        this._lblType = UtilGui.createLabelForComponent((Component)this._cbType, (String)RB.getStringResource("OPP.Lbl.Type.txt"));
        this._txtLabel = new WATextField();
        this._txtLabel.setMaxCharacters(60);
        this._txtLabel.setToolTipText(RB.getStringResource("OPP.Tooltip.Label.txt"));
        this._lblLabel = UtilGui.createLabelForComponent((Component)this._txtLabel, (String)RB.getStringResource("OPP.Lbl.Label.txt"));
        this._txtDescription = new WATextArea();
        this._txtDescription.setMaxCharacters(200);
        this._txtDescription.setLineWrap(true);
        this._txtDescription.setWrapStyleWord(true);
        this._txtDescription.setToolTipText(RB.getStringResource("COM.Tooltip.Desc.txt"));
        this._lblDescription = UtilGui.createLabelForComponent((Component)this._txtDescription, (String)RB.getStringResource("COM.Lbl.Desc0.txt"));
        this._scrDescription = new JScrollPane((Component)this._txtDescription);
    }

    public void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        this._scrDescription.setPreferredSize(DESCRIPTION_SCROLLWINDOW_SIZE);
        int row = 0;
        this.add(this._lblName, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_TOP_ROW, 0, 0));
        this.add((Component)this._txtName, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_TOP_ROW, 0, 0));
        this.add(this._lblType, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        this.add((Component)this._cbType, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_ROW, 0, 0));
        this.add(this._lblLabel, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        this.add((Component)this._txtLabel, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_ROW, 0, 0));
        this.add(this._lblDescription, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        this.add(this._scrDescription, new GridBagConstraints(1, row, 1, 1, 1.0, 1.0, 18, 1, NEXT_INSETS_IN_ROW, 0, 0));
    }

    public void moveDataToView() throws MdException {
        int indexToBeSet = 0;
        if (this._context == 2) {
            int size = this._typeComboBoxModel.getSize();
            for (int i = 1; i < size; ++i) {
                OPPTypeElement le = (OPPTypeElement)this._typeComboBoxModel.getElementAt(i);
                if (!le._xmlType.equals(this._parameter._type)) continue;
                indexToBeSet = i;
                break;
            }
            this._originalName = this._parameter._name;
            this._txtName.setText(this._originalName);
            this._txtLabel.setText(this._parameter._label);
            this._txtDescription.setText(this._parameter._description);
        }
        this._cbType.setSelectedItem(this._typeComboBoxModel.getElementAt(indexToBeSet));
    }

    public void moveDataToStore() throws MdException {
        this._parameter._name = this._txtName.getText();
        this._parameter._label = this._txtLabel.getText();
        OPPTypeElement le = (OPPTypeElement)this._cbType.getSelectedItem();
        this._parameter._type = le._xmlType;
        this._parameter._description = this._txtDescription.getText();
    }

    public boolean dataValidate() {
        OPPTypeElement selectedType;
        String temp = this._txtName.getText();
        if (UtilMisc.isBlankOrEmptyString((String)temp)) {
            MessageUtil.displayMessage((String)RB.getStringResource("COM.NoName.txt"), (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
            this._txtName.requestFocus();
            return false;
        }
        boolean performNameValidation = true;
        if (this._context == 2 && this._originalName.equalsIgnoreCase(temp)) {
            performNameValidation = false;
        }
        if (performNameValidation) {
            try {
                Names.validateSASVariableName((String)temp, (boolean)true);
            }
            catch (Exception e) {
                MessageUtil.displayMessage((String)e.getMessage(), (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
                this._txtName.requestFocus();
                return false;
            }
            for (int i = 0; i < this._existingParameterNames.length; ++i) {
                if (!temp.equalsIgnoreCase(this._existingParameterNames[i])) continue;
                String text = Message.format((ResourceBundle)RB.getResources(), (String)"COM.Exsts.fmt.txt", (Object)temp);
                MessageUtil.displayMessage((String)text, (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
                this._txtName.requestFocus();
                return false;
            }
        }
        if ((selectedType = (OPPTypeElement)this._typeComboBoxModel.getSelectedItem()) == SELECT_A_TYPE) {
            MessageUtil.displayMessage((String)RB.getStringResource("OPP.NoType.msg.txt"), (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
            this._txtName.requestFocus();
            return false;
        }
        return true;
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this._txtName.setEnabled(editable);
        this._cbType.setEnabled(editable);
        this._txtLabel.setEnabled(editable);
        this._txtDescription.setEnabled(editable);
    }

    static {
        _xmlTypeToDisplayTypeMap.put(TYPE_DATE._xmlType, TYPE_DATE._displayString);
        _xmlTypeToDisplayTypeMap.put(TYPE_DOUBLE._xmlType, TYPE_DOUBLE._displayString);
        _xmlTypeToDisplayTypeMap.put(TYPE_INTEGER._xmlType, TYPE_INTEGER._displayString);
        _xmlTypeToDisplayTypeMap.put(TYPE_TIME._xmlType, TYPE_TIME._displayString);
        _xmlTypeToDisplayTypeMap.put(TYPE_TIMESTAMP._xmlType, TYPE_TIMESTAMP._displayString);
        _xmlTypeToDisplayTypeMap.put(TYPE_STRING._xmlType, TYPE_STRING._displayString);
    }

    private static class OPPTypeElement
    implements ListElementInterface {
        private String _displayString;
        private String _xmlType;

        public OPPTypeElement(String xmlType, String displayString) {
            this._displayString = displayString;
            this._xmlType = xmlType;
        }

        public String toString() {
            return this._displayString;
        }
    }
}

