/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.metadata.logical.BaseObjectFactory;
import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.FolderInterface;
import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.WizardCompletionInterface;
import com.sas.metadata.logical.storedprocess.ChangeVersionAction;
import com.sas.metadata.logical.storedprocess.ConfigParameterPanel;
import com.sas.metadata.logical.storedprocess.DataTabPanel;
import com.sas.metadata.logical.storedprocess.ExecutionTabPanel93;
import com.sas.metadata.logical.storedprocess.GeneralTabPanel;
import com.sas.metadata.logical.storedprocess.MetadataManipulator;
import com.sas.metadata.logical.storedprocess.NewExecutionTabPanel;
import com.sas.metadata.logical.storedprocess.NewParameterTabPanel;
import com.sas.metadata.logical.storedprocess.NewStoredProcessAction;
import com.sas.metadata.logical.storedprocess.NewStoredProcessAction92;
import com.sas.metadata.logical.storedprocess.NewStoredProcessWizard;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.storedprocess.StoredProcessLogicalObject;
import com.sas.metadata.logical.storedprocess.StoredProcessType;
import com.sas.metadata.logical.storedprocess.UtilMetadataSP;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.SmartWsDescriptionWizardTab;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.logical.webservices.WebServiceDeployAction;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.Extension;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.MdOMIUtil;
import com.sas.metadata.remote.MdObjectStore;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerContext;
import com.sas.metadata.remote.Tree;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import java.awt.Cursor;
import java.awt.Frame;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;

public class ObjectFactory
extends BaseObjectFactory
implements ObjectFactoryInterface {
    static UsageVersion OLDEST_VERSION = new UsageVersion(0, 0);
    static UsageVersion NINETWO_VERSION = new UsageVersion(1, 0);
    static UsageVersion NINETHREE_VERSION = new UsageVersion(2, 0);
    static UsageVersion CURRENT_VERSION = new UsageVersion(2, 0);
    private static final String wizardVersionKey = "com.sas.metadata.logical.storedprocess.DefaultNewVersion";
    StoredProcessType _type;
    private boolean _wizardTypeIs93 = true;
    private String _options;

    ObjectFactory(StoredProcessType type, Factory factory) {
        super((TypeInterface)type, factory);
        String message;
        this._type = type;
        String value = System.getProperty(wizardVersionKey);
        if (value == null) {
            MdOMIUtil mdOMIUtil = factory.getOMIUtil();
            MdObjectStore store = null;
            try {
                store = this._factory.getMdFactory().createObjectStore();
                List extensions = mdOMIUtil.getMetadataObjectsSubset((MdStore)store, mdOMIUtil.getFoundationReposID(), "Extension", 392, "<XMLSelect search=\"Extension[@Name='com.sas.metadata.logical.storedprocess.DefaultNewVersion'][OwningObject/SoftwareComponent[@ClassIdentifier='mgmtcondata']]\"/>");
                if (extensions.size() > 0) {
                    value = ((Extension)extensions.get(0)).getValue();
                }
            }
            catch (RemoteException e) {
                factory.error(e.getMessage());
                throw new RuntimeException(e);
            }
            catch (MdException e) {
                String message2 = Message.format((String)RB.getStringResource("OF.excpOccrd.ex.fmt.txt"), (Object)wizardVersionKey);
                factory.error((Throwable)e, message2);
                throw new RuntimeException(message2, e);
            }
            finally {
                if (store != null) {
                    try {
                        store.dispose();
                    }
                    catch (RemoteException e) {
                        factory.error((Throwable)e, "RemoteException disposing store");
                    }
                }
            }
        }
        if (value == null) {
            return;
        }
        try {
            int ver = Integer.parseInt(value);
            if (ver != 1 && ver != 2) {
                message = Message.format((String)RB.getStringResource("OF.badVer.ex.fmt.txt"), (Object)wizardVersionKey, (Object)value);
                factory.error(message);
                throw new RuntimeException(message);
            }
            this._wizardTypeIs93 = ver == 2;
        }
        catch (NumberFormatException nfe) {
            message = Message.format((String)RB.getStringResource("OF.badVer.ex.fmt.txt"), (Object)wizardVersionKey, (Object)value);
            factory.error((Throwable)nfe, message);
            throw new RuntimeException(message, nfe);
        }
    }

    public LogicalObjectInterface createItemFromMetadataObject(Root root) throws RemoteException {
        if (!this.isObjectOfInterest(root)) {
            throw new IllegalArgumentException("Internal logic error: Not an object of interest " + root.toString() + " .");
        }
        StoredProcessLogicalObject sp = new StoredProcessLogicalObject((ClassifierMap)root, (TypeInterface)this._type, this._type.getFactory());
        return sp;
    }

    public List getPropertyTabs(LogicalObjectInterface logicalObject, Root complexSP, Config config) throws MdException, RemoteException {
        if (!this.isObjectOfInterest(complexSP)) {
            throw new IllegalArgumentException("Internal logic error: Not an object of interest " + complexSP.toString() + " .");
        }
        if (config == null) {
            config = new Config();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        ClassifierMap classifierMap = (ClassifierMap)complexSP;
        AssociationList al = classifierMap.getTrees();
        Tree tree = al.size() > 0 ? (Tree)al.get(0) : null;
        MetadataManipulator metadataManipulator = new MetadataManipulator(classifierMap);
        double uv = complexSP.getUsageVersion();
        boolean nine_two = uv == NINETWO_VERSION.encode();
        GeneralTabPanel generalTab = new GeneralTabPanel(classifierMap, tree, 1, logicalObject, config, metadataManipulator, nine_two);
        list.add((Object)generalTab);
        if (logicalObject.isReadCompatible()) {
            SmartWsDescriptionWizardTab executionTab;
            if (nine_two) {
                executionTab = new NewExecutionTabPanel(classifierMap, this, 1, UtilMetadata.makeRepositoryFQIDFromRoot((Root)classifierMap), null, config, metadataManipulator);
                list.add(executionTab);
            } else {
                executionTab = new ExecutionTabPanel93(classifierMap, this, 1, UtilMetadata.makeRepositoryFQIDFromRoot((Root)classifierMap), null, config, metadataManipulator);
                list.add(executionTab);
            }
            if (config.isVisible(ConfigParameterPanel.PANEL)) {
                NewParameterTabPanel parameterTab = new NewParameterTabPanel(classifierMap, 1, config, metadataManipulator);
                list.add((Object)parameterTab);
            }
            DataTabPanel dataTab = new DataTabPanel(classifierMap, 1, config, metadataManipulator);
            list.add((Object)dataTab);
        }
        return list;
    }

    public static SourceLocation getSourceLocation(ClassifierMap classifierMap) throws MdException, RemoteException {
        if (classifierMap.getTransformRole().equalsIgnoreCase("StoredProcess")) {
            return UtilMetadataSP.getSourceCodeLocation(classifierMap);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogicalObjectInterface create(Tree tree, WizardCompletionInterface wizardInterface, Config config) throws MdException, IllegalArgumentException, RemoteException {
        StoredProcessLogicalObject item;
        block12: {
            item = null;
            if (config == null) {
                config = new Config();
            }
            Frame frame = Factory.getInstance().getFrame();
            MdObjectStore objectStore = this._factory.getMdFactory().createObjectStore();
            tree = (Tree)this._factory.getOMIUtil().getMetadataAllDepths((MdStore)objectStore, tree.getCMetadataType(), tree.getFQID(), null, null, null, 264);
            try {
                String repositoryFQID = UtilMetadata.makeRepositoryFQIDFromRoot((Root)tree);
                ClassifierMap classifierMap = (ClassifierMap)UtilMetadata.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)tree, (String)"SP Classifier Map", (String)"ClassifierMap");
                classifierMap.setTransformRole("StoredProcess");
                classifierMap.setPublicType("StoredProcess");
                double desiredUV = config.getUsageVersion();
                if (desiredUV == -1.0) {
                    desiredUV = NINETWO_VERSION.encode();
                } else if (desiredUV != NINETWO_VERSION.encode() && desiredUV != NINETHREE_VERSION.encode()) {
                    throw new IllegalArgumentException("Value of " + desiredUV + " for usage version is not supported.");
                }
                classifierMap.setUsageVersion(desiredUV);
                NewStoredProcessWizard wizard = new NewStoredProcessWizard(this, frame, classifierMap, wizardInterface, repositoryFQID, tree, config);
                wizard.show();
                if (wizard.getReturnValue() != 1) break block12;
                frame.setCursor(Cursor.getPredefinedCursor(3));
                try {
                    classifierMap.getTrees().add((Object)tree);
                    objectStore.updatedMetadataAll();
                    item = new StoredProcessLogicalObject(classifierMap, (TypeInterface)this._type, this._type.getFactory());
                }
                catch (MdException mde) {
                    UtilGui.displayMdException((MdException)mde);
                }
                finally {
                    frame.setCursor(Cursor.getPredefinedCursor(0));
                }
            }
            finally {
                objectStore.dispose();
            }
        }
        return item;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllObjects(String reposID) throws MdException, RemoteException {
        if (reposID == null) {
            throw new IllegalArgumentException("logic error: no reposid specified");
        }
        if (this._options == null) {
            this._options = "<XMLSELECT Search=\"*[@TransformRole='StoredProcess']\"/><Templates><ClassifierMap " + this.getFactory().getTemplateFormOfRequiredAndNeededAttributes((TypeInterface)this._type) + "/></Templates>";
        }
        ArrayList<LogicalObjectInterface> list = new ArrayList<LogicalObjectInterface>();
        MdObjectStore myStore = this._factory.getMdFactory().createObjectStore();
        try {
            List storedProcesses = this._factory.getOMIUtil().getMetadataObjectsSubset((MdStore)myStore, reposID, "ClassifierMap", 388, this._options);
            for (ClassifierMap cm : storedProcesses) {
                list.add(this.createItemFromMetadataObject((Root)cm));
            }
        }
        finally {
            myStore.dispose();
        }
        return list;
    }

    public Action[] getActions(LogicalObjectInterface logicalObject, Root root, Config config) throws RemoteException {
        if (logicalObject instanceof FolderInterface) {
            if (!(root == null || root.getCMetadataType().equalsIgnoreCase("Tree") && logicalObject.getID().equalsIgnoreCase(root.getFQID()))) {
                throw new IllegalArgumentException("Logic error: Tree with FQID " + logicalObject.getID() + " expected.  Root object is " + root.getCMetadataType() + " with id " + root.getFQID());
            }
            try {
                Action[] array = new Action[]{this._wizardTypeIs93 ? new NewStoredProcessAction(this.getFactory().getFrame(), (FolderInterface)logicalObject, (Tree)root, this, config) : new NewStoredProcessAction92(this.getFactory().getFrame(), (FolderInterface)logicalObject, (Tree)root, this, config)};
                array[0].setEnabled(((FolderInterface)logicalObject).isCreateChildAllowed());
                return array;
            }
            catch (LogicalTypeException e) {
                UtilGui.displayExceptionError((Exception)((Object)e));
                return EMPTY_ACTION_ARRAY;
            }
        }
        if (logicalObject instanceof StoredProcessLogicalObject) {
            if (!(root instanceof ClassifierMap)) {
                throw new IllegalArgumentException("Logic error: ClassifierMap with FQID " + logicalObject.getID() + " expected.  Root object is " + root.getCMetadataType() + " with id " + root.getFQID());
            }
            Action[] actions = new Action[2];
            actions[0] = new WebServiceDeployAction(this.getFactory().getFrame(), logicalObject, root);
            if (logicalObject.getUsageVersion().equals((Object)NINETWO_VERSION)) {
                actions[1] = new ChangeVersionAction(logicalObject, (ClassifierMap)root, true);
            } else if (logicalObject.getUsageVersion().equals((Object)CURRENT_VERSION)) {
                actions[1] = new ChangeVersionAction(logicalObject, (ClassifierMap)root, false);
            } else {
                Action[] newArray = new Action[]{actions[0]};
                actions = newArray;
            }
            return actions;
        }
        return EMPTY_ACTION_ARRAY;
    }

    public Action[] getActions(LogicalObjectInterface[] logicalObjects, Root[] roots, Config config) throws RemoteException {
        if (logicalObjects.length == 1) {
            if (roots == null) {
                return this.getActions(logicalObjects[0], null, config);
            }
            if (roots.length == 1) {
                return this.getActions(logicalObjects[0], roots[0], config);
            }
            throw new IllegalArgumentException("Only one element should be present in the roots (parameter) array.");
        }
        if (logicalObjects.length != roots.length) {
            throw new IllegalArgumentException("Logic error: The number of logical objects " + logicalObjects.length + " is not the same as the number of metadata objects " + roots.length);
        }
        StoredProcessVersionsPresent versionsPresent = new StoredProcessVersionsPresent(logicalObjects, roots);
        if (this.allLogicalObjectsAreStoredProcesses(versionsPresent)) {
            int actionCount = 1;
            if (versionsPresent._v1) {
                ++actionCount;
            }
            if (versionsPresent._v2) {
                ++actionCount;
            }
            Action[] actions = new Action[actionCount];
            int nextActionNumber = 0;
            actions[nextActionNumber++] = new WebServiceDeployAction(this.getFactory().getFrame(), logicalObjects, roots);
            if (versionsPresent._v1) {
                actions[nextActionNumber++] = new ChangeVersionAction(logicalObjects, versionsPresent._classifierMaps, true);
            }
            if (versionsPresent._v2) {
                actions[nextActionNumber++] = new ChangeVersionAction(logicalObjects, versionsPresent._classifierMaps, false);
            }
            return actions;
        }
        return EMPTY_ACTION_ARRAY;
    }

    private boolean allLogicalObjectsAreStoredProcesses(StoredProcessVersionsPresent versionsPresent) throws RemoteException {
        LogicalObjectInterface[] logicalObjects = versionsPresent._logicalObjects;
        Root[] roots = versionsPresent._roots;
        int numberOfLogicalObjects = logicalObjects.length;
        if (numberOfLogicalObjects == 0) {
            return false;
        }
        ClassifierMap[] classifierMaps = new ClassifierMap[numberOfLogicalObjects];
        for (int i = 0; i < numberOfLogicalObjects; ++i) {
            if (!(logicalObjects[i] instanceof StoredProcessLogicalObject)) {
                return false;
            }
            if (logicalObjects[i].getUsageVersion().equals((Object)NINETWO_VERSION)) {
                versionsPresent._v1 = true;
            } else if (logicalObjects[i].getUsageVersion().equals((Object)NINETHREE_VERSION)) {
                versionsPresent._v2 = true;
            }
            if (!(roots[i] instanceof ClassifierMap)) {
                throw new IllegalArgumentException("Logic error: ClassifierMap with FQID " + logicalObjects[i].getID() + " expected.  Root object is " + roots[i].getCMetadataType() + " with id " + roots[i].getFQID());
            }
            classifierMaps[i] = (ClassifierMap)roots[i];
        }
        versionsPresent._classifierMaps = classifierMaps;
        return true;
    }

    private static class StoredProcessVersionsPresent {
        boolean _v1;
        boolean _v2;
        LogicalObjectInterface[] _logicalObjects;
        Root[] _roots;
        ClassifierMap[] _classifierMaps;

        StoredProcessVersionsPresent(LogicalObjectInterface[] logicalObjects, Root[] roots) {
            this._logicalObjects = logicalObjects;
            this._roots = roots;
        }
    }

    public static class SourceLocation {
        private ClassifierMap _storedProcess;
        private LogicalServer _logicalServer;
        private ServerContext _serverContext;
        private Directory _storedProcessRepository;
        private File _storedProcessFileName;
        private boolean _sourceInMetadata;

        SourceLocation(ClassifierMap storedProcess, LogicalServer logicalServer, Directory storedProcessRepository, File storedProcessFile) {
            this._storedProcess = storedProcess;
            this._logicalServer = logicalServer;
            this._storedProcessRepository = storedProcessRepository;
            this._storedProcessFileName = storedProcessFile;
        }

        SourceLocation(ClassifierMap storedProcess, ServerContext serverContext, Directory storedProcessRepository, File storedProcessFile, boolean sourceInMetadata) {
            this._storedProcess = storedProcess;
            this._serverContext = serverContext;
            this._storedProcessRepository = storedProcessRepository;
            this._storedProcessFileName = storedProcessFile;
            this._sourceInMetadata = sourceInMetadata;
        }

        public ClassifierMap getStoredProcess() {
            return this._storedProcess;
        }

        public Directory getStoredProcessRepository() {
            return this._storedProcessRepository;
        }

        public File getStoredProcessFile() {
            return this._storedProcessFileName;
        }

        public LogicalServer getLogicalServerFQID() {
            return this._logicalServer;
        }

        public ServerContext getServerContext() {
            return this._serverContext;
        }

        public boolean isSourceInMetadata() {
            return this._sourceInMetadata;
        }
    }
}

