/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.metadata.logical.storedprocess.ConfigExecutionPanel;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.EditableComboBox;
import com.sas.metadata.logical.visuals.ListElementInterface;
import com.sas.metadata.logical.visuals.SmartWsDescriptionWizardTab;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.swing.visuals.util.Util;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.workspace.WATextField;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.rmi.RemoteException;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

abstract class NewExecutionTabVC
extends SmartWsDescriptionWizardTab {
    private static final int DISABLE_SERVER = 1;
    private static final int DISABLE_SOURCE_CODE_REPOSITORY = 2;
    private static final int DISABLE_SOURCE_FILE = 4;
    private JLabel _lblServer;
    protected DefaultComboBoxModel _serverComboBoxModel;
    protected EditableComboBox _comboServer;
    private JLabel _lblRepository;
    protected DefaultComboBoxModel _repositoryComboBoxModel;
    protected EditableComboBox _comboRepository;
    private JButton _btnManageRepository;
    private int _disableVisual;
    private JLabel _lblFile;
    protected WATextField _txtFile;
    private JButton _btnEditFile;
    private JLabel _lblResults;
    protected JCheckBox _streamCB;
    protected JCheckBox _packageCB;
    protected Config _config;

    public NewExecutionTabVC(int type, Config config) {
        String description = (String)config.getInitValue(ConfigExecutionPanel.WIZARD_DESCRIPTION, (Object)RB.getStringResource("NETVC.Wiz.txt"));
        this.setDescription(description);
        this._disableVisual = 0;
        if (!config.isEnabled(ConfigExecutionPanel.SERVER)) {
            this._disableVisual |= 1;
        }
        if (!config.isEnabled(ConfigExecutionPanel.SOURCE_CODE_REPOSITORY)) {
            this._disableVisual |= 2;
        }
        if (!config.isEnabled(ConfigExecutionPanel.SOURCE_FILE)) {
            this._disableVisual |= 4;
        }
        this.initialize(type);
        this.layoutWidgets();
        this._config = config;
    }

    protected void initialize(int type) {
        this.setName(RB.getStringResource("NETVC.Tab.txt"));
        if (type == 1) {
            this.setHelpProduct("storedprocess");
            this.setHelpTopic("stp_executiontab");
        } else {
            this.setHelpProduct("newstp");
            this.setHelpTopic("executionwin");
        }
        this._serverComboBoxModel = new DefaultComboBoxModel();
        this._comboServer = new EditableComboBox(this._serverComboBoxModel, false){

            protected void doListItemSelected(ListElementInterface le) {
                try {
                    NewExecutionTabVC.this.doServerSelected(le, (Component)((Object)this));
                }
                catch (RemoteException e) {
                    UtilGui.displayRemoteException((RemoteException)e);
                }
            }
        };
        if ((this._disableVisual & 1) != 0) {
            this._comboServer.setEnabled(false);
        }
        this._comboServer.setToolTipText(RB.getStringResource("NETVC.Tooltip.Srvr.txt"));
        this._lblServer = UtilGui.createLabelForComponent((Component)this._comboServer, (String)RB.getStringResource("NETVC.Lbl.Srvr.txt"));
        this._repositoryComboBoxModel = new DefaultComboBoxModel();
        this._comboRepository = new EditableComboBox(this._repositoryComboBoxModel, false){

            protected void doListItemSelected(ListElementInterface le) {
            }
        };
        this._comboRepository.setToolTipText(RB.getStringResource("NETVC.Tooltip.Repo.txt"));
        this._lblRepository = UtilGui.createLabelForComponent((Component)this._comboRepository, (String)RB.getStringResource("NETVC.Lbl.Repo.txt"));
        this._btnManageRepository = UtilGui.createButton((String)RB.getStringResource("COM.Btn.Manage0.txt"));
        this._btnManageRepository.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    NewExecutionTabVC.this.doManageRepository();
                }
                catch (RemoteException e) {
                    UtilGui.displayRemoteException((RemoteException)e);
                }
            }
        });
        this._txtFile = new WATextField();
        this._txtFile.setMaxCharacters(256);
        this._txtFile.setToolTipText(RB.getStringResource("NETVC.Tooltip.FilNm.txt"));
        this._lblFile = UtilGui.createLabelForComponent((Component)this._txtFile, (String)RB.getStringResource("NETVC.Lbl.FilNm.txt"));
        this._btnEditFile = UtilGui.createButton((String)RB.getStringResource("COM.Btn.Mod0.txt"));
        this._btnEditFile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                NewExecutionTabVC.this.doEditFile();
            }
        });
        if ((this._disableVisual & 2) != 0) {
            this._btnManageRepository.setEnabled(false);
            this._comboRepository.setEnabled(false);
        }
        if ((this._disableVisual & 4) != 0) {
            this._txtFile.setEnabled(false);
        }
        this._lblResults = new JLabel(RB.getStringResource("NETVC.Lbl.Results.txt"));
        this._streamCB = UtilGui.createCheckBox((String)RB.getStringResource("NETVC.Lbl.ResStrm.txt"));
        this._packageCB = UtilGui.createCheckBox((String)RB.getStringResource("NETVC.Lbl.ResPkg.txt"));
    }

    public void setEditable(boolean editable) {
        super.setEditable(editable);
        this._comboServer.setEnabled(editable && (this._disableVisual & 1) == 0);
        this._txtFile.setEnabled(editable && (this._disableVisual & 4) == 0);
        this._btnManageRepository.setEnabled(editable && (this._disableVisual & 2) == 0);
        this._comboRepository.setEnabled(editable && (this._disableVisual & 2) == 0);
        Util.configureMnemonicForButton((AbstractButton)this._btnEditFile, (String)RB.getStringResource(editable ? "COM.Btn.Mod0.txt" : "NETVC.Lbl.EditView.txt"));
        this._streamCB.setEnabled(editable);
        this._packageCB.setEnabled(editable);
    }

    protected void setRepositoryListener(boolean on) {
        this._comboRepository.setListener(on);
    }

    protected void setServerListener(boolean on) {
        this._comboServer.setListener(on);
    }

    protected void enableManageRepository(boolean on) {
        if (this.isEditable() && (this._disableVisual & 2) == 0) {
            this._btnManageRepository.setEnabled(on);
        }
    }

    protected void layoutWidgets() {
        this.setLayout(new GridBagLayout());
        int row = 0;
        this.add(this._lblServer, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        this.add((Component)this._comboServer, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_ROW, 0, 0));
        this.add(this._lblRepository, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        this.add((Component)this._comboRepository, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_ROW, 0, 0));
        this.add(this._btnManageRepository, new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 18, 0, NEXT_INSETS_IN_ROW, 0, 0));
        this.add(this._lblFile, new GridBagConstraints(0, ++row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        this.add((Component)this._txtFile, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_ROW, 0, 0));
        this.add(this._btnEditFile, new GridBagConstraints(2, row, 1, 1, 0.0, 0.0, 18, 2, NEXT_INSETS_IN_ROW, 0, 0));
        ++row;
        JPanel resultsPanel = new JPanel();
        AutoSizingGridLayout resultsPanelLayout = new AutoSizingGridLayout(1, 2, 0, 5, true, false, true);
        resultsPanel.setLayout((LayoutManager)resultsPanelLayout);
        resultsPanel.add(this._streamCB);
        resultsPanel.add(this._packageCB);
        this.add(this._lblResults, new GridBagConstraints(0, row, 1, 1, 0.0, 0.0, 18, 0, FIRST_INSETS_IN_ROW, 0, 0));
        this.add(resultsPanel, new GridBagConstraints(1, row, 1, 1, 1.0, 0.0, 18, 2, NEXT_INSETS_IN_ROW, 0, 0));
        JPanel eaterPanel = new JPanel();
        this.add(eaterPanel, new GridBagConstraints(0, ++row, 3, 1, 1.0, 1.0, 10, 1, NEXT_INSETS_IN_ROW, 0, 0));
    }

    protected abstract void doEditFile();

    protected abstract void doManageRepository() throws RemoteException;

    protected abstract void doServerSelected(ListElementInterface var1, Component var2) throws RemoteException;
}

