/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.metadata.logical.ObjectContainer;
import com.sas.metadata.logical.ObjectFactoryInterface;
import com.sas.metadata.logical.UtilMetadata;
import com.sas.metadata.logical.server.RepositoryListElement;
import com.sas.metadata.logical.storedprocess.ConfigExecutionPanel;
import com.sas.metadata.logical.storedprocess.MetadataManipulator;
import com.sas.metadata.logical.storedprocess.NewExecutionTabVC;
import com.sas.metadata.logical.storedprocess.ObjectFactory;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.storedprocess.RepositoryManagerDialog;
import com.sas.metadata.logical.storedprocess.UtilMetadataSP;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.ListElementInterface;
import com.sas.metadata.logical.visuals.MetadataDialog;
import com.sas.metadata.logical.visuals.ServerComponentListElement;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.ArchiveFile;
import com.sas.metadata.remote.AssociationList;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Directory;
import com.sas.metadata.remote.File;
import com.sas.metadata.remote.LogicalServer;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Property;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.ServerComponent;
import com.sas.metadata.remote.Text;
import com.sas.workspace.MessageUtil;
import java.awt.Component;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

class NewExecutionTabPanel
extends NewExecutionTabVC {
    private ClassifierMap _classifierMap;
    private ObjectFactoryInterface _objectFactory;
    private ObjectContainer _sourceCodeLocationOC;
    private File _sourceFile;
    private Directory _sourceDirectory;
    private MetadataManipulator _metadataManipulator;
    private String _serverRepositoryID;
    private int _type;
    private LogicalServer _displayedLogicalServer;
    private boolean _packageSupported;
    private boolean _streamSupported;
    private Element _resultCapabilities;
    private boolean _packagesSupportedForWorkspaceServers;
    private boolean _streamsSupportedForWorkspaceServers;
    private boolean _packagesSupportedForStoredProcessServers;
    private boolean _streamsSupportedForStoredProcessServers;
    private boolean _dataPreviouslyMovedToView;
    private ArrayList _sourceRepositories = new ArrayList();
    private ArrayList _servers = new ArrayList();
    private ServerComponentListElement _displayedLogicalServerListElement;

    NewExecutionTabPanel(ClassifierMap classifierMap, ObjectFactoryInterface objectFactory, int type, String serverRepositoryID, ObjectContainer sourceCodeLocationOC, Config config, MetadataManipulator metadataManipulator) {
        super(type, config);
        this._classifierMap = classifierMap;
        this._objectFactory = objectFactory;
        this._sourceCodeLocationOC = sourceCodeLocationOC;
        this._type = type;
        this._serverRepositoryID = serverRepositoryID;
        this._metadataManipulator = metadataManipulator;
        this.setAllowedResultCapabilities();
    }

    private void setAllowedResultCapabilities() {
        ArrayList<Object> coll;
        this._packagesSupportedForWorkspaceServers = true;
        this._streamsSupportedForWorkspaceServers = false;
        this._packagesSupportedForStoredProcessServers = true;
        this._streamsSupportedForStoredProcessServers = true;
        if (this._config == null) {
            return;
        }
        Object o = this._config.getInitValue(ConfigExecutionPanel.RESULT_CAPABILITIES, null);
        if (o == null) {
            return;
        }
        if (o instanceof Collection) {
            coll = (ArrayList<Object>)o;
        } else {
            coll = new ArrayList<Object>();
            coll.add(o);
        }
        for (ConfigExecutionPanel.ResultCapabilities resultCapabilities : coll) {
            Set capSet = resultCapabilities._value;
            if (resultCapabilities._serverType == ConfigExecutionPanel.STORED_PROCESS_SERVERS) {
                this._packagesSupportedForStoredProcessServers = capSet.contains(ConfigExecutionPanel.PACKAGE);
                this._streamsSupportedForStoredProcessServers = capSet.contains(ConfigExecutionPanel.STREAM);
                continue;
            }
            if (resultCapabilities._serverType != ConfigExecutionPanel.WORKSPACE_SERVERS) continue;
            this._packagesSupportedForWorkspaceServers = capSet.contains(ConfigExecutionPanel.PACKAGE);
            this._streamsSupportedForWorkspaceServers = capSet.contains(ConfigExecutionPanel.STREAM);
        }
    }

    @Override
    public void setEditable(boolean editable) {
        super.setEditable(editable);
    }

    protected void smartPopulateStore() throws MdException, RemoteException {
        this.determineAvailbleServers();
        UtilMetadataSP.determineAllRepositoryContextsForLogicalServer(null, 2, this._displayedLogicalServer, this._sourceRepositories, null);
        if (this._type == 1) {
            this.determineRepositoryContextAndFileNameForThisStoredProcess();
            this.determineResultCapabilitiesOfThisStoredProcess();
        }
    }

    public void moveDataToView() throws MdException, RemoteException {
        if (!this._dataPreviouslyMovedToView) {
            this.setServersInVisual();
            this.setAllRepositoryContextsBasedOnDisplayedServer();
            this.enableValidResultCapabilitiesBasedOnDisplayedServer();
            if (this._type == 1) {
                if (this._displayedLogicalServer != null) {
                    this.setRepositoryContextAndFileNameForThisStoredProcess();
                    this.setResultCapabilitiesForThisStoredProcess();
                }
            } else {
                String sourceFile;
                String sourceCodeRepository = (String)this._config.getInitValue(ConfigExecutionPanel.SOURCE_CODE_REPOSITORY, null);
                if (sourceCodeRepository != null) {
                    int size = this._repositoryComboBoxModel.getSize();
                    for (int i = 0; i < size; ++i) {
                        RepositoryListElement re = (RepositoryListElement)this._repositoryComboBoxModel.getElementAt(i);
                        if (!re.isReal() || !re.getDirectory().getDirectoryName().equals(sourceCodeRepository)) continue;
                        this._repositoryComboBoxModel.setSelectedItem(re);
                        break;
                    }
                }
                if ((sourceFile = (String)this._config.getInitValue(ConfigExecutionPanel.SOURCE_FILE, null)) != null) {
                    this._txtFile.setText(sourceFile);
                }
            }
            this.enableManageRepository(this._displayedLogicalServer != null);
            this._dataPreviouslyMovedToView = true;
        }
    }

    protected boolean dataValidate() {
        ServerComponentListElement sle = (ServerComponentListElement)this._serverComboBoxModel.getSelectedItem();
        if (sle == null || !sle.isRealServer()) {
            MessageUtil.displayMessage((String)RB.getStringResource("ETP.NoSrvr.txt"), (String)RB.getStringResource("ETP.NoSrvr.title.txt"), (int)0);
            this._comboServer.requestFocus();
            return false;
        }
        RepositoryListElement re = (RepositoryListElement)this._repositoryComboBoxModel.getSelectedItem();
        if (!re.isReal()) {
            MessageUtil.displayMessage((String)RB.getStringResource("ETP.NoSoRepo.txt"), (String)RB.getStringResource("ETP.RepoErr.title.txt"), (int)0);
            this._comboRepository.requestFocus();
            return false;
        }
        String newFileName = this._txtFile.getText().trim();
        if (newFileName.length() == 0) {
            MessageUtil.displayMessage((String)RB.getStringResource("ETP.NoName.txt"), (String)RB.getStringResource("ETP.NoName.title.txt"), (int)0);
            this._txtFile.requestFocus();
            return false;
        }
        if (this._metadataManipulator._hasStreams && !this._metadataManipulator._storedProcessServerSelected) {
            MessageUtil.displayMessage((String)RB.getStringResource("NETP.ServrInvldForStrms.msg.txt"), (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
            return false;
        }
        return true;
    }

    private void determineAvailbleServers() throws MdException, RemoteException {
        this._displayedLogicalServer = null;
        this._displayedLogicalServerListElement = null;
        this._servers.clear();
        LogicalServer cmLogicalServer = null;
        AssociationList logicalServers = this._classifierMap.getComputeLocations();
        if (logicalServers.size() > 0) {
            this._displayedLogicalServer = cmLogicalServer = (LogicalServer)logicalServers.get(0);
            this._displayedLogicalServerListElement = new ServerComponentListElement((ServerComponent)cmLogicalServer);
            this._servers.add(this._displayedLogicalServerListElement);
        }
        int findFlag = 3;
        Set filters = this._config.getFilter(ConfigExecutionPanel.SERVER);
        if (filters != null) {
            findFlag = 0;
            for (Config.Filter filter : filters) {
                if (filter == ConfigExecutionPanel.STORED_PROCESS_SERVERS) {
                    findFlag |= 2;
                    continue;
                }
                if (filter != ConfigExecutionPanel.WORKSPACE_SERVERS) continue;
                findFlag |= 1;
            }
        }
        String serverNameOfDesiredServer = null;
        if (this._type == 0) {
            serverNameOfDesiredServer = (String)this._config.getInitValue(ConfigExecutionPanel.SERVER, null);
        }
        List servers = UtilMetadataSP.findStoredProcessAndWorkspaceServers(this._classifierMap.getObjectStore(), this._serverRepositoryID, findFlag);
        for (LogicalServer ls : servers) {
            if (cmLogicalServer != null && cmLogicalServer.getFQID().equals(ls.getFQID())) continue;
            ServerComponentListElement scle = new ServerComponentListElement((ServerComponent)ls);
            this._servers.add(scle);
            if (serverNameOfDesiredServer == null || !serverNameOfDesiredServer.equals(ls.getName())) continue;
            this._displayedLogicalServer = ls;
            this._displayedLogicalServerListElement = scle;
            this._metadataManipulator._storedProcessServerSelected = this._displayedLogicalServer.getClassIdentifier().equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c");
        }
    }

    private void setServersInVisual() throws MdException {
        this.setServerListener(false);
        this._serverComboBoxModel.removeAllElements();
        if (this._displayedLogicalServer == null) {
            this._displayedLogicalServerListElement = ServerComponentListElement.SELECT_A_SERVER;
            this._serverComboBoxModel.addElement(this._displayedLogicalServerListElement);
        }
        Iterator it = this._servers.iterator();
        while (it.hasNext()) {
            this._serverComboBoxModel.addElement(it.next());
        }
        if (this._displayedLogicalServerListElement != null) {
            this._serverComboBoxModel.setSelectedItem(this._displayedLogicalServerListElement);
        }
        this.setServerListener(true);
    }

    private void setAllRepositoryContextsBasedOnDisplayedServer() {
        this._repositoryComboBoxModel.removeAllElements();
        if (this._displayedLogicalServerListElement == null || !this._displayedLogicalServerListElement.isRealServer()) {
            return;
        }
        Iterator it = this._sourceRepositories.iterator();
        this._repositoryComboBoxModel.addElement(RepositoryListElement.SELECT_A_REPOSITORY);
        while (it.hasNext()) {
            this._repositoryComboBoxModel.addElement(new RepositoryListElement((Directory)it.next()));
        }
    }

    private void determineRepositoryContextAndFileNameForThisStoredProcess() throws MdException, RemoteException {
        if (this._displayedLogicalServer == null) {
            this._classifierMap.setSourceCode(null);
            return;
        }
        UtilMetadataSP.DirectoryAndFile df = UtilMetadataSP.determineDirectoryAndFile(this._classifierMap);
        if (df._file != null) {
            this._sourceFile = df._file;
            this._txtFile.setText(this._sourceFile.getFileName());
            this._sourceDirectory = df._directory;
        }
    }

    private void setRepositoryContextAndFileNameForThisStoredProcess() throws MdException, RemoteException {
        Text sc = this._classifierMap.getSourceCode();
        if (sc instanceof File) {
            this._txtFile.setText(this._sourceFile.getFileName());
            if (this._sourceDirectory == null) {
                MessageUtil.displayMessage((String)RB.getStringResource("ETP.BadRepo.txt"), (String)RB.getStringResource("ETP.RepoErr.title.txt"), (int)0);
            } else {
                this.setDirectoryAsSelectedAddingToModelIfNeeded(this._sourceDirectory, this._repositoryComboBoxModel);
            }
        }
    }

    private RepositoryListElement setDirectoryAsSelected(String directory, DefaultComboBoxModel model) throws RemoteException {
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            RepositoryListElement re = (RepositoryListElement)model.getElementAt(i);
            if (!re.isReal() || !re.getDirectory().getDirectoryName().equals(directory)) continue;
            model.setSelectedItem(re);
            return re;
        }
        return null;
    }

    private RepositoryListElement setDirectoryAsSelectedAddingToModelIfNeeded(Directory directory, DefaultComboBoxModel model) {
        RepositoryListElement selected = null;
        int size = model.getSize();
        for (int i = 0; i < size; ++i) {
            RepositoryListElement re = (RepositoryListElement)model.getElementAt(i);
            if (!re.isReal() || re.getDirectory() != directory) continue;
            selected = re;
            break;
        }
        if (selected == null) {
            selected = new RepositoryListElement(directory);
            model.addElement(selected);
        }
        model.setSelectedItem(selected);
        return selected;
    }

    private void enableValidResultCapabilitiesBasedOnDisplayedServer() throws RemoteException {
        if (this._displayedLogicalServer != null && this.isEditable()) {
            if (this._displayedLogicalServer.getClassIdentifier().equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c")) {
                this._packageCB.setEnabled(this._packagesSupportedForStoredProcessServers);
                this._streamCB.setEnabled(this._streamsSupportedForStoredProcessServers);
            } else {
                this._packageCB.setEnabled(this._packagesSupportedForWorkspaceServers);
                if (this._streamCB.isEnabled() && this._streamCB.isSelected() && !this._streamsSupportedForWorkspaceServers) {
                    UtilGui.displayWarning((String)RB.getStringResource("NETP.WrksNoStrms.msg.txt"));
                    this._streamCB.setSelected(false);
                }
                this._streamCB.setEnabled(this._streamsSupportedForWorkspaceServers);
            }
        } else {
            this._packageCB.setEnabled(false);
            this._streamCB.setEnabled(false);
        }
    }

    private void determineResultCapabilitiesOfThisStoredProcess() throws MdException {
        this._packageSupported = false;
        this._streamSupported = false;
        Element spE = this._metadataManipulator.getStoredProcessXMLElementIfExists();
        if (spE == null) {
            return;
        }
        NodeList list = spE.getElementsByTagName("ResultCapabilities");
        if (list.getLength() == 0) {
            return;
        }
        if (list.getLength() > 1) {
            throw new MdException(RB.getStringResource("NETP.MultplRCTag.txt"));
        }
        this._resultCapabilities = (Element)list.item(0);
        String value = this._resultCapabilities.getAttribute("Package");
        if (value != null && value.equalsIgnoreCase("true")) {
            this._packageSupported = true;
        }
        if ((value = this._resultCapabilities.getAttribute("Streaming")) != null && value.equalsIgnoreCase("true")) {
            this._streamSupported = true;
        }
    }

    private void setResultCapabilitiesForThisStoredProcess() {
        this._packageCB.setSelected(this._packageSupported);
        this._streamCB.setSelected(this._streamSupported);
    }

    @Override
    protected void doServerSelected(ListElementInterface lei, Component c) throws RemoteException {
        boolean selectedLSIsSTP;
        boolean displayedLogicalServerIsSTP;
        ServerComponentListElement le = (ServerComponentListElement)lei;
        LogicalServer selectedLS = (LogicalServer)le.getServerComponent();
        if (this._displayedLogicalServer == selectedLS) {
            return;
        }
        this.enableManageRepository(selectedLS != null);
        boolean serverTypeChanged = this._displayedLogicalServer == null || selectedLS == null ? true : (displayedLogicalServerIsSTP = this._displayedLogicalServer.getClassIdentifier().equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c")) != (selectedLSIsSTP = selectedLS.getClassIdentifier().equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c"));
        this._displayedLogicalServerListElement = le;
        this._displayedLogicalServer = selectedLS;
        Component parent = SwingUtilities.getRoot(c);
        try {
            UtilMetadataSP.determineAllRepositoryContextsForLogicalServer(parent, 2, this._displayedLogicalServer, this._sourceRepositories, null);
            this.setAllRepositoryContextsBasedOnDisplayedServer();
        }
        catch (MdException e) {
            UtilGui.displayMdException((MdException)e);
            this.setOtherMetaDataException();
        }
        if (serverTypeChanged) {
            this.enableValidResultCapabilitiesBasedOnDisplayedServer();
        }
        if (this._displayedLogicalServer != null) {
            this._metadataManipulator._storedProcessServerSelected = this._displayedLogicalServer.getClassIdentifier().equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c");
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    protected void doEditFile() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 4[CATCHBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    protected void doManageRepository() throws RemoteException {
        try {
            MetadataDialog dialog;
            int retVal;
            ObjectContainer objectContainer = new ObjectContainer();
            RepositoryListElement re = (RepositoryListElement)this._repositoryComboBoxModel.getSelectedItem();
            if (re != null && re.isReal()) {
                objectContainer.setObject((Object)re.getDirectory());
            }
            if ((retVal = (dialog = RepositoryManagerDialog.createInstance((JComponent)((Object)this), this._displayedLogicalServer, this._repositoryComboBoxModel, objectContainer, this._objectFactory.getFactory())).doModal()) == 1) {
                Directory dirToUse = (Directory)objectContainer.getObject();
                if (dirToUse == null && re != null) {
                    dirToUse = re.getDirectory();
                }
                UtilMetadataSP.determineAllRepositoryContextsForLogicalServer((Component)((Object)this), 2, this._displayedLogicalServer, this._sourceRepositories, null);
                this.setAllRepositoryContextsBasedOnDisplayedServer();
                if (dirToUse != null) {
                    this.setDirectoryAsSelected(dirToUse.getDirectoryName(), this._repositoryComboBoxModel);
                }
            }
        }
        catch (MdException e) {
            UtilGui.displayMdException((MdException)e);
            this.setOtherMetaDataException();
        }
    }

    public void moveDataToStore() throws MdException, RemoteException {
        boolean isWorkspaceServer;
        ServerComponentListElement sle = (ServerComponentListElement)this._serverComboBoxModel.getSelectedItem();
        AssociationList al = this._classifierMap.getComputeLocations();
        al.removeAllElements();
        al.add((Object)sle.getServerComponent());
        boolean bl = isWorkspaceServer = !sle.getServerComponent().getClassIdentifier().equalsIgnoreCase("15931e31-667f-11d5-8804-00c04f35ac8c");
        if (this._sourceFile == null) {
            this._sourceFile = (File)UtilMetadata.createANewComplexObjectToBeAssociatedWithGivenObject((CMetadata)this._classifierMap, (String)"SP Source File", (String)"File");
            this._classifierMap.setSourceCode((Text)this._sourceFile);
        }
        this._sourceFile.setFileName(this._txtFile.getText().trim());
        this._sourceFile.setIsARelativeName(1);
        RepositoryListElement re = (RepositoryListElement)this._repositoryComboBoxModel.getSelectedItem();
        al = this._sourceFile.getDirectories();
        al.removeAllElements();
        al.add((Object)re.getDirectory());
        if (this._sourceCodeLocationOC != null) {
            this._sourceCodeLocationOC.setObject((Object)new ObjectFactory.SourceLocation(this._classifierMap, (LogicalServer)sle.getServerComponent(), re.getDirectory(), this._sourceFile));
        }
        if (this._resultCapabilities == null) {
            try {
                Document document = this._metadataManipulator.getDocumentCreatingItIfItDoesNotExist();
                Element spE = this._metadataManipulator.getStoredProcessXMLElementCreatingItIfItDoesNotExist();
                this._resultCapabilities = document.createElement("ResultCapabilities");
                spE.appendChild(this._resultCapabilities);
            }
            catch (ParserConfigurationException e) {
                throw new MdException((Throwable)e);
            }
        }
        this._packageSupported = this._packageCB.isSelected();
        this._streamSupported = this._streamCB.isSelected();
        this._resultCapabilities.setAttribute("Package", this._packageSupported ? "true" : "false");
        this._resultCapabilities.setAttribute("Streaming", !isWorkspaceServer && this._streamSupported ? "true" : "false");
    }

    static ArchiveLocation validateArchiveLocation(ArchiveFile af) throws MdException, RemoteException {
        String fileName = af.getFileName();
        if (fileName.length() == 0) {
            return null;
        }
        if (af.getIsARelativeName() == 0) {
            return null;
        }
        Directory repository = null;
        AssociationList vv = af.getDirectories();
        for (int i = 0; i < vv.size(); ++i) {
            Directory d = (Directory)vv.get(i);
            AssociationList vvv = d.getProperties();
            boolean isAFileRepository = false;
            for (int ii = 0; ii < vvv.size(); ++ii) {
                Property p = (Property)vvv.get(ii);
                if (!p.getPropertyRole().equalsIgnoreCase("SPPackageFileRepository")) continue;
                isAFileRepository = true;
                break;
            }
            if (!isAFileRepository) continue;
            if (repository != null) {
                return null;
            }
            repository = d;
        }
        if (repository == null || repository.getDirectoryName().length() == 0) {
            return null;
        }
        return new ArchiveLocation(repository);
    }

    static ArchiveLocation validateArchiveLocation(Directory d) throws MdException, RemoteException {
        boolean isAFileRepository = UtilMetadata.checkPropertyRolePresence((Root)d, (String)"SPPackageFileRepository", null, (boolean)true);
        if (!isAFileRepository) {
            return null;
        }
        return new ArchiveLocation(d);
    }

    static WebDAVLocation validateWebDAVLocation(Directory d) throws MdException, RemoteException {
        if (!UtilMetadata.checkPropertyNamePresence((Root)d, (String)"HttpServerBasePath", (String)"0", (boolean)false)) {
            return null;
        }
        if (!UtilMetadata.checkPropertyNamePresence((Root)d, (String)"SupportsWebDAV", (String)"0", (boolean)false)) {
            return null;
        }
        for (Root root : d.getDeployedComponents()) {
            ServerComponent sc;
            if (!(root instanceof ServerComponent) || !(sc = (ServerComponent)root).getClassIdentifier().equalsIgnoreCase("DAC0D7F0-10DA-11D6-8816-AA0004006D06")) continue;
            return new WebDAVLocation(sc, d);
        }
        return null;
    }

    static class WebDAVLocation {
        ServerComponent _serverComponent;
        Directory _basePathDirectory;

        WebDAVLocation(ServerComponent serverComponent, Directory basePathDirectory) {
            this._basePathDirectory = basePathDirectory;
            this._serverComponent = serverComponent;
        }
    }

    static class ArchiveLocation {
        Directory _repository;

        ArchiveLocation(Directory repository) {
            this._repository = repository;
        }
    }
}

