/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.TypeInterface;
import com.sas.metadata.logical.storedprocess.MetadataManipulator;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.visuals.BIPTreeElementGeneralPropertyTab;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.logical.visuals.ConfigGeneralPanel;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Keyword;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.Root;
import com.sas.metadata.remote.Tree;
import com.sas.text.Message;
import java.rmi.RemoteException;

class GeneralTabPanel
extends BIPTreeElementGeneralPropertyTab {
    private MetadataManipulator _metadataManipulator;

    private static Config adjustConfigForWizardTextAndHideFromUser(Config config) {
        if (config != null && config.getInitValue(ConfigGeneralPanel.WIZARD_DESCRIPTION, null) == null) {
            config.setInitValue(ConfigGeneralPanel.WIZARD_DESCRIPTION, (Object)RB.getStringResource("GTP.Wiz.txt"));
        }
        if (config == null) {
            config = new Config();
        }
        if (!config.setVisibileInvoked(ConfigGeneralPanel.HIDEFROMUSER)) {
            config.setVisible(ConfigGeneralPanel.HIDEFROMUSER, true);
        }
        return config;
    }

    GeneralTabPanel(ClassifierMap classifierMap, Tree containingTree, int type, TypeInterface ti, Config config, MetadataManipulator metadataManipulator) throws RemoteException {
        super((Root)classifierMap, containingTree, type, ti, GeneralTabPanel.adjustConfigForWizardTextAndHideFromUser(config));
        this._metadataManipulator = metadataManipulator;
    }

    GeneralTabPanel(ClassifierMap classifierMap, Tree containingTree, int type, LogicalObjectInterface loi, Config config, MetadataManipulator metadataManipulator, boolean isNineTwo) throws RemoteException {
        super((Root)classifierMap, containingTree, type, loi, GeneralTabPanel.adjustConfigForWizardTextAndHideFromUser(config));
        this._metadataManipulator = metadataManipulator;
        if (isNineTwo) {
            this.setMetadataObjectDisplayType(Message.format((String)RB.getStringResource("GTP.92Type.txt"), (Object)loi.getTypeInterface().getDisplayType()));
        }
    }

    protected String getMessageForDeleteKeywordDialog(Keyword keyword) throws RemoteException {
        String keywordName = keyword.getName();
        if (keywordName.equalsIgnoreCase("XMLA Web Service")) {
            return RB.getStringResource("GTP.XMLAKeywdRemovWarn.msg.txt");
        }
        return super.getMessageForDeleteKeywordDialog(keyword);
    }

    protected void smartPopulateStore() throws MdException, RemoteException {
        super.smartPopulateStore();
        if (this.getType() == 1) {
            if (this._metadataManipulator._pre_92_version) {
                this._metadataManipulator.convertTo92();
            } else {
                this._metadataManipulator.readXML();
            }
        }
    }

    public void onParentOK() {
        try {
            this._metadataManipulator.writeXML();
        }
        catch (RemoteException e) {
            UtilGui.displayRemoteException((RemoteException)e);
        }
        super.onParentOK();
    }
}

