/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.metadata.logical.Factory;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.storedprocess.ObjectFactory;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.visuals.EditableComboBox;
import com.sas.metadata.logical.visuals.ListElementInterface;
import com.sas.metadata.logical.visuals.MetadataDialogPanel;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.MdException;
import com.sas.metadata.remote.PrimaryType;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.PhysicalTableInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.services.util.Names;
import com.sas.swing.visuals.util.Util;
import com.sas.text.Message;
import com.sas.visuals.AutoSizingGridLayout;
import com.sas.visuals.adapters.EqualSpacePartitioner;
import com.sas.visuals.adapters.SpacePartitionerInterface;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAStandardDialog;
import com.sas.workspace.WATextArea;
import com.sas.workspace.WATextField;
import com.sas.workspace.models.SimpleObject;
import com.sas.workspace.models.impl.SimpleObjectImpl;
import com.sas.workspace.visuals.objectselector.ObjectSelectorPanel;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.rmi.RemoteException;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;

final class DataItemPanel
extends MetadataDialogPanel {
    static String[] _publicTypes = new String[]{"Table"};
    private static TypeElement SELECT_A_TYPE = new TypeElement("", RB.getStringResource("DIP.SelTyp.txt"));
    private static TypeElement TYPE_GENERIC_STREAM = new TypeElement("GenericStream", RB.getStringResource("DIP.Typ.GenStr.txt"));
    private static TypeElement TYPE_XML_STREAM = new TypeElement("XMLStream", RB.getStringResource("DIP.Typ.XMLStr.txt"));
    private static TypeElement TYPE_GENERIC_DS = new TypeElement("GenericStream", RB.getStringResource("DIP.Typ.GenDS.txt"));
    private static TypeElement TYPE_SOURCE_DATA_TABLE = new TypeElement("DataTable", RB.getStringResource("DIP.Typ.SrcDataTable.txt"));
    private static TypeElement TYPE_XML_DS = new TypeElement("XMLStream", RB.getStringResource("DIP.Typ.XMLDS.txt"));
    private static TypeElement TYPE_GENERIC_DT = new TypeElement("GenericStream", RB.getStringResource("DIP.Typ.GenDT.txt"));
    private static TypeElement TYPE_XML_DT = new TypeElement("XMLStream", RB.getStringResource("DIP.Typ.XMLDT.txt"));
    private static TypeElement TYPE_TARGET_DATA_TABLE = new TypeElement("DataTable", RB.getStringResource("DIP.Typ.TargDataTable.txt"));
    private JLabel _lblType;
    private EditableComboBox _cbType;
    private JLabel _lblLabel;
    private WATextField _txtLabel;
    private JLabel _lblDescription;
    private JScrollPane _scrDescription;
    private WATextArea _txtDescription;
    private JPanel _containerPanel;
    private JPanel _streamsPanel;
    private JPanel _filerefPanel;
    private JPanel _dataTablePanel;
    private JLabel _lblFileref;
    private WATextField _txtFileref;
    private JLabel _lblParameterName;
    private WATextField _txtParameterName;
    private JLabel _lblTemplateTablePath;
    private WATextField _txtTemplateTablePath;
    private PhysicalTableInterface _table;
    private PathUrl _tablePathUrl;
    private JButton _selectTemplateTableB;
    private JButton _clearTemplateTableB;
    private JCheckBox _multiPass;
    private JLabel _lblContentType;
    private WATextField _txtContentType;
    private JCheckBox _schemaCB;
    private JPanel _schemaPanel;
    private JLabel _lblSchemaURI;
    private WATextField _txtSchemaURI;
    private JLabel _lblSchemaNS;
    private WATextField _txtSchemaNS;
    private JLabel _lblSchemaName;
    private WATextField _txtSchemaName;
    private JRadioButton _elementRB;
    private JRadioButton _typeRB;
    private JRadioButton _embeddedRB;
    private JRadioButton _referencedRB;
    private TypeElement _previousElementSelected;
    private DefaultComboBoxModel _typeComboBoxModel;
    private DataItem _dataItem;
    private int _context;
    private List<String> _existingFilerefNames;
    private List<String> _existingTableNames;
    private String _originalName;
    private boolean _source;

    DataItemPanel(DataItem dataItem, int context, List<String> listOfExistingFilerefNames, List<String> listOfExistingTableNames, boolean source, double usageVersion) {
        this._dataItem = dataItem;
        this._context = context;
        this._existingFilerefNames = listOfExistingFilerefNames;
        this._existingTableNames = listOfExistingTableNames;
        this._source = source;
        this._typeComboBoxModel = new DefaultComboBoxModel();
        this._typeComboBoxModel.addElement(SELECT_A_TYPE);
        if (usageVersion == ObjectFactory.NINETWO_VERSION.encode()) {
            this._typeComboBoxModel.addElement(TYPE_GENERIC_STREAM);
            this._typeComboBoxModel.addElement(TYPE_XML_STREAM);
        } else if (source) {
            this._typeComboBoxModel.addElement(TYPE_GENERIC_DS);
            this._typeComboBoxModel.addElement(TYPE_XML_DS);
            this._typeComboBoxModel.addElement(TYPE_SOURCE_DATA_TABLE);
        } else {
            this._typeComboBoxModel.addElement(TYPE_GENERIC_DT);
            this._typeComboBoxModel.addElement(TYPE_XML_DT);
            this._typeComboBoxModel.addElement(TYPE_TARGET_DATA_TABLE);
        }
        this.initialize();
        this.layoutWidgets();
    }

    public void initialize() {
        this.setHelpProduct("storedprocess");
        if (this._source) {
            this.setHelpTopic(this._context == 1 ? "stp_newdatasourcewin" : "stp_modifydatasourcewin");
        } else {
            this.setHelpTopic(this._context == 1 ? "stp_newdatatargetwin" : "stp_modifydatatargetwin");
        }
        this._cbType = new EditableComboBox(this._typeComboBoxModel, false){

            protected void doListItemSelected(ListElementInterface le) {
                DataItemPanel.this.itemSelected(le);
            }
        };
        this._cbType.setListener(true);
        this._lblType = UtilGui.createLabelForComponent((Component)this._cbType, (String)RB.getStringResource("COM.Lbl.Type.txt"));
        this._txtLabel = new WATextField();
        this._txtLabel.setToolTipText(RB.getStringResource("COM.Tooltip.LabelReq.txt"));
        this._lblLabel = UtilGui.createLabelForComponent((Component)this._txtLabel, (String)RB.getStringResource("COM.Lbl.Label.txt"));
        this._txtDescription = new WATextArea();
        this._txtDescription.setLineWrap(true);
        this._txtDescription.setWrapStyleWord(true);
        this._txtDescription.setToolTipText(RB.getStringResource("COM.Tooltip.Desc.txt"));
        this._lblDescription = UtilGui.createLabelForComponent((Component)this._txtDescription, (String)RB.getStringResource("COM.Lbl.Desc0.txt"));
        this._scrDescription = new JScrollPane((Component)this._txtDescription);
        this._containerPanel = new JPanel();
        this._containerPanel.setVisible(false);
        this._streamsPanel = new JPanel();
        this._filerefPanel = new JPanel();
        this._txtFileref = new WATextField();
        this._txtFileref.setMaxCharacters(8);
        this._txtFileref.setToolTipText(RB.getStringResource("DIP.Tooltip.Fileref.txt"));
        this._lblFileref = UtilGui.createLabelForComponent((Component)this._txtFileref, (String)RB.getStringResource("DIP.Lbl.Fileref.txt"));
        if (this._source) {
            this._multiPass = UtilGui.createCheckBox((String)RB.getStringResource("DIP.Lbl.AllowRwnd.txt"));
        }
        this._txtContentType = new WATextField();
        this._txtContentType.setToolTipText(RB.getStringResource("DIP.Tooltip.ContntTyp.txt"));
        this._lblContentType = UtilGui.createLabelForComponent((Component)this._txtContentType, (String)RB.getStringResource("DIP.Lbl.ContntTyp.txt"));
        this._schemaCB = UtilGui.createCheckBox((String)RB.getStringResource("DIP.Lbl.SpecifySchema.txt"));
        this._schemaCB.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                DataItemPanel.this._schemaPanel.setVisible(DataItemPanel.this._schemaCB.isSelected());
            }
        });
        this._schemaPanel = new JPanel();
        this._txtSchemaURI = new WATextField();
        this._txtSchemaURI.setToolTipText(RB.getStringResource("DIP.Tooltip.SchemaURI.txt"));
        this._lblSchemaURI = UtilGui.createLabelForComponent((Component)this._txtSchemaURI, (String)RB.getStringResource("DIP.Lbl.SchemaURI.txt"));
        this._txtSchemaNS = new WATextField();
        this._txtSchemaNS.setToolTipText(RB.getStringResource("DIP.Tooltip.SchemaNS.txt"));
        this._lblSchemaNS = UtilGui.createLabelForComponent((Component)this._txtSchemaNS, (String)RB.getStringResource("DIP.Lbl.SchemaNS.txt"));
        this._txtSchemaName = new WATextField();
        this._txtSchemaName.setToolTipText(RB.getStringResource("DIP.Tooltip.SchemaName.txt"));
        this._lblSchemaName = UtilGui.createLabelForComponent((Component)this._txtSchemaName, (String)RB.getStringResource("DIP.Lbl.SchemaName.txt"));
        this._elementRB = UtilGui.createRadioButton((String)RB.getStringResource("DIP.Lbl.SchemaElement.txt"));
        this._typeRB = UtilGui.createRadioButton((String)RB.getStringResource("DIP.Lbl.SchemaType.txt"));
        ButtonGroup etBG = new ButtonGroup();
        etBG.add(this._elementRB);
        etBG.add(this._typeRB);
        this._embeddedRB = UtilGui.createRadioButton((String)RB.getStringResource("DIP.Lbl.Embedded.txt"));
        this._referencedRB = UtilGui.createRadioButton((String)RB.getStringResource("DIP.Lbl.Referenced.txt"));
        ButtonGroup erBG = new ButtonGroup();
        erBG.add(this._embeddedRB);
        erBG.add(this._referencedRB);
        this._dataTablePanel = new JPanel();
        this._dataTablePanel.setVisible(false);
        this._txtParameterName = new WATextField();
        this._txtParameterName.setMaxCharacters(24);
        this._txtParameterName.setToolTipText(RB.getStringResource("DIP.Tooltip.ParmName.txt"));
        this._lblParameterName = UtilGui.createLabelForComponent((Component)this._txtParameterName, (String)RB.getStringResource("DIP.Lbl.ParmName.txt"));
        this._txtTemplateTablePath = new WATextField();
        this._txtTemplateTablePath.setEditable(false);
        this._lblTemplateTablePath = new JLabel(RB.getStringResource("DIP.Lbl.TempTable.txt"));
        this._txtTemplateTablePath.setToolTipText(RB.getStringResource("DIP.Tooltip.TempTable.txt"));
        this._clearTemplateTableB = UtilGui.createButton((String)RB.getStringResource("DIP.Lbl.Clear.txt"));
        this._clearTemplateTableB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataItemPanel.this._table = null;
                DataItemPanel.this._tablePathUrl = null;
                DataItemPanel.this._txtTemplateTablePath.setText("");
            }
        });
        this._selectTemplateTableB = UtilGui.createButton((String)RB.getStringResource("DIP.Lbl.Select.txt"));
        this._selectTemplateTableB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                try {
                    DataItemPanel.this.doSelectTable();
                }
                catch (MdException e) {
                    UtilGui.displayMdException((MdException)e);
                }
                catch (RemoteException e) {
                    UtilGui.displayRemoteException((RemoteException)e);
                }
                catch (Exception e) {
                    UtilGui.displayExceptionError((Exception)e);
                }
            }
        });
    }

    public void layoutWidgets() {
        AutoSizingGridLayout layout = new AutoSizingGridLayout(0, 1, 5, 5, true, true, true);
        this.setLayout((LayoutManager)layout);
        this.add(this._lblType);
        this.add((Component)this._cbType);
        this.add(this._lblLabel);
        this.add((Component)this._txtLabel);
        this.add(this._lblDescription);
        this._scrDescription.setPreferredSize(DESCRIPTION_SCROLLWINDOW_SIZE_SMALL);
        this.add(this._scrDescription);
        AutoSizingGridLayout cpLayout = new AutoSizingGridLayout(0, 1, 5, 5, true, true, true);
        this._containerPanel.setLayout((LayoutManager)cpLayout);
        cpLayout.setIgnoreSizeOfNonVisibleComponents(true);
        AutoSizingGridLayout spLayout = new AutoSizingGridLayout(0, 1, 5, 5, true, true, true);
        this._streamsPanel.setLayout((LayoutManager)spLayout);
        this._streamsPanel.add(this._lblFileref);
        AutoSizingGridLayout frLayout = new AutoSizingGridLayout(1, 2, 5, 5, true, true, true);
        frLayout.setColumnSpacePartitioner((SpacePartitionerInterface)new EqualSpacePartitioner());
        this._filerefPanel.setLayout((LayoutManager)frLayout);
        this._filerefPanel.add((Component)this._txtFileref);
        if (this._source) {
            this._filerefPanel.add(this._multiPass);
        } else {
            this._filerefPanel.add(new JPanel());
        }
        this._streamsPanel.add(this._filerefPanel);
        this._streamsPanel.add(this._lblContentType);
        this._streamsPanel.add((Component)this._txtContentType);
        this._schemaCB.setMargin(new Insets(0, 0, 0, 0));
        this._streamsPanel.add(this._schemaCB);
        AutoSizingGridLayout schLayout = new AutoSizingGridLayout(0, 1, 5, 5, true, true, true);
        this._schemaPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this._schemaPanel.setLayout((LayoutManager)schLayout);
        this._schemaPanel.add(this._lblSchemaURI);
        this._schemaPanel.add((Component)this._txtSchemaURI);
        this._schemaPanel.add(this._lblSchemaNS);
        this._schemaPanel.add((Component)this._txtSchemaNS);
        this._schemaPanel.add(this._lblSchemaName);
        this._schemaPanel.add((Component)this._txtSchemaName);
        JPanel referenceTypePanel = new JPanel();
        AutoSizingGridLayout rtpLayout = new AutoSizingGridLayout(1, 2, 5, 5, false, false, false);
        referenceTypePanel.setLayout((LayoutManager)rtpLayout);
        referenceTypePanel.setBorder(BorderFactory.createTitledBorder(RB.getStringResource("DIP.Lbl.RefTyp.txt")));
        referenceTypePanel.add(this._elementRB);
        referenceTypePanel.add(this._typeRB);
        this._schemaPanel.add(referenceTypePanel);
        JPanel wsdlPanel = new JPanel();
        AutoSizingGridLayout wsdlLayout = new AutoSizingGridLayout(1, 2, 5, 5, false, false, false);
        wsdlPanel.setLayout((LayoutManager)wsdlLayout);
        wsdlPanel.setBorder(BorderFactory.createTitledBorder(RB.getStringResource("DIP.Lbl.WSDLgen.txt")));
        wsdlPanel.add(this._embeddedRB);
        wsdlPanel.add(this._referencedRB);
        this._schemaPanel.add(wsdlPanel);
        this._streamsPanel.add(this._schemaPanel);
        this._streamsPanel.add(new JPanel());
        AutoSizingGridLayout dtpLayout = new AutoSizingGridLayout(0, 1, 5, 5, true, false, true);
        this._dataTablePanel.setLayout((LayoutManager)dtpLayout);
        this._dataTablePanel.add(this._lblParameterName);
        this._dataTablePanel.add((Component)this._txtParameterName);
        this._dataTablePanel.add(this._lblTemplateTablePath);
        JPanel phyTabPanel = new JPanel();
        AutoSizingGridLayout ptpLayout = new AutoSizingGridLayout(1, 3, 5, 5, false, false, true);
        ptpLayout.setRemainderColumn(1);
        phyTabPanel.setLayout((LayoutManager)ptpLayout);
        phyTabPanel.add((Component)this._txtTemplateTablePath);
        phyTabPanel.add(this._clearTemplateTableB);
        phyTabPanel.add(this._selectTemplateTableB);
        this._dataTablePanel.add(phyTabPanel);
        this._containerPanel.setPreferredSize(new Dimension(400, 400));
        this._containerPanel.add(this._streamsPanel);
        this._containerPanel.add(this._dataTablePanel);
        this.add(this._containerPanel);
    }

    private void doSelectTable() throws RemoteException, MdException, ServiceException, LogicalTypeException {
        SimpleObject so;
        SimpleObject o;
        UserContextInterface user = UtilPlatformServices.getUserContext();
        ObjectSelectorPanel _selectorPanel = new ObjectSelectorPanel(user, -1, null, true);
        _selectorPanel.setSelectionOptional(true);
        _selectorPanel.setSelectableTypes(_publicTypes);
        _selectorPanel.setVisibleTypes(_publicTypes);
        _selectorPanel.setInventoryTypes(_publicTypes);
        _selectorPanel.setAdditionalHierarchyModel(null);
        if (this._table != null) {
            PrimaryType meta = (PrimaryType)this._table.getRepositoryEntity();
            SimpleObjectImpl selected = new SimpleObjectImpl(meta.getName(), meta.getFQID(), meta.getCMetadataType(), meta.getPublicType());
            _selectorPanel.setSelectedObject((SimpleObject)selected);
        }
        String dialogTitle = RB.getStringResource("DIP.TabDlg.Title.txt");
        WAStandardDialog _selectorDialog = new WAStandardDialog(Factory.getInstance().getFrame(), dialogTitle, true, (WAPanel)_selectorPanel);
        _selectorDialog.setResizable(true);
        _selectorDialog.setHelpProduct("storedprocess");
        _selectorDialog.setHelpTopic("choosetmptable");
        _selectorDialog.show();
        if (_selectorDialog.getReturnValue() == 1 && (o = _selectorPanel.getSelectedObject()) != null && o instanceof SimpleObject && (so = o).getPublicType().equals("Table")) {
            this._table = (PhysicalTableInterface)UtilPlatformServices.getSmartObject((String)so.getID(), (String)so.getMetadataType());
            this._tablePathUrl = this._table.getPathUrl();
            if (this._tablePathUrl == null) {
                UtilGui.displayError((String)Message.format((String)RB.getStringResource("DIP.NoPathUrl.fmt.txt"), (Object)this._table.getReposKey()));
                this._table = null;
                this._txtTemplateTablePath.setText("");
            } else {
                this._txtTemplateTablePath.setText(this._tablePathUrl.getDisplayPath());
            }
        }
    }

    public void itemSelected(ListElementInterface le) {
        TypeElement te = (TypeElement)le;
        if (this._previousElementSelected == te) {
            return;
        }
        if (te._xmlType.equals("GenericStream")) {
            this._containerPanel.setVisible(true);
            this._streamsPanel.setVisible(true);
            this._dataTablePanel.setVisible(false);
            this._schemaCB.setVisible(false);
            this._schemaPanel.setVisible(false);
            String contentType = this._txtContentType.getText();
            if (contentType.length() == 0 || contentType.equalsIgnoreCase("text/xml")) {
                this._txtContentType.setText("application/unknown");
            }
        } else if (te._xmlType.equals("XMLStream")) {
            this._containerPanel.setVisible(true);
            this._streamsPanel.setVisible(true);
            this._dataTablePanel.setVisible(false);
            this._schemaCB.setVisible(true);
            this._schemaPanel.setVisible(this._schemaCB.isSelected());
            String contentType = this._txtContentType.getText();
            if (contentType.length() == 0 || contentType.equalsIgnoreCase("application/unknown")) {
                this._txtContentType.setText("text/xml");
            }
        } else if (te._xmlType.equals("DataTable")) {
            this._containerPanel.setVisible(true);
            this._streamsPanel.setVisible(false);
            this._dataTablePanel.setVisible(true);
        } else {
            this._containerPanel.setVisible(false);
            this._streamsPanel.setVisible(false);
            this._dataTablePanel.setVisible(false);
        }
        this._cbType.setListener(false);
        this._cbType.setListener(true);
        this._previousElementSelected = te;
    }

    public void moveDataToView() throws MdException {
        if (this._context == 2) {
            boolean readOnly = !this.isEditable();
            int size = this._typeComboBoxModel.getSize();
            TypeElement le = null;
            for (int i = 1; i < size; ++i) {
                le = (TypeElement)this._typeComboBoxModel.getElementAt(i);
                if (!le._xmlType.equals(this._dataItem._type)) continue;
                this._cbType.setSelectedItem((Object)le);
                break;
            }
            this._txtLabel.setText(this._dataItem._label);
            this._txtDescription.setText(this._dataItem._description);
            if (readOnly) {
                this._cbType.setEnabled(false);
                this._txtLabel.setEnabled(false);
                this._txtDescription.setEnabled(false);
            }
            if (le == TYPE_SOURCE_DATA_TABLE || le == TYPE_TARGET_DATA_TABLE) {
                block20: {
                    this._originalName = this._dataItem._tableParmName;
                    this._txtParameterName.setText(this._originalName);
                    if (this._dataItem._templateTableAbsolutePath.length() > 0) {
                        try {
                            this._table = (PhysicalTableInterface)UtilPlatformServices.getSmartObject((String)this._dataItem._templateTableAbsolutePath);
                            if (this._table == null) {
                                UtilGui.displayError((String)Message.format((String)RB.getStringResource("DIP.NoTab.fmt.txt"), (Object)this._dataItem._templateTableAbsolutePath));
                                break block20;
                            }
                            this._tablePathUrl = this._table.getPathUrl();
                            if (this._tablePathUrl == null) {
                                UtilGui.displayError((String)Message.format((String)RB.getStringResource("DIP.NoPathUrl.fmt.txt"), (Object)this._table.getReposKey()));
                                this._table = null;
                                this._txtTemplateTablePath.setText("");
                                break block20;
                            }
                            this._txtTemplateTablePath.setText(this._tablePathUrl.getDisplayPath());
                        }
                        catch (ServiceException e) {
                            UtilGui.displayError((String)Message.format((String)RB.getStringResource("DIP.NoTab.fmt.txt"), (Object)this._dataItem._templateTableAbsolutePath, (Object)e.getMessage()));
                        }
                        catch (RemoteException e) {
                            UtilGui.displayRemoteException((RemoteException)e);
                        }
                    } else {
                        this._table = null;
                        this._tablePathUrl = null;
                        this._txtTemplateTablePath.setText("");
                    }
                }
                if (readOnly) {
                    this._txtParameterName.setEnabled(false);
                    this._txtTemplateTablePath.setEnabled(false);
                    this._clearTemplateTableB.setEnabled(false);
                    this._selectTemplateTableB.setEnabled(false);
                }
            } else {
                this._originalName = this._dataItem._fileref;
                this._txtFileref.setText(this._originalName);
                if (this._source) {
                    this._multiPass.setSelected(this._dataItem._supportsMultiPass);
                    if (readOnly) {
                        this._multiPass.setEnabled(false);
                    }
                }
                this._txtContentType.setText(this._dataItem._contentType);
                if (readOnly) {
                    this._txtFileref.setEnabled(false);
                    this._txtContentType.setEnabled(false);
                }
                if (this._dataItem._type.equals("XMLStream") && this._dataItem._hasSchema) {
                    this._schemaCB.setSelected(true);
                    this._txtSchemaURI.setText(this._dataItem._schemaURI);
                    this._txtSchemaNS.setText(this._dataItem._schemaToplevelNS);
                    this._txtSchemaName.setText(this._dataItem._schemaToplevelName);
                    this._elementRB.setSelected(!this._dataItem._isSchemaReferenceTypeAType);
                    this._typeRB.setSelected(this._dataItem._isSchemaReferenceTypeAType);
                    this._embeddedRB.setSelected(this._dataItem._isWSDLEmbedded);
                    this._referencedRB.setSelected(!this._dataItem._isWSDLEmbedded);
                    if (readOnly) {
                        this._txtSchemaURI.setEnabled(false);
                        this._txtSchemaNS.setEnabled(false);
                        this._txtSchemaName.setEnabled(false);
                        this._elementRB.setEnabled(false);
                        this._typeRB.setEnabled(false);
                        this._embeddedRB.setEnabled(false);
                        this._referencedRB.setEnabled(false);
                    }
                }
                if (readOnly) {
                    this._schemaCB.setEnabled(false);
                }
            }
        } else {
            this._embeddedRB.setSelected(true);
        }
    }

    public void moveDataToStore() throws MdException {
        TypeElement le = (TypeElement)this._cbType.getSelectedItem();
        this._dataItem._type = le._xmlType;
        this._dataItem._description = this._txtDescription.getText();
        if (le == TYPE_SOURCE_DATA_TABLE || le == TYPE_TARGET_DATA_TABLE) {
            this._dataItem._tableParmName = this._txtParameterName.getText();
            this._dataItem._label = this._txtLabel.getText();
            if (this._dataItem._label.length() == 0) {
                this._dataItem._label = this._dataItem._tableParmName;
            }
            this._dataItem._templateTableAbsolutePath = this._tablePathUrl == null ? "" : this._tablePathUrl.getAbsolutePath();
        } else {
            this._dataItem._fileref = this._txtFileref.getText();
            this._dataItem._label = this._txtLabel.getText();
            if (this._dataItem._label.length() == 0) {
                this._dataItem._label = this._dataItem._fileref;
            }
            if (this._source) {
                this._dataItem._supportsMultiPass = this._multiPass.isSelected();
            }
            this._dataItem._contentType = this._txtContentType.getText();
            if (this._dataItem._type.equals("XMLStream")) {
                this._dataItem._hasSchema = this._schemaCB.isSelected();
                if (this._dataItem._hasSchema) {
                    this._dataItem._schemaURI = this._txtSchemaURI.getText();
                    this._dataItem._schemaToplevelNS = this._txtSchemaNS.getText();
                    this._dataItem._schemaToplevelName = this._txtSchemaName.getText();
                    this._dataItem._isSchemaReferenceTypeAType = this._typeRB.isSelected();
                    this._dataItem._isWSDLEmbedded = this._embeddedRB.isSelected();
                }
            }
        }
    }

    public boolean dataValidate() {
        TypeElement selectedType = (TypeElement)this._typeComboBoxModel.getSelectedItem();
        if (selectedType == SELECT_A_TYPE) {
            MessageUtil.displayMessage((String)RB.getStringResource("DIP.NoType.msg.txt"), (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
            this._cbType.requestFocus();
            return false;
        }
        if (selectedType == TYPE_SOURCE_DATA_TABLE || selectedType == TYPE_TARGET_DATA_TABLE) {
            String temp = this._txtParameterName.getText();
            if (UtilMisc.isBlankOrEmptyString((String)temp)) {
                MessageUtil.displayMessage((String)RB.getStringResource("DIP.NoParmName.txt"), (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
                this._txtParameterName.requestFocus();
                return false;
            }
            boolean performNameValidation = true;
            if (this._context == 2 && this._originalName.equalsIgnoreCase(temp)) {
                performNameValidation = false;
            }
            if (performNameValidation) {
                try {
                    String tempForNameValidation = selectedType == TYPE_SOURCE_DATA_TABLE ? "_Source_" + temp : "_Target_" + temp;
                    Names.validateSASVariableName((String)tempForNameValidation, (boolean)true);
                }
                catch (Exception e) {
                    MessageUtil.displayMessage((String)e.getMessage(), (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
                    this._txtParameterName.requestFocus();
                    return false;
                }
                for (String thisName : this._existingTableNames) {
                    if (!temp.equalsIgnoreCase(thisName)) continue;
                    String text = Message.format((ResourceBundle)RB.getResources(), (String)"COM.Exsts.fmt.txt", (Object)temp);
                    MessageUtil.displayMessage((String)text, (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
                    this._txtParameterName.requestFocus();
                    return false;
                }
            }
        } else {
            String temp = this._txtFileref.getText();
            if (UtilMisc.isBlankOrEmptyString((String)temp)) {
                MessageUtil.displayMessage((String)RB.getStringResource("DIP.NoFilrf.txt"), (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
                this._txtFileref.requestFocus();
                return false;
            }
            boolean performNameValidation = true;
            if (this._context == 2 && this._originalName.equalsIgnoreCase(temp)) {
                performNameValidation = false;
            }
            if (performNameValidation) {
                try {
                    Names.validateSASFilerefName((String)temp, (boolean)true);
                }
                catch (Exception e) {
                    MessageUtil.displayMessage((String)e.getMessage(), (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
                    this._txtFileref.requestFocus();
                    return false;
                }
                if (temp.equalsIgnoreCase("_WEBOUT")) {
                    MessageUtil.displayMessage((String)"_WEBOUT is a reserved FILEREF name.", (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
                    this._txtFileref.requestFocus();
                    return false;
                }
                for (String thisName : this._existingFilerefNames) {
                    if (!temp.equalsIgnoreCase(thisName)) continue;
                    String text = Message.format((ResourceBundle)RB.getResources(), (String)"COM.Exsts.fmt.txt", (Object)temp);
                    MessageUtil.displayMessage((String)text, (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
                    this._txtFileref.requestFocus();
                    return false;
                }
            }
            if (selectedType == TYPE_GENERIC_DS || selectedType == TYPE_GENERIC_DT || selectedType == TYPE_GENERIC_STREAM) {
                return true;
            }
            if (this._schemaCB.isSelected()) {
                String text;
                if (UtilMisc.isBlankOrEmptyString((String)this._txtSchemaURI.getText())) {
                    text = Message.format((ResourceBundle)RB.getResources(), (String)"DIP.NoURI.txt", (Object)Util.getLabelWithoutMnemonic((String)RB.getStringResource("DIP.Lbl.SpecifySchema.txt")));
                    MessageUtil.displayMessage((String)text, (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
                    this._txtSchemaURI.requestFocus();
                    return false;
                }
                if (UtilMisc.isBlankOrEmptyString((String)this._txtSchemaNS.getText())) {
                    text = Message.format((ResourceBundle)RB.getResources(), (String)"DIP.NoNS.txt", (Object)Util.getLabelWithoutMnemonic((String)RB.getStringResource("DIP.Lbl.SpecifySchema.txt")));
                    MessageUtil.displayMessage((String)text, (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
                    this._txtSchemaNS.requestFocus();
                    return false;
                }
                if (UtilMisc.isBlankOrEmptyString((String)this._txtSchemaName.getText())) {
                    text = Message.format((ResourceBundle)RB.getResources(), (String)"DIP.NoName.txt", (Object)Util.getLabelWithoutMnemonic((String)RB.getStringResource("DIP.Lbl.SpecifySchema.txt")));
                    MessageUtil.displayMessage((String)text, (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
                    this._txtSchemaName.requestFocus();
                    return false;
                }
                if (!this._elementRB.isSelected() && !this._typeRB.isSelected()) {
                    text = Message.format((ResourceBundle)RB.getResources(), (String)"DIP.NoRefTyp.txt", (Object)Util.getLabelWithoutMnemonic((String)RB.getStringResource("DIP.Lbl.SpecifySchema.txt")));
                    MessageUtil.displayMessage((String)text, (String)RB.getStringResource("COM.ErrDlgTitle.txt"), (int)0);
                    this._elementRB.requestFocus();
                    return false;
                }
            }
        }
        return true;
    }

    static class DataItem {
        String _type;
        String _description;
        String _label;
        String _fileref;
        boolean _supportsMultiPass;
        String _contentType;
        boolean _hasSchema;
        String _schemaURI;
        String _schemaToplevelNS;
        String _schemaToplevelName;
        boolean _isSchemaReferenceTypeAType;
        boolean _isWSDLEmbedded;
        String _tableParmName;
        String _templateTableAbsolutePath;

        DataItem() {
        }
    }

    private static class TypeElement
    implements ListElementInterface {
        private String _displayString;
        private String _xmlType;

        public TypeElement(String xmlType, String displayString) {
            this._xmlType = xmlType;
            this._displayString = displayString;
        }

        public String toString() {
            return this._displayString;
        }
    }
}

