/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.storedprocess;

import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.storedprocess.ObjectFactory;
import com.sas.metadata.logical.storedprocess.RB;
import com.sas.metadata.logical.visuals.UtilGui;
import com.sas.metadata.remote.ClassifierMap;
import com.sas.metadata.remote.Root;
import com.sas.services.storedprocess.metadata.StoredProcessInterface;
import com.sas.text.Message;
import com.sas.util.UsageVersion;
import com.sas.workspace.MessageUtil;
import com.sas.workspace.WATextArea;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.rmi.RemoteException;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JScrollPane;

class ChangeVersionAction
extends AbstractAction {
    private LogicalObjectInterface[] _logicalObjects;
    private ClassifierMap[] _classifierMaps;
    private boolean _upgrade;

    public ChangeVersionAction(LogicalObjectInterface logicalObject, ClassifierMap classifierMap, boolean upgrade) {
        this(new LogicalObjectInterface[]{logicalObject}, new ClassifierMap[]{classifierMap}, upgrade);
    }

    public ChangeVersionAction(LogicalObjectInterface[] logicalObjects, ClassifierMap[] classifierMaps, boolean upgrade) {
        this._upgrade = upgrade;
        this._logicalObjects = logicalObjects;
        this._classifierMaps = classifierMaps;
        UtilGui.setLabelAndMnemonicOnAction((AbstractAction)this, (String)RB.getStringResource(upgrade ? "UA.CtxtMenuItm.txt" : "MCA.CtxtMenuItm.txt"));
        this.putValue("ShortDescription", RB.getStringResource(upgrade ? "UA.ToolTip.txt" : "MCA.ToolTip.txt"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent ev) {
        int rowCount;
        String msg;
        StringBuilder logChanged = new StringBuilder();
        StringBuilder logErrors = new StringBuilder();
        int length = this._logicalObjects.length;
        int countOfDesiredVersion = 0;
        int countOfErrors = 0;
        int countOfUpdated = 0;
        UsageVersion desiredVersion = this._upgrade ? ObjectFactory.CURRENT_VERSION : ObjectFactory.NINETWO_VERSION;
        for (int i = 0; i < length; ++i) {
            String msg2;
            UsageVersion uv = this._logicalObjects[i].getUsageVersion();
            if (uv.equals((Object)desiredVersion)) {
                ++countOfDesiredVersion;
                continue;
            }
            UtilPlatformServices.DetachedTransaction detachedTransaction = null;
            String path = "";
            try {
                detachedTransaction = UtilPlatformServices.getDetachedTransaction();
                StoredProcessInterface spi = (StoredProcessInterface)detachedTransaction.getSmartObject((Root)this._classifierMaps[i]);
                path = "/" + spi.getPath(null);
                spi.convertToVersion(desiredVersion);
                spi.update();
                ++countOfUpdated;
                msg2 = Message.format((ResourceBundle)RB.getResources(), (String)"CVA.changed.msg.fmt.txt", (Object)path);
                logChanged.append(msg2);
                continue;
            }
            catch (Exception e) {
                ++countOfErrors;
                msg2 = Message.format((ResourceBundle)RB.getResources(), (String)"CVA.error.msg.fmt.txt", (Object)path, (Object)e.getMessage());
                logErrors.append(msg2);
                continue;
            }
            finally {
                if (detachedTransaction != null) {
                    try {
                        detachedTransaction.rollback();
                    }
                    catch (RemoteException e) {
                    }
                    catch (LogicalTypeException e) {}
                }
            }
        }
        StringBuilder log = new StringBuilder();
        if (countOfErrors > 0) {
            msg = Message.format((ResourceBundle)RB.getResources(), (String)"CVA.errorHeader.msg.fmt.txt", (Object)countOfErrors);
            log.append(msg);
            log.append((CharSequence)logErrors);
            rowCount = countOfErrors + 1;
        } else {
            rowCount = 0;
        }
        if (countOfUpdated > 0) {
            if (countOfErrors > 0) {
                log.append('\n');
            }
            msg = Message.format((ResourceBundle)RB.getResources(), (String)"CVA.changedHeader.msg.fmt.txt", (Object)countOfUpdated);
            log.append(msg);
            log.append((CharSequence)logChanged);
            rowCount += countOfUpdated + 1;
        }
        String message = Message.format((ResourceBundle)RB.getResources(), (String)"CVA.Summary.msg.fmt.txt", (Object)countOfUpdated, (Object)countOfDesiredVersion, (Object)countOfErrors);
        WATextArea textArea = new WATextArea(log.toString());
        textArea.setBehavior(2);
        textArea.setColumns(40);
        textArea.setRows(rowCount > 10 ? 10 : rowCount);
        JScrollPane sp = new JScrollPane((Component)textArea);
        MessageUtil.displayDetailsMessage((String)message, (String)RB.getStringResource("CVA.Summary.title.txt"), (int)(countOfErrors > 0 ? 2 : 1), (JComponent)sp);
    }
}

