/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.report.scheduling;

import com.sas.metadata.Util;
import com.sas.metadata.logical.report.scheduling.BatchServers;
import com.sas.metadata.logical.report.scheduling.RB;
import com.sas.workspace.WAComboBox;
import com.sas.workspace.WAPanel;
import com.sas.workspace.WAPasswordField;
import com.sas.workspace.WATextField;
import com.sas.workspace.Workspace;
import com.sas.workspace.WorkspaceFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TopPanel
extends WAPanel {
    static final Logger log = Logger.getLogger(TopPanel.class.getName());
    private static final int LABELS_WIDTH = 157;
    private static final int FIELDS_WIDTH = 338;
    private static final int ROW_HEIGHT = 20;
    private JLabel m_lblUserName;
    private JLabel m_lblPassword;
    private JLabel m_lblJavaBatchServers;
    private WATextField m_txtUserName;
    private WAPasswordField m_pwdPassword;
    private WAComboBox m_cboJavaBatchServers;
    private JPanel m_pnlLabels;
    private JPanel m_pnlTextFields;
    private static final Logger _log = Logger.getLogger(TopPanel.class.getName());
    private BatchServers _batchServers;

    public TopPanel(Component parent, BatchServers batchServers) {
        if (batchServers == null) {
            throw new IllegalArgumentException("batchServers == null");
        }
        this._batchServers = batchServers;
        this.initialize();
        this.layoutWidgets();
    }

    protected void initialize() {
        this.m_lblUserName = new JLabel(RB.getStringResource("TopPanel.UserName.txt"));
        this.m_lblUserName.setLabelFor((Component)this.m_txtUserName);
        this.m_lblUserName.setVerticalAlignment(0);
        this.m_txtUserName = new WATextField();
        this.m_txtUserName.setToolTipText(RB.getStringResource("TopPanel.UserName.ToolTip.txt"));
        this.m_lblPassword = new JLabel(RB.getStringResource("TopPanel.Password.txt"));
        this.m_lblPassword.setLabelFor((Component)this.m_pwdPassword);
        this.m_lblPassword.setVerticalAlignment(0);
        this.m_pwdPassword = new WAPasswordField();
        this.m_pwdPassword.setToolTipText(RB.getStringResource("TopPanel.Password.ToolTip.txt"));
        this.m_lblJavaBatchServers = new JLabel(RB.getStringResource("TopPanel.ListJavaBatchServers.txt"));
        this.m_lblJavaBatchServers.setLabelFor((Component)this.m_cboJavaBatchServers);
        this.m_lblJavaBatchServers.setVerticalAlignment(0);
        this.m_cboJavaBatchServers = new WAComboBox();
        this.m_cboJavaBatchServers.setToolTipText(RB.getStringResource("TopPanel.ListJavaBatchServers.ToolTip.txt"));
        try {
            this.m_cboJavaBatchServers.addItems((Object[])this._batchServers.getServers());
            this.m_cboJavaBatchServers.setSelectedIndex(this._batchServers.getSelectedIndex());
        }
        catch (Exception e) {
            log.log(Level.WARNING, "initialize() failed", e);
        }
        this.m_pnlLabels = new JPanel();
        this.m_pnlTextFields = new JPanel();
        this.initUserPassword();
    }

    protected void layoutWidgets() {
        this.m_pnlLabels.setLayout(new FlowLayout(0));
        this.m_lblUserName.setPreferredSize(new Dimension(157, 20));
        this.m_pnlLabels.add(this.m_lblUserName);
        this.m_lblPassword.setPreferredSize(new Dimension(157, 20));
        this.m_pnlLabels.add(this.m_lblPassword);
        this.m_lblJavaBatchServers.setPreferredSize(new Dimension(157, 20));
        this.m_pnlLabels.add(this.m_lblJavaBatchServers);
        this.m_pnlTextFields.setLayout(new FlowLayout(0));
        this.m_txtUserName.setPreferredSize(new Dimension(338, 20));
        this.m_pnlTextFields.add((Component)this.m_txtUserName);
        this.m_pwdPassword.setPreferredSize(new Dimension(338, 20));
        this.m_pnlTextFields.add((Component)this.m_pwdPassword);
        this.m_cboJavaBatchServers.setPreferredSize(new Dimension(338, 20));
        this.m_pnlTextFields.add((Component)this.m_cboJavaBatchServers);
        this.setLayout(new BorderLayout());
        this.m_pnlLabels.setPreferredSize(new Dimension(157, 80));
        this.add(this.m_pnlLabels, "Before");
        this.m_pnlTextFields.setPreferredSize(new Dimension(338, 80));
        this.add(this.m_pnlTextFields, "Center");
    }

    private void initUserPassword() {
        log.fine("begin user/pw processing");
        String user = null;
        String pass = null;
        try {
            if (user == null && pass == null) {
                WorkspaceFile ws = Workspace.getWorkspace().getWorkspaceFile();
                user = ws.getPropertyString("userid");
                pass = Util.decrypt((String)ws.getPropertyString("password"));
            }
            _log.fine("_DEBUG_:user = " + user);
        }
        catch (Exception e) {
            _log.fine("_DEBUG_: FAILED= " + e);
            e.printStackTrace();
        }
        if (user != null) {
            this.m_txtUserName.setText(user);
        }
        if (pass != null) {
            this.m_pwdPassword.setText(pass);
        }
    }

    public String getPassword() {
        char[] pwArray = this.m_pwdPassword.getPassword();
        String pwStr = new String(pwArray);
        for (int i = 0; i < pwArray.length; ++i) {
            pwArray[i] = '\u0000';
        }
        return pwStr;
    }

    public String getUserName() {
        return this.m_txtUserName.getText();
    }

    public int getSelectedJavaBatchServer() {
        return this.m_cboJavaBatchServers.getSelectedIndex();
    }
}

