/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.report;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.UtilMisc;
import com.sas.metadata.logical.informationmap.InformationMapConnectionType;
import com.sas.metadata.logical.report.RB;
import com.sas.metadata.logical.report.ReportCacheID;
import com.sas.metadata.logical.report.ReportConnectionType;
import com.sas.metadata.logical.report.ReportExImportUtil;
import com.sas.metadata.logical.report.ReportExportItem;
import com.sas.metadata.logical.report.UtilReportServices;
import com.sas.metadata.logical.storedprocess.StoredProcessConnectionType;
import com.sas.metadata.promotion.AbstractExportListener;
import com.sas.metadata.promotion.ConnectionManagerInterface;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ContentHandlerInterface;
import com.sas.metadata.promotion.ExportItemInterface;
import com.sas.metadata.promotion.ExportOperationInterface;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.MetadataPromotionException;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionItemInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.remote.MdException;
import com.sas.report.repository.CacheInterface;
import com.sas.report.repository.CacheItemInterface;
import com.sas.report.repository.CacheSetInterface;
import com.sas.report.repository.EntryInterface;
import com.sas.report.repository.Repository;
import com.sas.report.repository.RepositoryException;
import com.sas.services.ServiceException;
import com.sas.services.TransportException;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

class ReportExportListener
extends AbstractExportListener {
    public static final String REPORT_KEY = "###REPORT###";
    static final String REPORT_METADATA_TYPE = "Transformation";
    static final String XPATH = "XPath";
    static final String ORIGINALPATH = "OriginalPath";
    static final String FOLDER = "Folder";
    protected static final Class[] CONNECTION_TYPES = new Class[]{ReportConnectionType.class, InformationMapConnectionType.class, StoredProcessConnectionType.class};
    private static final Logger log = Logger.getLogger(ReportExportListener.class.getName());

    public ReportExportListener(TransportableTypeInterface type) {
        super(type);
        log.fine("entering");
    }

    public int exportContent(ExportOperationInterface operation, List objects) throws TransportException, IOException {
        log.fine("Report Export Listener Invoked");
        Log exportLogger = operation.getLogger();
        boolean _warning = false;
        ContentHandlerInterface contentHandler = operation.getContentHandler();
        try {
            int i = 1;
            UtilReportServices rs = UtilReportServices.getInstance();
            ReportCacheID rptCacheId = new ReportCacheID();
            for (ExportItemInterface exportItem : objects) {
                String fqid = exportItem.getID();
                log.fine("objects[" + i++ + "] = " + fqid);
                MetadataInterface smartObject = PromotionUtil.getSmartObject((PromotionInterface)operation, (String)fqid, (String)REPORT_METADATA_TYPE);
                EntryInterface report = rs.getReport(smartObject);
                String reportName = smartObject.getName();
                this.fireDisplayMessage(UtilMisc.getMessage((String)RB.getStringResource("REL.StatusIndicator.fmt.txt"), (Object)reportName));
                log.fine("report: " + reportName);
                CacheSetInterface cacheSet = report.getCacheSetInterface();
                List cacheList = cacheSet.list(null);
                boolean hasContent = !report.isEmpty() || !cacheList.isEmpty();
                int contentItemsExported = 0;
                if (hasContent) {
                    InputStream iStream = report.getInputStream();
                    contentHandler.addBinaryContent(fqid, REPORT_KEY, iStream);
                    ++contentItemsExported;
                    for (CacheInterface cache : cacheList) {
                        String cacheName = cache.getName();
                        log.fine("cache: " + cacheName);
                        rptCacheId.setCacheName(cacheName);
                        List cacheItemList = cache.list(null);
                        for (CacheItemInterface cacheItem : cacheItemList) {
                            String cacheItemName = cacheItem.getName();
                            log.fine("cache item: " + cacheItemName);
                            rptCacheId.setItemName(cacheItemName);
                            String fullname = rptCacheId.getFullName();
                            log.fine("adding content stream for: " + fullname);
                            InputStream stream = cacheItem.getInputStream();
                            contentHandler.addBinaryContent(fqid, fullname, stream);
                            ++contentItemsExported;
                        }
                    }
                } else {
                    log.warning(UtilMisc.getMessage((String)RB.getStringResource("REL.ReportDoesNotExist.fmt.txt"), (Object)reportName));
                    exportLogger.warn((Object)UtilMisc.getMessage((String)RB.getStringResource("REL.ReportDoesNotExist.fmt.txt"), (Object)reportName));
                    _warning = true;
                }
                exportLogger.info((Object)UtilMisc.getMessage((String)RB.getStringResource("REL.ContentItemCount.fmt.txt"), (Object)Integer.toString(contentItemsExported), (Object)exportItem.toString()));
            }
        }
        catch (Exception e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
        if (_warning) {
            return 4;
        }
        return 0;
    }

    public ExportItemInterface createExportItem(String name, String id, TransportableTypeInterface type) {
        return new ReportExportItem(name, id, type);
    }

    public int analyzeConnections(ExportOperationInterface exportOperation, List exportObjects) throws MdException, RemoteException {
        String _xpath = "";
        String _theURL = "";
        String _sourcePath = "";
        int returnValue = super.analyzeConnections(exportOperation, exportObjects);
        ArrayList<ExportItemInterface> reports = new ArrayList<ExportItemInterface>(exportObjects.size());
        for (ExportItemInterface exportItem : exportObjects) {
            if (exportItem.getTypeInterface().getPublicType().indexOf("Report") < 0) continue;
            reports.add(exportItem);
        }
        Log logger = exportOperation.getLogger();
        try {
            ConnectionManagerInterface connMgr = exportOperation.getConnectionManager();
            boolean counter = false;
            for (ReportExportItem reportExportItem : reports) {
                List relatedObject = reportExportItem.getRelatedObjects(0);
                Map urlMap = reportExportItem.getUrlMap();
                if (urlMap == null) continue;
                List originalPathList = reportExportItem.getOriginalPathList();
                Iterator oPIter = originalPathList.iterator();
                Iterator uIter = urlMap.keySet().iterator();
                Iterator uVIter = urlMap.values().iterator();
                for (SimpleLogicalObjectInterface lo : relatedObject) {
                    MetadataInterface smartObject = PromotionUtil.getSmartObject((PromotionInterface)exportOperation, (SimpleLogicalObjectInterface)lo);
                    if (smartObject == null || smartObject.getType().equalsIgnoreCase("Document") || smartObject.getType().equalsIgnoreCase("Note")) continue;
                    ConnectionPointInterface cpt = connMgr.createConnection(lo.getTypeInterface().getMetadataType(), lo.getID(), lo.getName());
                    _sourcePath = (String)uVIter.next();
                    _xpath = (String)uIter.next();
                    _theURL = (String)oPIter.next();
                    if (cpt == null) continue;
                    if (cpt.getUserDefinedProperty(ORIGINALPATH) == null) {
                        cpt.setPublicType(lo.getTypeInterface().getPublicType());
                        cpt.addAssociatedObject((PromotionItemInterface)reportExportItem);
                        cpt.setDescription(smartObject.getDescription());
                        cpt.setSourcePath(_sourcePath);
                        cpt.addUserDefinedProperty(XPATH, reportExportItem.getID() + _xpath);
                        String _search = null;
                        if (_theURL != null) {
                            String[] tokens = _theURL.split("\\|");
                            _theURL = tokens[0];
                            if (tokens.length == 4) {
                                String _reposSASOlapServer = tokens[1];
                                String _reposOlapSchema = tokens[2];
                                String _reposCube = tokens[3];
                                _search = ReportExImportUtil.getCubeSearch(_reposSASOlapServer, _reposOlapSchema, _reposCube, logger);
                            }
                        }
                        cpt.addUserDefinedProperty(ORIGINALPATH, _theURL);
                        if (_search == null) continue;
                        cpt.addSourceSearch(_search);
                        continue;
                    }
                    String existingKey = cpt.getUserDefinedProperty(XPATH);
                    cpt.removeUserDefinedProperty(XPATH);
                    _xpath = reportExportItem.getID() + _xpath + "," + existingKey;
                    cpt.addUserDefinedProperty(XPATH, _xpath);
                    cpt.addAssociatedObject((PromotionItemInterface)reportExportItem);
                }
            }
        }
        catch (LogicalTypeException e) {
            e.printStackTrace();
            ++returnValue;
        }
        catch (ServiceException e) {
            e.printStackTrace();
            ++returnValue;
        }
        return returnValue;
    }

    public Class[] getConnectionTypes() {
        return CONNECTION_TYPES;
    }

    public int analyzeObjectsToExport(ExportOperationInterface operation, List objects) throws MdException {
        block8: {
            log.fine("ReportExportListener analyzeObjectsToExport() Invoked");
            Log exportLogger = operation.getLogger();
            exportLogger.debug((Object)RB.getStringResource("REL.CheckContentServer.txt"));
            String exportErrorMsg = RB.getStringResource("REL.ExportContentMappingError.txt");
            try {
                UtilReportServices rs = UtilReportServices.getInstance();
                Iterator iter = objects.iterator();
                if (!iter.hasNext()) break block8;
                ExportItemInterface exportItem = (ExportItemInterface)iter.next();
                String[] fqid = exportItem.getSourcePath();
                PathUrl path = PathUrl.newPathUrlFromAbsolutePath((ServerInterface)operation.getServer(), (String)fqid[0]);
                if (path.getType() != FOLDER && path.getType() != null) {
                    path.setRootTree(fqid[0]);
                }
                path.setType(FOLDER);
                Repository rr = rs.getReportRepository(path);
                if (rr != null) {
                    try {
                        rr.ensureRepositoryContentExists(path.getRootTree());
                        exportLogger.debug((Object)RB.getStringResource("REL.ConnectedContentServer.txt"));
                        break block8;
                    }
                    catch (RepositoryException e) {
                        throw new MetadataPromotionException((Throwable)e);
                    }
                    catch (IllegalArgumentException e) {
                        throw new MetadataPromotionException(exportErrorMsg);
                    }
                    catch (IllegalStateException e) {
                        throw new MetadataPromotionException(exportErrorMsg);
                    }
                }
                throw new MetadataPromotionException(exportErrorMsg);
            }
            catch (Exception e) {
                exportLogger.error((Object)e.toString(), (Throwable)e);
                log.fine(e.toString());
                throw new MdException((Throwable)e);
            }
        }
        return 0;
    }
}

