/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.report;

import com.sas.metadata.logical.LogicalTypeException;
import com.sas.metadata.logical.RelatedObjectsInterface;
import com.sas.metadata.logical.SimpleLogicalObjectInterface;
import com.sas.metadata.logical.TransportableTypeInterface;
import com.sas.metadata.logical.bicommon.UtilPromotion;
import com.sas.metadata.logical.document.DocumentUtil;
import com.sas.metadata.logical.note.NoteUtil;
import com.sas.metadata.logical.report.ReportExImportUtil;
import com.sas.metadata.logical.report.UtilReportServices;
import com.sas.metadata.promotion.DefaultExportItem;
import com.sas.metadata.promotion.Log;
import com.sas.metadata.promotion.PromotionInterface;
import com.sas.metadata.promotion.PromotionUtil;
import com.sas.metadata.remote.CMetadata;
import com.sas.metadata.remote.Cube;
import com.sas.metadata.remote.MdStore;
import com.sas.metadata.remote.PhysicalTable;
import com.sas.metadata.remote.Root;
import com.sas.report.repository.ContentHelper;
import com.sas.report.repository.EntryInterface;
import com.sas.services.information.RepositoryInterface;
import com.sas.services.information.ServerInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import com.sas.services.information.metadata.RootFolderInterface;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class ReportExportItem
extends DefaultExportItem
implements RelatedObjectsInterface {
    private static final Logger log = Logger.getLogger(ReportExportItem.class.getName());
    static final String SBIP_PREFIX = "SBIP://";
    static final String HTTP_PREFIX = "HTTP://";
    static final String REPORT_IMAGE = "Report.Image";
    static final String REPOSSASOLAPSERVER = "ReposSASOlapServer";
    static final String REPOSWORKSPACESERVER = "ReposWorkspaceServer";
    private List _dependentObjects;
    private Map urlMap;
    private List originalPathList = new ArrayList();
    private List removeFailures = new ArrayList();

    public Map getUrlMap() {
        return this.urlMap;
    }

    public List getOriginalPathList() {
        return this.originalPathList;
    }

    public ReportExportItem(String name, String id, TransportableTypeInterface type) {
        super(name, id, type);
        log.fine("entering");
    }

    public List getRelatedObjects(int relationshipType) throws LogicalTypeException {
        Log exportLogger = this._exportOperation.getLogger();
        if (relationshipType != 0) {
            return null;
        }
        if (this._dependentObjects == null) {
            this._dependentObjects = new ArrayList();
            try {
                MetadataInterface smartObj = PromotionUtil.getSmartObject((PromotionInterface)this._exportOperation, (SimpleLogicalObjectInterface)this);
                UtilReportServices rs = UtilReportServices.getInstance();
                EntryInterface report = rs.getReport(smartObj);
                if (!this._type.getPublicType().equalsIgnoreCase(REPORT_IMAGE)) {
                    ContentHelper contentHelper = new ContentHelper();
                    log.fine("Parse report using SAX Parser" + report.toString());
                    this.urlMap = contentHelper.retrieveMapOfSbipAndAbsolutePathUrl(report.getInputStream());
                    RepositoryInterface repos = smartObj.getRepository();
                    ServerInterface server = this._exportOperation.getServer();
                    RootFolderInterface serverRoot = server.getRootFolder();
                    int originalPathListIndex = 0;
                    for (Map.Entry entry : this.urlMap.entrySet()) {
                        String loType;
                        String sbipUrlStr = (String)entry.getValue();
                        String sbipKeyStr = (String)entry.getKey();
                        MetadataInterface mi = null;
                        if (sbipUrlStr.startsWith("/")) {
                            PathUrl rootPath = serverRoot.getPathUrl();
                            PathUrl objectPath = new PathUrl(rootPath, sbipUrlStr);
                            mi = server.getObjectByPath(objectPath);
                            entry.setValue(objectPath.getAbsolutePath());
                            this.originalPathList.add(originalPathListIndex, objectPath.getAbsolutePath().toString());
                        } else if (sbipUrlStr.toUpperCase().startsWith(SBIP_PREFIX)) {
                            PathUrl sbipUrl = new PathUrl(sbipUrlStr);
                            mi = repos.getObjectByPath(sbipUrl);
                            entry.setValue(sbipUrl.getAbsolutePath());
                            this.originalPathList.add(originalPathListIndex, sbipUrlStr.toString());
                        } else if (sbipKeyStr.endsWith("@name")) {
                            CMetadata cd = (CMetadata)serverRoot.getRepositoryEntity();
                            String _fqID = repos.getBase();
                            MdStore md = cd.getObjectStore();
                            PathUrl _pathCube = null;
                            PathUrl _pathPhysicalTable = null;
                            String[] tokens = sbipUrlStr.split("\\|");
                            if (tokens.length == 3 && sbipKeyStr.contains(REPOSSASOLAPSERVER)) {
                                String _reposSASOlapServer = tokens[0];
                                String _reposOlapSchema = tokens[1];
                                String _reposCube = tokens[2];
                                Cube _cube = ReportExImportUtil.getCube(md, _fqID, _reposSASOlapServer, _reposOlapSchema, _reposCube, exportLogger);
                                if (_cube != null) {
                                    String _mdType = _cube.getCMetadataType();
                                    mi = repos.fetch(_cube.getFQID() + "/" + _mdType);
                                    _pathCube = mi.getPathUrl();
                                    entry.setValue(_pathCube.getAbsolutePath());
                                    String _originalPath = _pathCube.toString() + "|" + sbipUrlStr;
                                    this.originalPathList.add(originalPathListIndex, _originalPath);
                                } else {
                                    exportLogger.debug((Object)"Cube is null");
                                    this.originalPathList.add(originalPathListIndex, null);
                                }
                            } else if (tokens.length == 4 && sbipKeyStr.contains(REPOSWORKSPACESERVER)) {
                                PhysicalTable _physicalTable = null;
                                String _reposSASLibrarySchemaName = null;
                                String _reposSASWorkspaceServer = tokens[0];
                                String _reposSASLibraryName = tokens[1];
                                if (!tokens[2].contains("null")) {
                                    _reposSASLibrarySchemaName = tokens[2];
                                }
                                String _reposTable = tokens[3];
                                if (_reposSASLibrarySchemaName == null) {
                                    _physicalTable = ReportExImportUtil.getTable(md, _fqID, _reposSASWorkspaceServer, _reposSASLibraryName, _reposTable, exportLogger);
                                } else if (_reposSASLibrarySchemaName != null) {
                                    _physicalTable = ReportExImportUtil.getTable(md, _fqID, _reposSASWorkspaceServer, _reposSASLibraryName, _reposSASLibrarySchemaName, _reposTable, exportLogger);
                                }
                                if (_physicalTable != null) {
                                    String _mdType = _physicalTable.getCMetadataType();
                                    mi = repos.fetch(_physicalTable.getFQID() + "/" + _mdType);
                                    _pathPhysicalTable = mi.getPathUrl();
                                    entry.setValue(_pathPhysicalTable.getAbsolutePath());
                                    this.originalPathList.add(originalPathListIndex, _pathPhysicalTable.toString());
                                } else {
                                    log.fine("Physical Table is null");
                                    this.originalPathList.add(originalPathListIndex, null);
                                }
                            } else {
                                this.originalPathList.add(originalPathListIndex, sbipUrlStr.toString());
                            }
                        } else {
                            this.originalPathList.add(originalPathListIndex, sbipUrlStr.toString());
                        }
                        if (mi == null) {
                            String msg1 = this.getName() + ": Path " + entry.toString() + " at " + sbipUrlStr + " not found on source server";
                            log.warning(msg1);
                            exportLogger.debug((Object)msg1);
                            String iKey = (String)entry.getKey();
                            this.removeFailures.add(iKey);
                            this.originalPathList.remove(originalPathListIndex);
                            continue;
                        }
                        ++originalPathListIndex;
                        String _metadataType = mi.getType();
                        if ("BriefInformationMap".equals(_metadataType)) {
                            loType = "InformationMap";
                        } else if ("InformationMap.OLAP".equals(_metadataType)) {
                            loType = "InformationMap.OLAP";
                        } else if ("InformationMap.Relational".equals(_metadataType)) {
                            loType = "InformationMap.Relational";
                        } else if ("Report".equals(_metadataType)) {
                            loType = "Report";
                        } else if ("Report.Component".equals(_metadataType)) {
                            loType = "Report.Component";
                        } else if (REPORT_IMAGE.equals(_metadataType)) {
                            loType = REPORT_IMAGE;
                        } else if ("StoredProcess".equals(_metadataType)) {
                            loType = "StoredProcess";
                        } else if ("Cube".equals(_metadataType)) {
                            loType = "Cube";
                        } else if ("Table".equals(_metadataType)) {
                            loType = "Table";
                        } else {
                            log.warning("SmartObjectType = " + _metadataType + "... Unrecognized type! Skipping!");
                            continue;
                        }
                        SimpleLogicalObjectInterface dependentObject = UtilPromotion.createSimpleLogicalObject(mi.getName(), mi.getReposId(), loType);
                        this._dependentObjects.add(dependentObject);
                    }
                    Root rmtjOMAObj = (Root)smartObj.getRepositoryEntity();
                    List list = DocumentUtil.getDependentDocuments((Root)rmtjOMAObj);
                    List dependentNotes = NoteUtil.getDependentNotes((Root)rmtjOMAObj);
                    Iterator dd = list.iterator();
                    while (dd.hasNext()) {
                        this._dependentObjects.add(dd.next());
                    }
                    Iterator dn = dependentNotes.iterator();
                    while (dn.hasNext()) {
                        this._dependentObjects.add(dn.next());
                    }
                }
            }
            catch (Exception e) {
                exportLogger.warn((Object)e.getMessage());
                throw new LogicalTypeException(e);
            }
        }
        try {
            Iterator rf = this.removeFailures.iterator();
            while (rf.hasNext()) {
                this.urlMap.remove((String)rf.next());
            }
        }
        catch (Exception e) {
            throw new LogicalTypeException(e);
        }
        return this._dependentObjects;
    }
}

