/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.report;

import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.report.RB;
import com.sas.metadata.promotion.ConnectionPointInterface;
import com.sas.metadata.promotion.ConnectionTypeInterface;
import com.sas.metadata.promotion.ImportOperationInterface;
import com.sas.metadata.promotion.SourceConnectionInterface;
import com.sas.metadata.promotion.TargetConnectionInterface;
import com.sas.metadata.promotion.visuals.connections.AbstractConnectionPanel;
import com.sas.metadata.remote.Root;
import com.sas.services.ServiceException;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.information.metadata.PathUrl;
import java.rmi.RemoteException;
import java.util.Comparator;

public class ReportConnectionPanel
extends AbstractConnectionPanel {
    private static final long serialVersionUID = 1L;
    private static final String[] ALL_SPECIFIC_MAP_TYPES = new String[]{"Report", "Report.Component", "Report.Image"};

    public ReportConnectionPanel(ImportOperationInterface operation, ConnectionTypeInterface type) {
        super(operation, type);
        this.setSupportedPublicTypes(ALL_SPECIFIC_MAP_TYPES);
    }

    public String getDefaultSelectionValue() {
        return RB.getStringResource("ReportConnectionPanel.NoneSelection.txt");
    }

    public String getHelpTopicSuffix() {
        return "reportwin";
    }

    public String getPanelBorderLabel() {
        return RB.getStringResource("ReportConnectionPanel.BorderTitle.txt");
    }

    public String getPanelDescription() {
        return RB.getStringResource("ReportConnectionPanel.Desc.txt");
    }

    public String getPanelTitle() {
        return RB.getStringResource("ReportConnectionPanel.Title.txt");
    }

    public int getSelectionType() {
        return 1;
    }

    public Comparator getSourceTargetComparator() {
        return new ReportComparator();
    }

    class ReportComparator
    implements Comparator {
        ReportComparator() {
        }

        public int compare(Object obj1, Object obj2) {
            int rc = -1;
            if (obj1 instanceof SourceConnectionInterface && obj2 instanceof TargetConnectionInterface) {
                String s2;
                String s1 = ((SourceConnectionInterface)obj1).getDisplayName();
                if (!s1.equalsIgnoreCase(s2 = ((TargetConnectionInterface)obj2).getDisplayName())) {
                    return rc;
                }
                SourceConnectionInterface source = (SourceConnectionInterface)obj1;
                ConnectionPointInterface srcPoint = source.getConnectionPoint();
                String sourcePath = srcPoint.getSourcePath();
                TargetConnectionInterface target = (TargetConnectionInterface)obj2;
                Root trgObject = (Root)target.getMetadataObject();
                try {
                    String targetPathString;
                    MetadataInterface trgSmartObject = UtilPlatformServices.getSmartObject((Root)trgObject);
                    PathUrl targetPath = trgSmartObject.getPathUrl();
                    if (targetPath != null && (targetPathString = targetPath.toString()).endsWith(sourcePath)) {
                        rc = 0;
                    }
                }
                catch (RemoteException remoteException) {
                }
                catch (ServiceException serviceException) {
                    // empty catch block
                }
            }
            return rc;
        }
    }
}

