/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.report;

import java.io.File;
import java.util.List;

public class ImportUtils {
    public static final String REPORT = "(report)";
    public static final String REPORT_NAME = "(Report)";
    public static final String JPEG = "jpeg";
    public static final String JPG = "jpg";
    public static final String GIF = "gif";
    public static final String TIFF = "tiff";
    public static final String TIF = "tif";
    public static final String PNG = "png";
    public static final String BMP = "bmp";
    public static final String SRX = "srx";
    public static final String SRZ = "srz";
    public static final String SRT = "srt";
    public static final String XML = "xml";

    public static String getExtension(File f) {
        String ext = null;
        String s = f.getName();
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            ext = s.substring(i + 1).toLowerCase();
        }
        return ext;
    }

    public static String getExtension(String name) {
        String extension = name.substring(name.lastIndexOf(46) + 1);
        return extension;
    }

    public static boolean accept(File dir, String name, List supportedTypes) {
        if (supportedTypes.contains(ImportUtils.getExtension(name).toLowerCase())) {
            if (name.endsWith(REPORT_NAME)) {
                return true;
            }
            if (name.indexOf(REPORT_NAME) >= 0) {
                return false;
            }
        }
        return true;
    }

    public static boolean accept(File f, List supportedTypes) {
        if (f.isDirectory()) {
            return true;
        }
        String name = f.getName();
        String extension = ImportUtils.getExtension(name);
        if (extension != null) {
            if (supportedTypes.contains(extension.toLowerCase())) {
                if (name.endsWith(REPORT_NAME)) {
                    return true;
                }
                return name.indexOf(REPORT_NAME) < 0;
            }
            return false;
        }
        return false;
    }

    public static String generateDescription(String label, List supportedTypes) {
        StringBuffer description = new StringBuffer(label + ", (");
        boolean first = true;
        for (String typeName : supportedTypes) {
            if (typeName.indexOf(REPORT) >= 0) continue;
            if (first) {
                first = false;
            } else {
                description.append(", ");
            }
            description.append("*.");
            description.append(typeName.toUpperCase());
        }
        description.append(")");
        return description.toString();
    }
}

