/*
 * Decompiled with CFR 0.152.
 */
package com.sas.metadata.logical.report;

import com.sas.metadata.logical.LogicalObjectInterface;
import com.sas.metadata.logical.UtilPlatformServices;
import com.sas.metadata.logical.report.ObjectFactory;
import com.sas.metadata.logical.report.RootManager;
import com.sas.metadata.logical.visuals.Config;
import com.sas.metadata.remote.Root;
import com.sas.report.repository.AdapterFactory;
import com.sas.report.repository.EntryInterface;
import com.sas.services.information.metadata.MetadataInterface;
import com.sas.services.session.SessionContextInterface;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class ActionTestReport
extends AbstractAction {
    private static final Logger log = Logger.getLogger(ActionTestReport.class.getName());
    private Frame _frame;
    private LogicalObjectInterface _logicalObject;
    private Root _root;

    public ActionTestReport(Frame frame, LogicalObjectInterface logicalObj, Root root, ObjectFactory objectFactory, Config config) {
        log.fine("entering");
        this._frame = frame;
        this._logicalObject = logicalObj;
        this._root = root;
        this.putValue("Name", "Smart Object Test (development only)");
        String strMneumonic = null;
        if (strMneumonic != null) {
            this.putValue("MnemonicKey", new Integer(strMneumonic.charAt(0)));
        }
        this.putValue("ShortDescription", "Attempt to access RM API via Smart Object");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void actionPerformed(ActionEvent event) {
        log.fine("event = " + event);
        this._frame.setCursor(Cursor.getPredefinedCursor(3));
        RootManager rm = new RootManager();
        try {
            log.info("################## BEGIN TEST CODE ##################");
            log.info("Step 1: Test services and verify that we can get a session...");
            SessionContextInterface session = UtilPlatformServices.getSessionContext();
            if (session == null) {
                throw new NullPointerException("UtilPlatformServices.getSessionContext() returned null!");
            }
            log.info("Step 2: Obtaining Information Services object for this node...");
            log.info("metadata object = " + this._root);
            this._root = rm.getNonNullRoot(this._root, this._logicalObject);
            log.info("metadata object returned by RootManager = " + this._root);
            MetadataInterface smartObj = UtilPlatformServices.getSmartObject((Root)this._root);
            log.info("fetch returned " + smartObj);
            log.info("Step 3: Obtaining service object from smart object...");
            Object serviceObject = smartObj.newServiceObject();
            if (serviceObject == null) {
                throw new IllegalStateException("No service object exists for '" + smartObj + "'");
            }
            log.info("Step 4: Adapt the smart object to a bonafide Report Management object");
            EntryInterface entry = AdapterFactory.adaptEntry((Object)serviceObject);
            log.info("RM API entry object = " + entry);
            log.info("entry.getName() = " + entry.getName());
            log.info("entry.getAttributes()...");
            StringBuffer buf = new StringBuffer();
            buf.append("\n\n");
            Iterator itor = entry.getAttributes();
            while (itor.hasNext()) {
                Map.Entry mapEntry = (Map.Entry)itor.next();
                String key = mapEntry.getKey().toString();
                String value = mapEntry.getValue().toString();
                String keyAndValue = "   " + key + " = " + value;
                log.info(keyAndValue);
                buf.append(keyAndValue);
                buf.append('\n');
            }
            log.info("################## TEST COMPLETE! ##################");
            JOptionPane.showMessageDialog(this._frame, "It worked!\n" + entry + buf.toString(), "Repository Smart Object Test", 1);
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "TEST FAILED: ", e);
            StringWriter sWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(sWriter));
            JOptionPane.showMessageDialog(this._frame, "Failure:\n" + sWriter.toString(), "Repository Smart Object Test", 0);
        }
        finally {
            rm.dispose();
            this._frame.setCursor(Cursor.getPredefinedCursor(0));
            log.info("################## END TEST CODE ##################");
        }
    }
}

